/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.mvc.list.ListView;
import kd.epm.eb.business.ebupgrades.constants.UpgradeStatus;
import kd.epm.eb.business.ebupgrades.pojo.MainRecord;
import kd.epm.eb.business.ebupgrades.utils.UpgradesRecordHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;

public interface UpgradeHandler {
    public static final String OPEN_PAGE_TIME = "openPageTime";

    default public void setOpenPageTime(PreOpenFormEventArgs args) {
        long openPageTime = System.currentTimeMillis();
        args.getFormShowParameter().setCustomParam(OPEN_PAGE_TIME, (Object)openPageTime);
    }

    default public void upgradeIntercept(IFormView view, String evtKey) {
        boolean isIntercept = ModelServiceHelper.isUpgradeInterceptModel((IFormView)view);
        if (!isIntercept) {
            return;
        }
        String source = view.getEntityId();
        if (view instanceof ListView && "bos_list".equals(source)) {
            source = ((ListView)view).getBillFormId();
        }
        if ("eb_model_list".equals(source) && ("upgrade".equals(evtKey) || "testrollback".equals(evtKey)) || "eb_upgradeprogress".equals(source)) {
            return;
        }
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecord();
        if (mainRecord != null) {
            UpgradeStatus upgradeStatus = mainRecord.getStatus();
            if (upgradeStatus == UpgradeStatus.ING || upgradeStatus == UpgradeStatus.FAILED) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"UpgradeHandler_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            long startUpgradeTime = mainRecord.getBeginTime().getTime();
            long openPageTime = IDUtils.toLong((Object)view.getFormShowParameter().getCustomParam(OPEN_PAGE_TIME));
            if (openPageTime <= startUpgradeTime) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u91cd\u65b0\u767b\u5f55\u3002", (String)"UpgradeHandler_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

