/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.epm.eb.business.ebupgrades.constants.TaskStatus;
import kd.epm.eb.business.ebupgrades.pojo.DetailRecord;
import kd.epm.eb.business.ebupgrades.pojo.MainRecord;
import kd.epm.eb.business.ebupgrades.utils.UpgradesRecordHelper;
import kd.epm.eb.business.ebupgrades.utils.UpgradesServiceImpl;
import org.apache.commons.collections4.CollectionUtils;

public class UpgradeProgressUtil {
    public static Map<String, Double> getCurrentProgress() {
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecordNew(null);
        HashMap<String, Double> progressMap = new HashMap<String, Double>(1);
        double progress = 0.0;
        if (mainRecord == null) {
            progressMap.put(null, progress);
        } else {
            Map<String, DetailRecord> detailRecords = mainRecord.getDetailRecords();
            int totalTask = detailRecords.size();
            ArrayList success = new ArrayList(10);
            ArrayList rollFailed = new ArrayList(10);
            ArrayList rolled = new ArrayList(10);
            ArrayList failed = new ArrayList(10);
            ArrayList rollIng = new ArrayList(10);
            detailRecords.values().forEach(detailRecord -> {
                if (detailRecord.getStatus() == TaskStatus.SUCCEED) {
                    success.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.ROLLFAILED) {
                    rollFailed.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.ROLLED) {
                    rolled.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.FAILED) {
                    failed.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.ROLLING) {
                    rollIng.add(detailRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(failed) && CollectionUtils.isNotEmpty(rollIng)) {
                progressMap.put("rolling", progress);
            } else if (CollectionUtils.isNotEmpty(failed) && CollectionUtils.isEmpty(rollFailed) && CollectionUtils.isNotEmpty(rolled) && CollectionUtils.isEmpty(success)) {
                progressMap.put("rolled", progress);
            } else if (CollectionUtils.isNotEmpty(failed) && CollectionUtils.isNotEmpty(rollFailed)) {
                progressMap.put("rollFailed", progress);
            } else if (CollectionUtils.isNotEmpty(failed)) {
                progressMap.put("failed", progress);
            } else {
                progress = (double)success.size() * 100.0 / (double)totalTask;
                progressMap.put("success", progress);
            }
        }
        return progressMap;
    }

    public static boolean reUpgrade() {
        Map<String, DetailRecord> detailRecords;
        Collection<DetailRecord> values;
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecord();
        if (mainRecord != null && CollectionUtils.isNotEmpty(values = (detailRecords = mainRecord.getDetailRecords()).values())) {
            List collect = values.stream().filter(e -> e.getStatus() == TaskStatus.SUCCEED).collect(Collectors.toList());
            return values.size() == collect.size();
        }
        return false;
    }

    public static boolean reUpgradeTest(List<Long> modelIds) {
        Map<String, DetailRecord> detailRecords;
        Collection<DetailRecord> values;
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecordNew(modelIds);
        if (mainRecord != null && CollectionUtils.isNotEmpty(values = (detailRecords = mainRecord.getDetailRecords()).values())) {
            List collect = values.stream().filter(e -> e.getStatus() == TaskStatus.SUCCEED).collect(Collectors.toList());
            return values.size() == collect.size();
        }
        return false;
    }

    public static boolean upgradeFailed() {
        Map<String, DetailRecord> detailRecords;
        Collection<DetailRecord> values;
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecordNew(null);
        if (mainRecord != null && CollectionUtils.isNotEmpty(values = (detailRecords = mainRecord.getDetailRecords()).values())) {
            ArrayList rollFailed = new ArrayList(10);
            ArrayList failed = new ArrayList(10);
            values.forEach(detailRecord -> {
                if (detailRecord.getStatus() == TaskStatus.ROLLFAILED) {
                    rollFailed.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.FAILED) {
                    failed.add(detailRecord);
                }
            });
            return CollectionUtils.isNotEmpty(failed) && CollectionUtils.isEmpty(rollFailed);
        }
        return false;
    }

    public static boolean upgradeRollFailed() {
        Map<String, DetailRecord> detailRecords;
        Collection<DetailRecord> values;
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecordNew(null);
        if (mainRecord != null && CollectionUtils.isNotEmpty(values = (detailRecords = mainRecord.getDetailRecords()).values())) {
            ArrayList success = new ArrayList(10);
            ArrayList rollFailed = new ArrayList(10);
            ArrayList failed = new ArrayList(10);
            ArrayList rollIng = new ArrayList(10);
            values.forEach(detailRecord -> {
                if (detailRecord.getStatus() == TaskStatus.SUCCEED) {
                    success.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.ROLLFAILED) {
                    rollFailed.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.FAILED) {
                    failed.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.ROLLING) {
                    rollIng.add(detailRecord);
                }
            });
            return CollectionUtils.isNotEmpty(failed) && (CollectionUtils.isNotEmpty(rollFailed) || CollectionUtils.isNotEmpty(success) || CollectionUtils.isNotEmpty(rollIng));
        }
        return false;
    }

    public static boolean doPreUpgrades(List<Long> modelIds) {
        Map<String, DetailRecord> detailRecords;
        Collection<DetailRecord> values;
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecordNew(modelIds);
        if (mainRecord != null && CollectionUtils.isNotEmpty(values = (detailRecords = mainRecord.getDetailRecords()).values())) {
            ArrayList success = new ArrayList(10);
            ArrayList failed = new ArrayList(10);
            values.forEach(detailRecord -> {
                if (detailRecord.getStatus() == TaskStatus.SUCCEED) {
                    success.add(detailRecord);
                } else if (detailRecord.getStatus() == TaskStatus.FAILED) {
                    failed.add(detailRecord);
                }
            });
            return CollectionUtils.isNotEmpty(success) && CollectionUtils.isEmpty(failed);
        }
        return false;
    }

    public static boolean rollBack() {
        MainRecord mainRecord = UpgradesRecordHelper.getMainRecordNew(null);
        if (mainRecord != null) {
            return UpgradesServiceImpl.getInstance().doRollBack(mainRecord);
        }
        return false;
    }
}

