/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.epm.eb.business.ebupgrades.constants.TaskEnum;
import kd.epm.eb.business.ebupgrades.constants.TaskGroupEnum;
import kd.epm.eb.business.ebupgrades.constants.TaskStatus;
import kd.epm.eb.business.ebupgrades.interfaces.AbstractUpgradesTask;
import kd.epm.eb.business.ebupgrades.pojo.DetailRecord;
import kd.epm.eb.business.ebupgrades.pojo.MainRecord;
import kd.epm.eb.business.ebupgrades.tasks.TaskGroup;
import kd.epm.eb.business.ebupgrades.utils.UpgradesRecordHelper;

public class UpgradesHelper {
    public static List<TaskGroup> getAllTaskGroup() {
        HashMap<String, List> allTasks = new HashMap<String, List>(TaskGroupEnum.values().length);
        for (TaskEnum taskEnum : TaskEnum.values()) {
            TaskGroupEnum group = taskEnum.getGroup();
            Class taskClass = taskEnum.getTaskClass();
            List upgradesTasks = allTasks.computeIfAbsent(group.name(), key -> new ArrayList(16));
            AbstractUpgradesTask task = (AbstractUpgradesTask)TypesContainer.createInstance((Class)taskClass);
            task.setTaskKey(taskEnum.name());
            upgradesTasks.add(task);
        }
        ArrayList<TaskGroup> result = new ArrayList<TaskGroup>(TaskGroupEnum.values().length);
        for (TaskGroupEnum taskGroupEnum : TaskGroupEnum.values()) {
            List upgradesTasks = (List)allTasks.get(taskGroupEnum.name());
            if (upgradesTasks == null || upgradesTasks.isEmpty()) continue;
            TaskGroup taskGroup = new TaskGroup();
            taskGroup.setGroupKey(taskGroupEnum.name());
            taskGroup.setTaskList(upgradesTasks);
            result.add(taskGroup);
        }
        return result;
    }

    public static void markTaskStatus(AbstractUpgradesTask task, MainRecord mainRecord, TaskStatus status, long timeCost) {
        DetailRecord detailRecord;
        if (mainRecord != null && (detailRecord = mainRecord.getDetailRecords().get(task.getTaskKey())) != null) {
            detailRecord.setTimeCost(timeCost);
            detailRecord.setStatus(status);
            detailRecord.setLogInfo(task.getLogInfo());
            UpgradesRecordHelper.updateDetailRecord(detailRecord);
        }
        task.updateStatus(status);
    }

    public static boolean isUpLocked() {
        DLockInfo lockInfo = DLock.getLockInfo((String)"eb/UpgradesService_Lock");
        return lockInfo != null;
    }
}

