/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.constants.TaskStatus;
import kd.epm.eb.business.ebupgrades.constants.UpgradeStatus;
import kd.epm.eb.business.ebupgrades.pojo.DetailRecord;
import kd.epm.eb.business.ebupgrades.pojo.MainRecord;
import kd.epm.eb.business.ebupgrades.tasks.TaskGroup;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;

public class UpgradesRecordHelper {
    private static final String entitykey = "eb_upgradesrecord";
    private static final String updateDetailRecordSql = "update t_eb_updetailrecord set ftaskstatus = ?,foptime=? ,ftimecost = ?,floginfo = ? where fentryid = ?";
    private static final String updateDetailRecordSqlNoLog = "update t_eb_updetailrecord set ftaskstatus = ?,foptime=? ,ftimecost = ? where fentryid = ?";

    public static MainRecord addNewRecord(List<TaskGroup> taskGroups, List<Long> refModelIds) {
        MainRecord mainRecord = UpgradesRecordHelper.buildMainRecord(taskGroups, refModelIds);
        DynamicObject recordObj = UpgradesRecordHelper.toModelObj(mainRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        return mainRecord;
    }

    public static void updateDetailRecord(DetailRecord detailRecord) {
        try (TXHandle tx = TX.requiresNew((String)"updateDetailRecord");){
            try {
                if (StringUtils.isEmpty((String)detailRecord.getLogInfo())) {
                    DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)updateDetailRecordSqlNoLog, (Object[])new Object[]{detailRecord.getStatus().getVal(), detailRecord.getOpTime(), detailRecord.getTimeCost(), detailRecord.getId()});
                } else {
                    DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)updateDetailRecordSql, (Object[])new Object[]{detailRecord.getStatus().getVal(), detailRecord.getOpTime(), detailRecord.getTimeCost(), detailRecord.getLogInfo(), detailRecord.getId()});
                }
                UpgradesTaskUtil.getInstance().clearDataEntityCache(entitykey);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void updateMainRecord(MainRecord mainRecord) {
        mainRecord.setOpUserId(UserUtils.getUserId());
        mainRecord.setEndTime(TimeServiceHelper.now());
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)mainRecord.getId(), (String)entitykey);
        if (mainObj != null) {
            mainObj.set("status", (Object)mainRecord.getStatus().getVal());
            mainObj.set("endtime", (Object)mainRecord.getEndTime());
            mainObj.set("opuser", (Object)mainRecord.getOpUserId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObj});
        }
    }

    public static MainRecord getMainRecord() {
        MainRecord result = null;
        DynamicObject[] recordObjs = BusinessDataServiceHelper.load((String)entitykey, (String)"status,begintime,endtime,opuser,refmodels,detailrecord.taskkey,detailrecord.taskstatus,detailrecord.timeCost,detailrecord.opTime", null, (String)"begintime desc", (int)1);
        if (recordObjs != null && recordObjs.length > 0) {
            DynamicObject obj = recordObjs[0];
            result = UpgradesRecordHelper.toRecordPO(obj);
        }
        return result;
    }

    public static MainRecord getMainRecordNew(List<Long> modelIds) {
        MainRecord result = null;
        Long currentUser = UserUtils.getUserId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        if (CollectionUtils.isNotEmpty(modelIds)) {
            String modelStr = SerializationUtils.toJsonString(modelIds);
            qFilters.add(new QFilter("refmodels", "=", (Object)modelStr));
        }
        qFilters.add(new QFilter("opuser", "=", (Object)currentUser));
        Map recordObjs = BusinessDataServiceHelper.loadFromCache((String)entitykey, (String)"status,begintime,endtime,opuser,refmodels,detailrecord.taskkey,detailrecord.taskstatus,detailrecord.timeCost,detailrecord.opTime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"begintime desc");
        if (recordObjs != null && recordObjs.size() > 0) {
            DynamicObject obj = (DynamicObject)recordObjs.values().iterator().next();
            result = UpgradesRecordHelper.toRecordPO(obj);
        }
        return result;
    }

    public static MainRecord buildMainRecord(List<TaskGroup> taskGroups, List<Long> refModelIds) {
        MainRecord mainRecord = new MainRecord();
        mainRecord.setId(GlobalIdUtil.genGlobalLongId());
        mainRecord.setBeginTime(TimeServiceHelper.now());
        mainRecord.setOpUserId(UserUtils.getUserId());
        mainRecord.getRefModelIds().addAll(refModelIds);
        taskGroups.forEach(group -> group.getTaskList().forEach(task -> {
            DetailRecord detailRecord = new DetailRecord(mainRecord.getId(), GlobalIdUtil.genGlobalLongId(), task.getTaskKey(), TaskStatus.NULL, TimeServiceHelper.now(), 0L);
            mainRecord.getDetailRecords().put(detailRecord.getTaskKey(), detailRecord);
        }));
        return mainRecord;
    }

    public static MainRecord toRecordPO(DynamicObject recordObj) {
        MainRecord mainRecord = new MainRecord();
        mainRecord.setId(recordObj.getLong("id"));
        mainRecord.setBeginTime(recordObj.getDate("begintime"));
        mainRecord.setEndTime(recordObj.getDate("endtime"));
        mainRecord.setOpUserId(recordObj.getLong("opuser.id"));
        String refModelIdStr = recordObj.getString("refmodels");
        List modelIds = SerializationUtils.fromJsonStringToList((String)refModelIdStr, Long.class);
        mainRecord.getRefModelIds().addAll(modelIds);
        mainRecord.setStatus(UpgradeStatus.getStatusByVal(recordObj.getInt("status")));
        DynamicObjectCollection detailrecords = recordObj.getDynamicObjectCollection("detailrecord");
        detailrecords.forEach(dRecordObj -> {
            DetailRecord detailRecord = new DetailRecord(mainRecord.getId(), dRecordObj.getLong("id"), dRecordObj.getString("taskkey"), TaskStatus.getStatusByVal(dRecordObj.getInt("taskstatus")), dRecordObj.getDate("optime"), dRecordObj.getLong("timecost"));
            mainRecord.getDetailRecords().put(detailRecord.getTaskKey(), detailRecord);
        });
        return mainRecord;
    }

    public static DynamicObject toModelObj(MainRecord mainRecord) {
        DynamicObject mainObj = BusinessDataServiceHelper.newDynamicObject((String)entitykey);
        mainObj.set("id", (Object)mainRecord.getId());
        mainObj.set("status", (Object)mainRecord.getStatus().getVal());
        mainObj.set("begintime", (Object)mainRecord.getBeginTime());
        mainObj.set("endtime", (Object)mainRecord.getEndTime());
        mainObj.set("opuser", (Object)mainRecord.getOpUserId());
        mainObj.set("refmodels", (Object)SerializationUtils.toJsonString(mainRecord.getRefModelIds()));
        DynamicObjectCollection detailrecorda = mainObj.getDynamicObjectCollection("detailrecord");
        mainRecord.getDetailRecords().values().forEach(dRecord -> {
            DynamicObject row = detailrecorda.addNew();
            row.set("id", (Object)dRecord.getId());
            row.set("taskkey", (Object)dRecord.getTaskKey());
            row.set("taskstatus", (Object)dRecord.getStatus().getVal());
            row.set("optime", (Object)dRecord.getOpTime());
            row.set("loginfo", (Object)dRecord.getLogInfo());
        });
        return mainObj;
    }
}

