/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.epm.eb.business.ebupgrades.constants.TaskStatus;
import kd.epm.eb.business.ebupgrades.constants.UpgradeStatus;
import kd.epm.eb.business.ebupgrades.context.UpgradesContext;
import kd.epm.eb.business.ebupgrades.pojo.DetailRecord;
import kd.epm.eb.business.ebupgrades.pojo.MainRecord;
import kd.epm.eb.business.ebupgrades.tasks.TaskGroup;
import kd.epm.eb.business.ebupgrades.utils.UpgradesHelper;
import kd.epm.eb.business.ebupgrades.utils.UpgradesRecordHelper;
import kd.epm.eb.common.utils.lock.Lock;

public class UpgradesServiceImpl {
    private UpgradesContext upgradesContext;
    private List<TaskGroup> taskGroups = new ArrayList<TaskGroup>(16);
    private static final Log log = LogFactory.getLog(UpgradesServiceImpl.class);

    public static UpgradesServiceImpl getInstance() {
        return new UpgradesServiceImpl();
    }

    public boolean doUpgrades(List<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return false;
        }
        return Lock.lock(() -> {
            this.init(modelIds);
            MainRecord mainRecord = UpgradesRecordHelper.addNewRecord(this.getTaskGroups(), modelIds);
            this.update(mainRecord);
        }, (String)"UpgradesService_Lock", (long)0L);
    }

    public boolean doPreUpgrades(MainRecord mainRecord) {
        return Lock.lock(() -> {
            this.init(mainRecord.getRefModelIds());
            this.updateTaskByRecord(mainRecord);
            this.update(mainRecord);
        }, (String)"UpgradesService_Lock", (long)0L);
    }

    private void updateTaskByRecord(MainRecord mainRecord) {
        List<TaskGroup> taskGroups = this.getTaskGroups();
        Map<String, DetailRecord> detailRecords = mainRecord.getDetailRecords();
        Map<String, TaskStatus> taskStatusMap = detailRecords.values().stream().collect(Collectors.toMap(DetailRecord::getTaskKey, DetailRecord::getStatus));
        taskGroups.forEach(group -> group.getTaskList().forEach(task -> {
            TaskStatus taskStatus = (TaskStatus)((Object)((Object)((Object)taskStatusMap.get(task.getTaskKey()))));
            if (taskStatus != null) {
                task.updateStatus(taskStatus);
            }
        }));
    }

    private void update(MainRecord mainRecord) {
        List<TaskGroup> taskGroups = this.getTaskGroups();
        try {
            TaskGroup firstTask = taskGroups.get(0);
            firstTask.setMainRecord(mainRecord);
            firstTask.run();
            if (!this.upgradesContext.isHasError()) {
                CountDownLatch count = new CountDownLatch(taskGroups.size() - 1);
                for (int i = 1; i < taskGroups.size(); ++i) {
                    TaskGroup taskGroup = taskGroups.get(i);
                    taskGroup.setMainRecord(mainRecord);
                    taskGroup.setDownLatch(count);
                    ThreadPools.executeOnce((String)taskGroup.getGroupKey(), (Runnable)taskGroup);
                }
                count.await();
            }
            if (this.upgradesContext.isHasError()) {
                this.rollBack(taskGroups, mainRecord);
            } else {
                mainRecord.setStatus(UpgradeStatus.SUCCEED);
                UpgradesRecordHelper.updateMainRecord(mainRecord);
            }
        }
        catch (Throwable e) {
            log.error("UpgradesService", e);
            this.upgradesContext.setHasError(true);
            this.rollBack(taskGroups, mainRecord);
        }
    }

    public boolean doRollBack(MainRecord mainRecord) {
        return Lock.lock(() -> {
            this.init(mainRecord.getRefModelIds());
            this.updateTaskByRecord(mainRecord);
            List<TaskGroup> taskGroups = this.getTaskGroups();
            taskGroups.forEach(group -> group.setMainRecord(mainRecord));
            this.rollBack(this.getTaskGroups(), mainRecord);
        }, (String)"UpgradesService_Lock", (long)0L);
    }

    private void rollBack(List<TaskGroup> taskGroups, MainRecord mainRecord) {
        for (int groupSeq = taskGroups.size() - 1; groupSeq >= 0; --groupSeq) {
            TaskGroup taskGroup = taskGroups.get(groupSeq);
            if (taskGroup.rollbackTask()) {
                mainRecord.setStatus(UpgradeStatus.FAILED);
                break;
            }
            mainRecord.setStatus(UpgradeStatus.RollED);
        }
        UpgradesRecordHelper.updateMainRecord(mainRecord);
    }

    public List<TaskGroup> getTaskGroups() {
        if (this.taskGroups == null) {
            this.taskGroups = new ArrayList<TaskGroup>(16);
        }
        return this.taskGroups;
    }

    private void init(List<Long> modelIds) {
        this.upgradesContext = new UpgradesContext();
        this.upgradesContext.getToUpModelIds().addAll(modelIds);
        this.taskGroups = UpgradesHelper.getAllTaskGroup();
        this.taskGroups.forEach(taskGroup -> {
            taskGroup.setUpgradesContext(this.upgradesContext);
            taskGroup.getTaskList().forEach(task -> task.setGlobalContext(this.upgradesContext));
        });
    }
}

