/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.ebupgrades.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.ebupgrades.constants.DatabaseType;
import kd.epm.eb.business.ebupgrades.constants.ITableCreate;
import kd.epm.eb.business.ebupgrades.context.OldDataContext;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.convert.Convert;

public class UpgradesTaskUtil {
    private static final UpgradesTaskUtil instance = new UpgradesTaskUtil();
    private static final Log log = LogFactory.getLog(UpgradesTaskUtil.class);

    public static UpgradesTaskUtil getInstance() {
        return instance;
    }

    public void backupsDataByIds(String table, Collection<Long> ids) {
        this.backupsDataByIds(table, ids, "fid");
    }

    public void backupsDataByIds(String table, Collection<Long> ids, String property) {
        this.backupsDataByIds(table, this.getDefaultBakTable(table), ids, property);
    }

    public void backupsDataByIds(String table, String backupsTable, Collection<Long> ids, String property) {
        this.backupsDataByIds(table, backupsTable, "epm", ids, property);
    }

    public void backupsDataByIds(String table, String backupsTable, String routeKey, Collection<Long> ids, String property) {
        this.backupsDataByIds(table, backupsTable, routeKey, ids, property, true);
    }

    public void backupsDataByIds(String table, String backupsTable, String routeKey, Collection<Long> ids, String property, Boolean needClearData) {
        String filterIds = ids.stream().map(String::valueOf).collect(Collectors.joining(","));
        String filterSql = "%s in (%s)";
        String filterParam = String.format(filterSql, property, filterIds);
        this.backupsData(table, backupsTable, routeKey, filterParam, needClearData);
    }

    public void backupsData(String table, String filterParam) {
        this.backupsData(table, this.getDefaultBakTable(table), filterParam);
    }

    public void backupsData(String table, String backupsTable, String filterParam) {
        this.backupsData(table, backupsTable, "epm", filterParam);
    }

    public void backupsData(String table, String backupsTable, String routeKey, String filterParam) {
        this.backupsData(table, backupsTable, routeKey, filterParam, true);
    }

    public void backupsData(String table, String backupsTable, String routeKey, String filterParam, Boolean needClearData) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        if (!DB.exitsTable((DBRoute)dbRoute, (String)backupsTable)) {
            this.createBackupTable(dbRoute, backupsTable, table);
        } else if (needClearData.booleanValue()) {
            this.clearBakTableData(dbRoute, backupsTable, filterParam);
        }
        String insertSql = "insert into %s(%s) select %s from %s where %s";
        List columnNames_bak = DB.getColumnNames((DBRoute)dbRoute, (String)backupsTable);
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)table);
        columnNames.retainAll(columnNames_bak);
        HashSet columnNames_new = new HashSet(columnNames);
        String columns = String.join((CharSequence)",", columnNames_new);
        DB.execute((DBRoute)dbRoute, (String)String.format(insertSql, backupsTable, columns, columns, table, filterParam));
    }

    private void clearBakTableData(DBRoute dbRoute, String backupsTable, String filterParam) {
        String sql = "delete from %s where %s";
        DB.execute((DBRoute)dbRoute, (String)String.format(sql, backupsTable, filterParam));
    }

    public void createBackupTable(DBRoute dbRoute, String backupsTable, String srcTable) {
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        log.info("UpgradesTaskUtil_backTable: table --- " + srcTable + " dbType --- " + dbType.name());
        DatabaseType dataBaseType = DatabaseType.getDataBaseType(dbType.getValue());
        if (dataBaseType == null) {
            DatabaseType[] databaseTypes = DatabaseType.values();
            this.createBackupTableInLoop(dbRoute, backupsTable, srcTable, databaseTypes, 0, null);
        } else {
            Class<?> tableCreate = dataBaseType.getTableCreate();
            ITableCreate create = (ITableCreate)TypesContainer.createInstance(tableCreate);
            String backUpSql = create.getBackUpSql();
            try {
                DB.execute((DBRoute)dbRoute, (String)String.format(backUpSql, backupsTable, srcTable));
            }
            catch (KDException exception) {
                log.error((Throwable)exception);
                DatabaseType[] databaseTypes = DatabaseType.values();
                this.createBackupTableInLoop(dbRoute, backupsTable, srcTable, databaseTypes, 0, dataBaseType);
            }
        }
    }

    private void createBackupTableInLoop(DBRoute dbRoute, String backupsTable, String srcTable, DatabaseType[] databaseTypes, int index, DatabaseType databaseType) {
        int length = databaseTypes.length;
        if (index >= length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5907\u4efd\u8868\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"UpgradesTaskUtil_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (databaseType == databaseTypes[index]) {
            this.createBackupTableInLoop(dbRoute, backupsTable, srcTable, databaseTypes, ++index, databaseType);
        } else {
            Class<?> tableCreate = databaseTypes[index].getTableCreate();
            ITableCreate create = (ITableCreate)TypesContainer.createInstance(tableCreate);
            String backUpSql = create.getBackUpSql();
            try {
                DB.execute((DBRoute)dbRoute, (String)String.format(backUpSql, backupsTable, srcTable));
            }
            catch (KDException exception) {
                log.error((Throwable)exception);
                this.createBackupTableInLoop(dbRoute, backupsTable, srcTable, databaseTypes, ++index, databaseType);
            }
        }
    }

    public String getDefaultBakTable(String table) {
        return table + "_bak";
    }

    public void rollDataFromBak(String table, String filterParam) {
        this.rollDataFromBak(table, filterParam, false);
    }

    public void rollDataFromBak(String table, String filterParam, Boolean needDelRefData) {
        this.rollDataFromBak(table, filterParam, filterParam, needDelRefData);
    }

    public void rollDataFromBak(String table, String filterParam, String checkFilterParam, Boolean needDelRefData) {
        this.rollDataFromBak(table, this.getDefaultBakTable(table), filterParam, checkFilterParam, needDelRefData);
    }

    public void rollDataFromBak(String table, String backupsTable, String filterParam, String checkFilterParam, Boolean needDelRefData) {
        this.rollDataFromBak(table, backupsTable, "epm", filterParam, checkFilterParam, needDelRefData);
    }

    public void rollDataFromBak(String table, String backupsTable, String routeKey, String filterParam, String checkFilterParam, Boolean needDelRefData) {
        ArrayList<Map<String, String>> refTablePropertyList = new ArrayList<Map<String, String>>(16);
        if (needDelRefData.booleanValue()) {
            refTablePropertyList.add(this.getLanguageTableProperty(table));
        }
        this.rollDataFromBak(table, backupsTable, routeKey, filterParam, checkFilterParam, refTablePropertyList, needDelRefData);
    }

    public void rollDataFromBak(String table, String backupsTable, String routeKey, String filterParam, String checkFilterParam, List<Map<String, String>> refTablePropertyList, Boolean needDelRefData) {
        this.checkCanReCoverFromBak(table, backupsTable, routeKey, checkFilterParam);
        if (needDelRefData.booleanValue()) {
            this.delDataWithRefTable(table, refTablePropertyList, routeKey, filterParam);
        } else {
            this.delDataWithoutRef(table, routeKey, filterParam);
        }
        this.reCoverFromBak(table, backupsTable, routeKey, filterParam);
    }

    private void checkCanReCoverFromBak(String table, String backupsTable, String routeKey, String checkFilterParam) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        Set<Long> curIds = this.getPkIds(dbRoute, table, checkFilterParam);
        Set<Long> bakIds = this.getPkIds(dbRoute, backupsTable, checkFilterParam);
        if (!bakIds.containsAll(curIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u56de\u6eda\u7684\u6570\u636e\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5", (String)"UpgradesTaskUtil_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    private Set<Long> getPkIds(DBRoute dbRoute, String table, String filterParam) {
        HashSet<Long> pkIds = new HashSet<Long>(16);
        String sql = "select fid from %s where %s";
        try (DataSet ds = DB.queryDataSet((String)"queryPkIds", (DBRoute)dbRoute, (String)String.format(sql, table, filterParam));){
            while (ds.hasNext()) {
                Row row = ds.next();
                pkIds.add(row.getLong("fid"));
            }
        }
        return pkIds;
    }

    public void delDataWithoutRef(String table, String filterParam) {
        this.delDataWithoutRef(table, "epm", filterParam);
    }

    public void delDataWithoutRef(String table, String routeKey, String filterParam) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        String sql = "delete from %s where %s";
        DB.execute((DBRoute)dbRoute, (String)String.format(sql, table, filterParam));
    }

    public void delDataWithRefTable(String table, String filterParam) {
        ArrayList<Map<String, String>> refTablePropertyList = new ArrayList<Map<String, String>>(16);
        refTablePropertyList.add(this.getLanguageTableProperty(table));
        this.delDataWithRefTable(table, refTablePropertyList, filterParam);
    }

    public Map<String, String> getLanguageTableProperty(String table) {
        return this.getRefTablePropertyMap(table + "_l", "fid", "fid");
    }

    public Map<String, String> getRefTablePropertyMap(String refTable, String refProperty_table, String refProperty_refTable) {
        HashMap<String, String> refTablePropertyMap = new HashMap<String, String>(16);
        refTablePropertyMap.put("referTable", refTable);
        refTablePropertyMap.put("refProperty_table", refProperty_table);
        refTablePropertyMap.put("refProperty_refTable", refProperty_refTable);
        return refTablePropertyMap;
    }

    public void delDataWithRefTable(String table, List<Map<String, String>> refTableProperties, String filterParam) {
        this.delDataWithRefTable(table, refTableProperties, "epm", filterParam, false);
    }

    public void delDataWithRefTable(String table, List<Map<String, String>> refTableProperties, String routeKey, String filterParam) {
        this.delDataWithRefTable(table, refTableProperties, routeKey, filterParam, false);
    }

    public void delDataWithRefTable(String table, List<Map<String, String>> refTableProperties, String routeKey, String filterParam, Boolean onlyDelRef) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        for (Map<String, String> refTableProperty : refTableProperties) {
            this.delRefTableData(refTableProperty, dbRoute, table, filterParam);
        }
        if (!onlyDelRef.booleanValue()) {
            this.delDataWithoutRef(table, routeKey, filterParam);
        }
    }

    private void delRefTableData(Map<String, String> refTableProperty, DBRoute dbRoute, String table, String filterParam) {
        String refTable = refTableProperty.get("referTable");
        String refProperty_table = refTableProperty.get("refProperty_table");
        String refProperty_refTable = refTableProperty.get("refProperty_refTable");
        String sql = "delete from %s where %s in (select %s from %s where %s)";
        DB.execute((DBRoute)dbRoute, (String)String.format(sql, refTable, refProperty_refTable, refProperty_table, table, filterParam));
    }

    public void reCoverFromBak(String table, Collection<Long> ids) {
        this.reCoverFromBak(table, ids, "fid");
    }

    public void reCoverFromBak(String table, Collection<Long> ids, String property) {
        this.reCoverFromBak(table, this.getDefaultBakTable(table), ids, property);
    }

    public void reCoverFromBak(String table, String backupsTable, Collection<Long> ids, String property) {
        this.reCoverFromBak(table, backupsTable, "epm", ids, property);
    }

    public void reCoverFromBak(String table, String backupsTable, String routeKey, Collection<Long> ids, String property) {
        String filterParam = "%s in (%s)";
        String filter = String.format(filterParam, property, ids.stream().map(String::valueOf).collect(Collectors.joining(",")));
        this.reCoverFromBak(table, backupsTable, routeKey, filter);
    }

    public void reCoverFromBak(String table, String filterParam) {
        this.reCoverFromBak(table, this.getDefaultBakTable(table), filterParam);
    }

    public void reCoverFromBak(String table, String backupsTable, String filterParam) {
        this.reCoverFromBak(table, backupsTable, "epm", filterParam);
    }

    public void reCoverFromBak(String table, String backupsTable, String routeKey, String filterParam) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        String insertSql = "insert into %s(%s) select %s from %s where %s";
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)backupsTable);
        String columns = String.join((CharSequence)",", columnNames);
        DB.execute((DBRoute)dbRoute, (String)String.format(insertSql, table, columns, columns, backupsTable, filterParam));
    }

    public void updateData(String table, Map<String, Object> updateMap, String filterParam) {
        this.updateData(table, updateMap, "epm", filterParam);
    }

    public void updateData(String table, Map<String, Object> updateMap, String routeKey, String filterParam) {
        ArrayList<Object> updateValueList = new ArrayList<Object>(16);
        ArrayList<String> values = new ArrayList<String>(16);
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        for (Map.Entry<String, Object> updateEntry : updateMap.entrySet()) {
            values.add(updateEntry.getKey() + " = ?");
            Object value = updateEntry.getValue();
            updateValueList.add(this.convertValue(value));
        }
        String updateSql = "update %s set %s where %s";
        updateSql = String.format(updateSql, table, String.join((CharSequence)",", values), filterParam);
        DB.execute((DBRoute)dbRoute, (String)updateSql, (Object[])updateValueList.toArray());
    }

    private Object convertValue(Object value) {
        if (value instanceof Boolean) {
            Boolean booleanValue = Convert.toBool((Object)value);
            return booleanValue != false ? "1" : "0";
        }
        if (value instanceof Date) {
            Date date = ConvertUtils.toDate((Object)value);
            return new Timestamp(date.getTime());
        }
        return value;
    }

    public void clearDataEntityCache(String baseModel) {
        CacheServiceHelper.clearEntityCache((String)baseModel);
    }

    public void clearDataEntityCache(String baseModel, Object[] keys) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseModel);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dataEntityType);
        cacheManager.removeByPrimaryKey(keys);
    }

    public Map<Long, List<DynamicObject>> queryAndFillDataContextByOrm(OldDataContext dataContext, QFilter qFilter) {
        return this.queryAndFillDataContextByOrm(dataContext, qFilter, "model");
    }

    public Map<Long, List<DynamicObject>> queryAndFillDataContextByOrm(OldDataContext dataContext, QFilter qFilter, String modelFieldKey) {
        HashMap<Long, List<DynamicObject>> toDelDataMap = new HashMap<Long, List<DynamicObject>>(16);
        List<String> selectFields = dataContext.getSelectFields();
        selectFields.add(modelFieldKey);
        String table = dataContext.getTable();
        DynamicObjectCollection data = QueryServiceHelper.query((String)table, (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject datum : data) {
            long modelId = datum.getLong(modelFieldKey);
            List toDelList = toDelDataMap.computeIfAbsent(modelId, k -> new ArrayList(16));
            toDelList.add(datum);
        }
        return toDelDataMap;
    }

    public Map<Long, List<DynamicObject>> queryAndFillDataContextBySql(OldDataContext dataContext, String filterParam) {
        return this.queryAndFillDataContextBySql(dataContext, filterParam, "fmodelid");
    }

    public Map<Long, List<DynamicObject>> queryAndFillDataContextBySql(OldDataContext dataContext, String filterParam, String modelFieldKey) {
        return this.queryAndFillDataContextBySql(dataContext, "epm", filterParam, modelFieldKey);
    }

    public Map<Long, List<DynamicObject>> queryAndFillDataContextBySql(OldDataContext dataContext, String routeKey, String filterParam, String modelFieldKey) {
        HashMap<Long, List<DynamicObject>> toDelDataMap = new HashMap<Long, List<DynamicObject>>(16);
        List<String> selectFields = dataContext.getSelectFields();
        Map<String, String> specialFieldMap = dataContext.getSpecialFieldMap();
        List sqlFields = selectFields.stream().map(e -> {
            String specialField = (String)specialFieldMap.get(e);
            if (specialField != null) {
                return specialField + " as " + e;
            }
            return "f" + e + " as " + e;
        }).collect(Collectors.toList());
        selectFields.add(modelFieldKey);
        String table = dataContext.getRealTable();
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        DataSet dataSet = DB.queryDataSet((String)"queryOldData", (DBRoute)dbRoute, (String)String.format("select %s from %s where %s", String.join((CharSequence)",", sqlFields), table, filterParam));
        if (dataSet.isEmpty() || !dataSet.hasNext()) {
            return toDelDataMap;
        }
        DynamicObjectCollection oldData = ORMUtil.toDynamicObjectCollection((DataSet)dataSet, (String)table);
        for (DynamicObject datum : oldData) {
            long modelId = datum.getLong(modelFieldKey);
            List toDelList = toDelDataMap.computeIfAbsent(modelId, k -> new ArrayList(16));
            toDelList.add(datum);
        }
        return toDelDataMap;
    }

    public OldDataContext copyOldDataContext(OldDataContext oldDataContext) {
        OldDataContext oldDataContext_copy = new OldDataContext();
        oldDataContext_copy.setTable(oldDataContext.getTable());
        oldDataContext_copy.setSelectFields(oldDataContext.getSelectFields());
        return oldDataContext_copy;
    }

    public String getRefFilter(String table, QFilter qFilter) {
        return this.getRefFilter(table, qFilter, "fid", "fid");
    }

    public String getRefFilter(String table, QFilter qFilter, String refProperty, String curProperty) {
        String sql = "%s in (select %s from %s where %s)";
        return String.format(sql, curProperty, refProperty, table, qFilter.toString());
    }

    public Map<Long, List<DynamicObject>> getMemberMap(String memberTreeModel, QFilter qFilter) {
        HashMap<Long, List<DynamicObject>> memberMap = new HashMap<Long, List<DynamicObject>>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, memberTreeModel, null);
        DynamicObject[] members = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)memberTreeModel));
        if (members.length != 0) {
            for (DynamicObject member : members) {
                Long modelId = member.getLong("model.id");
                List memberList = memberMap.computeIfAbsent(modelId, k -> new ArrayList(16));
                memberList.add(member);
            }
        }
        return memberMap;
    }
}

