/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examine;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.rule.RuleUtils;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.examinev2.ExamineUtils;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.expr.expr.BinaryExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.expr.MemberGroupExpr;
import kd.epm.eb.business.expr.expr.NameExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.parse.ScriptParseUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.centralapproval.SimpleMemberDto;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.dao.variable.VariableCacheService;
import kd.epm.eb.common.dao.variable.VariableDto;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.examine.bo.ExamineViewMember;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.pojo.examine.ExamineFormulaExtend;
import kd.epm.eb.common.pojo.examine.ExamineFormulaInfo;
import kd.epm.eb.common.utils.AnalyzeRangeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.lang.StringUtils;

public class ExamineServiceHelper {
    private static final Log log = LogFactory.getLog(ExamineServiceHelper.class);
    private static final ExamineServiceHelper instance = new ExamineServiceHelper();
    public static final String markStr = "$$pp$$";
    private static final Character markStr2 = Character.valueOf('?');

    public static ExamineServiceHelper getInstance() {
        return instance;
    }

    public static Map<String, List<Pair<String, String>>> parseDimRangeStr2Map(String dimRangeStr) {
        String[] dimGrops;
        HashMap<String, List<Pair<String, String>>> dimMembNumMap = new HashMap<String, List<Pair<String, String>>>(16);
        if (StringUtils.isBlank((String)dimRangeStr)) {
            return dimMembNumMap;
        }
        ArrayList<Pair> membNums = null;
        dimRangeStr = dimRangeStr.substring(1, dimRangeStr.length() - 1);
        for (String dimInfoStr : dimGrops = dimRangeStr.split("\\)\\(")) {
            String dimNumber = dimInfoStr.split("\\|")[0];
            String dimMembStr = dimInfoStr.split("\\|")[1];
            membNums = new ArrayList<Pair>(16);
            if (!dimMembStr.equals(" ")) {
                String[] membGrops;
                for (String membStr : membGrops = dimMembStr.split(",")) {
                    String memberNum = membStr.split("\\!")[0];
                    String scope = membStr.split("\\!")[1];
                    membNums.add(new Pair((Object)memberNum, (Object)scope));
                }
            }
            dimMembNumMap.put(dimNumber, membNums);
        }
        return dimMembNumMap;
    }

    public static Map<String, Map<Long, Set<String>>> parseDimViewRangeStr2Map(Long modelId, Long busModelId, String dimRangeStr, String formula) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        HashMap<String, Map<Long, Set<String>>> dimMembNumMap = new HashMap<String, Map<Long, Set<String>>>(16);
        if (!StringUtils.isBlank((String)dimRangeStr)) {
            Map parseDimRangeMap = (Map)ObjectSerialUtil.parseObject((String)dimRangeStr, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){}, (Feature[])new Feature[0]);
            String examinePropRelation = ParamQueryServiceHelper.getString((long)modelId, (ParamEnum)ParamEnum.BG046);
            for (Map.Entry entry : parseDimRangeMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                List memberCondition = (List)entry.getValue();
                Map viewNumbers = dimMembNumMap.computeIfAbsent(dimNumber, v -> new HashMap(16));
                Long viewByBusModelAndDimNumber = modelCacheHelper.getViewByBusModelAndDimNumber(busModelId, dimNumber);
                Set membNums = viewNumbers.computeIfAbsent(viewByBusModelAndDimNumber, v -> new HashSet(16));
                if (!CollectionUtils.isNotEmpty((Collection)memberCondition)) continue;
                Set memNumbers = AnalyzeRangeUtils.analyzeMemberConditionToMember2((String)dimNumber, (List)memberCondition, (String)examinePropRelation, (IModelCacheHelper)modelCacheHelper, (MemberPropCache)memberPropCache, null, (boolean)false);
                membNums.addAll(memNumbers);
            }
        }
        if (!StringUtils.isBlank((String)formula)) {
            ArrayList<String> membInfoStrList = new ArrayList<String>(10);
            ExamineServiceHelper.findMembInfoStr(membInfoStrList, formula);
            ArrayList<ExamineFormulaInfo> examineFormulaInfos = new ArrayList<ExamineFormulaInfo>(10);
            Map<String, Set<ExamineViewMember>> dimMapMembNums = ExamineServiceHelper.mapDimMembNums(examineFormulaInfos, membInfoStrList, null, null);
            for (Map.Entry<String, Set<ExamineViewMember>> entry : dimMapMembNums.entrySet()) {
                String dimNum = entry.getKey();
                Map viewNumbers = dimMembNumMap.computeIfAbsent(dimNum, v -> new HashMap(16));
                for (ExamineViewMember viewMember : entry.getValue()) {
                    String membNum = viewMember.getMemberNum();
                    Long id = null;
                    if (SysDimensionEnum.Account.getNumber().equals(dimNum)) {
                        Member member = modelCacheHelper.getMember(dimNum, null, membNum);
                        if (member != null) {
                            id = member.getDatasetId();
                        }
                    } else {
                        id = modelCacheHelper.getViewByBusModelAndDimNumber(busModelId, dimNum);
                    }
                    Set membNums = viewNumbers.computeIfAbsent(id, v -> new HashSet(16));
                    membNums.add(membNum);
                }
            }
        }
        return dimMembNumMap;
    }

    @Deprecated
    public static BinaryExpr switchFormulaStr2Express(String formualStr) {
        ArrayList<String> membInfoStrList = new ArrayList<String>(16);
        formualStr = ExamineServiceHelper.findMembInfoStr(membInfoStrList, formualStr);
        ScriptParseUtils parse = new ScriptParseUtils();
        BinaryExpr formulaExpress = null;
        List<IExpress> exprList = parse.prase(formualStr);
        if (exprList != null && !exprList.isEmpty()) {
            formulaExpress = (BinaryExpr)exprList.get(0);
            ExamineServiceHelper.replaceFormulaMemb(formulaExpress, 0, membInfoStrList);
        }
        return formulaExpress;
    }

    public static int replaceFormulaMemb(BinaryExpr currentExpress, int curMembCount, List<String> membInfoStrList) {
        IExpress left = currentExpress.getLeft();
        IExpress right = currentExpress.getRight();
        if (left instanceof NameExpr) {
            if (left.toString().startsWith("#MARK")) {
                currentExpress.setLeft(ExamineServiceHelper.getFormulaMembExpr(membInfoStrList.get(curMembCount++)));
            }
        } else if (left instanceof BinaryExpr) {
            curMembCount = ExamineServiceHelper.replaceFormulaMemb((BinaryExpr)left, curMembCount, membInfoStrList);
        }
        if (right instanceof NameExpr) {
            currentExpress.setRight(ExamineServiceHelper.getFormulaMembExpr(membInfoStrList.get(curMembCount++)));
        } else if (right instanceof BinaryExpr) {
            curMembCount = ExamineServiceHelper.replaceFormulaMemb((BinaryExpr)right, curMembCount, membInfoStrList);
        }
        return curMembCount;
    }

    public static IExpress getFormulaMembExpr(String membStr) {
        String[] dimGrops;
        MemberGroupExpr membSetExpr = new MemberGroupExpr();
        MemberExpr membExpr = null;
        for (String dimMembStr : dimGrops = membStr.split(",")) {
            String dimNum = dimMembStr.split("\\|")[0];
            String membNum = dimMembStr.split("\\|")[1];
            membExpr = new MemberExpr();
            membExpr.setDimNumber(dimNum);
            membExpr.setNumber(membNum);
            membSetExpr.addMember(membExpr);
        }
        return membSetExpr;
    }

    public static String findMembInfoStr(List<String> membInfoStrList, String formulaStr) {
        char[] chars = formulaStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        StringBuilder newSb = new StringBuilder();
        int index = 0;
        for (int i = 0; i < formulaStr.length(); ++i) {
            if (chars[i] == '\"') {
                newSb.append("#").append(index++).append("MARK");
                ++i;
                while (i < formulaStr.length() && chars[i] != '\"') {
                    sb.append(chars[i]);
                    ++i;
                }
                membInfoStrList.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            newSb.append(chars[i]);
        }
        return newSb.toString();
    }

    public static Map<String, DynamicInfoCollection> qureyDimMembInfo(Map<String, Set<ExamineViewMember>> dimMapMembNums, long modelId) {
        HashMap<String, DynamicInfoCollection> dimMembFullInfo = new HashMap<String, DynamicInfoCollection>(dimMapMembNums.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        dimMapMembNums.remove("dataset");
        dimMapMembNums.remove("Dataset");
        Map viewByModelId = ViewGroupManager.getInstance().getViewByModelId(modelId);
        Map variableMap = VariableCacheService.getInstance().listVariableFromLocalCache(Long.valueOf(modelId)).getVariableDtoMap();
        for (Map.Entry<String, Set<ExamineViewMember>> entry : dimMapMembNums.entrySet()) {
            String dimNumber = entry.getKey();
            Set<ExamineViewMember> membNumbers = entry.getValue();
            DynamicInfoCollection dimMembInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f", (String)"ExamineServiceHelper_0", (String)"epm-eb-business", (Object[])new Object[0]), new String[]{"id", "number", "name", "viewNum"});
            if (membNumbers != null && !membNumbers.isEmpty()) {
                block1: for (ExamineViewMember examineViewMember : membNumbers) {
                    if (TemplateVarCommonUtil.checkIsVar((String)examineViewMember.getMemberNum(), (String)dimNumber).booleanValue()) {
                        VariableDto dynamicObject = (VariableDto)variableMap.get(dimNumber + ":" + examineViewMember.getMemberNum());
                        if (dynamicObject == null) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u7684\u53d8\u91cf\u6210\u5458\u201c%2\u201d\u4e0d\u5b58\u5728\u3002", (String)"EbExamineEditPlugin_57", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, examineViewMember.getMemberNum()}));
                        }
                        String id = String.valueOf(dynamicObject.getId());
                        String number = dynamicObject.getNumber();
                        String name = dynamicObject.getName();
                        dimMembInfo.addInfo(new Object[]{id, number, name, dynamicObject.getViewNum()});
                        continue;
                    }
                    List dimensionList = modelCacheHelper.getDimensionList().stream().filter(e -> org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)dimNumber, (CharSequence)e.getNumber())).collect(Collectors.toList());
                    for (Dimension dimension : dimensionList) {
                        Member member;
                        List dimensionViews;
                        Optional<Long> first;
                        Long viewId = 0L;
                        if (StringUtils.isNotEmpty((String)examineViewMember.getViewNum()) && (first = (dimensionViews = (List)viewByModelId.get(dimension.getId())).stream().filter(x -> x.getNumber().equals(examineViewMember.getViewNum())).map(x -> x.getId()).findFirst()).isPresent()) {
                            viewId = first.get();
                        }
                        if ((member = modelCacheHelper.getMember(dimension.getNumber(), viewId, examineViewMember.getMemberNum())) == null) continue;
                        dimMembInfo.addInfo(new Object[]{member.getId().toString(), member.getNumber(), member.getName(), examineViewMember.getViewNum()});
                        continue block1;
                    }
                }
            }
            dimMembFullInfo.put(dimNumber, dimMembInfo);
        }
        return dimMembFullInfo;
    }

    public static String changeFormulaShow(String formulaStr, Map<String, DynamicInfoCollection> dimMembFullInfo, Map<Long, String> templateInfoMap, Dimension mainDimension) {
        StringBuilder formulashowVal = null;
        try {
            ArrayList<String> membInfoStrList = new ArrayList<String>(16);
            formulaStr = ExamineServiceHelper.findMembInfoStr(membInfoStrList, formulaStr);
            char[] newChars = formulaStr.toCharArray();
            int count = 0;
            StringBuilder formulaMembshowVal = new StringBuilder();
            formulashowVal = new StringBuilder();
            Boolean isParam = true;
            for (int i = 0; i < formulaStr.length(); ++i) {
                if (newChars[i] == '#') {
                    String[] dimGroups;
                    String membInfoStr;
                    String[] split;
                    isParam = false;
                    if ((split = (membInfoStr = (String)membInfoStrList.get(count++)).split("#")).length > 1) {
                        String tempName = templateInfoMap.get(Long.parseLong(split[0].split("\\|")[1]));
                        formulaMembshowVal.append(tempName).append("|");
                        dimGroups = split[1].split(",");
                    } else {
                        dimGroups = split[0].split(",");
                    }
                    for (String dimInfo : dimGroups) {
                        String membName;
                        if (dimInfo.indexOf("dataset") > -1 || dimInfo.indexOf("Dataset") > -1) continue;
                        String dimNum = dimInfo.split("\\|")[0];
                        String membNum = dimInfo.split("\\|")[1];
                        DynamicInfoCollection.InfoObject dimMembInfo = dimMembFullInfo.get(dimNum).getInfoByOneProp("number", (Object)membNum);
                        if (dimMembInfo == null) continue;
                        if (mainDimension == null) {
                            membName = (String)dimMembInfo.getValueByPropName("name");
                            formulaMembshowVal.append(membName);
                            formulaMembshowVal.append("|");
                            continue;
                        }
                        if (!dimNum.equals(mainDimension.getNumber())) continue;
                        formulaMembshowVal.append(mainDimension.getName());
                        formulaMembshowVal.append("|");
                        membName = (String)dimMembInfo.getValueByPropName("name");
                        formulaMembshowVal.append(membName);
                        formulaMembshowVal.append("|");
                    }
                    formulashowVal.append("{").append(formulaMembshowVal.substring(0, formulaMembshowVal.length() - 1)).append("}");
                    formulaMembshowVal.setLength(0);
                    i += 4;
                    continue;
                }
                if (!isParam.booleanValue() && newChars[i] == 'K') {
                    isParam = true;
                    continue;
                }
                if (isParam.booleanValue()) {
                    formulashowVal.append(newChars[i]);
                    continue;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return "";
        }
        return formulashowVal.toString();
    }

    public static Map<String, Set<ExamineViewMember>> mapDimMembNums(List<ExamineFormulaInfo> examineFormulaInfos, List<String> membInfoStrList, Map<String, View> dimViewMap, Map<String, String> xuniMemberMap) {
        if (examineFormulaInfos == null) {
            examineFormulaInfos = new ArrayList<ExamineFormulaInfo>(10);
        }
        HashMap<String, Set<ExamineViewMember>> dimMapMembNums = new HashMap<String, Set<ExamineViewMember>>(16);
        String viewNum = null;
        HashSet<ExamineViewMember> membNums = null;
        for (String membInfoStr : membInfoStrList) {
            String[] dimGroups;
            ExamineFormulaInfo examineFormulaInfo = new ExamineFormulaInfo();
            String[] split = membInfoStr.split("#");
            if (split.length > 1) {
                examineFormulaInfo.setTemplateId(Long.valueOf(Long.parseLong(split[0].split("\\|")[1])));
                dimGroups = split[1].split(",");
            } else {
                dimGroups = split[0].split(",");
            }
            DynamicInfoCollection membInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u52fe\u7a3d\u6210\u5458\u4fe1\u606f", (String)"ExamineServiceHelper_1", (String)"epm-eb-business", (Object[])new Object[0]), new String[]{"id", "number", "name", "dimNum", "viewNum", "viewName"});
            for (String dimInfo : dimGroups) {
                ExamineViewMember viewMember;
                if (dimInfo.indexOf("dataset") > -1) continue;
                String[] split1 = dimInfo.split("\\|");
                String dimNum = dimInfo.split("\\|")[0];
                String membNum = dimInfo.split("\\|")[1];
                if (split1.length >= 3 && !View.NoViewDimNums.contains(dimNum)) {
                    viewNum = dimInfo.split("\\|")[2];
                } else if (!View.NoViewDimNums.contains(dimNum) && CollectionUtils.isNotEmpty(dimViewMap)) {
                    View view;
                    if (CollectionUtils.isNotEmpty(xuniMemberMap)) {
                        viewNum = xuniMemberMap.get(membNum);
                    }
                    if (StringUtils.isEmpty((String)viewNum) && (view = dimViewMap.get(dimNum)) != null) {
                        viewNum = view.getNumber();
                    }
                } else {
                    viewNum = null;
                }
                membNums = (HashSet<ExamineViewMember>)dimMapMembNums.get(dimNum);
                if (membInfo != null) {
                    membInfo.addInfo(new Object[]{null, membNum, null, dimNum, viewNum, null});
                }
                if (membNums == null) {
                    membNums = new HashSet<ExamineViewMember>(16);
                    viewMember = new ExamineViewMember();
                    viewMember.setMemberNum(membNum);
                    viewMember.setViewNum(viewNum);
                    membNums.add(viewMember);
                    dimMapMembNums.put(dimNum, membNums);
                    continue;
                }
                viewMember = new ExamineViewMember();
                viewMember.setMemberNum(membNum);
                viewMember.setViewNum(viewNum);
                membNums.add(viewMember);
            }
            examineFormulaInfo.setDynamicInfoCollection(membInfo);
            if (examineFormulaInfos == null) continue;
            examineFormulaInfos.add(examineFormulaInfo);
        }
        return dimMapMembNums;
    }

    public static void createMemberReference(Long modelId) {
        Map ruleColumnRowMap = DbUtils.getColumnRowMap((String)RuleUtils.class.getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,frangediminfo,fformula,fdimsetinfo from t_eb_examine where fmodelid = ?", (Object[])ObjUtils.getObjectArray((Object[])new Object[]{modelId}), (String)"fid");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
        LinkedList quotes = Lists.newLinkedList();
        for (Map.Entry entry : ruleColumnRowMap.entrySet()) {
            String formula;
            Member member;
            DynamicObject dynamicObject;
            Dimension dimension;
            Map rowMap = (Map)entry.getValue();
            Map dimensionMap = modelCacheHelper.getDimensionMap();
            Long resourceId = ObjUtils.getLong(rowMap.get("fid"));
            String rangeStrs = ObjUtils.getString(rowMap.get("frangediminfo"));
            if (StringUtils.isNotBlank((String)rangeStrs)) {
                Map parseDimRangeMap = (Map)ObjectSerialUtil.parseObject((String)ObjUtils.getString(rowMap.get("frangediminfo")), (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){}, (Feature[])new Feature[0]);
                for (Map.Entry listEntry : parseDimRangeMap.entrySet()) {
                    String dimensionNumber = (String)listEntry.getKey();
                    dimension = (Dimension)dimensionMap.get(dimensionNumber);
                    List value = (List)listEntry.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
                    for (MemberCondition memberCondition : value) {
                        String number = memberCondition.getNumber();
                        if (TemplateVarCommonUtil.checkIsVar((String)number, (String)dimensionNumber).booleanValue()) {
                            dynamicObject = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.id", "=", (Object)dimension.getId()).and("number", "=", (Object)number).toArray());
                            if (dynamicObject == null) continue;
                            quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), Long.valueOf(dynamicObject.getLong("id")), MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.Examine, resourceId));
                            continue;
                        }
                        member = dimension.getStructOfMember(number);
                        if (member == null) continue;
                        quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), member.getId(), MemberQuoteResourceEnum.Examine, resourceId));
                    }
                }
            }
            if (!StringUtils.isNotBlank((String)(formula = ObjUtils.getString(rowMap.get("fformula"))))) continue;
            BinaryExpr binaryExpr = (BinaryExpr)ExamineUtils.parse(formula);
            HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>(16);
            ExamineServiceHelper.parseExpr(binaryExpr, memberMap);
            for (Map.Entry entry1 : memberMap.entrySet()) {
                String dimensionNumber = (String)entry1.getKey();
                dimension = (Dimension)dimensionMap.get(dimensionNumber);
                if (dimension == null) continue;
                for (String memberNumber : (Set)entry1.getValue()) {
                    if (TemplateVarCommonUtil.checkIsVar((String)memberNumber, (String)dimension.getNumber()).booleanValue()) {
                        dynamicObject = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.id", "=", (Object)dimension.getId()).and("number", "=", (Object)memberNumber).toArray());
                        if (dynamicObject == null) continue;
                        quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), Long.valueOf(dynamicObject.getLong("id")), MemberTypeEnum.VARIABLE, MemberQuoteResourceEnum.Examine, resourceId));
                        continue;
                    }
                    member = dimension.getStructOfMember(memberNumber);
                    if (member == null) continue;
                    quotes.add(new MemberQuoteDao(modelId, Long.valueOf(0L), dimension.getId(), member.getId(), MemberQuoteResourceEnum.Examine, resourceId));
                }
            }
        }
        if (!quotes.isEmpty()) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
        }
    }

    private static void parseExpr(BinaryExpr expr, Map<String, Set<String>> memberMap) {
        if (expr == null) {
            return;
        }
        if (expr.getLeft() instanceof BinaryExpr) {
            ExamineServiceHelper.parseExpr((BinaryExpr)expr.getLeft(), memberMap);
        } else if (expr.getLeft() instanceof MemberGroupExpr) {
            ExamineServiceHelper.parseExpr((MemberGroupExpr)expr.getLeft(), memberMap);
        } else if (expr.getLeft() instanceof MemberExpr) {
            ExamineServiceHelper.parseExpr((MemberExpr)expr.getLeft(), memberMap);
        }
        if (expr.getRight() instanceof BinaryExpr) {
            ExamineServiceHelper.parseExpr((BinaryExpr)expr.getRight(), memberMap);
        } else if (expr.getRight() instanceof MemberGroupExpr) {
            ExamineServiceHelper.parseExpr((MemberGroupExpr)expr.getRight(), memberMap);
        } else if (expr.getRight() instanceof MemberExpr) {
            ExamineServiceHelper.parseExpr((MemberExpr)expr.getRight(), memberMap);
        }
    }

    private static void parseExpr(MemberGroupExpr expr, Map<String, Set<String>> memberMap) {
        if (expr == null) {
            return;
        }
        for (MemberExpr _expr : expr.getMembers()) {
            ExamineServiceHelper.parseExpr(_expr, memberMap);
        }
    }

    private static void parseExpr(MemberExpr expr, Map<String, Set<String>> memberMap) {
        if (expr == null || memberMap == null) {
            return;
        }
        Set<String> memberSet = memberMap.get(expr.getDimNumber());
        if (memberSet == null) {
            memberSet = new HashSet<String>(16);
            memberMap.put(expr.getDimNumber(), memberSet);
        }
        memberSet.add(expr.getNumber());
    }

    public static Map<String, DynamicInfoCollection> qureyDimMembInfoByMemberCondition(Map<String, List<MemberCondition>> dimMemberCondition, long modelId) {
        QFilter qModel = new QFilter("model", "=", (Object)modelId);
        HashMap<String, DynamicInfoCollection> dimMembFullInfo = new HashMap<String, DynamicInfoCollection>(dimMemberCondition.size());
        dimMemberCondition.remove("dataset");
        dimMemberCondition.remove("Dataset");
        for (Map.Entry<String, List<MemberCondition>> entry : dimMemberCondition.entrySet()) {
            String dimNumber = entry.getKey();
            List<MemberCondition> memberConditions = entry.getValue();
            DynamicInfoCollection dimMembInfo = new DynamicInfoCollection(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f", (String)"ExamineServiceHelper_0", (String)"epm-eb-business", (Object[])new Object[0]), new String[]{"id", "number", "name"});
            if (memberConditions != null && !memberConditions.isEmpty()) {
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                    for (MemberCondition memberCondition : memberConditions) {
                        if (TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimNumber).booleanValue()) {
                            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id,number,name", (QFilter[])new QFilter[]{qModel, new QFilter("number", "=", (Object)memberCondition.getNumber()), new QFilter("dimension.number", "=", (Object)dimNumber)});
                            String id = dynamicObject.getString("id");
                            String number = dynamicObject.getString("number");
                            String name = dynamicObject.getString("name");
                            dimMembInfo.addInfo(new Object[]{id, number, name});
                            continue;
                        }
                        dimMembInfo.addInfo(new Object[]{memberCondition.getId(), memberCondition.getNumber(), memberCondition.getName()});
                    }
                } else {
                    for (MemberCondition memberCondition : memberConditions) {
                        dimMembInfo.addInfo(new Object[]{memberCondition.getId(), memberCondition.getNumber(), memberCondition.getName()});
                    }
                }
            }
            dimMembFullInfo.put(dimNumber, dimMembInfo);
        }
        return dimMembFullInfo;
    }

    public String upgradeExamineRangeData(Long modelId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return null;
        }
        String sql = "select fid,frangediminfo,fmaindimension from t_eb_examine where fmodelid =  " + modelId + " ;";
        HashMap<Long, String> needUpgradeData = new HashMap<Long, String>(16);
        HashMap mainDimensionData = new HashMap(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        DB.query((DBRoute)DBRoute.of((String)"epm"), (String)sql, rs -> {
            while (rs.next()) {
                String mainDimension;
                Dimension dimension;
                String oldMainDimension;
                long fid = rs.getLong("fid");
                String rangeDimInfo = rs.getString("frangediminfo");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)rangeDimInfo) && rangeDimInfo.contains("|")) {
                    needUpgradeData.put(fid, rangeDimInfo);
                }
                if (StringUtils.isBlank((String)(oldMainDimension = rs.getString("fmaindimension")))) {
                    dimension = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
                    if (dimension == null) continue;
                    mainDimension = dimension.getId() + "-" + dimension.getNumber();
                    mainDimensionData.put(fid, mainDimension);
                    continue;
                }
                dimension = modelCacheHelper.getDimension(oldMainDimension.split("-")[1]);
                if (dimension == null || (mainDimension = dimension.getId() + "-" + dimension.getNumber()).equals(oldMainDimension)) continue;
                mainDimensionData.put(fid, mainDimension);
            }
            return needUpgradeData;
        });
        if (mainDimensionData.size() <= 0 && needUpgradeData.size() <= 0) {
            return ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u52fe\u7a3d\u5173\u7cfb\u65e0\u9700\u5347\u7ea7\u3002", (String)"ExamineListPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        if (mainDimensionData.size() > 0) {
            String maindimensionSql = "update t_eb_examine set fmaindimension = ? where fid = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(needUpgradeData.size());
            for (Map.Entry entry : mainDimensionData.entrySet()) {
                Object[] objects = new Object[]{entry.getValue(), entry.getKey()};
                paramList.add(objects);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)maindimensionSql, paramList);
        }
        if (needUpgradeData.size() > 0) {
            Map<String, Map<String, SimpleMemberDto>> needDimMemberData = this.getNeedDimMemberData(modelId, needUpgradeData);
            String updateSql = "update t_eb_examine set frangediminfo = ? where fid = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(needUpgradeData.size());
            for (Map.Entry entry : needUpgradeData.entrySet()) {
                Object[] objects = new Object[]{this.upgradeRangeDimInfo((String)entry.getValue(), needDimMemberData), entry.getKey()};
                paramList.add(objects);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, paramList);
            UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_examine");
        }
        return ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"ExamineListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private Map<String, Map<String, SimpleMemberDto>> getNeedDimMemberData(Long modelId, Map<Long, String> needUpgradeData) {
        HashMap<String, Map<String, SimpleMemberDto>> needDimMemberData = new HashMap<String, Map<String, SimpleMemberDto>>(16);
        HashMap<String, Set> dimRangeMemberNumber = new HashMap<String, Set>(16);
        for (Map.Entry<Long, String> entry : needUpgradeData.entrySet()) {
            String dimRangeStr = entry.getValue();
            Map<String, List<Pair<String, String>>> dimRangeDataMap = ExamineServiceHelper.parseDimRangeStr2Map(dimRangeStr);
            for (Map.Entry<String, List<Pair<String, String>>> dimRangeDataEntry : dimRangeDataMap.entrySet()) {
                String dimNumber = dimRangeDataEntry.getKey();
                List<Pair<String, String>> memNumberScopes = dimRangeDataEntry.getValue();
                if (CollectionUtils.isEmpty(memNumberScopes)) continue;
                Set memberNumbers = dimRangeMemberNumber.computeIfAbsent(dimNumber, e -> new HashSet(16));
                for (Pair<String, String> pair : memNumberScopes) {
                    memberNumbers.add("'" + (String)pair.getKey() + "'");
                }
            }
        }
        if (dimRangeMemberNumber.size() > 0) {
            for (Map.Entry<Long, String> entry : dimRangeMemberNumber.entrySet()) {
                String dimNumber = (String)((Object)entry.getKey());
                Set memNums = (Set)((Object)entry.getValue());
                Map<String, SimpleMemberDto> dimMemberData = this.getDimMemberData(dimNumber, modelId, memNums);
                needDimMemberData.put(dimNumber, dimMemberData);
            }
        }
        return needDimMemberData;
    }

    private Map<String, SimpleMemberDto> getDimMemberData(String dimNumber, Long modelId, Set<String> memNums) {
        HashMap<String, SimpleMemberDto> dimMemberData = new HashMap<String, SimpleMemberDto>(16);
        String memberTable = SysDimensionEnum.getMemberTableByNumber((String)dimNumber);
        String memberTable_l = memberTable + "_l";
        Lang lang = Lang.get();
        String sql = "select a.fid,a.fnumber,b.fname from " + memberTable + " a left join " + memberTable_l + " b on a.fid = b.fid  AND B.FLocaleId = '" + lang.name() + "' where a.fmodelid = " + modelId + " and a.fnumber in (" + String.join((CharSequence)",", memNums) + ");";
        try (DataSet ds = DB.queryDataSet((String)"getNeedModelDimMemData", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("fid");
                String number = row.getString("fnumber");
                String name = row.getString("fname");
                dimMemberData.put(number, new SimpleMemberDto(id, name, number));
            }
        }
        return dimMemberData;
    }

    private String upgradeRangeDimInfo(String dimRangeStr, Map<String, Map<String, SimpleMemberDto>> needDimMemberData) {
        HashMap dimMemberConditionMap = new HashMap(16);
        Map<String, List<Pair<String, String>>> dimRangeDataMap = ExamineServiceHelper.parseDimRangeStr2Map(dimRangeStr);
        for (Map.Entry<String, List<Pair<String, String>>> entry : dimRangeDataMap.entrySet()) {
            String dimNumber = entry.getKey();
            List<Pair<String, String>> memNumberScopes = entry.getValue();
            if (CollectionUtils.isEmpty(memNumberScopes)) continue;
            ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(memNumberScopes.size());
            for (Pair<String, String> memNumberScope : memNumberScopes) {
                String memNumber = (String)memNumberScope.getKey();
                String scope = (String)memNumberScope.getValue();
                if (needDimMemberData.get(dimNumber) != null && needDimMemberData.get(dimNumber).get(memNumber) != null) {
                    SimpleMemberDto simpleMemberDto = needDimMemberData.get(dimNumber).get(memNumber);
                    MemberCondition memberCondition = new MemberCondition();
                    memberConditions.add(memberCondition);
                    memberCondition.setId(String.valueOf(simpleMemberDto.getId()));
                    memberCondition.setName(simpleMemberDto.getName());
                    memberCondition.setNumber(simpleMemberDto.getNumber());
                    memberCondition.setRange(scope);
                }
                needDimMemberData.get(dimNumber);
            }
            dimMemberConditionMap.put(dimNumber, memberConditions);
        }
        return SerializationUtils.toJsonString(dimMemberConditionMap);
    }

    public static Boolean examineUpgrade(Long modelId) {
        long id;
        Row row;
        ArrayList<Object[]> updateVariables = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateFormula = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateRangeDimInfo = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateGroup = new ArrayList<Object[]>(16);
        String sql = "select fid,fformula,fformulaextend,fmodelid,frangediminfo from t_eb_examine where 1=1";
        String sqlDefaultView = "select v.fid,v.fnumber viewNum,d.fnumber dimNum,v.fmodelid,v.fsource from t_eb_dimensionview v left join t_eb_dimension d on v.fdimensionid=d.fid where 1=1 ";
        String sqlRootMember = "select m.fid,m.fnumber,m.fmemberid,m.fmodelid,m.fviewid,d.fnumber dimNum from t_eb_viewmember m left join t_eb_dimension d on m.fdimensionid=d.fid where m.flevel='1'";
        String sqlExamineGroupMember = "select m.fentryid,m.fmemberscope,e.fmodelid,m.fdimnumber from t_eb_examine_memberscope m left join t_eb_examinecategory e on m.fid=e.fid where 1=1";
        String orgSql = "select fid from t_eb_structofent where fmembersource='5'";
        String userDefineSql = "select fid from t_eb_structofdefined where fmembersource='5'";
        String icEntSql = "select fid from t_eb_structoficentity where fmembersource='5'";
        HashSet<Long> memberIds = new HashSet<Long>(16);
        String xuniMemberSql = "select fid,fnumber,fviewid,fmodelid from t_eb_viewmember where 1=1 ";
        HashMap<Long, Map> viewMap = new HashMap<Long, Map>(16);
        HashMap<Long, Map> otherViewMap = new HashMap<Long, Map>(16);
        HashMap<Long, Map> xuniViewMemberMap = new HashMap<Long, Map>(16);
        if (modelId != null) {
            sql = sql + " and fmodelid = " + modelId;
            sqlDefaultView = sqlDefaultView + " and v.fmodelid = " + modelId;
            sqlRootMember = sqlRootMember + " and m.fmodelid = " + modelId;
            sqlExamineGroupMember = sqlExamineGroupMember + " and e.fmodelid = " + modelId;
            xuniMemberSql = xuniMemberSql + " and fmodelid = " + modelId;
            orgSql = orgSql + " and fmodelid = " + modelId;
            userDefineSql = userDefineSql + " and fmodelid = " + modelId;
            icEntSql = icEntSql + " and fmodelid = " + modelId;
        } else {
            String modelSql = " select fid from t_eb_model order by fmodifytime desc";
            DataSet modelDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.model", (DBRoute)DBRoute.of((String)"epm"), (String)modelSql);
            ArrayList<Long> modelIds = new ArrayList<Long>(10);
            if (modelDataset != null && !modelDataset.isEmpty()) {
                row = null;
                while (modelDataset.hasNext()) {
                    row = modelDataset.next();
                    id = row.getLong("fid");
                    modelIds.add(id);
                    if (modelIds.size() < 20) continue;
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(modelIds)) {
                sql = sql + " and fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                sqlDefaultView = sqlDefaultView + " and v.fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                sqlRootMember = sqlRootMember + " and m.fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                sqlExamineGroupMember = sqlExamineGroupMember + " and e.fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                xuniMemberSql = xuniMemberSql + " and fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                orgSql = orgSql + " and fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                userDefineSql = userDefineSql + " and fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
                icEntSql = icEntSql + " and fmodelid in(" + StringUtils.join(modelIds, (String)",") + ")";
            }
        }
        log.info("icEntSql>>>>" + icEntSql);
        DataSet icEntDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.memberid", (DBRoute)DBRoute.of((String)"epm"), (String)icEntSql);
        if (icEntDataset != null && !icEntDataset.isEmpty()) {
            Row row2 = null;
            while (icEntDataset.hasNext()) {
                row2 = icEntDataset.next();
                long id2 = row2.getLong("fid");
                memberIds.add(id2);
            }
        }
        log.info("userDefineSql>>>>" + userDefineSql);
        DataSet userDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.memberid", (DBRoute)DBRoute.of((String)"epm"), (String)userDefineSql);
        if (userDataset != null && !userDataset.isEmpty()) {
            Row row3 = null;
            while (userDataset.hasNext()) {
                row3 = userDataset.next();
                long id3 = row3.getLong("fid");
                memberIds.add(id3);
            }
        }
        log.info("orgSql>>>>" + orgSql);
        DataSet orgDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.memberid", (DBRoute)DBRoute.of((String)"epm"), (String)orgSql);
        if (orgDataset != null && !orgDataset.isEmpty()) {
            row = null;
            while (orgDataset.hasNext()) {
                row = orgDataset.next();
                id = row.getLong("fid");
                memberIds.add(id);
            }
        }
        if (!memberIds.isEmpty()) {
            xuniMemberSql = xuniMemberSql + " and fmemberid in(" + StringUtils.join(memberIds, (String)",") + ")";
        }
        HashMap<Long, String> viewNumMap = new HashMap<Long, String>(16);
        log.info("sqlDefaultView>>>>" + sqlDefaultView);
        DataSet modelDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.view", (DBRoute)DBRoute.of((String)"epm"), (String)sqlDefaultView);
        if (modelDataset != null && !modelDataset.isEmpty()) {
            Row row4 = null;
            while (modelDataset.hasNext()) {
                row4 = modelDataset.next();
                if ("1".equals(row4.getString("fsource"))) {
                    Map stringMap = viewMap.computeIfAbsent(row4.getLong("fmodelid"), f -> Maps.newHashMap());
                    View view = new View();
                    view.setId(row4.getLong("fid"));
                    view.setNumber(row4.getString("viewNum"));
                    stringMap.put(row4.getString("dimNum"), view);
                }
                viewNumMap.put(row4.getLong("fid"), row4.getString("viewNum"));
            }
        }
        log.info("xuniMemberSql>>>>" + xuniMemberSql);
        DataSet xuniMemberDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.member", (DBRoute)DBRoute.of((String)"epm"), (String)xuniMemberSql);
        if (xuniMemberDataset != null && !xuniMemberDataset.isEmpty()) {
            Row row5 = null;
            while (xuniMemberDataset.hasNext()) {
                row5 = xuniMemberDataset.next();
                Map stringMap = xuniViewMemberMap.computeIfAbsent(row5.getLong("fmodelid"), f -> Maps.newHashMap());
                String viewNum = (String)viewNumMap.get(row5.getLong("fviewid"));
                stringMap.put(row5.getString("fnumber"), viewNum);
            }
        }
        log.info("sqlRootMember>>>>" + sqlRootMember);
        DataSet memberDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.member", (DBRoute)DBRoute.of((String)"epm"), (String)sqlRootMember);
        if (memberDataset != null && !memberDataset.isEmpty()) {
            Row row6 = null;
            while (memberDataset.hasNext()) {
                row6 = memberDataset.next();
                Map stringMap = otherViewMap.computeIfAbsent(row6.getLong("fmodelid"), f -> Maps.newHashMap());
                Member member = new Member();
                member.setId(row6.getLong("fmemberid"));
                member.setNumber(row6.getString("fnumber"));
                stringMap.put(row6.getLong("fviewid"), member);
            }
        }
        log.info("sqlExamineGroupMember>>>>" + sqlExamineGroupMember);
        DataSet groupDataset = DB.queryDataSet((String)"ExamineUpgradeImpl.group", (DBRoute)DBRoute.of((String)"epm"), (String)sqlExamineGroupMember);
        if (groupDataset != null && !groupDataset.isEmpty()) {
            Row row7 = null;
            while (groupDataset.hasNext()) {
                try {
                    row7 = groupDataset.next();
                    String dimNumber = row7.getString("fdimnumber");
                    if (View.NoViewDimNums.contains(dimNumber)) continue;
                    Map dimViewMap = (Map)viewMap.get(row7.getLong("fmodelid"));
                    Map dimViewStringMap = (Map)otherViewMap.get(row7.getLong("fmodelid"));
                    long id4 = row7.getLong("fentryid");
                    String fmemberscope = row7.getString("fmemberscope");
                    if (!StringUtils.isNotEmpty((String)fmemberscope)) continue;
                    List memberConditions = (List)ObjectSerialUtil.parseObject((String)fmemberscope, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
                    Boolean rangeBoolean = false;
                    for (MemberCondition memberCondition : memberConditions) {
                        Member member;
                        View view = (View)dimViewMap.get(dimNumber);
                        if (StringUtils.isEmpty((String)memberCondition.getViewId())) {
                            if (!rangeBoolean.booleanValue()) {
                                rangeBoolean = true;
                            }
                            if (view == null) continue;
                            memberCondition.setViewId(String.valueOf(view.getId()));
                            continue;
                        }
                        if (!dimNumber.equalsIgnoreCase(memberCondition.getNumber()) || view == null || !view.getId().equals(IDUtils.toLong((Object)memberCondition.getViewId()))) continue;
                        if (!rangeBoolean.booleanValue()) {
                            rangeBoolean = true;
                        }
                        if (dimViewStringMap == null || (member = (Member)dimViewStringMap.get(IDUtils.toLong((Object)memberCondition.getViewId()))) == null) continue;
                        memberCondition.setId(String.valueOf(member.getId()));
                        memberCondition.setNumber(member.getNumber());
                        memberCondition.setLongnumber(member.getNumber());
                    }
                    if (!rangeBoolean.booleanValue()) continue;
                    updateGroup.add(new Object[]{SerializationUtils.toJsonString((Object)memberConditions), id4});
                }
                catch (Exception e) {
                    log.error("examinegroup parse error:", (Throwable)e);
                }
            }
        }
        log.info("sql>>>>" + sql);
        DataSet dataSet = DB.queryDataSet((String)"ExamineUpgradeImpl.formulaextend", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty()) {
            Row row8 = null;
            while (dataSet.hasNext()) {
                row8 = dataSet.next();
                long id5 = row8.getLong("fid");
                try {
                    List examineFormulaExtends;
                    String formulaStr = row8.getString("fformula");
                    String fformulaextend = row8.getString("fformulaextend");
                    Map dimViewMap = (Map)viewMap.get(row8.getLong("fmodelid"));
                    Map xuniMemberMap = (Map)xuniViewMemberMap.get(row8.getLong("fmodelid"));
                    Map dimViewStringMap = (Map)otherViewMap.get(row8.getLong("fmodelid"));
                    String rangeStrs = row8.getString("frangediminfo");
                    if (StringUtils.isNotBlank((String)rangeStrs)) {
                        Map parseDimRangeMap = (Map)ObjectSerialUtil.parseObject((String)rangeStrs, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){}, (Feature[])new Feature[0]);
                        Boolean rangeBoolean = false;
                        for (Map.Entry entry : parseDimRangeMap.entrySet()) {
                            if (View.NoViewDimNums.contains(entry.getKey())) continue;
                            for (MemberCondition memberCondition : (List)entry.getValue()) {
                                Member member;
                                View view = (View)dimViewMap.get(entry.getKey());
                                if (StringUtils.isEmpty((String)memberCondition.getViewId())) {
                                    if (!rangeBoolean.booleanValue()) {
                                        rangeBoolean = true;
                                    }
                                    if (view == null) continue;
                                    memberCondition.setViewId(String.valueOf(view.getId()));
                                    continue;
                                }
                                if (!((String)entry.getKey()).equalsIgnoreCase(memberCondition.getNumber()) || view == null || !view.getId().equals(IDUtils.toLong((Object)memberCondition.getViewId()))) continue;
                                if (!rangeBoolean.booleanValue()) {
                                    rangeBoolean = true;
                                }
                                if (dimViewStringMap == null || (member = (Member)dimViewStringMap.get(IDUtils.toLong((Object)memberCondition.getViewId()))) == null) continue;
                                memberCondition.setId(String.valueOf(member.getId()));
                                memberCondition.setNumber(member.getNumber());
                                memberCondition.setLongnumber(member.getNumber());
                            }
                        }
                        if (rangeBoolean.booleanValue()) {
                            updateRangeDimInfo.add(new Object[]{SerializationUtils.toJsonString((Object)parseDimRangeMap), id5});
                        }
                    }
                    ArrayList<String> membInfoStrList = new ArrayList<String>(10);
                    ArrayList<ExamineFormulaInfo> examineFormulaInfos = new ArrayList<ExamineFormulaInfo>(10);
                    ExamineServiceHelper.findMembInfoStr(membInfoStrList, formulaStr);
                    ExamineServiceHelper.mapDimMembNums(examineFormulaInfos, membInfoStrList, dimViewMap, xuniMemberMap);
                    String updateFormulaStr = ExamineServiceHelper.updateFormulaStr(formulaStr, examineFormulaInfos);
                    if (!updateFormulaStr.equals(formulaStr)) {
                        updateFormula.add(new Object[]{updateFormulaStr, id5});
                    }
                    List examineFormulaExtendsOld = null;
                    if (StringUtils.isNotBlank((String)fformulaextend)) {
                        examineFormulaExtendsOld = (List)JsonUtils.readValue((String)fformulaextend, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<List<ExamineFormulaExtend>>(){});
                        if (examineFormulaInfos.size() == examineFormulaExtendsOld.size()) continue;
                    }
                    if (!CollectionUtils.isNotEmpty(examineFormulaExtends = examineFormulaInfos.stream().map(x -> {
                        ExamineFormulaExtend examineFormulaExtend = new ExamineFormulaExtend();
                        examineFormulaExtend.setSelectDim(x.getSelectDim());
                        if (x.getTemplateId() != null) {
                            examineFormulaExtend.setLinkTemplateId(x.getTemplateId().toString());
                        }
                        examineFormulaExtend.setFormulaShowName(x.getFormulaShowName());
                        return examineFormulaExtend;
                    }).collect(Collectors.toList()))) continue;
                    updateVariables.add(new Object[]{SerializationUtils.toJsonString(examineFormulaExtends), id5});
                }
                catch (Exception e) {
                    log.error("ExamineUpgrade is error id:" + id5 + ":", (Throwable)e);
                }
            }
        }
        String sql1 = "update t_eb_examine set fformulaextend=? where fid=?";
        Boolean result = false;
        if (!updateVariables.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql1, updateVariables);
            result = true;
        }
        String sql2 = "update t_eb_examine set fformula=? where fid=?";
        if (!updateFormula.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql2, updateFormula);
            result = true;
        }
        String sql3 = "update t_eb_examine set frangediminfo=? where fid=?";
        if (!updateRangeDimInfo.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql3, updateRangeDimInfo);
            result = true;
        }
        String sql4 = "update t_eb_examine_memberscope set fmemberscope=? where fentryid=?";
        if (!updateGroup.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql4, updateGroup);
            result = true;
        }
        viewMap.keySet().forEach(x -> {
            ExamineServiceImpl.getInstance().clearExamineCache((Long)x);
            ExamineServiceImpl.getInstance().clearExamineGroupCache((Long)x);
        });
        return result;
    }

    private static String updateFormulaStr(String formulaStr, List<ExamineFormulaInfo> examineFormulaInfos) {
        char[] chars = formulaStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        StringBuilder newSb = new StringBuilder();
        for (int i = 0; i < formulaStr.length(); ++i) {
            if (chars[i] == '\"') {
                newSb.append(markStr);
                ++i;
                while (i < formulaStr.length() && chars[i] != '\"') {
                    sb.append(chars[i]);
                    ++i;
                }
                sb.setLength(0);
                continue;
            }
            newSb.append(chars[i]);
        }
        String newformulaStr = newSb.toString().replaceAll("\\$\\$pp\\$\\$", markStr2.toString());
        return ExamineServiceHelper.reduceFormulaModel2DBStr(newformulaStr, examineFormulaInfos);
    }

    public static String reduceFormulaModel2DBStr(String formulaStr, List<ExamineFormulaInfo> formulaMembs) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        char[] chars = formulaStr.toCharArray();
        String membNum = null;
        String dimNum = null;
        String viewNum = null;
        for (int j = 0; j < formulaStr.length(); ++j) {
            if (chars[j] == markStr2.charValue()) {
                ExamineFormulaInfo memberInfo = formulaMembs.get(count++);
                sb.append('\"');
                if (memberInfo.getTemplateId() != null) {
                    sb.append("Template").append('|').append(memberInfo.getTemplateId()).append('#');
                }
                for (DynamicInfoCollection.InfoObject dimMemb : memberInfo.getDynamicInfoCollection().getValues()) {
                    membNum = (String)dimMemb.getValueByPropName("number");
                    dimNum = (String)dimMemb.getValueByPropName("dimNum");
                    viewNum = (String)dimMemb.getValueByPropName("viewNum");
                    sb.append(dimNum);
                    sb.append('|');
                    sb.append(membNum);
                    if (StringUtils.isNotEmpty((String)viewNum)) {
                        sb.append('|');
                        sb.append(viewNum);
                    }
                    sb.append(',');
                }
                sb.setCharAt(sb.length() - 1, '\"');
                continue;
            }
            sb.append(chars[j]);
        }
        return sb.toString();
    }
}

