/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.examinev2.FillEnvironment;
import kd.epm.eb.business.expr.Cube;
import kd.epm.eb.business.expr.Dimension;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Member;
import kd.epm.eb.business.expr.MockDataReader;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.FunCalcFactory;
import kd.epm.eb.business.expr.expr.BinaryExpr;
import kd.epm.eb.business.expr.expr.ConditionExpr;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.expr.MemberGroupExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.parse.Parse2RPN;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.bo.ExamineItem;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.AnalyzeRangeUtils;
import kd.epm.eb.common.var.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class ExamineUtils {
    public static IExpress parse(String script) {
        script = ExamineUtils.dillFormulaString(script);
        Parse2RPN parse2rpn = new Parse2RPN();
        parse2rpn.parse(script);
        return parse2rpn.getExpr();
    }

    private static String dillFormulaString(String script) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (char c : script.toCharArray()) {
            if (c == '\"') {
                if (i % 2 == 0) {
                    stringBuilder.append("@MGE(");
                } else {
                    stringBuilder.append(")");
                }
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void fillExprRefMembers(IExpress expr, Map<Long, Map<String, Set<String>>> exprRefMembers, List<ExamineItem> examineItemList, FillEnvironment fillEnvironment) {
        if (expr == null) {
            return;
        }
        expr.setTop(fillEnvironment.isTop());
        if (expr instanceof ConditionExpr) {
            ConditionExpr _expr = (ConditionExpr)expr;
            ExamineUtils.fillExprRefMembers(_expr.getCondition(), exprRefMembers, examineItemList, fillEnvironment.pushTop());
            ExamineUtils.fillExprRefMembers(_expr.getLefts().get(0), exprRefMembers, examineItemList, fillEnvironment.pushTop());
            ExamineUtils.fillExprRefMembers(_expr.getRights().get(0), exprRefMembers, examineItemList, fillEnvironment.pushTop());
        } else if (expr instanceof FunctionExpr) {
            FunctionExpr _expr = (FunctionExpr)expr;
            List<IExpress> params = _expr.getParams();
            if (params != null) {
                for (IExpress param : params) {
                    ExamineUtils.fillExprRefMembers(param, exprRefMembers, examineItemList, fillEnvironment.pushTop());
                }
            }
        } else if (expr instanceof BinaryExpr) {
            BinaryExpr _expr = (BinaryExpr)expr;
            ExamineUtils.fillExprRefMembers(_expr.getLeft(), exprRefMembers, examineItemList, fillEnvironment.pushTop());
            ExamineUtils.fillExprRefMembers(_expr.getRight(), exprRefMembers, examineItemList, fillEnvironment.pushTop());
        } else if (expr instanceof MemberGroupExpr) {
            ExamineUtils.fillExprRefMembers((MemberGroupExpr)expr, exprRefMembers, examineItemList, fillEnvironment.pushTop());
        } else if (expr instanceof MemberExpr) {
            ExamineUtils.fillExprRefMembers((MemberExpr)expr, exprRefMembers, examineItemList, fillEnvironment.pushTop());
        }
    }

    private static void fillExprRefMembers(MemberGroupExpr expr, Map<Long, Map<String, Set<String>>> exprRefMembers, List<ExamineItem> examineItemList, FillEnvironment fillEnvironment) {
        Long currentDataSetId = fillEnvironment.getMainDataSetId();
        IModelCacheHelper modelCache = fillEnvironment.getModelCache();
        for (MemberExpr member : expr.getMembers()) {
            String dimNumber = member.getDimNumber();
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
            kd.epm.eb.common.cache.impl.Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, member.getNumber());
            currentDataSetId = accountMember.getDatasetId();
            break;
        }
        LinkedHashMap members = Maps.newLinkedHashMap();
        String memberKey = "MGE" + examineItemList.size();
        examineItemList.add(new ExamineItem(memberKey, currentDataSetId, (Map)members, fillEnvironment.isCheckItem()));
        expr.setMemberKey(memberKey);
        Map currentDataSetRefMembers = exprRefMembers.computeIfAbsent(currentDataSetId, v -> Maps.newLinkedHashMap());
        Set<String> currentDataSetDims = modelCache.getDimensionMap(currentDataSetId).keySet();
        LinkedList realMembers = Lists.newLinkedList();
        boolean needRealMember = false;
        for (MemberExpr member : expr.getMembers()) {
            String dimNumber = member.getDimNumber();
            String memNumber = member.getNumber();
            if (currentDataSetDims.contains(dimNumber)) {
                if (TemplateVarCommonUtil.checkIsVar((String)memNumber, (String)dimNumber).booleanValue()) {
                    String msg = ResManager.loadResFormat((String)"\u52fe\u7a3d\u5173\u7cfb[%1]\u4f7f\u7528\u5230\u7684%2\u7ef4\u5ea6\u53d8\u91cf%3\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u65b9\u6848\u4e2d\u8bbe\u7f6e\u3002", (String)"ReportVarUtil_8", (String)"epm-eb-spread", (Object[])new Object[]{fillEnvironment.getExamineDto().getNumber(), dimNumber, memNumber});
                    String realMemberNumber = ReportVarUtil.transVarNumToRealNum((Long)modelCache.getModelobj().getId(), (String)dimNumber, (String)memNumber, fillEnvironment.getVarValues(), (String)msg);
                    members.put(dimNumber, realMemberNumber);
                    currentDataSetRefMembers.computeIfAbsent(dimNumber, v -> Sets.newLinkedHashSet()).add(realMemberNumber);
                    MemberExpr e = new MemberExpr();
                    e.setDimNumber(dimNumber);
                    e.setNumber(realMemberNumber);
                    realMembers.add(e);
                    needRealMember = true;
                    continue;
                }
                realMembers.add(member);
                members.put(dimNumber, memNumber);
                currentDataSetRefMembers.computeIfAbsent(dimNumber, v -> Sets.newLinkedHashSet()).add(memNumber);
                continue;
            }
            needRealMember = true;
        }
        if (needRealMember) {
            expr.setRealMembers(realMembers);
        }
        expr.setDims(currentDataSetDims);
    }

    private static void fillExprRefMembers(MemberExpr expr, Map<Long, Map<String, Set<String>>> exprRefMembers, List<ExamineItem> examineItemList, FillEnvironment fillEnvironment) {
        Long currentDataSetId = fillEnvironment.getMainDataSetId();
        IModelCacheHelper modelCache = fillEnvironment.getModelCache();
        if (SysDimensionEnum.Account.getNumber().equals(expr.getDimNumber())) {
            kd.epm.eb.common.cache.impl.Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, expr.getNumber());
            currentDataSetId = accountMember.getDatasetId();
        }
        LinkedHashMap members = Maps.newLinkedHashMap();
        String memberKey = "ME" + examineItemList.size();
        examineItemList.add(new ExamineItem(memberKey, currentDataSetId, (Map)members, fillEnvironment.isCheckItem()));
        expr.setMemberKey(memberKey);
        Map currentDataSetRefMembers = exprRefMembers.computeIfAbsent(currentDataSetId, v -> Maps.newLinkedHashMap());
        currentDataSetRefMembers.computeIfAbsent(expr.getDimNumber(), v -> Sets.newLinkedHashSet()).add(expr.getNumber());
        members.put(expr.getDimNumber(), expr.getNumber());
    }

    public static Map<String, Set<String>> parseDimRangeStrToMap(String rangediminfo, Long modelId, Long bizModelId) {
        Map parseDimRangeMap = (Map)ObjectSerialUtil.parseObject((String)rangediminfo, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){}, (Feature[])new Feature[0]);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        return ExamineUtils.parseDimRangeStrToMap(parseDimRangeMap, memberPropCache, modelCache, bizModelId);
    }

    public static Map<String, Set<String>> parseDimRangeStrToMap(Map<String, List<MemberCondition>> parseDimRangeMap, MemberPropCache memberPropCache, IModelCacheHelper modelCache, Long bizModelId) {
        String examinePropRelation = ParamQueryServiceHelper.getString((long)modelCache.getModelobj().getId(), (ParamEnum)ParamEnum.BG046);
        HashMap<String, Set<String>> dimMapMembNums = new HashMap<String, Set<String>>(parseDimRangeMap.size());
        for (Map.Entry<String, List<MemberCondition>> entry : parseDimRangeMap.entrySet()) {
            String dimNum = entry.getKey();
            Set members = AnalyzeRangeUtils.analyzeMemberConditionToMember2((String)dimNum, entry.getValue(), (String)examinePropRelation, (IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, null, (boolean)false);
            dimMapMembNums.put(dimNum, members);
        }
        return dimMapMembNums;
    }

    public static void tryOnceMockCheck(String number, IExpress express, Long modelId) {
        Evaluator evaluator = new Evaluator();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        evaluator.setNumber(number);
        evaluator.setDataReader(new MockDataReader());
        evaluator.setFunCalcFactory(FunCalcFactory.getInstance());
        Cube cube = new Cube();
        cube.setDimensionList(new ArrayList<Dimension>());
        evaluator.setCube(cube);
        evaluator.setModelCache(modelCache);
        express.init(evaluator);
        evaluator.setCurrentMembers(new Member[0]);
        express.calc(evaluator);
        if (express.getReturnType() != Type.Boolean) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u516c\u5f0f\u5fc5\u987b\u662f\u903b\u8f91\u8868\u8fbe\u5f0f\uff0c\u5f53\u524d\u516c\u5f0f\u4e0d\u6784\u6210\u903b\u8f91\u6bd4\u8f83\u516c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExamineCheckServiceHelper_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }
}

