/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.cache;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.examine.domain.ExamineDto;

public class ExamineCache {
    protected final long modelId;
    private Map<Long, ExamineDto> examineDtoIdMap;
    private Map<String, ExamineDto> examineDtoNumMap;
    private Map<Long, Set<ExamineDto>> tempDisExamineMap;
    private Map<Long, Set<ExamineDto>> applyTempExamineMap;

    private ExamineCache(long modelId) {
        this.modelId = modelId;
    }

    public static ExamineCache init(long modelId, int examineSize) {
        ExamineCache examineCache = new ExamineCache(modelId);
        examineCache.examineDtoIdMap = Maps.newHashMapWithExpectedSize((int)examineSize);
        examineCache.examineDtoNumMap = Maps.newHashMapWithExpectedSize((int)examineSize);
        examineCache.tempDisExamineMap = Maps.newHashMapWithExpectedSize((int)16);
        examineCache.applyTempExamineMap = Maps.newHashMapWithExpectedSize((int)16);
        return examineCache;
    }

    public void addExamine(ExamineDto examineDto) {
        List applyTempIds;
        List disTempIds = examineDto.getDisTempIds();
        this.examineDtoIdMap.put(examineDto.getId(), examineDto);
        this.examineDtoNumMap.put(examineDto.getNumber(), examineDto);
        if (disTempIds != null) {
            for (Long disTempId : disTempIds) {
                Set examineDtos = this.tempDisExamineMap.computeIfAbsent(disTempId, v -> Sets.newLinkedHashSet());
                examineDtos.add(examineDto);
            }
        }
        if ((applyTempIds = examineDto.getApplyTempIds()) != null) {
            for (Long disTempId : applyTempIds) {
                Set examineDtos = this.applyTempExamineMap.computeIfAbsent(disTempId, v -> Sets.newLinkedHashSet());
                examineDtos.add(examineDto);
            }
        }
    }

    public Set<ExamineDto> getExamineByTempId(Long templateId) {
        Set<Object> examineDtos = this.tempDisExamineMap.get(templateId);
        if (examineDtos == null) {
            examineDtos = Collections.emptySet();
        }
        return examineDtos;
    }

    public Set<ExamineDto> getExamineByApplyTempId(Long templateId) {
        Set<Object> examineDtos = this.applyTempExamineMap.get(templateId);
        if (examineDtos == null) {
            examineDtos = Collections.emptySet();
        }
        return examineDtos;
    }

    public ExamineDto getExamineByNumber(String examineNumber) {
        return this.examineDtoNumMap.get(examineNumber);
    }

    public ExamineDto getExamineById(Long examineId) {
        return this.examineDtoIdMap.get(examineId);
    }
}

