/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.check;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.check.ExamineReportRowCutHandler;
import kd.epm.eb.business.examinev2.domain.ExamineBo;
import kd.epm.eb.business.examinev2.domain.ExamineDataQuery;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.examinev2.vo.ReportShowExamineMemberBo;
import kd.epm.eb.business.examinev2.vo.ReportShowExamineRow;
import kd.epm.eb.business.expr.Coordy;
import kd.epm.eb.business.expr.Cube;
import kd.epm.eb.business.expr.CubeIterator;
import kd.epm.eb.business.expr.DataReader;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.FunCalcFactory;
import kd.epm.eb.business.expr.expr.AbsoluteCompareExpr;
import kd.epm.eb.business.expr.expr.BinaryExpr;
import kd.epm.eb.business.expr.expr.ConditionExpr;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.expr.MemberGroupExpr;
import kd.epm.eb.business.expr.expr.NumberExpr;
import kd.epm.eb.business.expr.expr.RelativeCompareExpr;
import kd.epm.eb.business.expr.expr.StringExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.ExamineBehaviorEnum;
import kd.epm.eb.common.enums.ExamineCheckTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.examine.bo.ExamineItem;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultForExamine;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultItem;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultRow;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultRowNew;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineInfoTypeEnum;
import kd.epm.eb.common.examine.enums.ExamineRowCheckResultEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.examine.request.ReportRelation;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.FixMember;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.DateExpr;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.utils.PageUtil;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.collections4.CollectionUtils;

public class ExamineCheckAction {
    private static final Log log = LogFactory.getLog(ExamineCheckAction.class);
    private static final Long MAX_VALUE_RANGE = Long.getLong("epm_examine_max_range", 1000000L);
    private static final Integer REPORT_MAX_ROW = Integer.getInteger("epm_examine_report_max_row", 10000);
    private static final Integer SAMPLING_ROW_SIZE = Integer.getInteger("epm_examine_report_sampling_row", 50);
    private Long modelId;
    private IModelCacheHelper modelCache;
    private Long datasetId;
    private Set<String> mainDatasetDims;
    private Long templateId;
    private Long reportProcessId;
    private TriggerEventEnum targetEvent;
    private ProcessTypeEnum processTypeEnum;
    private Long executorId;
    private List<CheckRange> checkRangeList;
    private List<ExamineBo> examineBoList;
    private Map<Long, String> templateIdToNumMap;
    private Long bizModelId;
    private Long currPeriodId;
    private Map<String, Set<String>> dimRelMap;
    private List<Long> dimRelList;
    private Stats mainStats = new Stats("doExamineCheck");
    private Stats currentStats;
    private Long approveBillId;
    private int pageSize = 1000000;
    private Boolean isCartesian = false;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private static final String OA_MATCHES = "/OADate\\(\\d+\\)/";
    ExamineCheckResultRow mainRow;

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public ExamineCheckReport doExamineCheck() {
        ExamineCheckReport examineCheckReport = new ExamineCheckReport();
        examineCheckReport.setModelId(this.modelId);
        examineCheckReport.setDatasetId(this.datasetId);
        examineCheckReport.setTargetEvent(this.targetEvent);
        examineCheckReport.setProcessTypeEnum(this.processTypeEnum);
        examineCheckReport.setExecutorId(this.executorId);
        examineCheckReport.setTemplateId(this.templateId);
        examineCheckReport.setReportProcessId(this.reportProcessId);
        examineCheckReport.setCheckRangeList(this.checkRangeList);
        examineCheckReport.setApproveBillId(this.approveBillId);
        this.mainStats.appendMessage("templateId:" + this.templateId + "reportProcessId:" + this.reportProcessId + "checkRangeSize:" + this.checkRangeList.size());
        for (CheckRange checkRange : this.checkRangeList) {
            this.mainStats.appendMessage(checkRange.toLogString());
        }
        examineCheckReport.setExamineCheckResultEnum(ExamineCheckResultEnum.NoExamine);
        ExamineReportRowCutHandler rowCutHandler = new ExamineReportRowCutHandler(REPORT_MAX_ROW, SAMPLING_ROW_SIZE);
        Stopwatch sw = Stopwatch.createStarted();
        HashMap sumMap = Maps.newHashMapWithExpectedSize((int)1);
        for (ExamineBo examineBo : this.examineBoList) {
            this.mainStats.createLinearStatItem("do examine:" + examineBo.getExamineDto().getNumber());
            ExamineCheckResultForExamine examineCheckResultForExamine = null;
            for (CheckRange checkRange : this.checkRangeList) {
                this.currentStats = new Stats("examine:" + examineBo.getExamineDto().getNumber() + ",checkRange:" + checkRange.getSeq());
                this.currentStats.createLinearStatItem("bindRelateItem");
                log.info(this.currentStats.toString("budget-examine-check:"));
                this.bindRelateItem(checkRange, examineBo);
                ReportRelation row = (ReportRelation)checkRange.getRelationList().get(0);
                boolean isRowHandle = false;
                BigInteger seqSum = sumMap.computeIfAbsent(checkRange.getSeq(), v -> {
                    BigInteger total = BigInteger.ONE;
                    for (Set members : checkRange.getCheckRange().values()) {
                        total = total.multiply(BigInteger.valueOf(members.size()));
                    }
                    return total;
                });
                ArrayList pageRangeList = Lists.newArrayListWithExpectedSize((int)10);
                if (seqSum.compareTo(BigInteger.valueOf(1000000L)) < 0) {
                    pageRangeList = Lists.newArrayList((Object[])new Map[]{checkRange.getCheckRange()});
                } else {
                    isRowHandle = true;
                    for (String[] rowMembers : row.getMemberRelationList()) {
                        HashMap<String, HashSet> map = new HashMap<String, HashSet>(16);
                        for (int i = 0; i < rowMembers.length; ++i) {
                            map.put(row.getDimNumbers()[i], Sets.newHashSet((Object[])new String[]{rowMembers[i]}));
                        }
                        checkRange.getCheckRange().forEach((k, v) -> map.computeIfAbsent((String)k, x -> v));
                        pageRangeList.add(map);
                    }
                }
                for (Map rowMemberMap : pageRangeList) {
                    List pageList;
                    checkRange.setRowCheckRange(rowMemberMap);
                    Map<String, Set<String>> iterateScope = this.calcItrScope(checkRange, examineBo);
                    if (iterateScope == null) continue;
                    BigInteger sum = BigInteger.ONE;
                    for (Set<String> members : iterateScope.values()) {
                        sum = sum.multiply(BigInteger.valueOf(members.size()));
                    }
                    if (!isRowHandle) {
                        log.info("examineCheck:" + examineBo.getExamineDto().getNumber() + ",iterateScopeSize:" + sum + ",time:" + sw.elapsed(TimeUnit.MILLISECONDS));
                        pageList = PageUtil.getPageMapExcludeBp(iterateScope, (int)this.pageSize);
                    } else {
                        pageList = Lists.newArrayList((Object[])new Map[]{iterateScope});
                    }
                    ArrayList<Future> futureList = new ArrayList<Future>(pageList.size());
                    for (Map sub : pageList) {
                        Future future = EpmThreadPools.EXAMINE_POOL.submit(() -> {
                            EpmThreadLocalUtils.setDimNoCheckVersion((long)this.modelId);
                            try {
                                Map<String, Set<String>> cubeMembers = this.calcCubeMembers(sub, examineBo);
                                List<ExamineDataQuery> examineDataQueryList = this.genOlapQueryInfo(sub, examineBo);
                                List<FixMember> fixMemberList = this.createFixMembers(cubeMembers, examineBo);
                                Cube cube = this.createCube(cubeMembers, sub, fixMemberList);
                                Map<String, String> fixMemberMap = fixMemberList.stream().collect(Collectors.toMap(x -> x.getDimNumber(), x -> x.getMemberNumber()));
                                cube.setFixMemberMap(fixMemberMap);
                                if (checkRange.getRelationList() == null) {
                                    cube.setRelationMap(null);
                                } else {
                                    HashMap<Object, Set<String>> map1 = new HashMap<Object, Set<String>>(16);
                                    for (ReportRelation reportRelation : checkRange.getRelationList()) {
                                        Set memNums = map1.computeIfAbsent(reportRelation.getDimNumbers(), x -> new HashSet(16));
                                        memNums.addAll(reportRelation.getMemberRelationList().stream().map(x -> StringUtils.join((Object[])x, (String)":")).collect(Collectors.toSet()));
                                    }
                                    cube.setRelationMap(map1);
                                }
                                cube.setCartesian(this.isCartesian);
                                DataReader dataReader = this.createDataReader(cube, examineDataQueryList);
                                ExamineCheckResultForExamine examineCheckResultForExamine = this.doExamineCheck(examineBo, dataReader, cube);
                                return examineCheckResultForExamine;
                            }
                            finally {
                                EpmThreadLocalUtils.remove();
                            }
                        }, RequestContext.getOrCreate());
                        futureList.add(future);
                    }
                    for (Future future : futureList) {
                        try {
                            ExamineCheckResultForExamine examineResult = (ExamineCheckResultForExamine)future.get();
                            if (examineCheckResultForExamine == null) {
                                examineCheckResultForExamine = examineResult;
                                continue;
                            }
                            examineCheckResultForExamine = this.combine(examineBo, examineCheckResultForExamine, examineResult);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            throw new KDBizException(ResManager.loadResFormat((String)"\u6267\u884c\u8fc7\u7a0b\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[tranceId:%1]\u3002", (String)"DataGatherRunService_0", (String)"epm-eb-business", (Object[])new Object[]{RequestContext.get().getTraceId()}));
                        }
                    }
                }
            }
            if (examineCheckResultForExamine == null) continue;
            List sortedItem = examineCheckResultForExamine.getExamineCheckResultItemList().stream().sorted((a, b) -> {
                int aIndex = a.getMainRow().getCheckResult().getIndex();
                int bIndex = b.getMainRow().getCheckResult().getIndex();
                return -Integer.compare(aIndex, bIndex);
            }).collect(Collectors.toList());
            examineCheckResultForExamine.setExamineCheckResultItemList(sortedItem);
            rowCutHandler.handler(examineCheckResultForExamine);
            examineCheckReport.addExamineCheckResultForExamine(examineCheckResultForExamine);
        }
        log.info(this.mainStats.toString("budget-examine-check:"));
        return examineCheckReport;
    }

    private ExamineCheckResultForExamine combine(ExamineBo examineBo, ExamineCheckResultForExamine examineCheckResult1, ExamineCheckResultForExamine examineCheckResult2) {
        Map sameMembers1 = examineCheckResult1.getSameMembers();
        Map sameMembers2 = examineCheckResult2.getSameMembers();
        Sets.SetView difference = Sets.difference((Set)Sets.newHashSet((Iterable)examineCheckResult1.getDiffDimensions()), (Set)Sets.newHashSet((Iterable)examineCheckResult2.getDiffDimensions()));
        List examineCheckResultItemList1 = examineCheckResult1.getExamineCheckResultItemList();
        List examineCheckResultItemList2 = examineCheckResult2.getExamineCheckResultItemList();
        if (examineCheckResultItemList1.isEmpty()) {
            return examineCheckResult2;
        }
        if (examineCheckResultItemList2.isEmpty()) {
            return examineCheckResult1;
        }
        if (!sameMembers1.equals(sameMembers2) || !difference.isEmpty()) {
            ArrayList<String> diffDimNumbers = new ArrayList<String>(16);
            for (String string : examineBo.getUsedDimNumbers()) {
                String member1 = (String)sameMembers1.get(string);
                String member2 = (String)sameMembers2.get(string);
                if (member1 != null && member1.equals(member2)) continue;
                diffDimNumbers.add(string);
            }
            this.rebuildExamineCheckResultItemList(sameMembers1, examineCheckResult1.getDiffDimensions(), examineCheckResultItemList1, diffDimNumbers);
            this.rebuildExamineCheckResultItemList(sameMembers2, examineCheckResult2.getDiffDimensions(), examineCheckResultItemList2, diffDimNumbers);
            examineCheckResult1.setDiffDimensions(diffDimNumbers);
            Set panelSet1 = examineCheckResultItemList1.stream().map(ExamineCheckResultItem::getShowPanel).collect(Collectors.toSet());
            for (ExamineCheckResultItem item2 : examineCheckResultItemList2) {
                if (panelSet1.contains(item2.getShowPanel())) continue;
                examineCheckResultItemList1.add(item2);
            }
            for (String diffDimNumber : diffDimNumbers) {
                sameMembers1.remove(diffDimNumber);
            }
        } else {
            Set panelSet1 = examineCheckResultItemList1.stream().map(ExamineCheckResultItem::getShowPanel).collect(Collectors.toSet());
            for (ExamineCheckResultItem examineCheckResultItem : examineCheckResultItemList2) {
                if (panelSet1.contains(examineCheckResultItem.getShowPanel())) continue;
                examineCheckResultItemList1.add(examineCheckResultItem);
            }
        }
        if (ExamineCheckResultEnum.worse((ExamineCheckResultEnum)examineCheckResult1.getExamineCheckResultEnum(), (ExamineCheckResultEnum)examineCheckResult2.getExamineCheckResultEnum())) {
            examineCheckResult1.setExamineCheckResultEnum(examineCheckResult2.getExamineCheckResultEnum());
        }
        return examineCheckResult1;
    }

    private void rebuildExamineCheckResultItemList(Map<String, String> sameMembers1, List<String> diffDimensions, List<ExamineCheckResultItem> examineCheckResultItemList1, List<String> diffDimNumbers) {
        Map<String, Integer> indexMap = diffDimensions.stream().collect(Collectors.toMap(k -> k, diffDimensions::indexOf));
        for (ExamineCheckResultItem examineCheckResultItem : examineCheckResultItemList1) {
            List itrMemberList = examineCheckResultItem.getItrMemberList();
            ArrayList newItrMemberList = Lists.newArrayListWithExpectedSize((int)diffDimNumbers.size());
            for (String diffDimNumber : diffDimNumbers) {
                if (sameMembers1.containsKey(diffDimNumber)) {
                    newItrMemberList.add(sameMembers1.get(diffDimNumber));
                    continue;
                }
                newItrMemberList.add(itrMemberList.get(indexMap.get(diffDimNumber)));
            }
            examineCheckResultItem.setItrMemberList((List)newItrMemberList);
        }
    }

    private List<FixMember> createFixMembers(Map<String, Set<String>> cubeMembers, ExamineBo examineBo) {
        ArrayList fixMemberList = Lists.newArrayListWithExpectedSize((int)10);
        cubeMembers.forEach((k, v) -> {
            if (v.size() == 1 && !k.equals(examineBo.getExamineDto().getMainDimension())) {
                fixMemberList.add(new FixMember(k, (String)v.iterator().next()));
            }
        });
        return fixMemberList;
    }

    private void bindRelateItem(CheckRange checkRange, ExamineBo examineBo) {
        Map<String, Set<String>> scopes = examineBo.getScopes();
        List<ExamineItem> examineItemList = examineBo.getExamineItemList();
        List dimensionList = this.modelCache.getDimensionList(this.datasetId);
        for (ExamineItem examineItem : examineItemList) {
            examineItem.setRelate(this.hasItemRelate(checkRange, dimensionList, scopes, examineItem));
        }
    }

    private boolean hasItemRelate(CheckRange checkRange, List<Dimension> dimensionList, Map<String, Set<String>> scopes, ExamineItem examineItem) {
        if (!this.datasetId.equals(examineItem.getDatasetId())) {
            return false;
        }
        Map checkRangeMap = checkRange.getCheckRange();
        Map itemMembers = examineItem.getMembers();
        for (Dimension dimension : dimensionList) {
            Set<String> scopeMemNums;
            Set checkMemNums = (Set)checkRangeMap.get(dimension.getNumber());
            String memNum = (String)itemMembers.get(dimension.getNumber());
            if (!(StringUtils.isNotEmpty((String)memNum) ? !checkMemNums.contains(memNum) : (scopeMemNums = scopes.get(dimension.getNumber())) != null && checkMemNums.stream().noneMatch(scopeMemNums::contains))) continue;
            return false;
        }
        if (this.isCartesian.booleanValue()) {
            List relationList = checkRange.getRelationList();
            for (ReportRelation reportRelation : relationList) {
                LinkedList<String[]> currMemberRelationList = new LinkedList<String[]>();
                String[] dimNumbers = reportRelation.getDimNumbers();
                List memberRelationList = reportRelation.getMemberRelationList();
                for (String[] memberRelation : memberRelationList) {
                    boolean hasRelate = true;
                    for (int i = 0; i < dimNumbers.length; ++i) {
                        String memNum = (String)itemMembers.get(dimNumbers[i]);
                        Set<String> scopeMemNums = scopes.get(dimNumbers[i]);
                        String memNumber = memberRelation[i];
                        if (StringUtils.isNotEmpty((String)memNum)) {
                            if (memNum.equals(memNumber)) continue;
                            hasRelate = false;
                            break;
                        }
                        if (scopeMemNums == null || scopeMemNums.contains(memNumber)) continue;
                        hasRelate = false;
                        break;
                    }
                    if (!hasRelate) continue;
                    currMemberRelationList.add(memberRelation);
                }
                if (currMemberRelationList.isEmpty()) {
                    return false;
                }
                ReportRelation reportRelation1 = new ReportRelation();
                reportRelation1.setDimNumbers(dimNumbers);
                reportRelation1.setMemberRelationList(memberRelationList);
            }
        }
        return true;
    }

    private Map<String, Set<String>> calcItrScope(CheckRange checkRange, ExamineBo examineBo) {
        List<ExamineItem> examineItemList = examineBo.getExamineItemList();
        List relateExamineItem = examineItemList.stream().filter(ExamineItem::isRelate).collect(Collectors.toList());
        if (relateExamineItem.isEmpty()) {
            return null;
        }
        this.currentStats.appendMessage("relateItem:" + relateExamineItem.stream().map(ExamineItem::getMemberKey).collect(Collectors.toList()));
        Long busModelId = this.modelCache.getBusModelByDataSet(this.datasetId);
        List dimensionList = this.modelCache.getDimensionListByBusModel(busModelId);
        Set<String> usedDimNumbers = examineBo.getUsedDimNumbers();
        dimensionList = dimensionList.stream().filter(dimension -> usedDimNumbers.contains(dimension.getNumber())).collect(Collectors.toList());
        Map<String, Dimension> currentDimensionMap = dimensionList.stream().collect(Collectors.toMap(BaseCache::getNumber, v -> v));
        HashMap iterateScope = Maps.newHashMapWithExpectedSize((int)dimensionList.size());
        Map checkRangeMap = checkRange.getRowCheckRange();
        Map<String, Set<String>> examineScope = examineBo.getScopes();
        HashSet allSelectDims = null;
        Object itemSelectDim = null;
        for (ExamineItem examineItem : examineItemList) {
            Long itemDatasetId = examineItem.getDatasetId();
            Map dimensionMap = this.modelCache.getDimensionMap(itemDatasetId);
            HashSet<String> _usedDimNumbers = new HashSet<String>(usedDimNumbers);
            _usedDimNumbers.removeAll(dimensionMap.keySet());
            if (_usedDimNumbers.isEmpty()) {
                itemSelectDim = examineItem.getMembers().keySet();
            } else {
                _usedDimNumbers.addAll(examineItem.getMembers().keySet());
                itemSelectDim = _usedDimNumbers;
            }
            if (allSelectDims == null) {
                allSelectDims = new HashSet(itemSelectDim);
                continue;
            }
            allSelectDims.retainAll((Collection<?>)itemSelectDim);
        }
        if (allSelectDims == null) {
            allSelectDims = new HashSet(0);
        }
        for (String selectDim : allSelectDims) {
            String memNumber = (String)((ExamineItem)relateExamineItem.get(0)).getMembers().get(selectDim);
            if (memNumber != null) {
                iterateScope.put(selectDim, Sets.newHashSet((Object[])new String[]{memNumber}));
                continue;
            }
            iterateScope.put(selectDim, Sets.newHashSet((Object[])new String[]{currentDimensionMap.get(selectDim).getNoneNumber()}));
        }
        HashSet useScopeDims = Sets.newHashSetWithExpectedSize((int)16);
        for (ExamineItem examineItem : relateExamineItem) {
            Map members = examineItem.getMembers();
            for (Object dimNum : members.keySet()) {
                if (allSelectDims.contains(dimNum)) continue;
                useScopeDims.add(dimNum);
            }
        }
        if (!useScopeDims.isEmpty()) {
            this.currentStats.appendMessage("useScopeDim:" + useScopeDims);
        }
        for (String useScopeDim : useScopeDims) {
            Set<String> scopeMembers = examineScope.get(useScopeDim);
            if (scopeMembers == null) {
                scopeMembers = new HashSet<String>(16);
            }
            if (CollectionUtils.isEmpty(scopeMembers)) {
                log.error("budget-examine-check:", (Object)("\u52fe\u7a3d\u5173\u7cfb\uff08" + examineBo.getExamineDto().getNumber() + "\uff09\u8bbe\u7f6e\u9519\u8bef\uff0c\u7b49\u5f0f\u53f3\u4fa7\u7ef4\u5ea6\uff08" + useScopeDim + "\uff09\u9009\u4e86\u6210\u5458\uff0c\u5de6\u4fa7\u5fc5\u987b\u9009\u62e9\u8303\u56f4"));
                List views = this.modelCache.getViewGroupViewsByBusModelAndDimNumber(examineBo.getBusModelId(), useScopeDim);
                for (Long view : views) {
                    List members = this.modelCache.getMembers(view, useScopeDim);
                    if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                    scopeMembers.addAll(members.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                }
                iterateScope.put(useScopeDim, scopeMembers);
                continue;
            }
            iterateScope.put(useScopeDim, scopeMembers);
        }
        for (Dimension dimension2 : dimensionList) {
            String dimNumber = dimension2.getNumber();
            if (iterateScope.containsKey(dimNumber)) continue;
            Set reportRange = (Set)checkRangeMap.get(dimNumber);
            Set<String> examineScopeRange = examineScope.get(dimNumber);
            if (examineScopeRange == null) {
                examineScopeRange = new HashSet<String>(16);
            }
            if (useScopeDims.contains(dimNumber)) {
                if (CollectionUtils.isEmpty(examineScopeRange)) {
                    log.error("budget-examine-check:", (Object)("\u52fe\u7a3d\u5173\u7cfb\uff08" + examineBo.getExamineDto().getNumber() + "\uff09\u8bbe\u7f6e\u9519\u8bef\uff0c\u7b49\u5f0f\u53f3\u4fa7\u7ef4\u5ea6\uff08" + dimNumber + "\uff09\u9009\u4e86\u6210\u5458\uff0c\u5de6\u4fa7\u5fc5\u987b\u9009\u62e9\u8303\u56f4"));
                    List views = this.modelCache.getViewGroupViewsByBusModelAndDimNumber(examineBo.getBusModelId(), dimNumber);
                    for (Long view : views) {
                        List members = this.modelCache.getMembers(view, dimNumber);
                        if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
                        examineScopeRange.addAll(members.stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                    }
                }
                iterateScope.put(dimNumber, examineScopeRange);
                continue;
            }
            if (CollectionUtils.isEmpty(examineScopeRange)) {
                if (reportRange == null) {
                    iterateScope.put(dimNumber, Sets.newHashSet((Object[])new String[]{dimension2.getNoneNumber()}));
                    continue;
                }
                iterateScope.put(dimNumber, reportRange);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)reportRange)) {
                iterateScope.put(dimNumber, examineScopeRange);
                continue;
            }
            Set intersection = reportRange.stream().filter(examineScopeRange::contains).collect(Collectors.toSet());
            if (intersection.isEmpty()) {
                return null;
            }
            iterateScope.put(dimNumber, intersection);
        }
        return iterateScope;
    }

    private Map<String, Set<String>> calcCubeMembers(Map<String, Set<String>> iterateScope, ExamineBo examineBo) {
        HashMap cubeMembers = Maps.newHashMapWithExpectedSize((int)16);
        iterateScope.forEach((dimNum, v) -> cubeMembers.put(dimNum, new HashSet(v)));
        Map<Long, Map<String, Set<String>>> exprRefMembers = examineBo.getExprRefMembers();
        for (Map.Entry<Long, Map<String, Set<String>>> entry : exprRefMembers.entrySet()) {
            for (Map.Entry<String, Set<String>> valueEntry : entry.getValue().entrySet()) {
                cubeMembers.computeIfAbsent(valueEntry.getKey(), v -> new HashSet(16)).addAll((Collection)valueEntry.getValue());
            }
        }
        return cubeMembers;
    }

    private List<ExamineDataQuery> genOlapQueryInfo(Map<String, Set<String>> iterateScope, ExamineBo examineBo) {
        LinkedList examineDataQueryList = Lists.newLinkedList();
        ExamineDataQuery mainDataSetQuery = new ExamineDataQuery(this.datasetId);
        iterateScope.forEach((k, v) -> {
            if (this.mainDatasetDims.contains(k)) {
                mainDataSetQuery.addScope((String)k, (Set<String>)new HashSet<String>((Collection<String>)v));
            }
        });
        examineDataQueryList.add(mainDataSetQuery);
        for (ExamineItem examineItem : examineBo.getExamineItemList()) {
            Long itemDatasetId = examineItem.getDatasetId();
            Map members = examineItem.getMembers();
            if (this.datasetId.equals(itemDatasetId)) {
                for (Map.Entry entry : members.entrySet()) {
                    if (!this.mainDatasetDims.contains(entry.getKey())) continue;
                    mainDataSetQuery.addMember((String)entry.getKey(), (String)entry.getValue());
                }
                continue;
            }
            ExamineDataQuery itemExamineDataQuery = new ExamineDataQuery(itemDatasetId);
            List dimensionList = this.modelCache.getDimensionList(itemDatasetId);
            for (Dimension dimension : dimensionList) {
                String memNumber = (String)members.get(dimension.getNumber());
                if (memNumber != null) {
                    itemExamineDataQuery.addMember(dimension.getNumber(), memNumber);
                    continue;
                }
                Set<String> itrMemNumber = iterateScope.get(dimension.getNumber());
                itemExamineDataQuery.addScope(dimension.getNumber(), itrMemNumber);
            }
            examineDataQueryList.add(itemExamineDataQuery);
        }
        return examineDataQueryList;
    }

    private Cube createCube(Map<String, Set<String>> cubeMembers, Map<String, Set<String>> iterateScope, List<FixMember> fixMemberList) {
        for (FixMember fixMember : fixMemberList) {
            cubeMembers.remove(fixMember.getDimNumber());
            iterateScope.remove(fixMember.getDimNumber());
        }
        Cube cube = new Cube();
        ArrayList cubeDimensionList = Lists.newArrayListWithExpectedSize((int)16);
        CubeIterator cubeIterator = new CubeIterator();
        cube.setDimensionList(cubeDimensionList);
        cube.setFixMemberList(fixMemberList);
        cube.setIterator(cubeIterator);
        List dimensionList = this.modelCache.getDimensionListByBusModel(this.modelCache.getBusModelByDataSet(this.datasetId));
        int seq = 1;
        for (Dimension dimension : dimensionList) {
            String dimNumber = dimension.getNumber();
            Set<String> memNumbers = cubeMembers.get(dimNumber);
            Set<String> itrMemNumbers = iterateScope.get(dimNumber);
            if (memNumbers == null) continue;
            ArrayList itrMemberList = Lists.newArrayListWithExpectedSize((int)itrMemNumbers.size());
            kd.epm.eb.business.expr.Dimension cubeDimension = new kd.epm.eb.business.expr.Dimension(dimNumber, seq++, memNumbers.size());
            memNumbers.stream().sorted().forEach(memNumber -> {
                kd.epm.eb.business.expr.Member member = cubeDimension.addMember((String)memNumber);
                if (member != null && itrMemNumbers.contains(memNumber)) {
                    itrMemberList.add(member);
                }
            });
            cubeDimension.setNoneNumber(dimension.getNoneNumber());
            cubeDimensionList.add(cubeDimension);
            cubeIterator.addDimension(dimNumber, itrMemberList);
        }
        return cube;
    }

    private DataReader createDataReader(Cube cube, List<ExamineDataQuery> examineDataQueryList) {
        List<kd.epm.eb.business.expr.Dimension> dimensionList = cube.getDimensionList();
        List<FixMember> fixMemberList = cube.getFixMemberList();
        Coordy coordy = new Coordy(dimensionList);
        DataReader dataReader = new DataReader(coordy);
        HashMap<String, Member> metricMemberMap = new HashMap<String, Member>(16);
        for (ExamineDataQuery examineDataQuery : examineDataQueryList) {
            Map<String, Set<String>> queryScopes = examineDataQuery.getQueryScopes();
            QueryRequest request = new QueryRequest(this.modelId, examineDataQuery.getDatasetId(), queryScopes);
            List bgCells = OlapCommService.getInstance().queryList(request);
            if (bgCells.isEmpty()) continue;
            for (BGCell bgCell : bgCells) {
                kd.epm.eb.business.expr.Member[] members = new kd.epm.eb.business.expr.Member[dimensionList.size()];
                for (int i = 0; i < dimensionList.size(); ++i) {
                    kd.epm.eb.business.expr.Dimension dimension = dimensionList.get(i);
                    String memNumber = (String)bgCell.getMemberMap().get(dimension.getNumber());
                    if (StringUtils.isEmpty((String)memNumber)) {
                        memNumber = dimension.getNoneNumber();
                    }
                    members[i] = dimension.getMember(memNumber);
                }
                Object value = bgCell.getValue();
                String metricNumber = (String)bgCell.getMemberMap().get(SysDimensionEnum.Metric.getNumber());
                Member metricMember = metricMemberMap.computeIfAbsent(metricNumber, k -> this.modelCache.getMember(SysDimensionEnum.Metric.getNumber(), metricNumber));
                if (metricMember != null && MetricDataTypeEnum.TEXT.getIndex().equals(metricMember.getDatatype())) {
                    Object object = value = Objects.isNull(value) ? "" : value.toString();
                }
                if (value instanceof String && ((String)value).matches(OA_MATCHES)) {
                    value = simpleDateFormat.format(ConvertUtils.from((String)((String)value)));
                }
                dataReader.addData(members, value);
            }
        }
        return dataReader;
    }

    private ExamineCheckResultForExamine doExamineCheck(ExamineBo examineBo, DataReader dataReader, Cube cube) {
        boolean pass;
        IExpress beginExpr = examineBo.getExpr();
        PanelEnvironment environment = new PanelEnvironment();
        environment.setRuleKey(examineBo.getExamineDto().getNumber());
        IExpress execExpr = beginExpr;
        Evaluator evaluator = new Evaluator();
        evaluator.setNumber(examineBo.getExamineDto().getNumber());
        evaluator.setDataReader(dataReader);
        evaluator.setFunCalcFactory(FunCalcFactory.getInstance());
        evaluator.setCube(cube);
        evaluator.setMainDim(examineBo.getExamineDto().getMainDimension());
        evaluator.setTemplateIdToNumMap(this.templateIdToNumMap);
        evaluator.setModelCache(this.modelCache);
        execExpr.init(evaluator);
        boolean hasNumber = this.analyzeExpr(beginExpr);
        ExamineCheckTypeEnum examineCheckTypeEnum = examineBo.getExamineDto().getExamineCheckTypeEnum();
        BigDecimal tolerance = examineBo.getExamineDto().getTolerance();
        if (examineCheckTypeEnum == ExamineCheckTypeEnum.ABSOLUTE_VALUE || examineCheckTypeEnum == ExamineCheckTypeEnum.RELATIVE_VALUE) {
            execExpr = this.replaceExpr(tolerance, beginExpr, examineCheckTypeEnum, evaluator);
        }
        CubeIterator cubeIterator = cube.getIterator();
        ExamineCheckResultForExamine examineCheckResultForExamine = new ExamineCheckResultForExamine();
        examineCheckResultForExamine.setExamineNumber(examineBo.getExamineDto().getNumber());
        examineCheckResultForExamine.setExamineId(examineBo.getExamineDto().getId());
        examineCheckResultForExamine.setExamineDto(examineBo.getExamineDto());
        List<FixMember> fixMemberList = cube.getFixMemberList();
        Map<String, String> sameMembers = fixMemberList.stream().collect(Collectors.toMap(FixMember::getDimNumber, FixMember::getMemberNumber));
        examineCheckResultForExamine.setSameMembers(sameMembers);
        examineCheckResultForExamine.setDiffDimensions(cubeIterator.getDimNumbers());
        examineCheckResultForExamine.setMemberKeyUsedDimMap(examineBo.getMemberKeyUsedDimMap());
        List<String> dimList = this.modelCache.getDimensionList().stream().map(x -> x.getNumber()).collect(Collectors.toList());
        Map<String, Integer> dimIndexMap = cubeIterator.getDimNumbers().stream().collect(Collectors.toMap(str -> str, str -> cubeIterator.getDimNumbers().indexOf(str)));
        evaluator.setDimIndexMap(dimIndexMap);
        if (!dataReader.isEmpty() || hasNumber) {
            while (cubeIterator.hasNext()) {
                kd.epm.eb.business.expr.Member[] currentMembers = cubeIterator.next();
                evaluator.setCurrentMembers(currentMembers);
                Map<String, String> memMap = Arrays.stream(currentMembers).collect(Collectors.toMap(x -> x.getDimension().getNumber(), x -> x.getNumber()));
                memMap.putAll(sameMembers);
                if (!DimensionRelationUtils.isValidRelation((IModelCacheHelper)this.modelCache, (long)this.bizModelId, (Long)this.currPeriodId, memMap, this.dimRelMap, this.dimRelList)) continue;
                evaluator.getMedianCache().clear();
                evaluator.setAllNull(true);
                evaluator.setRelate(false);
                boolean result = (Boolean)execExpr.calc(evaluator);
                if (result || this.isCartesian.booleanValue() && !evaluator.isRelate() || evaluator.isAllNull()) continue;
                if (examineCheckResultForExamine.getExamineCheckResultItemList().size() > 10000) break;
                ExamineCheckResultItem examineCheckResultItem = this.genExamineResultItem(examineBo, execExpr, evaluator, result);
                Map<String, String> rowDimMemberInfo = ExamineCheckReportServiceImpl.getInstance().getRowDimMemberInfo(examineCheckResultForExamine.getSameMembers(), examineCheckResultForExamine.getDiffDimensions(), examineCheckResultItem.getItrMemberList(), (Set)examineCheckResultForExamine.getMemberKeyUsedDimMap().get(examineCheckResultItem.getMainRow().getMemberKey()), dimList);
                ReportShowExamineRow reportShowExamineRow = new ReportShowExamineRow();
                this.getShowExamineMember(examineCheckResultItem.getChildRows(), reportShowExamineRow, this.datasetId, rowDimMemberInfo);
                PanelEnvironment panelEnvironment = new PanelEnvironment();
                panelEnvironment.setRuleKey(examineBo.getExamineDto().getNumber());
                panelEnvironment.setExamineMemberBoMap(reportShowExamineRow.getExamineMemberBoMap());
                List<ExprPanel> exprPanels = examineBo.getExpr().toPanel(panelEnvironment);
                String jsonString = JSON.toJSONString(exprPanels);
                examineCheckResultItem.setShowPanel(jsonString);
                examineCheckResultForExamine.addExamineCheckResultItem(examineCheckResultItem);
            }
        }
        if (pass = examineCheckResultForExamine.getExamineCheckResultItemList().isEmpty()) {
            examineCheckResultForExamine.setExamineCheckResultEnum(ExamineCheckResultEnum.Pass);
        } else if (examineBo.getExamineDto().getExamineBehaviorEnum() == ExamineBehaviorEnum.HINT) {
            examineCheckResultForExamine.setExamineCheckResultEnum(ExamineCheckResultEnum.NoPassIgnore);
        } else if (examineBo.getExamineDto().getExamineBehaviorEnum() == ExamineBehaviorEnum.POSTIL) {
            examineCheckResultForExamine.setExamineCheckResultEnum(ExamineCheckResultEnum.NoPassCanAnnotation);
        } else {
            examineCheckResultForExamine.setExamineCheckResultEnum(ExamineCheckResultEnum.NoPass);
        }
        return examineCheckResultForExamine;
    }

    private boolean analyzeExpr(IExpress beginExpr) {
        if (beginExpr instanceof FunctionExpr) {
            String functionName = ((FunctionExpr)beginExpr).getFunctionName();
            if (functionName.equals("NOTNULL")) {
                return true;
            }
            if (functionName.equalsIgnoreCase("AND") || functionName.equalsIgnoreCase("OR")) {
                List<IExpress> params = ((FunctionExpr)beginExpr).getParams();
                for (IExpress param : params) {
                    if (!this.analyzeExpr(param)) continue;
                    return true;
                }
                return false;
            }
        } else {
            if (beginExpr instanceof MemberExpr || beginExpr instanceof MemberGroupExpr) {
                return false;
            }
            if (beginExpr instanceof ConditionExpr) {
                return this.analyzeExpr(((ConditionExpr)beginExpr).getLefts().get(0)) || this.analyzeExpr(((ConditionExpr)beginExpr).getRights().get(0));
            }
            if (beginExpr instanceof BinaryExpr) {
                return this.analyzeExpr(((BinaryExpr)beginExpr).getLeft()) || this.analyzeExpr(((BinaryExpr)beginExpr).getRight());
            }
            if (beginExpr instanceof DateExpr || beginExpr instanceof StringExpr || beginExpr instanceof NumberExpr) {
                return true;
            }
            if (beginExpr instanceof AbsoluteCompareExpr) {
                return this.analyzeExpr(((AbsoluteCompareExpr)beginExpr).getArgs()[0]);
            }
        }
        return false;
    }

    private IExpress replaceExpr(BigDecimal tolerance, IExpress beginExpr, ExamineCheckTypeEnum examineCheckTypeEnum, Evaluator evaluator) {
        String funName;
        if (beginExpr instanceof ConditionExpr) {
            if (CollectionUtils.isNotEmpty(((ConditionExpr)beginExpr).getLefts())) {
                ((ConditionExpr)beginExpr).getLefts().set(0, this.replaceExpr(tolerance, ((ConditionExpr)beginExpr).getLefts().get(0), examineCheckTypeEnum, evaluator));
            }
            if (CollectionUtils.isNotEmpty(((ConditionExpr)beginExpr).getRights())) {
                ((ConditionExpr)beginExpr).getRights().set(0, this.replaceExpr(tolerance, ((ConditionExpr)beginExpr).getRights().get(0), examineCheckTypeEnum, evaluator));
            }
            ((ConditionExpr)beginExpr).init(evaluator);
        } else if (beginExpr instanceof FunctionExpr && ((funName = ((FunctionExpr)beginExpr).getFunctionName()).equals("AND") || funName.equals("OR"))) {
            for (int i = 0; i < ((FunctionExpr)beginExpr).getParams().size(); ++i) {
                ((FunctionExpr)beginExpr).getParams().set(i, this.replaceExpr(tolerance, ((FunctionExpr)beginExpr).getParams().get(i), examineCheckTypeEnum, evaluator));
            }
            ((FunctionExpr)beginExpr).init(evaluator);
        } else if (beginExpr instanceof BinaryExpr && beginExpr.getReturnType() == Type.Boolean && this.checkReturnTypeIsNumber(((BinaryExpr)beginExpr).getLeft().getReturnType()) && this.checkReturnTypeIsNumber(((BinaryExpr)beginExpr).getRight().getReturnType())) {
            IExpress[] params = new IExpress[]{beginExpr, new NumberExpr(tolerance)};
            if (examineCheckTypeEnum == ExamineCheckTypeEnum.ABSOLUTE_VALUE) {
                AbsoluteCompareExpr absoluteCompareExpr = new AbsoluteCompareExpr(params);
                absoluteCompareExpr.init(evaluator);
                return absoluteCompareExpr;
            }
            if (examineCheckTypeEnum == ExamineCheckTypeEnum.RELATIVE_VALUE) {
                RelativeCompareExpr relativeCompareExpr = new RelativeCompareExpr(params);
                relativeCompareExpr.init(evaluator);
                return relativeCompareExpr;
            }
        }
        return beginExpr;
    }

    private boolean checkReturnTypeIsNumber(Type type) {
        return type == Type.Number || type == Type.All;
    }

    private ExamineCheckResultItem genExamineResultItem(ExamineBo examineBo, IExpress beginExpr, Evaluator evaluator, boolean result) {
        ExamineCheckResultItem examineCheckResultItem = new ExamineCheckResultItem();
        this.mainRow = new ExamineCheckResultRow();
        this.mainRow.setName(examineBo.getExamineDto().getName() + "(" + examineBo.getExamineDto().getNumber() + ")");
        this.mainRow.setCheckResult(result ? ExamineRowCheckResultEnum.Pass : ExamineRowCheckResultEnum.NoPass);
        examineCheckResultItem.setMainRow(this.mainRow);
        kd.epm.eb.business.expr.Member[] currentMembers = evaluator.getCurrentMembers();
        List itrMemberList = Arrays.stream(currentMembers).map(kd.epm.eb.business.expr.Member::getNumber).collect(Collectors.toList());
        examineCheckResultItem.setItrMemberList(itrMemberList);
        ArrayList<ExamineCheckResultRowNew> examineCheckResultRowNews = new ArrayList<ExamineCheckResultRowNew>(16);
        List<ExamineCheckResultRow> examineCheckResultRows = this.fillExpr(examineBo, beginExpr, evaluator, true, examineCheckResultRowNews, 0);
        if (beginExpr.getReturnType() == Type.Boolean) {
            // empty if block
        }
        examineCheckResultItem.setChildRow(examineCheckResultRows);
        examineCheckResultItem.setNewChildRows(examineCheckResultRowNews);
        return examineCheckResultItem;
    }

    private void getShowExamineMember(List<ExamineCheckResultRow> examineCheckResultRows, ReportShowExamineRow reportShowExamineRow, Long datasetId, Map<String, String> rowDimMemberInfo) {
        examineCheckResultRows.stream().forEach(x -> {
            if (!StringUtils.isEmpty((String)x.getMemberKey())) {
                ReportShowExamineMemberBo reportShowExamineMemberBo = new ReportShowExamineMemberBo(x.getName(), x.getName(), x.getMemberKey(), datasetId);
                reportShowExamineMemberBo.setValue(x.getLeftValue());
                HashMap<String, String> dimMemberInfo = new HashMap<String, String>(16);
                if (x.getDiffMembers() != null) {
                    dimMemberInfo.putAll(rowDimMemberInfo);
                    dimMemberInfo.putAll(x.getDiffMembers());
                }
                reportShowExamineMemberBo.setDimToMemMap(dimMemberInfo);
                reportShowExamineRow.addReportShowExamineMemberBo(reportShowExamineMemberBo);
            }
            if (x.getChildRows() != null) {
                this.getShowExamineMember(x.getChildRows(), reportShowExamineRow, datasetId, rowDimMemberInfo);
            }
        });
    }

    private List<ExamineCheckResultRow> fillExpr(ExamineBo examineBo, IExpress iExpress, Evaluator evaluator, boolean collectToMainRow, List<ExamineCheckResultRowNew> examineCheckResultRowNews, int examineType) {
        if (iExpress instanceof ConditionExpr) {
            return Lists.newArrayList((Object[])new ExamineCheckResultRow[]{this.fillExpr(examineBo, (ConditionExpr)iExpress, evaluator, collectToMainRow, examineCheckResultRowNews, examineType)});
        }
        if (iExpress instanceof BinaryExpr) {
            return this.fillExpr(examineBo, (BinaryExpr)iExpress, evaluator, collectToMainRow, examineCheckResultRowNews, examineType);
        }
        if (iExpress instanceof FunctionExpr) {
            return Lists.newArrayList((Object[])new ExamineCheckResultRow[]{this.fillExpr(examineBo, (FunctionExpr)iExpress, evaluator, collectToMainRow, examineCheckResultRowNews, examineType)});
        }
        if (iExpress instanceof MemberGroupExpr) {
            return Lists.newArrayList((Object[])new ExamineCheckResultRow[]{this.fillExpr(examineBo, (MemberGroupExpr)iExpress, evaluator, examineCheckResultRowNews, examineType)});
        }
        if (iExpress instanceof AbsoluteCompareExpr || iExpress instanceof RelativeCompareExpr) {
            IExpress[] args = iExpress instanceof AbsoluteCompareExpr ? ((AbsoluteCompareExpr)iExpress).getArgs() : ((RelativeCompareExpr)iExpress).getArgs();
            return this.fillExpr(examineBo, args[0], evaluator, collectToMainRow, examineCheckResultRowNews, examineType);
        }
        return Collections.emptyList();
    }

    private ExamineCheckResultRow fillExpr(ExamineBo examineBo, ConditionExpr conditionExpr, Evaluator evaluator, boolean collectToMainRow, List<ExamineCheckResultRowNew> examineCheckResultRowNews, int examineType) {
        ExamineCheckResultRow currRow = new ExamineCheckResultRow();
        currRow.setName(conditionExpr.getShowString(evaluator));
        currRow.setLeftValue(this.handValue(conditionExpr.calc(evaluator)));
        ArrayList<ExamineCheckResultRow> childRows = new ArrayList<ExamineCheckResultRow>(16);
        ArrayList<ExamineCheckResultRowNew> newChildRows = new ArrayList<ExamineCheckResultRowNew>(16);
        childRows.addAll(this.fillExpr(examineBo, conditionExpr.getCondition(), evaluator, false, newChildRows, examineType));
        currRow.setChildRows(childRows);
        ExamineCheckResultRowNew newCurrRow = new ExamineCheckResultRowNew();
        newCurrRow.setName(conditionExpr.getShowString(evaluator));
        newCurrRow.setValue(this.handValue(conditionExpr.calc(evaluator)));
        newCurrRow.setExaminetype(Integer.valueOf(examineType));
        examineCheckResultRowNews.add(newCurrRow);
        Object calc = conditionExpr.getCondition().calc(evaluator);
        if (!collectToMainRow) {
            IExpress express = conditionExpr.getLefts().get(0);
            childRows.addAll(this.fillExpr(examineBo, express, evaluator, false, newChildRows, examineType));
            IExpress express2 = conditionExpr.getRights().get(0);
            childRows.addAll(this.fillExpr(examineBo, express2, evaluator, false, newChildRows, examineType));
        } else {
            boolean leftCollect = collectToMainRow;
            if (calc instanceof Boolean) {
                leftCollect = (Boolean)calc;
            }
            IExpress express = conditionExpr.getLefts().get(0);
            childRows.addAll(this.fillExpr(examineBo, express, evaluator, leftCollect, newChildRows, examineType));
            IExpress express2 = conditionExpr.getRights().get(0);
            childRows.addAll(this.fillExpr(examineBo, express2, evaluator, !leftCollect, newChildRows, examineType));
        }
        newCurrRow.setChildRows(newChildRows);
        return currRow;
    }

    private ExamineCheckResultRow fillExpr(ExamineBo examineBo, FunctionExpr functionExpr, Evaluator evaluator, boolean collectToMainRow, List<ExamineCheckResultRowNew> examineCheckResultRowNews, int examineType) {
        ExamineCheckResultRow currRow = new ExamineCheckResultRow();
        currRow.setName(functionExpr.getShowString(evaluator));
        currRow.setLeftValue(this.handValue(functionExpr.calc(evaluator)));
        ArrayList<ExamineCheckResultRow> childRows = new ArrayList<ExamineCheckResultRow>(16);
        currRow.setChildRows(childRows);
        ExamineCheckResultRowNew newCurrRow = new ExamineCheckResultRowNew();
        newCurrRow.setName(functionExpr.getShowString(evaluator));
        newCurrRow.setValue(this.handValue(functionExpr.calc(evaluator)));
        ArrayList<ExamineCheckResultRowNew> newchildRows = new ArrayList<ExamineCheckResultRowNew>(16);
        List<IExpress> params = functionExpr.getParams();
        if (params != null) {
            for (IExpress param : params) {
                childRows.addAll(this.fillExpr(examineBo, param, evaluator, collectToMainRow, newchildRows, examineType));
            }
        }
        newCurrRow.setChildRows(newchildRows);
        examineCheckResultRowNews.add(newCurrRow);
        return currRow;
    }

    private List<ExamineCheckResultRow> fillExpr(ExamineBo examineBo, BinaryExpr binaryExpr, Evaluator evaluator, boolean collect, List<ExamineCheckResultRowNew> examineCheckResultRowNews, int examineType) {
        ArrayList<ExamineCheckResultRow> childRows = new ArrayList<ExamineCheckResultRow>(16);
        ArrayList<ExamineCheckResultRowNew> leftChild = new ArrayList<ExamineCheckResultRowNew>(16);
        ArrayList<ExamineCheckResultRowNew> rightChild = new ArrayList<ExamineCheckResultRowNew>(16);
        childRows.addAll(this.fillExpr(examineBo, binaryExpr.getLeft(), evaluator, false, leftChild, ExamineInfoTypeEnum.LEFT_DIVISOR.getIndex()));
        childRows.addAll(this.fillExpr(examineBo, binaryExpr.getRight(), evaluator, false, rightChild, ExamineInfoTypeEnum.RIGHT_DIVISOR.getIndex()));
        if (collect) {
            Object leftCalc = binaryExpr.getLeft().calc(evaluator);
            Object rightCalc = binaryExpr.getRight().calc(evaluator);
            String difference = null;
            try {
                if (leftCalc != null || rightCalc != null) {
                    difference = leftCalc == null ? this.handValue(Convert.toBigDecimal((Object)rightCalc).multiply(BigDecimal.valueOf(-1.0))) : (rightCalc == null ? this.handValue(Convert.toBigDecimal((Object)leftCalc)) : this.handValue(Convert.toBigDecimal((Object)leftCalc).subtract(Convert.toBigDecimal((Object)rightCalc))));
                }
            }
            catch (ConversionException e) {
                log.error("cast is error!", (Throwable)e);
            }
            this.mainRow.setLeftValue(this.handValue(binaryExpr.getLeft().calc(evaluator)));
            this.mainRow.setRightValue(this.handValue(binaryExpr.getRight().calc(evaluator)));
            this.mainRow.setSymbol(binaryExpr.getOperType().getOper());
            this.mainRow.setDifference(this.handValue(difference));
        }
        ExamineCheckResultRowNew leftRow = new ExamineCheckResultRowNew();
        leftRow.setName(binaryExpr.getLeft().getShowString(evaluator));
        leftRow.setValue(this.handValue(binaryExpr.getLeft().calc(evaluator)));
        leftRow.setExaminetype(Integer.valueOf(ExamineInfoTypeEnum.LEFT_VALUE.getIndex()));
        leftRow.setChildRows(leftChild);
        examineCheckResultRowNews.add(leftRow);
        ExamineCheckResultRowNew rightRow = new ExamineCheckResultRowNew();
        rightRow.setName(binaryExpr.getRight().getShowString(evaluator));
        rightRow.setValue(this.handValue(binaryExpr.getRight().calc(evaluator)));
        rightRow.setExaminetype(Integer.valueOf(ExamineInfoTypeEnum.RIGHT_VALUE.getIndex()));
        rightRow.setChildRows(rightChild);
        examineCheckResultRowNews.add(rightRow);
        if (binaryExpr.getReturnType() == Type.Boolean) {
            ExamineCheckResultRow currRow = new ExamineCheckResultRow();
            currRow.setName(binaryExpr.getShowString(evaluator));
            currRow.setLeftValue(this.handValue(binaryExpr.calc(evaluator)));
            currRow.setChildRows(childRows);
            return Lists.newArrayList((Object[])new ExamineCheckResultRow[]{currRow});
        }
        return childRows;
    }

    private ExamineCheckResultRow fillExpr(ExamineBo examineBo, MemberGroupExpr memberGroupExpr, Evaluator evaluator, List<ExamineCheckResultRowNew> examineCheckResultRowNews, int examineType) {
        ExamineCheckResultRow childRow = new ExamineCheckResultRow();
        childRow.setName(memberGroupExpr.getShowString(evaluator));
        childRow.setLeftValue(this.handValue(memberGroupExpr.calc(evaluator)));
        childRow.setMemberKey(memberGroupExpr.getMemberKey());
        childRow.setIntersection(examineBo.getExamineItemMap().get(memberGroupExpr.getMemberKey()).isRelate());
        Map<String, String> diffMembers = memberGroupExpr.getRealMembers().stream().collect(Collectors.toMap(MemberExpr::getDimNumber, MemberExpr::getNumber));
        childRow.setDiffMembers(diffMembers);
        ExamineCheckResultRowNew newChildRow = new ExamineCheckResultRowNew();
        newChildRow.setName(memberGroupExpr.getShowString(evaluator));
        newChildRow.setValue(this.handValue(memberGroupExpr.calc(evaluator)));
        newChildRow.setMemberKey(memberGroupExpr.getMemberKey());
        newChildRow.setIntersection(examineBo.getExamineItemMap().get(memberGroupExpr.getMemberKey()).isRelate());
        newChildRow.setDiffMembers(diffMembers);
        newChildRow.setExaminetype(Integer.valueOf(examineType));
        examineCheckResultRowNews.add(newChildRow);
        return childRow;
    }

    private String handValue(Object calc) {
        if (calc == null) {
            return "null";
        }
        if (calc instanceof BigDecimal) {
            return ((BigDecimal)calc).stripTrailingZeros().toPlainString();
        }
        return calc.toString();
    }

    public void setApproveBillId(Long approveBillId) {
        this.approveBillId = approveBillId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
        this.modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        this.setMainDatasetDims();
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
        this.setMainDatasetDims();
    }

    private void setMainDatasetDims() {
        if (this.modelCache != null && this.datasetId != null) {
            this.mainDatasetDims = this.modelCache.getDimensionMap(this.datasetId).keySet();
        }
    }

    public void setTargetEvent(TriggerEventEnum targetEvent) {
        this.targetEvent = targetEvent;
    }

    public TriggerEventEnum getTargetEvent() {
        return this.targetEvent;
    }

    public ProcessTypeEnum getProcessTypeEnum() {
        return this.processTypeEnum;
    }

    public void setProcessTypeEnum(ProcessTypeEnum processTypeEnum) {
        this.processTypeEnum = processTypeEnum;
    }

    public void setCheckRangeList(List<CheckRange> checkRangeList) {
        this.checkRangeList = checkRangeList;
    }

    public void setExamineBoList(List<ExamineBo> examineBoList) {
        this.examineBoList = examineBoList;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void setReportProcessId(Long reportProcessId) {
        this.reportProcessId = reportProcessId;
    }

    public void setExecutorId(Long executorId) {
        this.executorId = executorId;
    }

    public Long getExecutorId() {
        return this.executorId;
    }

    public void setTemplateIdToNumMap(Map<Long, String> templateIdToNumMap) {
        this.templateIdToNumMap = templateIdToNumMap;
    }

    public Boolean getCartesian() {
        return this.isCartesian;
    }

    public void setCartesian(Boolean cartesian) {
        this.isCartesian = cartesian;
    }

    public void setBizModelId(Long bizModelId) {
        this.bizModelId = bizModelId;
    }

    public void setCurrPeriodId(Long currPeriodId) {
        this.currPeriodId = currPeriodId;
    }

    public void setDimRelMap(Map<String, Set<String>> dimRelMap) {
        this.dimRelMap = dimRelMap;
    }

    public void setDimRelList(List<Long> dimRelList) {
        this.dimRelList = dimRelList;
    }
}

