/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.check;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultForExamine;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineRowCheckResultEnum;

public class ExamineReportRowCutHandler {
    private final Integer reportMaxRow;
    private final Integer samplingRowSize;
    private int allRowSize;
    private boolean onlyStoreNoPass;
    private boolean allStoreSimple;
    private List<ExamineCheckResultForExamine> resultList = new ArrayList<ExamineCheckResultForExamine>(16);

    public ExamineReportRowCutHandler(Integer reportMaxRow, Integer samplingRowSize) {
        this.reportMaxRow = reportMaxRow;
        this.samplingRowSize = samplingRowSize;
    }

    public void handler(ExamineCheckResultForExamine examineResult) {
        if (this.allStoreSimple) {
            this.allStoreSimple(examineResult);
        } else if (this.onlyStoreNoPass) {
            this.onlyStoreNoPass(examineResult);
        }
        this.allRowSize += examineResult.getExamineCheckResultItemList().size();
        this.resultList.add(examineResult);
        if (!this.allStoreSimple && this.allRowSize > this.reportMaxRow) {
            if (!this.onlyStoreNoPass) {
                this.setStoreNoPassTrue();
            }
            if (!this.allStoreSimple && this.allRowSize > this.reportMaxRow) {
                this.setStoreSimpleTrue();
            }
        }
    }

    private void setStoreSimpleTrue() {
        this.allStoreSimple = true;
        this.allRowSize = 0;
        for (ExamineCheckResultForExamine examineCheckResultForExamine : this.resultList) {
            int rowSize = this.allStoreSimple(examineCheckResultForExamine);
            this.allRowSize += rowSize;
        }
    }

    private void setStoreNoPassTrue() {
        this.onlyStoreNoPass = true;
        this.allRowSize = 0;
        for (ExamineCheckResultForExamine examineCheckResultForExamine : this.resultList) {
            int rowSize = this.onlyStoreNoPass(examineCheckResultForExamine);
            this.allRowSize += rowSize;
        }
    }

    private int allStoreSimple(ExamineCheckResultForExamine examineResult) {
        if (examineResult.getExamineCheckResultItemList().size() > this.samplingRowSize) {
            List examineCheckResultItems = examineResult.getExamineCheckResultItemList().subList(0, this.samplingRowSize);
            examineResult.setExamineCheckResultItemList(examineCheckResultItems);
        }
        return Math.min(this.samplingRowSize, examineResult.getExamineCheckResultItemList().size());
    }

    private int onlyStoreNoPass(ExamineCheckResultForExamine examineResult) {
        if (examineResult.getExamineCheckResultEnum() == ExamineCheckResultEnum.Pass) {
            if (examineResult.getExamineCheckResultItemList().size() > this.samplingRowSize) {
                List examineCheckResultItems = examineResult.getExamineCheckResultItemList().subList(0, this.samplingRowSize);
                examineResult.setExamineCheckResultItemList(examineCheckResultItems);
            }
            return Math.min(this.samplingRowSize, examineResult.getExamineCheckResultItemList().size());
        }
        List noPassRow = examineResult.getExamineCheckResultItemList().stream().filter(item -> item.getMainRow().getCheckResult() == ExamineRowCheckResultEnum.NoPass).collect(Collectors.toList());
        examineResult.setExamineCheckResultItemList(noPassRow);
        return noPassRow.size();
    }
}

