/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.domain;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.examinev2.ExamineUtils;
import kd.epm.eb.business.examinev2.FillEnvironment;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.examine.bo.ExamineItem;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.var.ReportVarUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;

public class ExamineBo
implements Serializable {
    private final ExamineDto examineDto;
    private Map<String, Map<String, String>> varValues;
    private Long busModelId;
    private IExpress expr;
    private Map<String, Set<String>> scopes;
    private Map<Long, Map<String, Set<String>>> exprRefMembers;
    private List<ExamineItem> examineItemList;
    private Map<String, ExamineItem> examineItemMap;
    private Set<String> usedDimNumbers;
    private Map<String, Set<String>> memberKeyUsedDimMap;
    private static LoadingCache<Long, IModelCacheHelper> modelMap = CacheBuilder.newBuilder().maximumSize(3L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, IModelCacheHelper>(){

        public IModelCacheHelper load(Long modelId) {
            return ModelCacheContext.getOrCreate((Long)modelId);
        }
    });

    public ExamineBo(ExamineDto examineDto, long busModelId, Map<String, Map<String, String>> varValues) {
        this.examineDto = examineDto;
        this.busModelId = busModelId;
        this.varValues = varValues;
    }

    public ExamineDto getExamineDto() {
        return this.examineDto;
    }

    public IExpress getExpr() {
        if (this.expr == null) {
            this.expr = ExamineUtils.parse(this.examineDto.getFormulaStr());
        }
        return this.expr;
    }

    public static IModelCacheHelper getModelCache(Long modelId) {
        IModelCacheHelper modelCache = null;
        try {
            modelCache = (IModelCacheHelper)modelMap.get((Object)modelId);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return modelCache;
    }

    public Map<String, Set<String>> getScopes() {
        if (this.scopes == null) {
            String realMemberNumber;
            Set scope;
            String dimNumber;
            this.scopes = new HashMap<String, Set<String>>(16);
            this.examineDto.getScopes().forEach((k, v) -> this.scopes.put((String)k, new HashSet(v)));
            IModelCacheHelper modelCache = ExamineBo.getModelCache(this.examineDto.getModelId());
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.examineDto.getModelId());
            Map viewMap = modelCache.getViewsByBusModel(this.getBusModelId());
            if (!MapUtils.isEmpty((Map)this.examineDto.getVarConditions())) {
                for (Map.Entry entry : this.examineDto.getVarConditions().entrySet()) {
                    dimNumber = (String)entry.getKey();
                    scope = this.scopes.computeIfAbsent(dimNumber, v -> new HashSet(16));
                    for (MemberCondition memberCondition : (List)entry.getValue()) {
                        String msg = ResManager.loadResFormat((String)"\u52fe\u7a3d\u5173\u7cfb[%1]\u4f7f\u7528\u5230\u7684%2\u7ef4\u5ea6\u53d8\u91cf%3\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u65b9\u6848\u4e2d\u8bbe\u7f6e\u3002", (String)"ReportVarUtil_8", (String)"epm-eb-spread", (Object[])new Object[]{this.examineDto.getNumber(), dimNumber, memberCondition.getNumber()});
                        realMemberNumber = ReportVarUtil.transVarNumToRealNum((Long)this.examineDto.getModelId(), (String)dimNumber, (String)memberCondition.getNumber(), this.varValues, (String)msg);
                        Long viewId = (Long)viewMap.get(dimNumber);
                        if (StringUtils.isNotEmpty((String)memberCondition.getViewId()) && (viewId = Long.valueOf(Long.parseLong(memberCondition.getViewId()))) < 1L) {
                            viewId = (Long)viewMap.get(dimNumber);
                        }
                        List member = modelCache.getMember(dimNumber, viewId, realMemberNumber, Integer.parseInt(memberCondition.getRange()));
                        Set memNumberSet = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                        scope.addAll(memNumberSet);
                    }
                }
            }
            if (!MapUtils.isEmpty((Map)this.examineDto.getRemoveConditions())) {
                for (Map.Entry entry : this.examineDto.getRemoveConditions().entrySet()) {
                    dimNumber = (String)entry.getKey();
                    scope = this.scopes.computeIfAbsent(dimNumber, v -> new HashSet(16));
                    for (MemberCondition memberCondition : (List)entry.getValue()) {
                        Long viewId = (Long)viewMap.get(dimNumber);
                        if (StringUtils.isNotEmpty((String)memberCondition.getViewId()) && (viewId = Long.valueOf(Long.parseLong(memberCondition.getViewId()))) < 1L) {
                            viewId = (Long)viewMap.get(dimNumber);
                        }
                        if (memberCondition.isProp()) {
                            CustomPropertyValue customPropertyValue = MemberPropCache.getCustomPropertyValue((MemberPropCache)memberPropCache, (String)dimNumber, (String)memberCondition.getLongnumber());
                            List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, (Long)viewId, (CustomPropertyValue)customPropertyValue);
                            Set propSet = propMemberList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                            scope.removeAll(propSet);
                            continue;
                        }
                        if (memberCondition.isVariable()) {
                            String msg = ResManager.loadResFormat((String)"\u52fe\u7a3d\u5173\u7cfb[%1]\u4f7f\u7528\u5230\u7684%2\u7ef4\u5ea6\u53d8\u91cf%3\u6ca1\u6709\u8bbe\u7f6e\u503c\uff0c\u8bf7\u5728\u65b9\u6848\u4e2d\u8bbe\u7f6e\u3002", (String)"ReportVarUtil_8", (String)"epm-eb-spread", (Object[])new Object[]{this.examineDto.getNumber(), dimNumber, memberCondition.getNumber()});
                            realMemberNumber = ReportVarUtil.transVarNumToRealNum((Long)this.examineDto.getModelId(), (String)dimNumber, (String)memberCondition.getNumber(), this.varValues, (String)msg);
                        } else {
                            realMemberNumber = memberCondition.getNumber();
                        }
                        List member = modelCache.getMember(dimNumber, viewId, realMemberNumber, Integer.parseInt(memberCondition.getRange()));
                        Set memNumberSet = member.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                        scope.removeAll(memNumberSet);
                    }
                }
            }
        }
        return this.scopes;
    }

    public Long getBusModelId() {
        return this.busModelId;
    }

    public Map<Long, Map<String, Set<String>>> getExprRefMembers() {
        if (this.exprRefMembers == null) {
            this.initRefMembers();
        }
        return this.exprRefMembers;
    }

    public List<ExamineItem> getExamineItemList() {
        if (this.examineItemList == null) {
            this.initRefMembers();
        }
        return this.examineItemList;
    }

    public Map<String, ExamineItem> getExamineItemMap() {
        if (this.examineItemMap == null) {
            this.initRefMembers();
        }
        return this.examineItemMap;
    }

    public Set<String> getUsedDimNumbers() {
        if (this.usedDimNumbers == null) {
            this.initRefMembers();
        }
        return this.usedDimNumbers;
    }

    public Map<String, Set<String>> getMemberKeyUsedDimMap() {
        if (this.memberKeyUsedDimMap == null) {
            this.initRefMembers();
        }
        return this.memberKeyUsedDimMap;
    }

    private void initRefMembers() {
        this.exprRefMembers = new HashMap<Long, Map<String, Set<String>>>(16);
        this.examineItemList = new ArrayList<ExamineItem>(16);
        this.usedDimNumbers = new HashSet<String>(16);
        this.memberKeyUsedDimMap = new HashMap<String, Set<String>>(16);
        IExpress expr = this.getExpr();
        FillEnvironment fillEnvironment = new FillEnvironment(ExamineBo.getModelCache(this.examineDto.getModelId()), this.examineDto, this.examineDto.getDatasetId(), this.varValues, true, true);
        ExamineUtils.fillExprRefMembers(expr, this.exprRefMembers, this.examineItemList, fillEnvironment);
        for (ExamineItem examineItem : this.examineItemList) {
            IModelCacheHelper modelCache = ExamineBo.getModelCache(this.examineDto.getModelId());
            Long itemDatasetId = examineItem.getDatasetId();
            Map dimensionMap = modelCache.getDimensionMap(itemDatasetId);
            this.memberKeyUsedDimMap.put(examineItem.getMemberKey(), dimensionMap.keySet());
            this.usedDimNumbers.addAll(dimensionMap.keySet());
        }
        this.examineItemMap = this.examineItemList.stream().collect(Collectors.toMap(ExamineItem::getMemberKey, v -> v));
    }
}

