/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.examinev2.vo.ExprPanelTypeEnum;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportV2;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;

public class ExamineCheckDataServiceImpl {
    public static final Log log = LogFactory.getLog(ExamineCheckReportServiceImpl.class);
    private static final ExamineCheckDataServiceImpl INSTANCE = new ExamineCheckDataServiceImpl();

    private ExamineCheckDataServiceImpl() {
    }

    public static ExamineCheckDataServiceImpl getInstance() {
        return INSTANCE;
    }

    public List<ExamineCheckReportV2> queryCrossData(List<?> filter) {
        DynamicObjectCollection doj = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
        if (doj == null || doj.size() == 0) {
            return Collections.emptyList();
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])doj.stream().map(x -> x.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_examine_result_report"));
        ArrayList<ExamineCheckReportV2> examineCheckReports = new ArrayList<ExamineCheckReportV2>(dynamicObjects.length);
        Set datasetIds = Arrays.stream(dynamicObjects).map(x -> x.getString("dataset.id")).collect(Collectors.toSet());
        long modelId = dynamicObjects[0].getLong("model.id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap dimMemberPermCheckerHashMap = new HashMap(datasetIds.size());
        datasetIds.stream().filter(StringUtils::isNotEmpty).forEach(x -> {
            DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)Long.valueOf(x));
            dimMemberPermCheckerHashMap.put(x, readPermChecker);
        });
        for (DynamicObject object : dynamicObjects) {
            ExamineCheckReportV2 examineCheckReportV2 = ExamineCheckReportV2.of((DynamicObject)object);
            Long busModelId = modelCacheHelper.getBusModelByDataSet(Long.valueOf(Long.parseLong(examineCheckReportV2.getDataSetId())));
            String showpanel = object.getString("showpanel");
            List exprPanels = JSON.parseArray((String)showpanel, ExprPanel.class);
            DimMemberPermChecker readPermChecker = (DimMemberPermChecker)dimMemberPermCheckerHashMap.get(examineCheckReportV2.getDataSetId());
            if (readPermChecker != null && !readPermChecker.hasAllPerm()) {
                exprPanels.stream().filter(Objects::nonNull).forEach(panel -> {
                    if (ExprPanelTypeEnum.Member == panel.getType()) {
                        HashMap memberGroup = Maps.newHashMap();
                        panel.getDimMemberInfo().forEach((dim, mem) -> {
                            MemberItem mi = new MemberItem(true, modelCacheHelper.getMemberByAnyView(busModelId, dim, mem).getId());
                            memberGroup.put(dim, mi);
                        });
                        if (!readPermChecker.check((Map)memberGroup)) {
                            panel.setValue("***");
                        }
                    }
                });
                examineCheckReportV2.setShowPanel(JSONObject.parseArray((String)JSON.toJSONString((Object)exprPanels), JSONObject.class));
            }
            examineCheckReports.add(examineCheckReportV2);
        }
        return this.sort(examineCheckReports);
    }

    public List<ExamineCheckReportV2> queryCrossDataByPage(List<?> filter, int page, int pageSize) {
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("eb_examine_result_report", "eb_examine_result_report", "id", filter.toArray(new QFilter[0]), "id", (page - 1) * pageSize, pageSize);
        if (ds == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
        ds.close();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return Collections.emptyList();
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])rows.stream().map(x -> x.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_examine_result_report"));
        long modelId = dynamicObjects[0].getLong("model.id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set datasetIds = Arrays.stream(dynamicObjects).map(x -> x.getString("dataset.id")).collect(Collectors.toSet());
        HashMap dimMemberPermCheckerHashMap = new HashMap(datasetIds.size());
        datasetIds.stream().filter(StringUtils::isNotEmpty).forEach(x -> {
            DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)Long.valueOf(x));
            dimMemberPermCheckerHashMap.put(x, readPermChecker);
        });
        ArrayList<ExamineCheckReportV2> examineCheckReports = new ArrayList<ExamineCheckReportV2>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            ExamineCheckReportV2 examineCheckReportV2 = ExamineCheckReportV2.of((DynamicObject)object);
            String showpanel = object.getString("showpanel");
            List exprPanels = JSON.parseArray((String)showpanel, ExprPanel.class);
            String dataSetIdStr = examineCheckReportV2.getDataSetId();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dataSetIdStr)) {
                examineCheckReports.add(examineCheckReportV2);
                continue;
            }
            Long busModelId = modelCacheHelper.getBusModelByDataSet(Long.valueOf(Long.parseLong(dataSetIdStr)));
            DimMemberPermChecker readPermChecker = (DimMemberPermChecker)dimMemberPermCheckerHashMap.get(dataSetIdStr);
            if (readPermChecker != null && !readPermChecker.hasAllPerm()) {
                exprPanels.stream().filter(Objects::nonNull).forEach(panel -> {
                    if (ExprPanelTypeEnum.Member == panel.getType()) {
                        HashMap memberGroup = Maps.newHashMap();
                        panel.getDimMemberInfo().forEach((dim, mem) -> {
                            MemberItem mi = new MemberItem(true, modelCacheHelper.getMemberByAnyView(busModelId, dim, mem).getId());
                            memberGroup.put(dim, mi);
                        });
                        if (!readPermChecker.check((Map)memberGroup)) {
                            panel.setValue("***");
                        }
                    }
                });
                examineCheckReportV2.setShowPanel(JSONObject.parseArray((String)JSON.toJSONString((Object)exprPanels), JSONObject.class));
            }
            examineCheckReports.add(examineCheckReportV2);
        }
        return this.sort(examineCheckReports);
    }

    public int queryTotal(List<?> filter) {
        ORM orm = ORM.create();
        return orm.count("eb_examine_result_report", "eb_examine_result_report", filter.toArray(new QFilter[0]));
    }

    public DynamicObjectCollection getReportStatus(List<Long> ProcessIds) {
        QFilter filter = new QFilter("reportprocess", "in", ProcessIds);
        return QueryServiceHelper.query((String)"eb_examine_result_report", (String)"reportprocess, status", (QFilter[])filter.toArray());
    }

    public void deleteReport(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DeleteServiceHelper.delete((String)"eb_examine_result_report", (QFilter[])qFilter.toArray());
    }

    public List<Long> queryCrossDataIds(List<?> filter) {
        DynamicObjectCollection doj = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])filter.toArray(new QFilter[0]));
        return doj.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }

    private List<ExamineCheckReportV2> sort(List<ExamineCheckReportV2> examineCheckReports) {
        return examineCheckReports.stream().sorted(Comparator.comparing(ExamineCheckReportV2::getId).reversed()).sorted((o1, o2) -> {
            if (o2.getResult() != 60 && o1.getResult() != 60) {
                return Integer.compare(o2.getResult(), o1.getResult());
            }
            if (o1.getResult() == 60 && o2.getResult() != 60) {
                return 1;
            }
            return -1;
        }).collect(Collectors.toList());
    }
}

