/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.utils.FixReportUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateFactory;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ExamineCheckRangeUtils {
    private static final Set<String> replaceDimSets = Sets.newHashSet((Object[])new String[]{"Entity", "BudgetPeriod", "DataType", "Version"});
    private static final Log log = LogFactory.getLog(ExamineCheckRangeUtils.class);

    public static List<ReportCheckRange> getReportCheckRange(ReportCheckRangeRequest args) {
        ArrayList<ReportCheckRange> result = new ArrayList<ReportCheckRange>();
        log.info("getReportCheckRange:{}", (Object)JSONObject.toJSONString((Object)args));
        if (args == null || CollectionUtils.isEmpty((Collection)args.getReportList()) || IDUtils.isNull((Long)args.getModel())) {
            return result;
        }
        HashMap<Long, ITemplateModel> templateModelsMap = new HashMap<Long, ITemplateModel>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        IModelCacheHelper modelCacheHelper = null;
        MemberPropCache memberPropCache = null;
        Long oldTaskprocessId = 0L;
        Long modelId = args.getModel();
        Long orgViewid = 0L;
        modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        for (SchemeOrTaskReqeust request : args.getReportList()) {
            Integer processType = request.getReportProcessType();
            Long taskProcessId = request.getTaskProcessId();
            Long approveBillId = request.getApproveBillId();
            List reportIds = request.getReportProcessId();
            if (CollectionUtils.isEmpty((Collection)reportIds) || taskProcessId == null || processType == null || modelId == null) continue;
            Long taskProcess = IDUtils.toLong((Object)taskProcessId);
            if (!taskProcess.equals(oldTaskprocessId)) {
                if (ProcessTypeEnum.REPORT.getIndex() == processType.intValue()) {
                    DynamicObject scheme;
                    DynamicObject reportAssign = BusinessDataServiceHelper.loadSingle((Object)taskProcessId, (String)"eb_schemeassign");
                    if (reportAssign != null && (scheme = reportAssign.getDynamicObject("scheme")) != null) {
                        orgViewid = scheme.getLong("orgview.id");
                    }
                } else {
                    DynamicObject orgview;
                    DynamicObject taskList = BusinessDataServiceHelper.loadSingle((Object)taskProcessId, (String)"eb_tasklist");
                    if (taskList != null && (orgview = taskList.getDynamicObject("orgview")) != null) {
                        orgViewid = orgview.getLong("id");
                    }
                }
            }
            Map varValues = ReportVarUtil.getVarValues((Integer)processType, (Long)modelId, (Long)taskProcess);
            String selectFields = "id,template.id,template.name,template.number,template.dataunit,template.model.id,template.dataset.businessmodel.id,template.dataset.id,template.varbaseforeb,template.templateCatalog.id,template.isreadonly,template.isrelation,template.floatcalculate,template.data,entity.id,period.id,datatype.id,version.id";
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"eb_reportprocess", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)reportIds)});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                FixSpreadManager spreadManager;
                ITemplateModel templateModel;
                long templateId;
                if (dynamicObject == null || IDUtils.isNull((long)(templateId = dynamicObject.getLong("template.id")))) continue;
                if (templateIds.contains(templateId)) {
                    templateModel = (ITemplateModel)templateModelsMap.get(templateId);
                } else {
                    String data = dynamicObject.getString("template.data");
                    if (StringUtils.isEmpty((CharSequence)data)) continue;
                    templateModel = StringUtils.isNotEmpty((CharSequence)data) ? TemplateModelJSONUtil.parseITemplateModel((String)data) : TemplateFactory.buildTemplateModel();
                    templateModel.setTemplateBaseInfo(ExamineCheckRangeUtils.getTemplateBaseInfo(dynamicObject));
                    templateModel.initDimensionViewsFromDataSet();
                    templateModelsMap.put(templateId, templateModel);
                    templateIds.add(templateId);
                }
                Long datasetID = templateModel.getTemplateBaseInfo().getDatasetID();
                List dimensionList = modelCacheHelper.getDimensionList(datasetID);
                Map viewIds = modelCacheHelper.getViewsByDataSet(datasetID);
                Long reportOrgId = dynamicObject.getLong("entity.id");
                Long reportPeriodId = dynamicObject.getLong("period.id");
                Long reportDatatypeId = dynamicObject.getLong("datatype.id");
                Long reportVersionId = dynamicObject.getLong("version.id");
                Map allDimMems = templateModel.retrieveQuoteMembersWithChildren(modelCacheHelper.getModelobj().getId().longValue(), memberPropCache, varValues, args.getIncludeNotLeaf());
                Map<String, Collection<String>> pageDims = ExamineCheckRangeUtils.getPageMems(orgViewid, reportOrgId, reportPeriodId, reportDatatypeId, reportVersionId, modelCacheHelper, allDimMems, templateModel, args.getIncludeNotLeaf());
                kd.epm.eb.common.cache.impl.Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewid, reportOrgId);
                List allMembers = orgMember.getAllMembers();
                Set<String> entityNumberSet = allMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                ArrayList<CheckRange> mapList = new ArrayList<CheckRange>(16);
                int i = 0;
                FixReportUtils fixReportUtils = new FixReportUtils();
                fixReportUtils.setCurrentOrgNumber(orgMember.getNumber());
                fixReportUtils.setCurrentOrgLongNumber(orgMember.getLongNumber());
                Map<String, Set<String>> floatMemberMap = fixReportUtils.getMemberByTemplateScope(null, templateModel, memberPropCache, pageDims, varValues, args.getIncludeNotLeaf());
                Map reportRelationMap = templateModel.getReportRelationList(modelCacheHelper.getModelobj().getId(), memberPropCache, varValues);
                if (templateModel instanceof FixTemplateModel) {
                    spreadManager = null;
                    spreadManager = new FixSpreadManager();
                    spreadManager.setProcessId(taskProcessId);
                    spreadManager.setVarFlagStr("1");
                    spreadManager.setProcessType(ProcessTypeEnum.getProcessTypeByIndex((int)processType).getNumber());
                    spreadManager.initModelObj(templateModel);
                    spreadManager.buildReportManager(templateModel);
                    FixTemplateModel templateModel1 = (FixTemplateModel)templateModel;
                    fixReportUtils.addFloatRelationList(null, templateModel1, reportRelationMap, entityNumberSet);
                    for (Object multiAreaSetting : templateModel1.getAreaRanges()) {
                        Long dimensionViewId;
                        IRowColDimensionEntry defaultRowColDimensionEntry22;
                        ArrayList entityList = new ArrayList(16);
                        if (multiAreaSetting.getFloatInfos() != null && multiAreaSetting.getFloatInfos().size() > 0) {
                            for (MultiAreaSetting.FloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                                for (IRowColDimensionEntry defaultRowColDimensionEntry22 : floatInfo.getPartition().getRowColDimensionEntries()) {
                                    if (defaultRowColDimensionEntry22.isFloat() || !SysDimensionEnum.Entity.getNumber().equals(defaultRowColDimensionEntry22.getDimension().getNumber())) continue;
                                    entityList.addAll(defaultRowColDimensionEntry22.getMembers().stream().map(x -> x.getNumber()).collect(Collectors.toList()));
                                }
                            }
                        }
                        String areaIndex = multiAreaSetting.getAreaRangeStart();
                        HashMap areaMemberMap = Maps.newHashMapWithExpectedSize((int)allDimMems.size());
                        Map areaRowColMembers = templateModel1.retrieveRowColMembersWithScope(areaIndex);
                        if (MapUtils.isEmpty((Map)areaRowColMembers)) continue;
                        defaultRowColDimensionEntry22 = areaRowColMembers.entrySet().iterator();
                        while (defaultRowColDimensionEntry22.hasNext()) {
                            Map.Entry entry = defaultRowColDimensionEntry22.next();
                            HashSet areaMembers = new HashSet(16);
                            for (Member member : (Collection)entry.getValue()) {
                                if (RangeF7PropertyCataEnum.Property.getIndex().equals(member.getType())) {
                                    Set refMembers = memberPropCache.getRefMembersByLongNumber((String)entry.getKey(), member.getLongNumber());
                                    if (!CollectionUtils.isNotEmpty((Collection)refMembers)) continue;
                                    areaMembers.addAll(refMembers);
                                    continue;
                                }
                                String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)member.getNumber(), (String)((String)entry.getKey()), (Map)varValues);
                                if (RangeEnum.ONLY.getIndex() != member.getRange()) {
                                    dimensionViewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (Long)datasetID, (String)((String)entry.getKey()), (String)areaIndex);
                                    List cacheMems = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, realDimByVar, member.getRange());
                                    if (cacheMems == null) continue;
                                    if (!args.getIncludeNotLeaf().booleanValue()) {
                                        Set collect = cacheMems.stream().filter(x -> x.isLeaf()).collect(Collectors.toList()).stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                                        areaMembers.addAll(collect);
                                        continue;
                                    }
                                    areaMembers.addAll(cacheMems.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                                    continue;
                                }
                                if (!args.getIncludeNotLeaf().booleanValue()) {
                                    kd.epm.eb.common.cache.impl.Member member1 = modelCacheHelper.getMember((String)entry.getKey(), (Long)viewIds.get(entry.getKey()), realDimByVar);
                                    if (member1 == null || !member1.isLeaf()) continue;
                                    areaMembers.add(realDimByVar);
                                    continue;
                                }
                                areaMembers.add(realDimByVar);
                            }
                            areaMemberMap.put(entry.getKey(), areaMembers);
                        }
                        if (multiAreaSetting.getFloatOnWhere() == 0) {
                            if (MapUtils.isEmpty(floatMemberMap)) continue;
                            boolean hasEmpty = false;
                            for (Map.Entry entry : areaMemberMap.entrySet()) {
                                Set<String> _members = floatMemberMap.get(entry.getKey());
                                Set memNumbers = (Set)entry.getValue();
                                if (_members == null) continue;
                                HashSet<String> temp = new HashSet<String>(_members.size());
                                temp.addAll(_members);
                                if (SysDimensionEnum.Entity.getNumber().equals(entry.getKey())) {
                                    dimensionViewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (Long)datasetID, (String)((String)entry.getKey()), (String)areaIndex);
                                    kd.epm.eb.common.cache.impl.Member submitMember = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, reportOrgId);
                                    if (submitMember != null) {
                                        Set members;
                                        if (args.getIncludeNotLeaf().booleanValue()) {
                                            members = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, submitMember.getNumber(), RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                                            temp.retainAll(members);
                                        } else {
                                            members = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, submitMember.getNumber(), RangeEnum.ALL.getIndex()).stream().filter(x -> x.isLeaf()).collect(Collectors.toSet()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                                            temp.retainAll(members);
                                        }
                                    }
                                    temp.addAll(entityList);
                                }
                                memNumbers.retainAll(temp);
                                if (!memNumbers.isEmpty()) continue;
                                hasEmpty = true;
                                break;
                            }
                            if (hasEmpty) continue;
                        }
                        for (Dimension dimension : dimensionList) {
                            String dimNumber = dimension.getNumber();
                            if (areaMemberMap.containsKey(dimNumber)) continue;
                            if (pageDims.containsKey(dimNumber)) {
                                areaMemberMap.put(dimNumber, new HashSet<String>(pageDims.get(dimNumber)));
                                continue;
                            }
                            Collection collection = (Collection)allDimMems.get(dimNumber);
                            if (CollectionUtils.isEmpty((Collection)collection)) {
                                areaMemberMap.put(dimNumber, Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()}));
                                continue;
                            }
                            areaMemberMap.put(dimNumber, new HashSet(collection));
                        }
                        mapList.add(new CheckRange(i++, spreadManager != null ? spreadManager.getDimemsionViews() : null, (Map)areaMemberMap, reportRelationMap == null ? null : (List)reportRelationMap.get(multiAreaSetting.getAreaRange())));
                    }
                } else {
                    Object multiAreaSetting;
                    spreadManager = null;
                    spreadManager = new EbSpreadManager();
                    spreadManager.setProcessId(taskProcessId);
                    spreadManager.setVarFlagStr("1");
                    spreadManager.setProcessType(ProcessTypeEnum.getProcessTypeByIndex((int)processType).getNumber());
                    spreadManager.initModelObj(templateModel);
                    EBook ieBook = new EBook(new String[]{"Sheet1"});
                    spreadManager.setEbook((IEBook)ieBook);
                    spreadManager.buildReportManager(templateModel);
                    HashMap areaMemberMap = Maps.newHashMapWithExpectedSize((int)allDimMems.size());
                    multiAreaSetting = dimensionList.iterator();
                    while (multiAreaSetting.hasNext()) {
                        Dimension dimension = (Dimension)multiAreaSetting.next();
                        String dimNumber = dimension.getNumber();
                        if (pageDims.containsKey(dimNumber)) {
                            areaMemberMap.put(dimNumber, new HashSet<String>(pageDims.get(dimNumber)));
                            continue;
                        }
                        Collection strings = (Collection)allDimMems.get(dimNumber);
                        if (CollectionUtils.isEmpty((Collection)strings)) {
                            if (args.getIncludeNotLeaf().booleanValue()) {
                                areaMemberMap.put(dimNumber, Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()}));
                                continue;
                            }
                            areaMemberMap.put(dimNumber, new HashSet(16));
                            continue;
                        }
                        areaMemberMap.put(dimNumber, new HashSet(strings));
                    }
                    CheckRange dynamic = new CheckRange(i, spreadManager != null ? spreadManager.getDimemsionViews() : null, (Map)areaMemberMap);
                    dynamic.setRelationList(reportRelationMap == null ? null : (List)reportRelationMap.get("dynamic"));
                    mapList.add(dynamic);
                }
                if (CollectionUtils.isEmpty(mapList)) continue;
                ReportCheckRange reportCheckRange = new ReportCheckRange();
                reportCheckRange.setDatasetId(templateModel.getTemplateBaseInfo().getDatasetID());
                reportCheckRange.setTemplateId(templateModel.getTemplateBaseInfo().getId());
                reportCheckRange.setReportProcessId(Long.valueOf(dynamicObject.getLong("id")));
                reportCheckRange.setCartesian(Boolean.TRUE);
                reportCheckRange.setCheckRangeList(mapList);
                reportCheckRange.setBizModelId(templateModel.getTemplateBaseInfo().getBizModel());
                reportCheckRange.setCurrPeriodId(reportPeriodId);
                reportCheckRange.setDimRelList(templateModel.getTemplateBaseInfo().getDimRelations());
                reportCheckRange.setDimRelMap(DimensionRelationUtils.getRelationMap((Long)modelId, (Long)reportCheckRange.getBizModelId(), (List)reportCheckRange.getDimRelList()));
                if (approveBillId != null) {
                    reportCheckRange.setApproveBillId(approveBillId);
                }
                result.add(reportCheckRange);
            }
        }
        return result;
    }

    public static List<ReportCheckRange> parseRptExamineScope(Long reportPeriodId, Long reportDatatypeId, Long reportVersionId, Long orgViewId, IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, Long currentSubmitEntityId, Long reportProcessId, Map<String, Map<String, String>> varValues, ITemplateModel templateModel, IEbSpreadManager spreadManager) {
        ArrayList<ReportCheckRange> result = new ArrayList<ReportCheckRange>(16);
        if (templateModel == null || spreadManager == null) {
            return result;
        }
        Long datasetID = templateModel.getTemplateBaseInfo().getDatasetID();
        List dimensionList = modelCacheHelper.getDimensionList(datasetID);
        Map allDimMems = templateModel.retrieveQuoteMembersWithChildren(modelCacheHelper.getModelobj().getId().longValue(), memberPropCache, varValues, Boolean.TRUE);
        Map<String, Collection<String>> pageDims = ExamineCheckRangeUtils.getPageMems(orgViewId, currentSubmitEntityId, reportPeriodId, reportDatatypeId, reportVersionId, modelCacheHelper, allDimMems, templateModel, Boolean.TRUE);
        kd.epm.eb.common.cache.impl.Member orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, currentSubmitEntityId);
        List allMembers = orgMember.getAllMembers();
        Set<String> entityNumberSet = allMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        ArrayList<CheckRange> mapList = new ArrayList<CheckRange>(16);
        int i = 0;
        FixReportUtils fixReportUtils = new FixReportUtils();
        fixReportUtils.setCurrentOrgNumber(orgMember.getNumber());
        fixReportUtils.setCurrentOrgLongNumber(orgMember.getLongNumber());
        Map<String, Set<String>> floatMemberMap = fixReportUtils.getMemberByTemplateScope(null, templateModel, memberPropCache, pageDims, varValues, Boolean.TRUE);
        Map reportRelationMap = templateModel.getReportRelationList(modelCacheHelper.getModelobj().getId(), memberPropCache, varValues);
        if (templateModel instanceof FixTemplateModel) {
            FixTemplateModel templateModel1 = (FixTemplateModel)templateModel;
            fixReportUtils.addFloatRelationList(null, templateModel1, reportRelationMap, entityNumberSet);
            for (IMultiAreaSetting multiAreaSetting : templateModel1.getAreaRanges()) {
                Long dimensionViewId;
                IRowColDimensionEntry defaultRowColDimensionEntry22;
                ArrayList entityList = new ArrayList(16);
                if (multiAreaSetting.getFloatInfos() != null && multiAreaSetting.getFloatInfos().size() > 0) {
                    for (MultiAreaSetting.FloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                        for (IRowColDimensionEntry defaultRowColDimensionEntry22 : floatInfo.getPartition().getRowColDimensionEntries()) {
                            if (defaultRowColDimensionEntry22.isFloat() || !SysDimensionEnum.Entity.getNumber().equals(defaultRowColDimensionEntry22.getDimension().getNumber())) continue;
                            entityList.addAll(defaultRowColDimensionEntry22.getMembers().stream().map(IBaseEntry::getNumber).collect(Collectors.toList()));
                        }
                    }
                }
                String areaIndex = multiAreaSetting.getAreaRangeStart();
                HashMap areaMemberMap = Maps.newHashMapWithExpectedSize((int)allDimMems.size());
                Map areaRowColMembers = templateModel1.retrieveRowColMembersWithScope(areaIndex);
                if (MapUtils.isEmpty((Map)areaRowColMembers)) continue;
                defaultRowColDimensionEntry22 = areaRowColMembers.entrySet().iterator();
                while (defaultRowColDimensionEntry22.hasNext()) {
                    Map.Entry entry = defaultRowColDimensionEntry22.next();
                    HashSet areaMembers = new HashSet(16);
                    for (Member member : (Collection)entry.getValue()) {
                        if (RangeF7PropertyCataEnum.Property.getIndex().equals(member.getType())) {
                            Set refMembers = memberPropCache.getRefMembersByLongNumber((String)entry.getKey(), member.getLongNumber());
                            if (!CollectionUtils.isNotEmpty((Collection)refMembers)) continue;
                            areaMembers.addAll(refMembers);
                            continue;
                        }
                        String realDimByVar = ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)member.getNumber(), (String)((String)entry.getKey()), varValues);
                        if (RangeEnum.ONLY.getIndex() != member.getRange()) {
                            dimensionViewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (Long)datasetID, (String)((String)entry.getKey()), (String)areaIndex);
                            List cacheMems = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, realDimByVar, member.getRange());
                            if (cacheMems == null) continue;
                            areaMembers.addAll(cacheMems.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                            continue;
                        }
                        areaMembers.add(realDimByVar);
                    }
                    areaMemberMap.put(entry.getKey(), areaMembers);
                }
                if (multiAreaSetting.getFloatOnWhere() == 0) {
                    if (MapUtils.isEmpty(floatMemberMap)) continue;
                    boolean hasEmpty = false;
                    for (Map.Entry entry : areaMemberMap.entrySet()) {
                        Set<String> _members = floatMemberMap.get(entry.getKey());
                        Set memNumbers = (Set)entry.getValue();
                        if (_members == null) continue;
                        HashSet<String> temp = new HashSet<String>(_members.size());
                        temp.addAll(_members);
                        if (SysDimensionEnum.Entity.getNumber().equals(entry.getKey())) {
                            dimensionViewId = DimensionViewServiceHelper.getViewId((Map)templateModel.getDimemsionViews(), (Long)datasetID, (String)((String)entry.getKey()), (String)areaIndex);
                            kd.epm.eb.common.cache.impl.Member submitMember = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, currentSubmitEntityId);
                            if (submitMember != null) {
                                Set members = modelCacheHelper.getMember((String)entry.getKey(), dimensionViewId, submitMember.getNumber(), RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                                temp.retainAll(members);
                            }
                            temp.addAll(entityList);
                        }
                        memNumbers.retainAll(temp);
                        if (!memNumbers.isEmpty()) continue;
                        hasEmpty = true;
                        break;
                    }
                    if (hasEmpty) continue;
                }
                for (Dimension dimension : dimensionList) {
                    String dimNumber = dimension.getNumber();
                    if (areaMemberMap.containsKey(dimNumber)) continue;
                    if (pageDims.containsKey(dimNumber)) {
                        areaMemberMap.put(dimNumber, new HashSet<String>(pageDims.get(dimNumber)));
                        continue;
                    }
                    Collection collection = (Collection)allDimMems.get(dimNumber);
                    if (CollectionUtils.isEmpty((Collection)collection)) {
                        areaMemberMap.put(dimNumber, Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()}));
                        continue;
                    }
                    areaMemberMap.put(dimNumber, new HashSet(collection));
                }
                mapList.add(new CheckRange(i++, spreadManager.getDimemsionViews(), (Map)areaMemberMap, reportRelationMap == null ? null : (List)reportRelationMap.get(multiAreaSetting.getAreaRange())));
            }
        } else {
            HashMap areaMemberMap = Maps.newHashMapWithExpectedSize((int)allDimMems.size());
            for (Dimension dimension : dimensionList) {
                String dimNumber = dimension.getNumber();
                if (pageDims.containsKey(dimNumber)) {
                    areaMemberMap.put(dimNumber, new HashSet<String>(pageDims.get(dimNumber)));
                    continue;
                }
                Collection strings = (Collection)allDimMems.get(dimNumber);
                if (CollectionUtils.isEmpty((Collection)strings)) {
                    areaMemberMap.put(dimNumber, Sets.newHashSet((Object[])new String[]{dimension.getNoneNumber()}));
                    continue;
                }
                areaMemberMap.put(dimNumber, new HashSet(strings));
            }
            CheckRange dynamic = new CheckRange(i, spreadManager.getDimemsionViews(), (Map)areaMemberMap);
            dynamic.setRelationList(reportRelationMap == null ? null : (List)reportRelationMap.get("dynamic"));
            mapList.add(dynamic);
        }
        if (CollectionUtils.isEmpty(mapList)) {
            return result;
        }
        ReportCheckRange reportCheckRange = new ReportCheckRange();
        reportCheckRange.setDatasetId(templateModel.getTemplateBaseInfo().getDatasetID());
        reportCheckRange.setTemplateId(templateModel.getTemplateBaseInfo().getId());
        reportCheckRange.setReportProcessId(reportProcessId);
        reportCheckRange.setCartesian(Boolean.TRUE);
        reportCheckRange.setCheckRangeList(mapList);
        reportCheckRange.setBizModelId(templateModel.getTemplateBaseInfo().getBizModel());
        reportCheckRange.setCurrPeriodId(reportPeriodId);
        reportCheckRange.setDimRelList(templateModel.getTemplateBaseInfo().getDimRelations());
        reportCheckRange.setDimRelMap(DimensionRelationUtils.getRelationMap((Long)modelCacheHelper.getModelobj().getId(), (Long)reportCheckRange.getBizModelId(), (List)reportCheckRange.getDimRelList()));
        result.add(reportCheckRange);
        return result;
    }

    public static Map<String, Collection<String>> getPageMems(Long orgViewId, Long orgId, Long yearPeriodId, Long dataTypeId, Long versionId, IModelCacheHelper modelCache, Map<String, Collection<String>> allDimMems, ITemplateModel templateModel, Boolean includeNotLeaf) {
        HashMap<String, Collection<String>> pageMembers = new HashMap<String, Collection<String>>(16);
        List pageMems = templateModel.getPagemembentry();
        if (pageMems == null || pageMems.size() == 0) {
            return pageMembers;
        }
        Set members = null;
        for (IPageDimensionEntry pageMem : pageMems) {
            String dimKey = pageMem.getDimension().getNumber();
            if (replaceDimSets.contains(dimKey)) {
                switch (dimKey) {
                    case "Entity": {
                        List member1;
                        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimKey, orgViewId, orgId);
                        if (member != null) {
                            if (!includeNotLeaf.booleanValue()) {
                                member1 = modelCache.getMember(dimKey, orgViewId, member.getNumber(), RangeEnum.ONLY.getIndex());
                                members = member1.stream().filter(x -> x.isLeaf()).collect(Collectors.toList()).stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                            } else {
                                members = modelCache.getMember(dimKey, orgViewId, member.getNumber(), RangeEnum.ONLY.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                            }
                        }
                        pageMembers.put(dimKey, members);
                        break;
                    }
                    case "BudgetPeriod": {
                        List member1;
                        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimKey, null, yearPeriodId);
                        if (!includeNotLeaf.booleanValue()) {
                            member1 = modelCache.getMember(dimKey, null, member.getNumber(), RangeEnum.ALL.getIndex());
                            members = member1.stream().filter(x -> x.isLeaf()).collect(Collectors.toList()).stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                        } else {
                            members = modelCache.getMember(dimKey, null, member.getNumber(), RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                        }
                        pageMembers.put(dimKey, members);
                        break;
                    }
                    case "DataType": {
                        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimKey, null, dataTypeId);
                        if (!includeNotLeaf.booleanValue()) {
                            if (member.isLeaf()) {
                                pageMembers.put(dimKey, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
                                break;
                            }
                            pageMembers.put(dimKey, new HashSet(16));
                            break;
                        }
                        pageMembers.put(dimKey, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
                        break;
                    }
                    case "Version": {
                        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(dimKey, null, versionId);
                        if (!includeNotLeaf.booleanValue()) {
                            if (member.isLeaf()) {
                                pageMembers.put(dimKey, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
                                break;
                            }
                            pageMembers.put(dimKey, new HashSet(16));
                            break;
                        }
                        pageMembers.put(dimKey, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
                    }
                }
                continue;
            }
            pageMembers.put(dimKey, allDimMems.get(dimKey));
        }
        return pageMembers;
    }

    public static BgTemplate getTemplateBaseInfo(DynamicObject dyna) {
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("template.id")));
        templateBaseInfo.setName(dyna.getString("template.name"));
        templateBaseInfo.setNumber(dyna.getString("template.number"));
        templateBaseInfo.setDataunit(dyna.getString("template.dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("template.model.id")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("template.templateCatalog.id")));
        templateBaseInfo.setBizModel(Long.valueOf(dyna.getLong("template.dataset.businessmodel.id")));
        templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("template.dataset.id")));
        templateBaseInfo.setVarBase(dyna.getString("template.varbaseforeb"));
        templateBaseInfo.setIsReadOnly(dyna.getBoolean("template.isreadonly") ? "1" : "0");
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("template.isrelation") ? "1" : "0");
        templateBaseInfo.setFloatcalculate(dyna.getBoolean("template.floatcalculate") ? "1" : "0");
        String selectFields = "id,model,dataset.businessmodel,isrelation,dimrelationinfo2";
        DynamicObject tem = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)templateBaseInfo.getId())).toArray());
        if (tem != null) {
            DynamicObjectCollection dimrelationinfos = tem.getDynamicObjectCollection("dimrelationinfo2");
            List dimRelations = dimrelationinfos.stream().map(e -> e.getLong("fbasedataid_id")).collect(Collectors.toList());
            templateBaseInfo.setDimRelations(dimRelations);
        }
        return templateBaseInfo;
    }
}

