/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.domain.ExamineBo;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.examinev2.vo.ReportShowExamineMemberBo;
import kd.epm.eb.business.examinev2.vo.ReportShowExamineRow;
import kd.epm.eb.business.examinev2.vo.ReportShowExamineVo;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ExamineBehaviorEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.bo.ExamineItem;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportDetail;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportV1;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultForExamine;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultItem;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultRowNew;
import kd.epm.eb.common.examine.domain.report.ExamineReportUnique;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineRowCheckResultEnum;
import kd.epm.eb.common.examine.util.ExamineReportUtils;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.base.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ExamineCheckReportServiceImpl {
    public static final Log log = LogFactory.getLog(ExamineCheckReportServiceImpl.class);
    private static final ExamineCheckReportServiceImpl INSTANCE = new ExamineCheckReportServiceImpl();
    private static String selectFields = "id,number,model,dataset,template,reportprocess,checkresult,executetype,checkrange,createdate,creater,examine_annotation,checkreportforexamine,checkreportforexamine.examine,checkreportforexamine.checkresutdetail,checkreportforexamine.otherinfo";

    private ExamineCheckReportServiceImpl() {
    }

    public static ExamineCheckReportServiceImpl getInstance() {
        return INSTANCE;
    }

    public void saveCheckReport(ExamineCheckReport examineCheckReport, Map<String, List<DynamicObject>> annotationInfoMapV1) {
        try {
            this.saveCheckReportNew(Lists.newArrayList((Object[])new ExamineCheckReport[]{examineCheckReport}), annotationInfoMapV1);
        }
        catch (Exception e) {
            log.error("saveCheckReportNew is error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u68c0\u67e5\u62a5\u544a\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ExamineCheckReportServiceImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public void saveCheckReportNew(List<ExamineCheckReport> examineCheckReportList, Map<String, List<DynamicObject>> annotationInfoMapV1) {
        Map<Object, Object> applyBillMap = new HashMap(16);
        Map<Object, Object> reportProcessMap = new HashMap(16);
        if (CollectionUtils.isEmpty(examineCheckReportList)) {
            return;
        }
        List reportProcessIds = examineCheckReportList.stream().map(ExamineCheckReport::getReportProcessId).collect(Collectors.toList());
        List<ExamineReportUnique> examineReportUniques = examineCheckReportList.stream().map(x -> {
            ExamineReportUnique examineReportUnique = new ExamineReportUnique();
            examineReportUnique.setReportProcessId(x.getReportProcessId());
            examineReportUnique.setApproveBillId(x.getApproveBillId());
            return examineReportUnique;
        }).collect(Collectors.toList());
        if (ProcessTypeEnum.APPLY.getNumber().equals(examineCheckReportList.get(0).getProcessTypeEnum().getNumber())) {
            DynamicObjectCollection applyBills = ReportProcessServiceImpl.getInstance().getApplyBill(reportProcessIds);
            applyBillMap = applyBills.stream().collect(Collectors.toMap(x -> x.getLong("id"), v -> v));
        } else {
            QFBuilder qfBuilder = QFBuilder.newQFilter();
            qfBuilder.add("reportprocess", "in", reportProcessIds);
            List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcess(reportProcessIds);
            reportProcessMap = reportProcessList.stream().collect(Collectors.toMap(ReportProcess::getId, v -> v));
        }
        ArrayList savez = Lists.newArrayListWithExpectedSize((int)16);
        for (ExamineCheckReport examineCheckReport : examineCheckReportList) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)examineCheckReport.getModelId());
            List<String> dimList = modelCacheHelper.getDimensionList().stream().map(x -> x.getNumber()).collect(Collectors.toList());
            for (ExamineCheckResultForExamine examineCheckResultForExamine : examineCheckReport.getExamineCheckResultForExamineList()) {
                Map memberKeyUsedDimMap = examineCheckResultForExamine.getMemberKeyUsedDimMap();
                if (ExamineCheckResultEnum.Pass == examineCheckResultForExamine.getExamineCheckResultEnum()) continue;
                for (ExamineCheckResultItem examineCheckResultItem : examineCheckResultForExamine.getExamineCheckResultItemList()) {
                    Member budgetPeriod;
                    Member account;
                    if (ExamineRowCheckResultEnum.Pass == examineCheckResultItem.getMainRow().getCheckResult()) continue;
                    Map<String, String> rowDimMemberInfo = this.getRowDimMemberInfo(examineCheckResultForExamine.getSameMembers(), examineCheckResultForExamine.getDiffDimensions(), examineCheckResultItem.getItrMemberList(), (Set)memberKeyUsedDimMap.get(examineCheckResultItem.getMainRow().getMemberKey()), dimList);
                    DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)"eb_examine_result_report");
                    String memberNumer = rowDimMemberInfo.get(SysDimensionEnum.Account.getNumber());
                    if (StringUtils.isNotEmpty((CharSequence)memberNumer) && !SysDimensionEnum.Account.getNumber().equals(examineCheckResultForExamine.getExamineDto().getMainDimension()) && (account = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, memberNumer)) != null) {
                        doj.set("account", (Object)account.getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(memberNumer = rowDimMemberInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()))) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(examineCheckResultForExamine.getExamineDto().getMainDimension()) && (budgetPeriod = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, memberNumer)) != null) {
                        doj.set("detailperiod", (Object)budgetPeriod.getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(memberNumer = rowDimMemberInfo.get(SysDimensionEnum.Entity.getNumber()))) && !SysDimensionEnum.Entity.getNumber().equals(examineCheckResultForExamine.getExamineDto().getMainDimension())) {
                        Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(examineCheckReport.getDatasetId(), SysDimensionEnum.Entity.getNumber());
                        Member entity = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, memberNumer);
                        if (entity != null) {
                            doj.set("detailentity", (Object)entity.getId());
                        }
                    }
                    doj.set("model", (Object)examineCheckReport.getModelId());
                    if (ProcessTypeEnum.APPLY.getNumber().equals(examineCheckReport.getProcessTypeEnum().getNumber())) {
                        DynamicObject dynamicObject = (DynamicObject)applyBillMap.get(examineCheckReport.getReportProcessId());
                        if (dynamicObject != null) {
                            doj.set("entity", (Object)dynamicObject.getString("org"));
                            doj.set("version", (Object)dynamicObject.getLong("version"));
                            doj.set("datatype", (Object)dynamicObject.getLong("datatype"));
                            doj.set("period", (Object)dynamicObject.getLong("year"));
                        }
                        doj.set("applybill", (Object)examineCheckReport.getReportProcessId());
                    } else {
                        ReportProcess reportProcess = (ReportProcess)reportProcessMap.get(examineCheckReport.getReportProcessId());
                        if (reportProcess != null) {
                            doj.set("entity", (Object)reportProcess.getEntityId());
                            doj.set("version", (Object)reportProcess.getVersionId());
                            doj.set("datatype", (Object)reportProcess.getDataTypeId());
                            doj.set("period", (Object)reportProcess.getPeriodId());
                        }
                        doj.set("reportprocess", (Object)examineCheckReport.getReportProcessId());
                    }
                    doj.set("template", (Object)examineCheckReport.getTemplateId());
                    doj.set("executetype", (Object)examineCheckReport.getTargetEvent().getNumber());
                    String jsonString = JsonUtils.getJsonString(rowDimMemberInfo);
                    doj.set("dimrange", (Object)jsonString);
                    doj.set("examinetime", (Object)new Date());
                    doj.set("creater", (Object)examineCheckReport.getExecutorId());
                    doj.set("examine", (Object)examineCheckResultForExamine.getExamineId());
                    List<DynamicObject> dynamicObjectList = annotationInfoMapV1.get(examineCheckReport.getReportProcessId() + "_" + examineCheckResultForExamine.getExamineId());
                    if (CollectionUtils.isNotEmpty(dynamicObjectList)) {
                        Map<String, Long> dimrangeSetMap = dynamicObjectList.stream().collect(Collectors.toMap(x -> StringUtils.isNotBlank((CharSequence)x.getString("dimrange")) ? x.getString("dimrange") : "blank", x -> x.getLong("id"), (v1, v2) -> v1));
                        Long tarId = dimrangeSetMap.get(jsonString);
                        if (tarId != null) {
                            doj.set("annotation", (Object)tarId);
                        } else if (dimrangeSetMap.get("blank") != null) {
                            doj.set("annotation", (Object)dimrangeSetMap.get("blank"));
                        }
                    }
                    if (examineCheckReport.getApproveBillId() != null) {
                        doj.set("approvebillid", (Object)examineCheckReport.getApproveBillId());
                    }
                    doj.set("dataset", (Object)examineCheckReport.getDatasetId());
                    doj.set("processtype", (Object)examineCheckReport.getProcessTypeEnum().getIndex());
                    if (ExamineRowCheckResultEnum.Annotation == examineCheckResultItem.getMainRow().getCheckResult()) {
                        doj.set("status", (Object)ExamineCheckResultEnum.Annotation.getIndex());
                    } else {
                        doj.set("status", (Object)examineCheckResultForExamine.getExamineCheckResultEnum().getIndex());
                    }
                    doj.set("leftvalue", (Object)examineCheckResultItem.getMainRow().getLeftValue());
                    doj.set("rightvalue", (Object)examineCheckResultItem.getMainRow().getRightValue());
                    doj.set("dataset", (Object)examineCheckReport.getDatasetId());
                    doj.set("difference", (Object)examineCheckResultItem.getMainRow().getDifference());
                    doj.set("showpanel", (Object)examineCheckResultItem.getShowPanel());
                    doj.set("symbol", (Object)examineCheckResultItem.getMainRow().getSymbol());
                    DynamicObjectCollection examineCheckDojs = doj.getDynamicObjectCollection("treeentryentity");
                    this.addChild(examineCheckDojs, examineCheckResultItem.getNewChildRows(), 0L, rowDimMemberInfo);
                    savez.add(doj);
                }
            }
        }
        try (TXHandle tx = TX.requiresNew((String)"ExamineCheckReportServiceImpl.saveResult");){
            try {
                this.deleteCheckReport(examineReportUniques, examineCheckReportList.get(0).getProcessTypeEnum().getNumber());
                if (!savez.isEmpty()) {
                    savez.stream().map(x -> x.getString("id")).collect(Collectors.toList());
                    SaveServiceHelper.save((DynamicObject[])savez.toArray(new DynamicObject[0]));
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    @NotNull
    public Map<String, String> getRowDimMemberInfo(Map<String, String> sameMembers, List<String> diffDimensions, List<String> itrMemberList, Set<String> memberKeyUsedDim, List<String> dimensionList) {
        HashMap<String, String> dimMemberInfo = new HashMap<String, String>(16);
        for (String dimNumber : dimensionList) {
            String memberNumber = sameMembers.get(dimNumber);
            if (StringUtils.isNotEmpty((CharSequence)memberNumber)) {
                dimMemberInfo.put(dimNumber, memberNumber);
                continue;
            }
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(diffDimensions)) continue;
            for (int j = 0; j < diffDimensions.size(); ++j) {
                if (!dimNumber.equals(diffDimensions.get(j)) || itrMemberList == null || itrMemberList.size() <= j) continue;
                dimMemberInfo.put(diffDimensions.get(j), itrMemberList.get(j));
            }
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(memberKeyUsedDim)) {
            dimMemberInfo.keySet().removeIf(e -> !memberKeyUsedDim.contains(e));
        }
        return dimMemberInfo;
    }

    private void addChild(DynamicObjectCollection examineCheckDojs, List<ExamineCheckResultRowNew> examineCheckResultRowNews, Long parentEntryID, Map<String, String> rowDimMemberInfo) {
        if (CollectionUtils.isEmpty(examineCheckResultRowNews)) {
            return;
        }
        for (ExamineCheckResultRowNew examineCheckResultRowNew : examineCheckResultRowNews) {
            DynamicObject childDoj = examineCheckDojs.addNew();
            long id = DBServiceHelper.genGlobalLongId();
            childDoj.set("id", (Object)id);
            childDoj.set("name", (Object)examineCheckResultRowNew.getName());
            childDoj.set("examinetype", (Object)examineCheckResultRowNew.getExaminetype());
            childDoj.set("value", (Object)examineCheckResultRowNew.getValue());
            HashMap<String, String> dimMemberInfo = new HashMap<String, String>(16);
            if (examineCheckResultRowNew.getDiffMembers() != null) {
                dimMemberInfo.putAll(rowDimMemberInfo);
                dimMemberInfo.putAll(examineCheckResultRowNew.getDiffMembers());
            }
            childDoj.set("memberkey", (Object)examineCheckResultRowNew.getMemberKey());
            childDoj.set("dimjson", (Object)JsonUtils.getJsonString(dimMemberInfo));
            childDoj.set("pid", (Object)parentEntryID);
            if (!CollectionUtils.isNotEmpty((Collection)examineCheckResultRowNew.getChildRows())) continue;
            this.addChild(examineCheckDojs, examineCheckResultRowNew.getChildRows(), id, rowDimMemberInfo);
        }
    }

    public List<ReportShowExamineVo> queryCellRefExamine(Long modelId, Long datasetId, Long reportProcessId, Map<String, String> cell, Map<String, Map<String, String>> varValues) {
        List<ExamineCheckReportV1> examineCheckReportV1List = this.queryCheckReportByReportProcessV1(reportProcessId);
        if (examineCheckReportV1List == null) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        LinkedList returnLists = Lists.newLinkedList();
        block0: for (ExamineCheckReportV1 examineCheckReportV1 : examineCheckReportV1List) {
            ExamineDto examineDto = ExamineServiceImpl.getInstance().getExamineFromCache(modelId, examineCheckReportV1.getExamineId());
            if (examineDto == null) {
                return null;
            }
            ExamineBo examineBo = new ExamineBo(examineDto, modelCacheHelper.getBusModelByDataSet(datasetId), varValues);
            List<ExamineItem> examineItemList = examineBo.getExamineItemList();
            for (ExamineItem examineItem : examineItemList) {
                boolean relate = ExamineReportUtils.checkRelate(cell, (ExamineItem)examineItem, examineBo.getScopes());
                if (!relate) continue;
                ReportShowExamineVo reportShowExamineVo = new ReportShowExamineVo(examineDto, examineCheckReportV1.getExamineCheckResultEnum());
                List examineCheckReportDetailList = examineCheckReportV1.getExamineCheckReportDetailList();
                ReportShowExamineRow reportShowExamineRow = new ReportShowExamineRow();
                examineCheckReportDetailList.forEach(examineCheckReportDetail -> {
                    if (StringUtils.isNotEmpty((CharSequence)examineCheckReportDetail.getMemberKey())) {
                        ReportShowExamineMemberBo reportShowExamineMemberBo = new ReportShowExamineMemberBo(examineCheckReportDetail.getName(), examineCheckReportDetail.getName(), examineCheckReportDetail.getMemberKey(), examineItem.getDatasetId());
                        reportShowExamineMemberBo.setValue(examineCheckReportDetail.getValue());
                        reportShowExamineMemberBo.setDimToMemMap(examineCheckReportDetail.getDimRange());
                        reportShowExamineRow.addReportShowExamineMemberBo(reportShowExamineMemberBo);
                    }
                });
                for (ExamineCheckReportDetail examineCheckReportDetail2 : examineCheckReportDetailList) {
                    Map dimRange = examineCheckReportDetail2.getDimRange();
                    reportShowExamineVo.setReportShowExamineRow(reportShowExamineRow);
                    if (!this.checkRange(dimRange, cell)) continue;
                    PanelEnvironment environment = new PanelEnvironment();
                    environment.setRuleKey(examineBo.getExamineDto().getNumber());
                    environment.setExamineMemberBoMap(reportShowExamineRow.getExamineMemberBoMap());
                    IExpress expr = examineBo.getExpr();
                    List<ExprPanel> exprPanelList = expr.toPanel(environment);
                    reportShowExamineRow.setExprPanelList(exprPanelList);
                    returnLists.add(reportShowExamineVo);
                    continue block0;
                }
                continue block0;
            }
        }
        return returnLists;
    }

    private boolean checkRange(Map<String, String> dimRange, Map<String, String> cell) {
        if (dimRange != null) {
            for (Map.Entry<String, String> entry : cell.entrySet()) {
                String memNumber;
                String dimNumber = entry.getKey();
                String cellMemNumber = entry.getValue();
                if (cellMemNumber.equals(memNumber = dimRange.get(dimNumber))) continue;
                return false;
            }
        }
        return true;
    }

    public List<ExamineCheckReportV1> queryCheckReportByReportProcessV1(Long reportProcessId) {
        return this.queryCheckReportByReportProcessListV1(Collections.singletonList(reportProcessId));
    }

    public List<ExamineCheckReportV1> queryCheckReportByReportProcessListV1(Collection<Long> reportProcessIds) {
        QFBuilder qfBuilder = QFBuilder.newQFilter();
        qfBuilder.add("reportprocess", "in", reportProcessIds);
        DynamicObjectCollection doj = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])qfBuilder.toArray());
        if (doj == null || doj.size() == 0) {
            return Collections.emptyList();
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])doj.stream().map(x -> x.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_examine_result_report"));
        ArrayList<ExamineCheckReportV1> examineCheckReports = new ArrayList<ExamineCheckReportV1>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            examineCheckReports.add(ExamineCheckReportV1.of((DynamicObject)object));
        }
        return examineCheckReports;
    }

    public List<ExamineCheckReportV1> queryCheckReportByListV1(Collection<Long> ids) {
        QFBuilder qfBuilder = QFBuilder.newQFilter();
        qfBuilder.add("id", "in", ids);
        DynamicObjectCollection doj = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])qfBuilder.toArray());
        if (doj == null || doj.size() == 0) {
            return Collections.emptyList();
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])doj.stream().map(x -> x.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_examine_result_report"));
        ArrayList<ExamineCheckReportV1> examineCheckReports = new ArrayList<ExamineCheckReportV1>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            examineCheckReports.add(ExamineCheckReportV1.of((DynamicObject)object));
        }
        return examineCheckReports;
    }

    public List<ExamineCheckReportV1> queryCheckReportByReportProcessListNew(Collection<Long> applybillIds) {
        QFBuilder qfBuilder = QFBuilder.newQFilter();
        qfBuilder.add("applybill", "in", applybillIds);
        DynamicObjectCollection doj = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id", (QFilter[])qfBuilder.toArray());
        if (doj == null || doj.size() == 0) {
            return Collections.emptyList();
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])doj.stream().map(x -> x.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_examine_result_report"));
        ArrayList<ExamineCheckReportV1> examineCheckReports = new ArrayList<ExamineCheckReportV1>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            examineCheckReports.add(ExamineCheckReportV1.of((DynamicObject)object));
        }
        return examineCheckReports;
    }

    public void deleteCheckReport(List<ExamineReportUnique> examineReportUniques, String number) {
        List reportProcessIds = examineReportUniques.stream().filter(x -> x.getApproveBillId() == null).map(x -> x.getReportProcessId()).collect(Collectors.toList());
        List hasApproveBill = examineReportUniques.stream().filter(x -> x.getApproveBillId() != null).collect(Collectors.toList());
        QFBuilder qfBuilder = QFBuilder.newQFilter();
        if (ProcessTypeEnum.APPLY.getNumber().equals(number)) {
            qfBuilder.add("applybill", "in", reportProcessIds);
        } else {
            QFilter qFilter = null;
            for (ExamineReportUnique examineReportUnique : hasApproveBill) {
                if (qFilter == null) {
                    qFilter = new QFilter("reportprocess", "=", (Object)examineReportUnique.getReportProcessId()).and("approveBillId", "=", (Object)examineReportUnique.getApproveBillId());
                    continue;
                }
                qFilter.or(new QFilter("reportprocess", "=", (Object)examineReportUnique.getReportProcessId()).and("approveBillId", "=", (Object)examineReportUnique.getApproveBillId()));
            }
            if (!CollectionUtils.isEmpty(reportProcessIds)) {
                qfBuilder.add("reportprocess", "in", reportProcessIds);
                if (qFilter != null) {
                    qfBuilder.or(qFilter);
                }
            } else if (qFilter != null) {
                qfBuilder.add(qFilter);
            }
        }
        DeleteServiceHelper.delete((String)"eb_examine_result_report", (QFilter[])qfBuilder.toArray());
    }

    public ExamineCheckReport queryCheckReport(Long checkReportId) {
        List<ExamineCheckReport> examineCheckReports = this.queryCheckReport(Collections.singletonList(checkReportId));
        if (CollectionUtils.isNotEmpty(examineCheckReports)) {
            return examineCheckReports.get(0);
        }
        return null;
    }

    public List<ExamineCheckReport> queryCheckReport(List<Long> checkReportIds) {
        DynamicObject[] doj = BusinessDataServiceHelper.load((String)"eb_examine_report", (String)selectFields, (QFilter[])new QFilter("id", "in", checkReportIds).toArray());
        if (doj == null || doj.length == 0) {
            return null;
        }
        ArrayList<ExamineCheckReport> examineCheckReports = new ArrayList<ExamineCheckReport>(doj.length);
        for (DynamicObject object : doj) {
            examineCheckReports.add(ExamineCheckReport.of((DynamicObject)object));
        }
        return examineCheckReports;
    }

    public List<ExamineCheckReport> queryCheckReportByModelId(Long modelId) {
        QFBuilder qfBuilder = QFBuilder.newQFilter();
        qfBuilder.add("model", "=", (Object)modelId);
        DynamicObjectCollection dojs = QueryServiceHelper.query((String)"eb_examine_report", (String)selectFields, (QFilter[])qfBuilder.toArray());
        if (dojs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList returnz = Lists.newArrayListWithExpectedSize((int)dojs.size());
        for (DynamicObject doj : dojs) {
            returnz.add(ExamineCheckReport.of((DynamicObject)doj));
        }
        return returnz;
    }

    public DynamicObject getAnnotationInfo(Long modelId, Long reportProcessId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("reportprocess", "=", (Object)reportProcessId);
        return QueryServiceHelper.queryOne((String)"eb_examine_annotatio_v1", (String)"id,modifier.name,modifier.id,modifydate,remark,reportprocess", (QFilter[])qFilter.toArray());
    }

    public DynamicObject getAnnotationInfoV1(Long modelId, Long reportProcessId, Long examineId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("reportprocess", "=", (Object)reportProcessId);
        qFilter.and("examine", "=", (Object)examineId);
        return QueryServiceHelper.queryOne((String)"eb_examine_annotatio_v1", (String)"id,modifier.name,modifier.id,modifydate,remark,reportprocess", (QFilter[])qFilter.toArray());
    }

    public Map<Long, Long> getAnnotationInfos(Long modelId, Set<Long> reportProcessIds) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("reportprocess", "in", reportProcessIds);
        DynamicObjectCollection dojs = QueryServiceHelper.query((String)"eb_examine_annotatio_v1", (String)"id,reportprocess", (QFilter[])qFilter.toArray());
        HashMap maps = Maps.newHashMapWithExpectedSize((int)dojs.size());
        for (DynamicObject doj : dojs) {
            long reportProcessId = doj.getLong("reportprocess");
            long annotationId = doj.getLong("id");
            maps.put(reportProcessId, annotationId);
        }
        return maps;
    }

    public Map<String, List<DynamicObject>> getAnnotationInfoMapV1(Long modelId, Set<Long> reportProcessIds, ProcessTypeEnum processTypeEnum) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (ProcessTypeEnum.APPLY.getIndex() == processTypeEnum.getIndex()) {
            qFilter.and("billid", "in", reportProcessIds);
        } else {
            qFilter.and("reportprocess", "in", reportProcessIds);
        }
        DynamicObjectCollection dojs = QueryServiceHelper.query((String)"eb_examine_annotatio_v1", (String)"id,reportprocess,examine,billid,dimrange", (QFilter[])qFilter.toArray());
        HashMap maps = Maps.newHashMapWithExpectedSize((int)dojs.size());
        for (DynamicObject doj : dojs) {
            List<Object> dynamicObjectList;
            if (ProcessTypeEnum.APPLY.getIndex() == processTypeEnum.getIndex()) {
                dynamicObjectList = (ArrayList<DynamicObject>)maps.get(doj.getLong("billid") + "_" + doj.getLong("examine"));
                if (dynamicObjectList == null) {
                    dynamicObjectList = new ArrayList<DynamicObject>(16);
                    dynamicObjectList.add(doj);
                    maps.put(doj.getLong("billid") + "_" + doj.getLong("examine"), dynamicObjectList);
                    continue;
                }
                dynamicObjectList.add(doj);
                continue;
            }
            dynamicObjectList = (List)maps.get(doj.getLong("reportprocess") + "_" + doj.getLong("examine"));
            if (dynamicObjectList == null) {
                dynamicObjectList = new ArrayList(16);
                dynamicObjectList.add(doj);
                maps.put(doj.getLong("reportprocess") + "_" + doj.getLong("examine"), dynamicObjectList);
                continue;
            }
            dynamicObjectList.add(doj);
        }
        return maps;
    }

    public int delAnnotationInfoV1(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return DeleteServiceHelper.delete((String)"eb_examine_annotatio_v1", (QFilter[])qFilter.toArray());
    }

    public Map<String, ExamineBehaviorEnum> getExamineBehavior(List<String> examineNumbers) {
        if (CollectionUtils.isEmpty(examineNumbers)) {
            return new HashMap<String, ExamineBehaviorEnum>(0);
        }
        HashMap<String, ExamineBehaviorEnum> examineBehavior = new HashMap<String, ExamineBehaviorEnum>(16);
        DynamicObjectCollection examines = QueryServiceHelper.query((String)"eb_examine", (String)"number,checkinfluence", (QFilter[])new QFilter("number", "in", examineNumbers).toArray());
        if (CollectionUtils.isNotEmpty((Collection)examines)) {
            for (DynamicObject examine : examines) {
                ExamineBehaviorEnum checkinfluence = ExamineBehaviorEnum.getEnumsByValue((String)examine.getString("checkinfluence"));
                if (checkinfluence == null) continue;
                examineBehavior.put(examine.getString("number"), checkinfluence);
            }
        }
        return examineBehavior;
    }

    public DynamicObjectCollection getProcessMapNew(Long modelId, List<Long> selectIds) {
        QFilter qFilter = new QFilter("id", "in", selectIds);
        qFilter.and("model", "=", (Object)modelId);
        DynamicObjectCollection dojs = QueryServiceHelper.query((String)"eb_examine_result_report", (String)"id,examine.number,reportprocess,status", (QFilter[])qFilter.toArray());
        return dojs;
    }
}

