/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.service;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.examinev2.cache.ExamineCache;
import kd.epm.eb.business.examinev2.domain.ExamineBo;
import kd.epm.eb.business.examinev2.service.ExamineCheckRangeUtils;
import kd.epm.eb.business.examinev2.service.ExamineCheckReportServiceImpl;
import kd.epm.eb.business.examinev2.service.ExamineCheckService;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultForExamine;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultItem;
import kd.epm.eb.common.examine.domain.report.ExamineReportUnique;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineRowCheckResultEnum;
import kd.epm.eb.common.examine.request.ExamineCheckAllChildRequest;
import kd.epm.eb.common.examine.request.MultiExamineCheckRequest;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRangeRequest;
import kd.epm.eb.common.examine.request.SchemeOrTaskReqeust;
import kd.epm.eb.common.examine.request.SingleExamineCheckRequest;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.params.ParamServiceHelper;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExamineCheckServiceImpl
implements ExamineCheckService {
    public static final Log log = LogFactory.getLog(ExamineCheckServiceImpl.class);
    private static final ExamineCheckService INSTANCE = new ExamineCheckServiceImpl();
    public static final String logTag = "budget-examine-check:";
    private static final String LOG_PREFIX = "EB_INTER_EXAMINE";

    private ExamineCheckServiceImpl() {
    }

    public static ExamineCheckService getInstance() {
        return INSTANCE;
    }

    @Override
    public ExamineCheckReport singleCheck(SingleExamineCheckRequest request) {
        log.info(logTag, (Object)request.toString());
        this.checkRequestAndSetDefaultValue(request);
        Stats stats = new Stats("singleCheck");
        stats.appendMessage("reportProcessId is" + request.getReportCheckRange().getReportProcessId());
        Stats.StatItem queryBindExamine = stats.createLinearStatItem("queryBindExamine");
        ExamineCache examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(request.getModelId()).getExamineCache();
        Set<ExamineDto> examineDtos = ProcessTypeEnum.APPLY.getNumber().equals(request.getProcessTypeEnum().getNumber()) ? examineCache.getExamineByApplyTempId(request.getReportCheckRange().getTemplateId()) : examineCache.getExamineByTempId(request.getReportCheckRange().getTemplateId());
        if (examineDtos.isEmpty()) {
            queryBindExamine.append((Object)"this template no bind examine,don't need check");
            ExamineReportUnique examineReportUnique = new ExamineReportUnique();
            examineReportUnique.setReportProcessId(request.getReportCheckRange().getReportProcessId());
            ExamineCheckReportServiceImpl.getInstance().deleteCheckReport(Lists.newArrayList((Object[])new ExamineReportUnique[]{examineReportUnique}), request.getProcessTypeEnum().getNumber());
            log.info(stats.toString(logTag));
            return null;
        }
        queryBindExamine.append(examineDtos.stream().map(ExamineDto::getNumber).collect(Collectors.toList()));
        Long busModelId = ModelCacheContext.getOrCreate((Long)request.getModelId()).getBusModelByDataSet(request.getReportCheckRange().getDatasetId());
        List examineBos = examineDtos.stream().map(v -> new ExamineBo((ExamineDto)v, busModelId, request.getVarValues())).collect(Collectors.toList());
        stats.createLinearStatItem("doExamine");
        String appId = "eb";
        String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
        ExamineCheckReport examineCheckReport = (ExamineCheckReport)DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"ExamineMSService", (String)"check", (Object[])new Object[]{request.getModelId(), request.getTriggerEvent().getNumber(), request.getProcessTypeEnum().getIndex(), request.getExecutorId(), request.getReportCheckRange(), examineBos, this.getExamineParamPageSize(request.getModelId())});
        stats.appendMessage("this report has annotation,don't need check.");
        Map<String, List<DynamicObject>> annotationInfoMapV1 = ExamineCheckReportServiceImpl.getInstance().getAnnotationInfoMapV1(examineCheckReport.getModelId(), Sets.newHashSet((Object[])new Long[]{examineCheckReport.getReportProcessId()}), examineCheckReport.getProcessTypeEnum());
        this.handleAnnotation(examineCheckReport, annotationInfoMapV1);
        log.info(stats.toString(logTag));
        stats.createLinearStatItem("saveReport");
        ExamineCheckReportServiceImpl.getInstance().saveCheckReport(examineCheckReport, annotationInfoMapV1);
        log.info(stats.toString(logTag));
        return examineCheckReport;
    }

    public int getExamineParamPageSize(Long modelId) {
        return ParamQueryServiceHelper.getInt((long)modelId, (ParamEnum)ParamEnum.BG045);
    }

    private void handleAnnotation(ExamineCheckReport examineCheckReport, Map<String, List<DynamicObject>> annotationInfoMapV1) {
        try {
            if (!(examineCheckReport.getExamineCheckResultEnum() != ExamineCheckResultEnum.NoPass && ExamineCheckResultEnum.NoPassCanAnnotation != examineCheckReport.getExamineCheckResultEnum() || annotationInfoMapV1.isEmpty())) {
                List examineCheckResultForExamineList = examineCheckReport.getExamineCheckResultForExamineList();
                if (examineCheckReport != null) {
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)examineCheckReport.getModelId());
                    List<String> dimList = modelCacheHelper.getDimensionList().stream().map(x -> x.getNumber()).collect(Collectors.toList());
                    examineCheckReport.setExamineCheckResultEnum(ExamineCheckResultEnum.NoExamine);
                    for (ExamineCheckResultForExamine examineCheckResultForExamine : examineCheckResultForExamineList) {
                        List<DynamicObject> dynamicObjectList = annotationInfoMapV1.get(examineCheckReport.getReportProcessId() + "_" + examineCheckResultForExamine.getExamineId());
                        if (CollectionUtils.isEmpty(dynamicObjectList) || examineCheckResultForExamine.getExamineCheckResultEnum() != ExamineCheckResultEnum.NoPassCanAnnotation) {
                            if (examineCheckReport.getExamineCheckResultEnum() == ExamineCheckResultEnum.Annotation) {
                                if (ExamineCheckResultEnum.NoPass != examineCheckResultForExamine.getExamineCheckResultEnum() && ExamineCheckResultEnum.NoPassIgnore != examineCheckResultForExamine.getExamineCheckResultEnum() && ExamineCheckResultEnum.NoPassCanAnnotation != examineCheckResultForExamine.getExamineCheckResultEnum()) continue;
                                examineCheckReport.setExamineCheckResultEnum(examineCheckResultForExamine.getExamineCheckResultEnum());
                                continue;
                            }
                            if (!ExamineCheckResultEnum.worse((ExamineCheckResultEnum)examineCheckReport.getExamineCheckResultEnum(), (ExamineCheckResultEnum)examineCheckResultForExamine.getExamineCheckResultEnum())) continue;
                            examineCheckReport.setExamineCheckResultEnum(examineCheckResultForExamine.getExamineCheckResultEnum());
                            continue;
                        }
                        Map memberKeyUsedDimMap = examineCheckResultForExamine.getMemberKeyUsedDimMap();
                        List examineCheckResultItemList = examineCheckResultForExamine.getExamineCheckResultItemList();
                        Set dimrangeSet = dynamicObjectList.stream().map(x -> StringUtils.isNotBlank((CharSequence)x.getString("dimrange")) ? x.getString("dimrange") : "blank").collect(Collectors.toSet());
                        for (ExamineCheckResultItem examineCheckResultItem : examineCheckResultItemList) {
                            Map<String, String> rowDimMemberInfo = ExamineCheckReportServiceImpl.getInstance().getRowDimMemberInfo(examineCheckResultForExamine.getSameMembers(), examineCheckResultForExamine.getDiffDimensions(), examineCheckResultItem.getItrMemberList(), (Set)memberKeyUsedDimMap.get(examineCheckResultItem.getMainRow().getMemberKey()), dimList);
                            String jsonString = JsonUtils.getJsonString(rowDimMemberInfo);
                            if (dimrangeSet.contains(jsonString)) {
                                examineCheckResultItem.getMainRow().setCheckResult(ExamineRowCheckResultEnum.Annotation);
                                continue;
                            }
                            if (!dimrangeSet.contains("blank")) continue;
                            examineCheckResultItem.getMainRow().setCheckResult(ExamineRowCheckResultEnum.Annotation);
                        }
                        if (examineCheckResultItemList.stream().noneMatch(x -> ExamineRowCheckResultEnum.NoPass == x.getMainRow().getCheckResult()) && examineCheckResultItemList.stream().anyMatch(x -> ExamineRowCheckResultEnum.Annotation == x.getMainRow().getCheckResult())) {
                            examineCheckResultForExamine.setExamineCheckResultEnum(ExamineCheckResultEnum.Annotation);
                            if (ExamineCheckResultEnum.NoPass == examineCheckReport.getExamineCheckResultEnum() || ExamineCheckResultEnum.NoPassCanAnnotation == examineCheckReport.getExamineCheckResultEnum() || ExamineCheckResultEnum.NoPassIgnore == examineCheckReport.getExamineCheckResultEnum()) continue;
                            examineCheckReport.setExamineCheckResultEnum(ExamineCheckResultEnum.Annotation);
                            continue;
                        }
                        if (!ExamineCheckResultEnum.worse((ExamineCheckResultEnum)examineCheckReport.getExamineCheckResultEnum(), (ExamineCheckResultEnum)examineCheckResultForExamine.getExamineCheckResultEnum())) continue;
                        examineCheckReport.setExamineCheckResultEnum(examineCheckResultForExamine.getExamineCheckResultEnum());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("handleAnnotation is error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5904\u7406\u6279\u6ce8\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExamineCheckServiceHelper_6", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    @Override
    public List<ExamineCheckReport> multiCheck(MultiExamineCheckRequest request) {
        log.info(logTag, (Object)request.toString());
        this.checkRequestAndSetDefaultValue(request);
        Stats stats = new Stats("multiCheck");
        List reportCheckRangeList = request.getReportCheckRangeList();
        Set reportProcessId = reportCheckRangeList.stream().map(ReportCheckRange::getReportProcessId).collect(Collectors.toSet());
        stats.appendMessage("reportProcessId is" + reportProcessId);
        stats.createLinearStatItem("queryExamine");
        Map<Long, List<ReportCheckRange>> tempReportPrecess = reportCheckRangeList.stream().collect(Collectors.groupingBy(ReportCheckRange::getTemplateId));
        Long modelId = request.getModelId();
        ExamineCache examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(modelId).getExamineCache();
        LinkedHashMap examineBoMap = Maps.newLinkedHashMap();
        ArrayList<ExamineCheckReport> examineCheckReportList = new ArrayList<ExamineCheckReport>(16);
        ArrayList<ExamineCheckReport> needSavez = new ArrayList<ExamineCheckReport>(16);
        boolean isMerticNotNullCheck = request.getTemplateMetricNullChcekExamineMap() != null;
        Map<String, List<DynamicObject>> annotationInfoMapV1 = ExamineCheckReportServiceImpl.getInstance().getAnnotationInfoMapV1(request.getModelId(), request.getReportCheckRangeList().stream().map(x -> x.getReportProcessId()).collect(Collectors.toSet()), request.getProcessTypeEnum());
        int examineParamPageSize = this.getExamineParamPageSize(request.getModelId());
        for (Map.Entry<Long, List<ReportCheckRange>> entry : tempReportPrecess.entrySet()) {
            Long tempId = entry.getKey();
            Stats.StatItem doExamine = stats.createLinearStatItem("doExamine,temp:" + tempId);
            Set<Object> examineDtos = new HashSet(16);
            examineDtos = isMerticNotNullCheck ? (Set)request.getTemplateMetricNullChcekExamineMap().get(tempId) : (ProcessTypeEnum.APPLY.getNumber().equals(request.getProcessTypeEnum().getNumber()) ? examineCache.getExamineByApplyTempId(tempId) : examineCache.getExamineByTempId(tempId));
            if (CollectionUtils.isEmpty(examineDtos) && !isMerticNotNullCheck) {
                doExamine.append((Object)"this template no bind examine,don't need check");
                List needDelReportProcessIds = entry.getValue().stream().map(ReportCheckRange::getReportProcessId).collect(Collectors.toList());
                List<ExamineReportUnique> examineReportUniques = entry.getValue().stream().map(x -> {
                    ExamineReportUnique examineReportUnique = new ExamineReportUnique();
                    examineReportUnique.setApproveBillId(x.getApproveBillId());
                    examineReportUnique.setReportProcessId(x.getReportProcessId());
                    return examineReportUnique;
                }).collect(Collectors.toList());
                reportProcessId.removeAll(needDelReportProcessIds);
                ExamineCheckReportServiceImpl.getInstance().deleteCheckReport(examineReportUniques, request.getProcessTypeEnum().getNumber());
                continue;
            }
            Long busModelId = ModelCacheContext.getOrCreate((Long)request.getModelId()).getBusModelByDataSet(((ReportCheckRange)request.getReportCheckRangeList().get(0)).getDatasetId());
            ArrayList examineBos = Lists.newArrayListWithExpectedSize((int)examineDtos.size());
            for (ExamineDto examineDto : examineDtos) {
                examineBos.add(examineBoMap.computeIfAbsent(examineDto.getNumber(), v -> new ExamineBo(examineDto, busModelId, request.getVarValues())));
            }
            List<ReportCheckRange> reportCheckRanges = entry.getValue();
            doExamine.append((Object)("reportProcessSize:" + reportCheckRanges.size()));
            for (ReportCheckRange reportCheckRange : reportCheckRanges) {
                ExamineCheckReport examineCheckReport = this.exeuteCheck(request, examineParamPageSize, examineBos, reportCheckRange);
                this.handleAnnotation(examineCheckReport, annotationInfoMapV1);
                examineCheckReportList.add(examineCheckReport);
                if (isMerticNotNullCheck) continue;
                needSavez.add(examineCheckReport);
            }
        }
        stats.createLinearStatItem("saveReport,size:" + needSavez.size());
        ExamineCheckReportServiceImpl.getInstance().saveCheckReportNew(needSavez, annotationInfoMapV1);
        log.info(stats.toString(logTag));
        return examineCheckReportList;
    }

    private ExamineCheckReport exeuteCheck(MultiExamineCheckRequest request, int examineParamPageSize, List<ExamineBo> examineBos, ReportCheckRange reportCheckRange) {
        String appId = "eb";
        String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
        ExamineCheckReport examineCheckReport = (ExamineCheckReport)DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"ExamineMSService", (String)"check", (Object[])new Object[]{request.getModelId(), request.getTriggerEvent().getNumber(), request.getProcessTypeEnum().getIndex(), request.getExecutorId(), reportCheckRange, examineBos, examineParamPageSize});
        return examineCheckReport;
    }

    @Override
    public List<ReportCheckRange> getReportCheckRange(ReportCheckRangeRequest args) {
        return ExamineCheckRangeUtils.getReportCheckRange(args);
    }

    @Override
    public List<ExamineCheckReport> checkAllChild(ExamineCheckAllChildRequest examineCheckAllChildRequest) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map varValues = ReportVarUtil.getVarValues((Integer)examineCheckAllChildRequest.getProcessType(), (Long)examineCheckAllChildRequest.getModelId(), (Long)examineCheckAllChildRequest.getTaskListId());
        MultiExamineCheckRequest multiExamineCheckRequest = new MultiExamineCheckRequest();
        multiExamineCheckRequest.setExecutorId(UserUtils.getUserId());
        multiExamineCheckRequest.setModelId(examineCheckAllChildRequest.getModelId());
        multiExamineCheckRequest.setTriggerEvent(TriggerEventEnum.BUDGET_TABLE_SUBMIT);
        multiExamineCheckRequest.setProcessTypeEnum(ProcessTypeEnum.getProcessTypeByIndex((int)examineCheckAllChildRequest.getProcessType()));
        multiExamineCheckRequest.setVarValues(varValues);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)examineCheckAllChildRequest.getModelId());
        ExamineCache examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(examineCheckAllChildRequest.getModelId()).getExamineCache();
        DynamicObject[] temDyn = (DynamicObject[])BusinessDataServiceHelper.load((Object[])examineCheckAllChildRequest.getTemplateIdSet().toArray(new Long[0]), (IDataEntityType)ORM.create().getDataEntityType("eb_templateentity"));
        Set temIds = Arrays.stream(temDyn).filter(x -> {
            Set<ExamineDto> examineDtos = examineCache.getExamineByTempId(x.getLong("id"));
            if (CollectionUtils.isEmpty(examineDtos)) {
                return false;
            }
            String data = (String)x.get("data");
            return !StringUtils.isEmpty((CharSequence)data);
        }).map(x -> x.getLong("id")).collect(Collectors.toSet());
        Set entityIdSetByRange = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCache, (Long)examineCheckAllChildRequest.getEntityViewId(), (Long)examineCheckAllChildRequest.getEntityId(), (Integer)RangeEnum.VALUE_40.getValue());
        List notApproveBillProcessList = ApproveBillHelper.getNotApproveBillProcessList((Long)examineCheckAllChildRequest.getModelId(), (Long)examineCheckAllChildRequest.getEntityViewId(), (Long)examineCheckAllChildRequest.getPeriodId(), (Long)examineCheckAllChildRequest.getDataTypeId(), (Long)examineCheckAllChildRequest.getVersionId(), temIds, (Set)entityIdSetByRange, (boolean)true);
        for (ReportProcess reportProcess : notApproveBillProcessList) {
            if (examineCheckAllChildRequest.getReportIds().contains(reportProcess.getId())) continue;
            examineCheckAllChildRequest.getReportIds().add(reportProcess.getId());
        }
        ReportCheckRangeRequest reportCheckRangeRequest = new ReportCheckRangeRequest();
        reportCheckRangeRequest.setModel(examineCheckAllChildRequest.getModelId());
        ArrayList<SchemeOrTaskReqeust> reportList = new ArrayList<SchemeOrTaskReqeust>(16);
        SchemeOrTaskReqeust schemeOrTaskReqeust = new SchemeOrTaskReqeust();
        schemeOrTaskReqeust.setReportProcessId(examineCheckAllChildRequest.getReportIds());
        schemeOrTaskReqeust.setReportProcessType(Integer.valueOf(examineCheckAllChildRequest.getProcessType()));
        schemeOrTaskReqeust.setTaskProcessId(examineCheckAllChildRequest.getTaskListId());
        reportList.add(schemeOrTaskReqeust);
        reportCheckRangeRequest.setReportList(reportList);
        log.info("{} createRequest cost:{}ms,params:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.getJsonString((Object)reportCheckRangeRequest)});
        stopwatch.reset();
        stopwatch.start();
        List<ReportCheckRange> reportCheckRanges = this.getReportCheckRange(reportCheckRangeRequest);
        log.info("{} getReportCheckRange cost:{}ms,response:{}", new Object[]{LOG_PREFIX, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.getJsonString(reportCheckRanges)});
        stopwatch.reset();
        if (CollectionUtils.isEmpty(reportCheckRanges)) {
            return new ArrayList<ExamineCheckReport>();
        }
        multiExamineCheckRequest.setReportCheckRangeList(reportCheckRanges);
        return this.multiCheck(multiExamineCheckRequest);
    }

    private void checkRequestAndSetDefaultValue(MultiExamineCheckRequest request) {
        if (IDUtils.isEmptyLong((Long)request.getModelId()).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"ExamineCheckServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (IDUtils.isEmptyLong((Long)request.getExecutorId()).booleanValue()) {
            request.setExecutorId(Long.valueOf(RequestContext.getOrCreate().getCurrUserId()));
        }
        if (request.getTriggerEvent() == null) {
            request.setTriggerEvent(TriggerEventEnum.PREPARING_CHECK);
        }
        for (ReportCheckRange reportCheckRange : request.getReportCheckRangeList()) {
            this.checkReportCheckRange(reportCheckRange);
        }
    }

    private void checkRequestAndSetDefaultValue(SingleExamineCheckRequest request) {
        if (IDUtils.isEmptyLong((Long)request.getModelId()).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"ExamineCheckServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (IDUtils.isEmptyLong((Long)request.getExecutorId()).booleanValue()) {
            request.setExecutorId(Long.valueOf(RequestContext.getOrCreate().getCurrUserId()));
        }
        if (request.getTriggerEvent() == null) {
            request.setTriggerEvent(TriggerEventEnum.PREPARING_CHECK);
        }
        this.checkReportCheckRange(request.getReportCheckRange());
    }

    private void checkReportCheckRange(ReportCheckRange reportCheckRange) {
        if (reportCheckRange == null || CollectionUtils.isEmpty((Collection)reportCheckRange.getCheckRangeList())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ExamineCheckServiceHelper_4", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }
}

