/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.examinev2.service;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.examinev2.ExamineUtils;
import kd.epm.eb.business.examinev2.cache.ExamineCache;
import kd.epm.eb.business.examinev2.cache.ExamineCacheContextV2;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.ExamineBehaviorEnum;
import kd.epm.eb.common.enums.ExamineCheckTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.domain.ExamineDto;
import kd.epm.eb.common.examine.domain.ExamineGroup;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.pojo.examine.ExamineFormulaExtend;
import kd.epm.eb.common.pojo.examine.ExamineFormulaInfo;
import kd.epm.eb.common.utils.AnalyzeRangeUtils;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.var.TemplateVarCommonUtil;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ExamineServiceImpl {
    private static final Log log = LogFactory.getLog(ExamineServiceImpl.class);
    private static final String CACHE_EXAMINE_KEY = "epm:cacheExamine:";
    private static final String CACHE_EXAMINEGROUP_KEY = "epm:cacheExamineGroup:";
    private static final ExamineServiceImpl INSTANCE = new ExamineServiceImpl();
    public static final String CACHE_RULE_GRAPHNODE_Version_KEY = "epm:cacheExamine:v";
    private static final long MODEL_MAX_SIZE = 16L;
    private static final long MODEL_OVER_TIME = 2L;
    private static LoadingCache<Long, ExamineCacheContextV2> caches = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, ExamineCacheContextV2>(){

        public ExamineCacheContextV2 load(Long modelId) {
            return ExamineServiceImpl.getInstance().initCache(modelId);
        }
    });

    private ExamineServiceImpl() {
    }

    public static ExamineServiceImpl getInstance() {
        return INSTANCE;
    }

    public ExamineCacheContextV2 initCache(@NotNull Long modelId) {
        if (modelId == 0L) {
            throw new NullPointerException("getFromCache error.(modelId is null)");
        }
        ExamineCacheContextV2 examineCacheContextV2 = new ExamineCacheContextV2();
        String versionNum = this.getVersionFromRedis(modelId);
        log.info("\u89c4\u5219\u7f13\u5b58\u7248\u672c\u53f7\uff1a" + versionNum);
        examineCacheContextV2.setVersionId(versionNum);
        List<ExamineDto> examineDtos = this.listExamineFromDB(modelId, "1", null);
        ExamineCache examineCache = ExamineCache.init(modelId, examineDtos.size());
        for (ExamineDto examineDto : examineDtos) {
            examineCache.addExamine(examineDto);
        }
        examineCacheContextV2.setExamineDtoList(Collections.unmodifiableList(examineDtos));
        examineCacheContextV2.setExamineCache(examineCache);
        return examineCacheContextV2;
    }

    public ExamineCacheContextV2 listExamineFromLocalCache(Long modelId) {
        ExamineCacheContextV2 examineCacheContextV2;
        try {
            examineCacheContextV2 = (ExamineCacheContextV2)caches.get((Object)modelId);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String versionNum = this.getVersionFromRedis(modelId);
        if (examineCacheContextV2 != null && !examineCacheContextV2.getVersionId().equals(versionNum)) {
            caches.refresh((Object)modelId);
            try {
                examineCacheContextV2 = (ExamineCacheContextV2)caches.get((Object)modelId);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        if (examineCacheContextV2 != null) {
            return examineCacheContextV2;
        }
        return new ExamineCacheContextV2();
    }

    private String getVersionFromRedis(Long modelId) {
        String versionStr = Cache.get().get(this.getExamineCacheKey(modelId));
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(this.getExamineCacheKey(modelId), newVersionNum);
        return newVersionNum;
    }

    public Set<String> listExamineVarInfos(Long modelId, Set<Long> temIds) {
        List<ExamineDto> examineDtos = this.listExamineFromLocalCache(modelId).getExamineDtoList();
        HashSet<String> vars = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(examineDtos) || CollectionUtils.isEmpty(temIds)) {
            return vars;
        }
        for (ExamineDto examineDto : examineDtos) {
            if (examineDto.getDisTempIds() == null || org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)examineDto.getDisTempIds()) || Sets.intersection(temIds, examineDto.getDisTempIds().stream().collect(Collectors.toSet())).size() <= 0) continue;
            for (Map.Entry entry : examineDto.getVarConditions().entrySet()) {
                vars.addAll(((List)entry.getValue()).stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
            }
            if (examineDto.getFormulaVar() == null) continue;
            for (Map.Entry entry : examineDto.getFormulaVar().entrySet()) {
                vars.addAll((Collection)entry.getValue());
            }
        }
        return vars;
    }

    public Map<String, Set<String>> getExamineVarMap(Long modelId, Set<Long> temIds) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        try {
            List<ExamineDto> examineDtos = this.listExamineFromLocalCache(modelId).getExamineDtoList();
            if (CollectionUtils.isEmpty(examineDtos) || CollectionUtils.isEmpty(temIds)) {
                return map;
            }
            for (ExamineDto examineDto : examineDtos) {
                Set vars;
                if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)examineDto.getDisTempIds())) continue;
                if (temIds.stream().noneMatch(examineDto.getDisTempIds()::contains)) continue;
                for (Map.Entry entry : examineDto.getVarConditions().entrySet()) {
                    vars = map.computeIfAbsent((String)entry.getKey(), (Function<String, Set<String>>)((Function<String, Set>)e -> new HashSet(16)));
                    vars.addAll(((List)entry.getValue()).stream().map(x -> x.getNumber()).collect(Collectors.toSet()));
                }
                for (Map.Entry entry : examineDto.getFormulaVar().entrySet()) {
                    vars = map.computeIfAbsent((String)entry.getKey(), (Function<String, Set<String>>)((Function<String, Set>)e -> new HashSet(16)));
                    vars.addAll((Collection)entry.getValue());
                }
            }
        }
        catch (Exception e2) {
            log.error("examine var is error", (Throwable)e2);
        }
        return map;
    }

    private String getExamineGroupCacheKey(Long modelId) {
        return CACHE_EXAMINEGROUP_KEY + modelId + "v2";
    }

    private String getExamineCacheKey(Long modelId) {
        return CACHE_EXAMINE_KEY + modelId + "v3";
    }

    public void clearExamineGroupCache(Long modelId) {
        CacheServiceHelper.remove((String)this.getExamineGroupCacheKey(modelId));
        this.clearExamineCache(modelId);
    }

    public void clearExamineCache(Long modelId) {
        if (modelId == null) {
            return;
        }
        Cache.get().remove(this.getExamineCacheKey(modelId));
        caches.invalidate((Object)modelId);
    }

    public ExamineDto getExamineFromCache(Long modelId, Long examineId) {
        ExamineCache examineCache = ExamineServiceImpl.getInstance().listExamineFromLocalCache(modelId).getExamineCache();
        return examineCache.getExamineById(examineId);
    }

    public List<ExamineDto> listExamineFromDB(Long modelId, String status, Set<Long> ids) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (StringUtils.isNotEmpty((String)status)) {
            qFilter.and("status", "=", (Object)status);
        }
        if (ids != null && !ids.isEmpty()) {
            qFilter.and("id", "in", ids);
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        List<ExamineGroup> examineGroups = this.listExamineGroupFromRedis(modelId);
        Map<Long, ExamineGroup> examineGroupMap = examineGroups.stream().collect(Collectors.toMap(ExamineGroup::getId, v -> v));
        LinkedHashMap<Long, ExamineDto> examineDtoMap = new LinkedHashMap<Long, ExamineDto>(16);
        String tempSql = "id, name,number, rangediminfo, formula, failoverval,checkinfluence,group,mutigroup.fbasedataid_id,failoverway,maindimension,model.id,explain,formulaextend";
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_examine", (String)tempSql, (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : objectDynamicObjectMap.values()) {
            ExamineDto obj = new ExamineDto();
            obj.setId(Long.valueOf(dynamicObject.getLong("id")));
            obj.setModelId(Long.valueOf(dynamicObject.getLong("model.id")));
            obj.setNumber(dynamicObject.getString("number"));
            log.info("\u6b63\u5728\u5904\u7406\u52fe\u7a3d\u5173\u7cfb\uff1a" + obj.getNumber());
            obj.setName(dynamicObject.getString("name"));
            obj.setExamineCheckTypeEnum(ExamineCheckTypeEnum.getEnumsByValue((String)dynamicObject.getString("failoverway")));
            obj.setFormulaStr(dynamicObject.getString("formula"));
            String mainDimension = dynamicObject.getString("maindimension");
            if (StringUtils.isNotEmpty((String)mainDimension)) {
                String[] split = mainDimension.split("-");
                obj.setMainDimension(split[1]);
            } else {
                obj.setMainDimension(SysDimensionEnum.Account.getNumber());
            }
            String formulaextend = dynamicObject.getString("formulaextend");
            if (StringUtils.isNotEmpty((String)formulaextend)) {
                List examineFormulaExtends = (List)JsonUtils.readValue((String)formulaextend, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<List<ExamineFormulaExtend>>(){});
                obj.setExamineFormulaExtends(examineFormulaExtends);
            }
            obj.setExplain(dynamicObject.getString("explain"));
            obj.setTolerance(new BigDecimal(dynamicObject.getString("failoverval")));
            obj.setExamineBehaviorEnum(ExamineBehaviorEnum.getEnumsByValue((String)dynamicObject.getString("checkinfluence")));
            Set<Long> groupIds = this.getGroupIds(dynamicObject);
            Long bizModelId = this.getBizModelIdByGroup(groupIds, examineGroupMap);
            Map parseDimRangeMap = null;
            try {
                parseDimRangeMap = (Map)ObjectSerialUtil.parseObject((String)dynamicObject.getString("rangediminfo"), (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                log.error("parseExamineRange is error", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u5173\u7cfb\u7ef4\u5ea6\u8303\u56f4\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u52fe\u7a3d\u5173\u7cfb\u5217\u8868\u5347\u7ea7\u52fe\u7a3d\u5173\u7cfb\u3002", (String)"ExamineServiceImpl_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Map<String, Set<String>> rangeDimInfo = null;
            try {
                rangeDimInfo = ExamineUtils.parseDimRangeStrToMap(parseDimRangeMap, memberPropCache, modelCache, bizModelId);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"\u52fe\u7a3d\u5173\u7cfb\u3010%1\u3011\u8303\u56f4\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6216\u8005\u5220\u9664\u91cd\u5199\u3002", (String)"ExamineServiceImpl_1", (String)"epm-eb-formplugin", (Object[])new Object[]{obj.getNumber()}));
            }
            for (Long id : groupIds) {
                ExamineGroup examineGroup = examineGroupMap.get(id);
                if (examineGroup == null) continue;
                Map dimMemberRangeMap = examineGroup.getDimMemberRangeMap();
                this.appendInRange(rangeDimInfo, dimMemberRangeMap);
            }
            obj.setScopes(rangeDimInfo);
            Map<String, Set<String>> dimMapMembNums = this.mapDimVarNums(obj.getFormulaStr());
            obj.setFormulaVar(dimMapMembNums);
            Map<String, List<MemberCondition>> varScope = this.collectVarScope(parseDimRangeMap, examineGroupMap, groupIds);
            obj.setVarConditions(varScope);
            Map<String, List<MemberCondition>> removeScope = this.collectRemoveScope(parseDimRangeMap, examineGroupMap, groupIds);
            obj.setRemoveConditions(removeScope);
            if (!SysDimensionEnum.Account.getNumber().equals(obj.getMainDimension())) {
                Set<String> accountNumbers = rangeDimInfo.get(SysDimensionEnum.Account.getNumber());
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(accountNumbers)) {
                    log.info("\u52fe\u7a3d\u5173\u7cfb\u810f\u6570\u636e\uff0c\u7f16\u7801\uff1a" + obj.getNumber());
                    continue;
                }
                Long datasetIdLong = null;
                for (String accountNumber : accountNumbers) {
                    Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
                    Long itemDatasetIdLong = accountMember.getDatasetId();
                    if (datasetIdLong == null) {
                        datasetIdLong = itemDatasetIdLong;
                        continue;
                    }
                    if (datasetIdLong.equals(itemDatasetIdLong)) continue;
                    throw new KDBizException(ResManager.loadResFormat((String)"\u52fe\u7a3d\u5173\u7cfb:%1,\u68c0\u67e5\u8303\u56f4\u4e2d\u2018\u79d1\u76ee\u2019\u7684\u6240\u6709\u6210\u5458\u9700\u8981\u540c\u5c5e\u4e8e\u4e00\u4e2a\u6570\u636e\u96c6\uff0c\u8bf7\u68c0\u67e5", (String)"EbExamineEditPlugin_68", (String)"epm-eb-formplugin", (Object[])new Object[]{obj.getNumber()}));
                }
                obj.setDatasetId(datasetIdLong);
            }
            examineDtoMap.put(obj.getId(), obj);
        }
        Map<Long, Set<Long>> examineDisTemplate = this.getExamineDisTemplate(examineDtoMap.keySet(), "t_eb_examine_temp");
        examineDisTemplate.forEach((k, v) -> {
            ExamineDto examineDto = (ExamineDto)examineDtoMap.get(k);
            examineDto.setDisTempIds((List)Lists.newArrayList((Iterable)v));
        });
        Map<Long, Set<Long>> examineApplyTemplate = this.getExamineDisTemplate(examineDtoMap.keySet(), "t_eb_examine_applytemp");
        examineApplyTemplate.forEach((k, v) -> {
            ExamineDto examineDto = (ExamineDto)examineDtoMap.get(k);
            examineDto.setApplyTempIds((List)Lists.newArrayList((Iterable)v));
        });
        return Lists.newArrayList(examineDtoMap.values());
    }

    public Map<String, Set<String>> mapDimVarNums(String formulaStr) {
        ArrayList<String> membInfoStrList = new ArrayList<String>(16);
        char[] chars = formulaStr.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < formulaStr.length(); ++i) {
            if (chars[i] != '\"') continue;
            ++i;
            while (i < formulaStr.length() && chars[i] != '\"') {
                sb.append(chars[i]);
                ++i;
            }
            membInfoStrList.add(sb.toString());
            sb.setLength(0);
        }
        HashMap<String, Set<String>> dimMapMembNums = new HashMap<String, Set<String>>(16);
        HashSet<String> membNums = null;
        for (String membInfoStr : membInfoStrList) {
            String[] dimGroups;
            ExamineFormulaInfo examineFormulaInfo = new ExamineFormulaInfo();
            String[] split = membInfoStr.split("#");
            if (split.length > 1) {
                examineFormulaInfo.setTemplateId(Long.valueOf(Long.parseLong(split[0].split("\\|")[1])));
                dimGroups = split[1].split(",");
            } else {
                dimGroups = split[0].split(",");
            }
            for (String dimInfo : dimGroups) {
                if (dimInfo.indexOf("dataset") > -1) continue;
                String dimNum = dimInfo.split("\\|")[0];
                String membNum = dimInfo.split("\\|")[1];
                if (!TemplateVarCommonUtil.checkIsVar((String)membNum, (String)dimNum).booleanValue()) continue;
                membNums = (HashSet<String>)dimMapMembNums.get(dimNum);
                if (membNums == null) {
                    membNums = new HashSet<String>(16);
                    membNums.add(membNum);
                    dimMapMembNums.put(dimNum, membNums);
                    continue;
                }
                membNums.add(membNum);
            }
        }
        return dimMapMembNums;
    }

    private Map<String, List<MemberCondition>> collectVarScope(Map<String, List<MemberCondition>> parseDimRangeMap, Map<Long, ExamineGroup> examineGroupMap, Set<Long> groupIds) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)1);
        if (parseDimRangeMap != null) {
            for (Map.Entry entry : parseDimRangeMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                for (MemberCondition memberCondition : (List)entry.getValue()) {
                    if (!TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimNumber).booleanValue()) continue;
                    res.computeIfAbsent(entry.getKey(), v -> new ArrayList(4)).add(memberCondition);
                }
            }
        }
        if (groupIds != null && examineGroupMap != null) {
            for (Long l : groupIds) {
                ExamineGroup examineGroup = examineGroupMap.get(l);
                if (examineGroup == null || examineGroup.getDimMemberRangeInfo() == null) continue;
                Map dimMemberRangeInfo = examineGroup.getDimMemberRangeInfo();
                for (Map.Entry entry : dimMemberRangeInfo.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    for (MemberCondition memberCondition : (List)entry.getValue()) {
                        if (!TemplateVarCommonUtil.checkIsVar((String)memberCondition.getNumber(), (String)dimNumber).booleanValue()) continue;
                        res.computeIfAbsent(entry.getKey(), v -> new ArrayList(4)).add(memberCondition);
                    }
                }
            }
        }
        return res;
    }

    private Map<String, List<MemberCondition>> collectRemoveScope(Map<String, List<MemberCondition>> parseDimRangeMap, Map<Long, ExamineGroup> examineGroupMap, Set<Long> groupIds) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)1);
        if (parseDimRangeMap != null) {
            for (Map.Entry entry : parseDimRangeMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                for (MemberCondition memberCondition : (List)entry.getValue()) {
                    if (memberCondition.getRemoveBoolean() == null || !memberCondition.getRemoveBoolean().equals(Boolean.TRUE)) continue;
                    res.computeIfAbsent(dimNumber, v -> new ArrayList(4)).add(memberCondition);
                }
            }
        }
        if (groupIds != null && examineGroupMap != null) {
            for (Long l : groupIds) {
                ExamineGroup examineGroup = examineGroupMap.get(l);
                if (examineGroup == null || examineGroup.getDimMemberRangeInfo() == null) continue;
                Map dimMemberRangeInfo = examineGroup.getDimMemberRangeInfo();
                for (Map.Entry entry : dimMemberRangeInfo.entrySet()) {
                    String dimNumber = (String)entry.getKey();
                    for (MemberCondition memberCondition : (List)entry.getValue()) {
                        if (memberCondition.getRemoveBoolean() == null || !memberCondition.getRemoveBoolean().equals(Boolean.TRUE)) continue;
                        res.computeIfAbsent(dimNumber, v -> new ArrayList(4)).add(memberCondition);
                    }
                }
            }
        }
        return res;
    }

    private Set<Long> getGroupIds(DynamicObject dynamicObject) {
        HashSet groupIds = Sets.newHashSetWithExpectedSize((int)10);
        Long groupId = dynamicObject.getLong("group.id");
        DynamicObjectCollection mutiGroup = dynamicObject.getDynamicObjectCollection("mutigroup");
        if (IDUtils.isNotEmptyLong((Long)groupId).booleanValue()) {
            groupIds.add(groupId);
        }
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)mutiGroup)) {
            for (DynamicObject object : mutiGroup) {
                groupIds.add(object.getLong("fbasedataid_id"));
            }
        }
        return groupIds;
    }

    private void appendInRange(Map<String, Set<String>> rangeDimInfo, Map<String, Set<String>> dimMemberRangeMap) {
        for (Map.Entry<String, Set<String>> entry : dimMemberRangeMap.entrySet()) {
            rangeDimInfo.computeIfAbsent(entry.getKey(), v -> new HashSet(((Set)entry.getValue()).size())).addAll((Collection)entry.getValue());
        }
    }

    public List<ExamineGroup> listExamineGroupFromRedis(Long modelId) {
        List<ExamineGroup> examineDtos;
        String json = (String)CacheServiceHelper.get((String)this.getExamineGroupCacheKey(modelId), String.class);
        if (StringUtils.isBlank((String)json)) {
            examineDtos = this.listExamineGroupFromDB(modelId);
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(examineDtos)) {
                CacheServiceHelper.put((String)this.getExamineGroupCacheKey(modelId), (Object)JsonUtils.getJsonString(examineDtos));
            }
        } else {
            log.info("\u89c4\u5219\u547d\u4e2d\u7f13\u5b58");
            try {
                examineDtos = (List<ExamineGroup>)JsonUtils.readValue((String)json, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<List<ExamineGroup>>(){});
            }
            catch (Exception e) {
                log.warn("\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u4eceDB\u91cc\u518d\u53d6\u4e00\u6b21", (Throwable)e);
                examineDtos = this.listExamineGroupFromDB(modelId);
            }
        }
        return examineDtos;
    }

    public Set<ExamineGroup> listExamineGroupByIds(Long modelId, Set<Long> ids) {
        List<ExamineGroup> examineGroups = this.listExamineGroupFromRedis(modelId);
        return examineGroups.stream().filter(x -> ids.contains(x.getId())).collect(Collectors.toSet());
    }

    private List<ExamineGroup> listExamineGroupFromDB(Long modelId) {
        DynamicObject[] examineGroupObjects = BusinessDataServiceHelper.load((String)"eb_examinecategory", (String)"id,name,code,model.id,businessmodel.id,parent.id,rangediminfo,entryentity.memberscopejson,entryentity.dimnumber", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (examineGroupObjects == null || examineGroupObjects.length == 0) {
            return new ArrayList<ExamineGroup>(0);
        }
        ArrayList<ExamineGroup> examineGroups = new ArrayList<ExamineGroup>(examineGroupObjects.length);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
        for (DynamicObject examineGroupObject : examineGroupObjects) {
            ExamineGroup examineGroup = new ExamineGroup();
            examineGroups.add(examineGroup);
            examineGroup.setId(Long.valueOf(examineGroupObject.getLong("id")));
            examineGroup.setNumber(examineGroupObject.getString("code"));
            examineGroup.setName(examineGroupObject.getString("name"));
            examineGroup.setModelId(Long.valueOf(examineGroupObject.getLong("model.id")));
            examineGroup.setParentId(Long.valueOf(examineGroupObject.getLong("parent.id")));
            examineGroup.setBizModelId(Long.valueOf(examineGroupObject.getLong("businessmodel.id")));
            examineGroup.setDimMemberRangeInfoStr(examineGroupObject.getString("rangediminfo"));
            LinkedHashMap<String, List> dimMemberRangeInfo = new LinkedHashMap<String, List>(16);
            examineGroup.setDimMemberRangeInfo(dimMemberRangeInfo);
            DynamicObjectCollection entryEntity = examineGroupObject.getDynamicObjectCollection("entryentity");
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                for (DynamicObject object : entryEntity) {
                    List members;
                    String memberScopeJson = object.getString("memberscopejson");
                    String dimNumber = object.getString("dimnumber");
                    if (!StringUtils.isNotEmpty((String)memberScopeJson) || !org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)(members = (List)ObjectSerialUtil.parseObject((String)memberScopeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0])))) continue;
                    dimMemberRangeInfo.put(dimNumber, members);
                }
            }
            this.setExamineGroupRange(modelCache, memberPropCache, examineGroup);
        }
        return examineGroups;
    }

    private void setExamineGroupRange(IModelCacheHelper modelCache, MemberPropCache memberPropCache, ExamineGroup examineGroup) {
        LinkedHashMap dimMemberRangeMap = new LinkedHashMap(16);
        Map dimMemberRangeInfo = examineGroup.getDimMemberRangeInfo();
        String examinePropRelation = ParamQueryServiceHelper.getString((long)modelCache.getModelobj().getId(), (ParamEnum)ParamEnum.BG046);
        for (Map.Entry entry : dimMemberRangeInfo.entrySet()) {
            String dimNumber = (String)entry.getKey();
            Set members = AnalyzeRangeUtils.analyzeMemberConditionToMember2((String)dimNumber, (List)((List)entry.getValue()), (String)examinePropRelation, (IModelCacheHelper)modelCache, (MemberPropCache)memberPropCache, null, (boolean)false);
            dimMemberRangeMap.put(entry.getKey(), members);
        }
        examineGroup.setDimMemberRangeMap(dimMemberRangeMap);
    }

    public Map<Long, Set<Long>> getExamineDisTemplate(Collection<Long> examineIds, String tabName) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(examineIds)) {
            return Collections.emptyMap();
        }
        HashMap returnCollection = Maps.newHashMapWithExpectedSize((int)examineIds.size());
        String tempSql = "select fid,fbasedataid from " + tabName + " where fid in (" + SqlBatchUtils.getBatchParamsSql((int)examineIds.size()) + ") ";
        try (DataSet dataSet = DB.queryDataSet((String)"query-examine-check-ref-report", (DBRoute)BgBaseConstant.epm, (String)tempSql, (Object[])examineIds.toArray());){
            for (Row row : dataSet) {
                Long examineId = row.getLong("fid");
                Long templateId = row.getLong("fbasedataid");
                returnCollection.computeIfAbsent(examineId, v -> Sets.newLinkedHashSet()).add(templateId);
            }
        }
        return returnCollection;
    }

    public Map<String, String> getExamineSignColor(Set<String> examineNumbers, Long modelId) {
        HashMap<String, String> examineSignColor = new HashMap<String, String>(examineNumbers.size());
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(examineNumbers) || IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return examineSignColor;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "in", examineNumbers);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_examine", (String)"remarkcolor,number", (QFilter[])qFilter.toArray());
        if (objects != null && objects.size() > 0) {
            for (DynamicObject object : objects) {
                examineSignColor.put(object.getString("number"), object.getString("remarkcolor"));
            }
        }
        return examineSignColor;
    }

    public boolean existDimMemberScope(Long examineCatalogId) {
        HashSet<Long> examineCatalogIds = new HashSet<Long>(1);
        examineCatalogIds.add(examineCatalogId);
        return this.existDimMemberScope(examineCatalogIds);
    }

    public boolean existDimMemberScope(Set<Long> examineCatalogIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(examineCatalogIds)) {
            return false;
        }
        QFilter qFilter = new QFilter("id", "in", examineCatalogIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_examinecategory", (String)"id,rangediminfo", (QFilter[])qFilter.toArray());
        if (query == null) {
            return false;
        }
        return query.stream().anyMatch(x -> StringUtils.isNotBlank((String)x.getString("rangediminfo")));
    }

    public boolean isLeaf(Long examineCatalogId) {
        QFilter qFilter = new QFilter("parent", "=", (Object)examineCatalogId);
        return QueryServiceHelper.exists((String)"eb_examinecategory", (QFilter[])qFilter.toArray());
    }

    public Set<String> getHasMemberScopeDim(Set<Long> examineCatalogIds) {
        HashSet<String> hasMemberScopeDim = new HashSet<String>(16);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(examineCatalogIds)) {
            return hasMemberScopeDim;
        }
        String sql = "select fmemberscope,fdimnumber from t_eb_examine_memberscope where  fid in (" + StringUtils.join(examineCatalogIds, (String)",") + ");";
        try (DataSet ds = DB.queryDataSet((String)"getHasMemberScopeDim", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String memberScopeJson = row.getString("fmemberscope");
                if (!StringUtils.isNotBlank((String)memberScopeJson)) continue;
                hasMemberScopeDim.add(row.getString("fdimnumber"));
            }
        }
        return hasMemberScopeDim;
    }

    public Map<Long, Map<String, String>> getExamineGroupDimMemberScope(Set<Long> examineCatalogIds) {
        HashMap<Long, Map<String, String>> examineGroupDimMemberScope = new HashMap<Long, Map<String, String>>(16);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(examineCatalogIds)) {
            return examineGroupDimMemberScope;
        }
        String sql = "select fid,fmemberscope,fdimnumber from t_eb_examine_memberscope where  fid in (" + StringUtils.join(examineCatalogIds, (String)",") + ");";
        try (DataSet ds = DB.queryDataSet((String)"getExamineGroupDimMemberScope", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds != null && ds.hasNext()) {
                List members;
                Row row = ds.next();
                Long examineCatalogId = row.getLong("fid");
                String dimNumber = row.getString("fdimnumber");
                String memberScopeJson = row.getString("fmemberscope");
                if (!StringUtils.isNotBlank((String)memberScopeJson) || (members = (List)ObjectSerialUtil.parseObject((String)memberScopeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0])).size() <= 0) continue;
                Map dimMemberScope = examineGroupDimMemberScope.computeIfAbsent(examineCatalogId, e -> new LinkedHashMap(16));
                String memberScopeShow = members.toString();
                dimMemberScope.put(dimNumber, memberScopeShow.substring(1, memberScopeShow.length() - 1));
            }
        }
        return examineGroupDimMemberScope;
    }

    public void copyExamine(Set<Long> ids, Long modelId) {
        ArrayList<DynamicObject> copySchemes = new ArrayList<DynamicObject>(16);
        for (Long id : ids) {
            copySchemes.add(this.getCopyScheme(id, modelId));
        }
        SaveServiceHelper.save((DynamicObject[])copySchemes.toArray(new DynamicObject[0]));
        this.clearExamineCache(modelId);
    }

    public DynamicObject getCopyScheme(Object id, Long modelId) {
        String name_copy;
        Long pkId = ConvertUtils.toLong((Object)id);
        if (pkId == null || pkId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u52fe\u7a3d\u5173\u7cfb\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExamineListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"eb_examine");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u52fe\u7a3d\u5173\u7cfb\u4fe1\u606f\u5931\u8d25\u3002", (String)"ExamineListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject scheme_copy = BusinessDataServiceHelper.newDynamicObject((String)"eb_examine");
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.add("number");
        ignoreKeys.add("name");
        DynamicObjectUtils.copy((DynamicObject)scheme, (DynamicObject)scheme_copy, ignoreKeys);
        long schemeId = DB.genGlobalLongId();
        String number = scheme.getString("number");
        String indexStr = ExecuteAnalyseUtil.getInstance().getCopyIndex(number, "eb_examine", modelId);
        String number_copy = number + indexStr;
        if (number_copy.length() > 50) {
            number_copy = number_copy.substring(0, 50);
        }
        if ((name_copy = scheme.getString("name") + indexStr).length() > 50) {
            name_copy = name_copy.substring(0, 80);
        }
        scheme_copy.set("number", (Object)number_copy);
        scheme_copy.set("name", (Object)name_copy);
        scheme_copy.set("id", (Object)schemeId);
        scheme_copy.set("status", (Object)"0");
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        scheme_copy.set("creater", (Object)userId);
        scheme_copy.set("modifier", (Object)userId);
        scheme_copy.set("createdate", (Object)now);
        scheme_copy.set("modifydate", (Object)now);
        if (scheme_copy.containsProperty("syncstatus")) {
            scheme_copy.set("syncstatus", (Object)"");
        }
        if (scheme_copy.containsProperty("syncdate")) {
            scheme_copy.set("syncdate", null);
        }
        if (scheme_copy.containsProperty("syncmainnumber")) {
            scheme_copy.set("syncmainnumber", (Object)"");
        }
        return scheme_copy;
    }

    public Map<Long, String> getTemplateInfoMap(Long model) {
        DynamicObject[] templateInfo = BusinessDataServiceHelper.load((String)"eb_templateentity", (String)"id,name", (QFilter[])new QFilter("model", "=", (Object)model).toArray());
        if (templateInfo == null) {
            return new LinkedHashMap<Long, String>(16);
        }
        return Arrays.asList(templateInfo).stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getString("name")));
    }

    private Long getBizModelIdByGroup(Set<Long> groupIds, Map<Long, ExamineGroup> examineGroupMap) {
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(groupIds) && examineGroupMap != null && examineGroupMap.size() > 0) {
            for (Long groupId : groupIds) {
                ExamineGroup examineGroup = examineGroupMap.get(groupId);
                if (examineGroup == null) continue;
                return examineGroup.getBizModelId();
            }
        }
        return 0L;
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u52fe\u7a3d\u7f13\u5b58");
                caches.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u52fe\u7a3d\u7f13\u5b58\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

