/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.BinaryExpr;
import kd.bos.formula.excel.CompoundId;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.AnalyseColTypeGroup;
import kd.epm.eb.common.execanalyse.AnalyseExportParameter;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.AnalyseQueryParameter;
import kd.epm.eb.common.execanalyse.ExecAnalyseConstant;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SchemeColType;
import kd.epm.eb.common.execanalyse.SplitDimRange;
import kd.epm.eb.common.execanalyse.SplitMemberRange;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.control.calc.face.Calculator;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.olap.impl.ext.expr.AnalyseExprParse;
import kd.epm.eb.olap.impl.ext.expr.face.IAnalyseExpr;
import kd.epm.eb.olap.impl.ext.expr.impl.EmptyExpr;
import kd.epm.eb.olap.impl.ext.expr.impl.MonthOnMonth;
import kd.epm.eb.olap.impl.ext.expr.impl.YearOnYear;
import kd.epm.eb.olap.impl.metadata.DataRow;

public class AnalyseBudgetQueryService {
    private static final AnalyseBudgetQueryService instance = new AnalyseBudgetQueryService();
    private static final Log log = LogFactory.getLog(AnalyseBudgetQueryService.class);

    public static AnalyseBudgetQueryService getInstance() {
        return instance;
    }

    public List<Object[]> getAnalyseData(AnalyseQueryParameter queryParameter) {
        if (queryParameter.getMaxQueryData() != 0 && queryParameter.isNeedSplit()) {
            queryParameter.setSplitDimRanges(this.getSplitRanges(queryParameter));
        }
        HashMap<MembersKey, IKDCell> dataMap = new HashMap<MembersKey, IKDCell>(16);
        ArrayList<Set<String>> dataKeyList = new ArrayList<Set<String>>(16);
        if (!queryParameter.isNeedSplit()) {
            this.reQueryOlap(queryParameter, null, dataMap, dataKeyList);
        }
        List<SchemeColSetting> schemeCol_afterFilter = queryParameter.getColSettings().stream().filter(e -> e.getShow() != false || SchemeColType.PRESET == e.getColType() && !AnalysePreColType.BUD_ACT_RATE.getNumber().equals(e.getNumber()) && !AnalysePreColType.BALANCE.getNumber().equals(e.getNumber())).collect(Collectors.toList());
        Map<Long, SchemeColSetting> colSettingMap = schemeCol_afterFilter.stream().collect(Collectors.toMap(SchemeColSetting::getId, e -> e, (n1, n2) -> n2));
        List<IDataRow> dataRows = this.convertToDataRows(schemeCol_afterFilter, queryParameter);
        this.updateCountByNextPageStartRowMembers(queryParameter);
        this.getControlDimensions(queryParameter);
        this.addDimMember(queryParameter, null, dataMap, dataKeyList, colSettingMap, dataRows, 0);
        if (queryParameter.getTmpData().size() != 0) {
            Map<String, IBudgetBalance> balanceMap = this.getAllBalances(queryParameter);
            CommonServiceHelper.handleLog((Log)log, (String)"AnalyseBudgetQueryService_queryBalance: ", (String)balanceMap.toString());
            this.dealControlCols(queryParameter, balanceMap, null);
        }
        return queryParameter.getAnalyseData();
    }

    private void updateCountByNextPageStartRowMembers(AnalyseQueryParameter queryParameter) {
        String[] nextPageStartRowMembers = queryParameter.getNextPageStartRowMembers();
        if (nextPageStartRowMembers == null) {
            return;
        }
        List rowDimKeys = queryParameter.getRowDimKeys();
        Map queryParam = queryParameter.getQueryParam();
        for (int i = 0; i < rowDimKeys.size(); ++i) {
            int index = ((List)queryParam.get(rowDimKeys.get(i))).indexOf(nextPageStartRowMembers[i]);
            this.updateRangeCount(index, queryParameter, i);
        }
        queryParameter.setCurQueryDataCount(queryParameter.getCurRangeCount() / queryParameter.getMaxQueryData() - 1);
    }

    public void dealControlCols(AnalyseQueryParameter queryParameter, Map<String, IBudgetBalance> balanceMap, AnalyseExportParameter exportParameter) {
        List balanceCols = queryParameter.getAnalyseColTypeGroup().getBalanceCols();
        Map colKeys = queryParameter.getColKeys();
        List colKeyList = queryParameter.getColKeyList();
        List balanceMemberList = queryParameter.getBalanceMemberList();
        AnalyseColTypeGroup analyseColTypeGroup = queryParameter.getAnalyseColTypeGroup();
        Map controlCols = analyseColTypeGroup.getControlCols();
        int defaultScale = 2;
        DimMemberPermChecker checker = this.getDimPermChecker(queryParameter);
        for (int i = 0; i < balanceMemberList.size(); ++i) {
            Object[] analyseData = (Object[])queryParameter.getTmpData().get(i);
            Map balanceMemberMap = (Map)balanceMemberList.get(i);
            for (String balanceCol : balanceCols) {
                Map controlColMap;
                IBudgetBalance budgetBalance;
                String bPeriod;
                AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)((String)colKeys.get(balanceCol)));
                if (preColType == null) continue;
                String colMember = (String)analyseColTypeGroup.getColMemberMap().get(balanceCol);
                if (colMember == null) {
                    bPeriod = "amountRange";
                } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(queryParameter.getColDimKey())) {
                    bPeriod = (String)colKeys.get(colMember);
                } else {
                    bPeriod = (String)balanceMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    balanceMemberMap.put(queryParameter.getColDimKey(), colKeys.get(colMember));
                }
                HashMap<String, String> balanceMemberMap_new = new HashMap<String, String>(balanceMemberMap);
                HashMap<String, String> balanceMemberMap_perm = new HashMap<String, String>(balanceMemberMap);
                balanceMemberMap_new.put(SysDimensionEnum.BudgetPeriod.getNumber(), (String)queryParameter.getMaxMonthMap().get(bPeriod));
                if ("amountRange".equals(bPeriod)) {
                    balanceMemberMap_perm.put(SysDimensionEnum.BudgetPeriod.getNumber(), (String)queryParameter.getMaxMonthMap().get(bPeriod));
                }
                if ((budgetBalance = balanceMap.get(this.getCtlKey(balanceMemberMap_new, (List<String>)queryParameter.getControlDimensions()))) == null) continue;
                HashMap<AnalysePreColType, Boolean> permMap = new HashMap<AnalysePreColType, Boolean>(16);
                boolean showBalanceValue = false;
                String[] stringArray = new String[2];
                stringArray[0] = "#";
                String string = stringArray[1] = colMember == null ? "amountRange" : colMember;
                if (!(this.checkCurColTypeNotHasPerm(queryParameter, Arrays.asList(AnalysePreColType.BUDGET, AnalysePreColType.CONTROL_OCCUPY, AnalysePreColType.CONTROL_EXECUTE, AnalysePreColType.INIT_ACTUAL, AnalysePreColType.BUD_OCCUPY), Arrays.asList(stringArray), balanceMemberMap_perm, permMap, checker) || Calculator.calc(budgetBalance, CalculatorTypeEnum.ACTUAL.getNumber()) == null && Calculator.calc(budgetBalance, CalculatorTypeEnum.BUDGET.getNumber()) == null)) {
                    showBalanceValue = true;
                    BigDecimal balance = budgetBalance.getBalance();
                    if (balance != null) {
                        analyseData[colKeyList.indexOf((Object)balanceCol)] = balance.setScale(defaultScale, 4);
                    }
                }
                if (controlCols == null || (controlColMap = (Map)controlCols.get(balanceCol)) == null) continue;
                for (Map.Entry entry : controlColMap.entrySet()) {
                    CalculatorTypeEnum calculatorType;
                    String colType = (String)entry.getKey();
                    String colKey = (String)entry.getValue();
                    AnalysePreColType preColType_1 = AnalysePreColType.getColByNumber((String)colType);
                    if (preColType_1 == null) continue;
                    if (AnalysePreColType.CONTROL_TYPE == preColType_1 && budgetBalance.getSetting() != null && showBalanceValue) {
                        analyseData[colKeyList.indexOf((Object)colKey)] = budgetBalance.getSetting().getSettingType().getName();
                        continue;
                    }
                    if (AnalysePreColType.CONTROL_BUD_ACT_RATE == preColType_1) {
                        BigDecimal actualData = null;
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "#";
                        String string2 = stringArray2[1] = colMember == null ? "amountRange" : colMember;
                        if (!this.checkCurColTypeNotHasPerm(queryParameter, Arrays.asList(AnalysePreColType.CONTROL_OCCUPY, AnalysePreColType.CONTROL_EXECUTE, AnalysePreColType.INIT_ACTUAL, AnalysePreColType.BUD_OCCUPY), Arrays.asList(stringArray2), balanceMemberMap_perm, permMap, checker)) {
                            actualData = ConvertUtils.toDecimal((Object)Calculator.calc(budgetBalance, CalculatorTypeEnum.ACTUAL.getNumber()));
                        }
                        BigDecimal budgetData = null;
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "#";
                        String string3 = stringArray3[1] = colMember == null ? "amountRange" : colMember;
                        if (!this.checkCurColTypeNotHasPerm(queryParameter, Collections.singletonList(AnalysePreColType.BUDGET), Arrays.asList(stringArray3), balanceMemberMap_perm, permMap, checker)) {
                            budgetData = ConvertUtils.toDecimal((Object)Calculator.calc(budgetBalance, CalculatorTypeEnum.BUDGET.getNumber()));
                        }
                        if (actualData == null || budgetData == null) continue;
                        if (budgetData.compareTo(BigDecimal.ZERO) == 0 || actualData.compareTo(BigDecimal.ZERO) == 0) {
                            analyseData[colKeyList.indexOf((Object)colKey)] = BigDecimal.ZERO.setScale(2, 4) + "%";
                            continue;
                        }
                        analyseData[colKeyList.indexOf((Object)colKey)] = actualData.multiply(BigDecimal.TEN.pow(2)).divide(budgetData, 2, 4) + "%";
                        continue;
                    }
                    if (AnalysePreColType.CONTROL_ACTUAL == preColType_1) {
                        calculatorType = this.getCalculateType(preColType_1);
                        if (calculatorType == null) continue;
                        String[] stringArray4 = new String[2];
                        stringArray4[0] = "#";
                        String string4 = stringArray4[1] = colMember == null ? "amountRange" : colMember;
                        if (this.checkCurColTypeNotHasPerm(queryParameter, Arrays.asList(AnalysePreColType.CONTROL_OCCUPY, AnalysePreColType.CONTROL_EXECUTE, AnalysePreColType.INIT_ACTUAL, AnalysePreColType.BUD_OCCUPY), Arrays.asList(stringArray4), balanceMemberMap_perm, permMap, checker)) continue;
                        analyseData[colKeyList.indexOf((Object)colKey)] = ConvertUtils.toDecimal((Object)Calculator.calc(budgetBalance, calculatorType.getNumber()));
                        continue;
                    }
                    calculatorType = this.getCalculateType(preColType_1);
                    if (calculatorType == null) continue;
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = "#";
                    String string5 = stringArray5[1] = colMember == null ? "amountRange" : colMember;
                    if (this.checkCurColTypeNotHasPerm(queryParameter, Collections.singletonList(preColType_1), Arrays.asList(stringArray5), balanceMemberMap_perm, permMap, checker)) continue;
                    analyseData[colKeyList.indexOf((Object)colKey)] = ConvertUtils.toDecimal((Object)Calculator.calc(budgetBalance, calculatorType.getNumber()));
                }
            }
            if (this.isAllColEmpty(analyseData, colKeys, colKeyList, queryParameter.getModelCacheHelper())) continue;
            queryParameter.getAnalyseData().add(analyseData);
            if (exportParameter == null) continue;
            exportParameter.getEnableRowIndex().add(i);
        }
        queryParameter.getTmpData().clear();
        queryParameter.getBalanceMemberList().clear();
    }

    private CalculatorTypeEnum getCalculateType(AnalysePreColType preColType) {
        if (preColType == null) {
            return null;
        }
        CalculatorTypeEnum calculatorType = null;
        switch (preColType) {
            case CONTROL_OCCUPY: {
                calculatorType = CalculatorTypeEnum.OCCUPATION;
                break;
            }
            case CONTROL_EXECUTE: {
                calculatorType = CalculatorTypeEnum.EXECUTE;
                break;
            }
            case CONTROL_ACTUAL: {
                calculatorType = CalculatorTypeEnum.ACTUAL;
                break;
            }
        }
        return calculatorType;
    }

    private List<SplitDimRange> getSplitRanges(AnalyseQueryParameter queryParameter) {
        ArrayList<SplitDimRange> splitDimRanges = new ArrayList<SplitDimRange>(16);
        List rowDimKeys = queryParameter.getRowDimKeys();
        Map queryParam = queryParameter.getQueryParam();
        int maxQueryData = queryParameter.getMaxQueryData();
        int maxSize = 1;
        for (String rowDimKey : rowDimKeys) {
            maxSize *= ((List)queryParam.get(rowDimKey)).size();
        }
        int curSize = 0;
        SplitDimRange preRange = null;
        Stack<SplitMemberRange> stack = new Stack<SplitMemberRange>();
        while (curSize < maxSize) {
            int retainSize = maxQueryData;
            for (int i = rowDimKeys.size() - 1; i >= 0; --i) {
                String dimKey = (String)rowDimKeys.get(i);
                List memberList = (List)queryParam.get(dimKey);
                int memberListSize = memberList.size();
                int curDimRetainSize = retainSize % memberListSize;
                retainSize /= memberListSize;
                int preSize = 0;
                if (preRange != null) {
                    preSize = preRange.getMemberRange(i).getEnd();
                }
                if ((curDimRetainSize += preSize) >= memberListSize) {
                    ++retainSize;
                    curDimRetainSize -= memberListSize;
                }
                if (curDimRetainSize >= memberListSize) {
                    curDimRetainSize = memberListSize - 1;
                }
                boolean isContainsAll = this.checkIsContainsAll(retainSize, preSize, curDimRetainSize);
                stack.push(new SplitMemberRange(preSize, curDimRetainSize, isContainsAll));
                if (retainSize == 0) break;
            }
            SplitDimRange range = new SplitDimRange();
            for (int i = rowDimKeys.size(); i > 0; --i) {
                if (i > stack.size()) {
                    if (preRange == null) {
                        range.addMemberRange(new SplitMemberRange(0, 0, false));
                        continue;
                    }
                    range.addMemberRange(preRange.getMemberRange(rowDimKeys.size() - i));
                    continue;
                }
                range.addMemberRange((SplitMemberRange)stack.pop());
            }
            splitDimRanges.add(range);
            preRange = range;
            curSize = splitDimRanges.size() * maxQueryData;
        }
        return splitDimRanges;
    }

    public boolean checkIsContainsAll(int retainSize, int preSize, int curDimRetainSize) {
        if (retainSize == 0) {
            return false;
        }
        if (retainSize == 1) {
            return preSize <= curDimRetainSize;
        }
        return true;
    }

    public void dealQueryParam(Map<String, Set<String>> queryParam, AnalyseQueryParameter queryParameter) {
        this.fillCustomMembers(queryParam, queryParameter);
        this.addAmountPeriodRange(queryParam, queryParameter);
        this.addPageDims(queryParam, queryParameter);
        this.addSpecialMembers(queryParam, queryParameter);
        this.addRefPeriods(queryParam, queryParameter);
    }

    private void addRefPeriods(Map<String, Set<String>> queryParam, AnalyseQueryParameter queryParameter) {
        List refPeriods = queryParameter.getRefPeriods();
        if (refPeriods != null) {
            queryParam.get(SysDimensionEnum.BudgetPeriod.getNumber()).addAll(refPeriods);
        }
    }

    public Map<String, IBudgetBalance> getAllBalances(AnalyseQueryParameter queryParameter) {
        List controlDimensions = queryParameter.getControlDimensions();
        List balanceMemberList = queryParameter.getBalanceMemberList();
        AnalyseColTypeGroup analyseColTypeGroup = queryParameter.getAnalyseColTypeGroup();
        List balanceCols = analyseColTypeGroup.getBalanceCols();
        Map colKeys = queryParameter.getColKeys();
        ArrayList<Map<String, String>> balanceMemberList_new = new ArrayList<Map<String, String>>(16);
        HashSet<String> balanceMemberJson = new HashSet<String>(16);
        for (Map balanceMemberMap : balanceMemberList) {
            for (String balanceCol : balanceCols) {
                String bPeriod;
                AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)((String)colKeys.get(balanceCol)));
                if (preColType == null) continue;
                String colMember = (String)analyseColTypeGroup.getColMemberMap().get(balanceCol);
                if (colMember == null) {
                    bPeriod = "amountRange";
                } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(queryParameter.getColDimKey())) {
                    bPeriod = (String)colKeys.get(colMember);
                } else {
                    bPeriod = (String)balanceMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    balanceMemberMap.put(queryParameter.getColDimKey(), colKeys.get(colMember));
                }
                HashMap balanceMemberMap_new = new HashMap(balanceMemberMap);
                balanceMemberMap_new.put(SysDimensionEnum.BudgetPeriod.getNumber(), queryParameter.getMaxMonthMap().get(bPeriod));
                String membersJson = SerializationUtils.toJsonString(balanceMemberMap_new);
                if (!balanceMemberJson.add(membersJson)) continue;
                balanceMemberList_new.add(balanceMemberMap_new);
            }
        }
        ArrayList<String> types = new ArrayList<String>(16);
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        CommonServiceHelper.handleLog((Log)log, (String)"AnalyseBudgetQueryService_queryBalance(members): ", (String)((Object)balanceMemberList_new).toString());
        Collection<IBudgetBalance> balances = new BgControlCallerImpl().queryBalance(queryParameter.getModelId(), balanceMemberList_new, types, true, true, queryParameter.getBizModelId());
        HashMap<String, IBudgetBalance> balanceMap = new HashMap<String, IBudgetBalance>(16);
        balances.forEach(e -> balanceMap.put(instance.getCtlKey((IBudgetBalance)e, (List<String>)controlDimensions), (IBudgetBalance)e));
        return balanceMap;
    }

    public AnalyseColTypeGroup classifyAnalyseColType(AnalyseQueryParameter queryParameter) {
        AnalyseColTypeGroup analyseColTypeGroup = new AnalyseColTypeGroup();
        Map colKeys = queryParameter.getColKeys();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        HashMap<String, String> toAddKeyMap = new HashMap<String, String>(16);
        block6: for (Map.Entry colKey : colKeys.entrySet()) {
            String key = (String)colKey.getKey();
            String value = (String)colKey.getValue();
            if (this.isDimensionCol(value, modelCacheHelper)) continue;
            this.addToColMemberMap(analyseColTypeGroup, key, value);
            AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)value);
            if (preColType == null) {
                if (value.startsWith("formula")) {
                    analyseColTypeGroup.addFormulaCol(key);
                    analyseColTypeGroup.addFormulaInfo(key, Long.valueOf(Long.parseLong(value.replace("formula", ""))));
                    continue;
                }
                analyseColTypeGroup.addOtherCol(key);
                continue;
            }
            switch (preColType) {
                case BUD_ACT_RATE: {
                    analyseColTypeGroup.addPreFormulaCol(key);
                    this.addRelateDataCol(analyseColTypeGroup, toAddKeyMap, queryParameter, Arrays.asList(AnalysePreColType.OCCUPY, AnalysePreColType.EXECUTE, AnalysePreColType.EXECUTE, AnalysePreColType.INIT_ACTUAL, AnalysePreColType.BUDGET), null, key);
                    continue block6;
                }
                case ACTUAL: {
                    analyseColTypeGroup.addPreFormulaCol(key);
                    this.addRelateDataCol(analyseColTypeGroup, toAddKeyMap, queryParameter, Arrays.asList(AnalysePreColType.OCCUPY, AnalysePreColType.EXECUTE, AnalysePreColType.EXECUTE, AnalysePreColType.INIT_ACTUAL), null, key);
                    continue block6;
                }
                case BALANCE: {
                    analyseColTypeGroup.addPreFormulaCol(key);
                    this.addRelateDataCol(analyseColTypeGroup, toAddKeyMap, queryParameter, Arrays.asList(AnalysePreColType.OCCUPY, AnalysePreColType.EXECUTE, AnalysePreColType.BUDGET, AnalysePreColType.INIT_ACTUAL, AnalysePreColType.BUD_OCCUPY), null, key);
                    continue block6;
                }
                case CONTROL_BALANCE: {
                    analyseColTypeGroup.addBalanceCol(key);
                    continue block6;
                }
            }
            if (preColType.getControlRefCol().booleanValue()) {
                String balanceKey = this.getPreColKey(analyseColTypeGroup.getColMemberMap(), key, AnalysePreColType.CONTROL_BALANCE);
                analyseColTypeGroup.addControlCol(balanceKey, key, preColType);
                if (queryParameter.getColKeyList().contains(balanceKey)) continue;
                queryParameter.getColKeyList().add(balanceKey);
                this.addToColMemberMap(analyseColTypeGroup, balanceKey, AnalysePreColType.CONTROL_BALANCE.getNumber());
                toAddKeyMap.put(balanceKey, AnalysePreColType.CONTROL_BALANCE.getNumber());
                continue;
            }
            analyseColTypeGroup.addDataCol(key);
        }
        this.addFormulaRelDataCols(analyseColTypeGroup, queryParameter, colKeys, toAddKeyMap);
        colKeys.putAll(toAddKeyMap);
        return analyseColTypeGroup;
    }

    private void addFormulaRelDataCols(AnalyseColTypeGroup analyseColTypeGroup, AnalyseQueryParameter queryParameter, Map<String, String> colKeys, Map<String, String> toAddKeyMap) {
        Map formulaMap = analyseColTypeGroup.getFormulaMap();
        if (formulaMap.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", formulaMap.values());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"eb_execcolentity", (String)"id, formula", (QFilter[])new QFilter[]{qFilter});
        if (cols.size() == 0) {
            return;
        }
        ArrayList<String> toAddPeriods = new ArrayList<String>(16);
        HashMap<String, Set<String>> formulaRelPeriodMap = new HashMap<String, Set<String>>(16);
        ArrayList<Long> relDataIds = new ArrayList<Long>(16);
        HashMap<Long, ArrayList<Long>> formulaRelDataMap = new HashMap<Long, ArrayList<Long>>(16);
        for (DynamicObject col : cols) {
            long id = col.getLong("id");
            String formulaString = col.getString("formula");
            Map formulaInfoMap = (Map)SerializationUtils.fromJsonString((String)formulaString, Map.class);
            String expr = (String)formulaInfoMap.get("expr");
            ArrayList<Long> relDataList = new ArrayList<Long>(16);
            DataRow dataRow = new DataRow();
            dataRow.setExpression(expr);
            IAnalyseExpr analyseExpr = AnalyseExprParse.parse((DataRow)dataRow, (IModelCacheHelper)queryParameter.getModelCacheHelper(), null, null);
            if (analyseExpr instanceof EmptyExpr) {
                Expr expression = FormulaEngine.parseFormula((String)expr);
                if (expression instanceof BinaryExpr) {
                    BinaryExpr binaryExpr = (BinaryExpr)expression;
                    this.addRelDataId(binaryExpr, relDataList);
                }
            } else {
                List params = analyseExpr.getParams();
                HashMap dataRowMap = new HashMap(16);
                params.forEach(e -> {
                    relDataList.add(Long.parseLong(e.substring(1)));
                    DataRow row = new DataRow();
                    row.setIndex(e);
                    row.setMetas(new HashMap(16));
                    dataRowMap.put(e, row);
                });
                analyseExpr.setDataRowMap(dataRowMap);
                this.addPeriod(analyseExpr, queryParameter, dataRow, formulaMap, colKeys, toAddPeriods, formulaRelPeriodMap, id);
            }
            formulaRelDataMap.put(id, relDataList);
            relDataIds.addAll(relDataList);
        }
        queryParameter.setRefPeriods(toAddPeriods);
        QFilter qf = new QFilter("id", "in", relDataIds);
        DynamicObjectCollection execCols = QueryServiceHelper.query((String)"eb_execcolentity", (String)"id, number", (QFilter[])new QFilter[]{qf});
        if (execCols.size() == 0) {
            return;
        }
        Map<Long, String> colInfo = execCols.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("number")));
        for (Map.Entry entry : formulaRelDataMap.entrySet()) {
            Long formulaId = (Long)entry.getKey();
            List colIds = (List)entry.getValue();
            for (Long colId : colIds) {
                String colKey = colInfo.get(colId);
                AnalysePreColType analysePreColType = AnalysePreColType.getColByNumber((String)colKey);
                List<String> formulaKeys = this.getKeysByValue(formulaMap, formulaId);
                formulaKeys.forEach(e -> {
                    Set refPeriods = (Set)formulaRelPeriodMap.get(e);
                    if (refPeriods == null) {
                        this.addRelateDataCol(analyseColTypeGroup, toAddKeyMap, queryParameter, analysePreColType, null, (String)e);
                        queryParameter.addRefColTypes(analysePreColType);
                    } else {
                        for (String refPeriod : refPeriods) {
                            this.addRelateDataCol(analyseColTypeGroup, toAddKeyMap, queryParameter, analysePreColType, refPeriod, (String)e);
                            queryParameter.addRefColTypes(analysePreColType);
                            queryParameter.addReferAmountPeriods(refPeriod);
                        }
                    }
                });
            }
        }
        queryParameter.setFormulaRelDataMap(formulaRelDataMap);
    }

    private void addPeriod(IAnalyseExpr analyseExpr, AnalyseQueryParameter queryParameter, DataRow dataRow, Map<String, Long> formulaMap, Map<String, String> colKeys, List<String> toAddPeriods, Map<String, Set<String>> formulaRelPeriodMap, long id) {
        String colDimKey = queryParameter.getColDimKey();
        List<String> controlKeys = null;
        ArrayList curPeriods = new ArrayList(16);
        List periodNumbers = (List)queryParameter.getQueryParam().get(SysDimensionEnum.BudgetPeriod.getNumber());
        HashMap<String, String> commonMap = new HashMap<String, String>(16);
        analyseExpr.setCommMemberMap(commonMap);
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(colDimKey)) {
            controlKeys = this.getKeysByValue(formulaMap, id);
            for (String controlKey : controlKeys) {
                boolean checkContain = true;
                String replace = controlKey.replace("_formula" + id, "");
                replace = replace.replace("entryentity_", "");
                HashSet<String> periods = new HashSet<String>(16);
                if ("amountrange".equals(replace)) {
                    periods.addAll(queryParameter.getAmountPeriods());
                    checkContain = false;
                } else {
                    String colDimNumber = colKeys.get(replace);
                    if (periodNumbers.contains(colDimNumber)) {
                        periods.add(colDimNumber);
                    }
                }
                HashSet allLeadPeriods = new HashSet(16);
                for (String period : periods) {
                    Set leadPeriods;
                    commonMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), period);
                    IAnalyseExpr analyseExpr_new = AnalyseExprParse.parse((DataRow)dataRow, (IModelCacheHelper)analyseExpr.getModelCacheHelper(), (Map)analyseExpr.getDataRowMap(), commonMap);
                    Map metas = analyseExpr_new.getMetas();
                    if (metas == null || (leadPeriods = (Set)metas.get(SysDimensionEnum.BudgetPeriod.getNumber())) == null) continue;
                    allLeadPeriods.addAll(leadPeriods);
                    for (String leadPeriod : leadPeriods) {
                        if (checkContain && periodNumbers.contains(leadPeriod)) continue;
                        toAddPeriods.add(leadPeriod);
                    }
                }
                formulaRelPeriodMap.put(controlKey, allLeadPeriods);
            }
            return;
        }
        curPeriods.addAll(periodNumbers);
        for (String curPeriod : curPeriods) {
            Class<?> aClass = analyseExpr.getClass();
            IAnalyseExpr tmp = (IAnalyseExpr)TypesContainer.createInstance(aClass);
            tmp.setParams(analyseExpr.getParams());
            tmp.setCommMemberMap(analyseExpr.getCommMemberMap());
            tmp.setDataRowMap(analyseExpr.getDataRowMap());
            tmp.setModelCacheHelper(analyseExpr.getModelCacheHelper());
            commonMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), curPeriod);
            this.leadPeriod(tmp, toAddPeriods, periodNumbers);
        }
    }

    private List<String> getKeysByValue(Map<String, Long> map, Long entryKey) {
        ArrayList<String> keyList = new ArrayList<String>(16);
        if (map.size() == 0) {
            return keyList;
        }
        map.forEach((key, value) -> {
            if (value.equals(entryKey)) {
                keyList.add((String)key);
            }
        });
        return keyList;
    }

    private void addRelDataId(BinaryExpr binaryExpr, List<Long> relDataList) {
        Expr left = binaryExpr.getLeft();
        if (left instanceof BinaryExpr) {
            this.addRelDataId((BinaryExpr)left, relDataList);
        } else if (left instanceof CompoundId) {
            CompoundId compoundId = (CompoundId)left;
            relDataList.add(Long.parseLong(compoundId.toString().substring(1)));
        }
        Expr right = binaryExpr.getRight();
        if (right instanceof BinaryExpr) {
            this.addRelDataId((BinaryExpr)right, relDataList);
        } else if (right instanceof CompoundId) {
            CompoundId compoundId = (CompoundId)right;
            relDataList.add(Long.parseLong(compoundId.toString().substring(1)));
        }
    }

    private void leadPeriod(IAnalyseExpr analyseExpr, List<String> toAddPeriods, List<String> periodNumbers) {
        Map metas = analyseExpr.getMetas();
        if (metas == null) {
            return;
        }
        Set periods = (Set)metas.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (periods == null) {
            return;
        }
        for (String period : periods) {
            if (periodNumbers.contains(period)) continue;
            toAddPeriods.add(period);
        }
    }

    private void addToColMemberMap(AnalyseColTypeGroup analyseColTypeGroup, String key, String colNumber) {
        String controlKey = key.replace("entryentity_", "");
        if (!"amountrange".equals(controlKey = controlKey.replace("_" + colNumber, ""))) {
            analyseColTypeGroup.addColMember(key, controlKey);
        }
    }

    private void addRelateDataCol(AnalyseColTypeGroup analyseColTypeGroup, Map<String, String> toAddKeyMap, AnalyseQueryParameter queryParameter, AnalysePreColType colType, String period, String colKey) {
        this.addRelateDataCol(analyseColTypeGroup, toAddKeyMap, queryParameter, Collections.singletonList(colType), period, colKey);
    }

    private void addRelateDataCol(AnalyseColTypeGroup analyseColTypeGroup, Map<String, String> toAddKeyMap, AnalyseQueryParameter queryParameter, List<AnalysePreColType> colTypes, String period, String colKey) {
        Map colMemberMap = analyseColTypeGroup.getColMemberMap();
        List colKeyList = queryParameter.getColKeyList();
        HashSet<String> colSet = new HashSet<String>(colKeyList);
        for (AnalysePreColType colType : colTypes) {
            String preColKey = period == null ? this.getPreColKey(colMemberMap, colKey, colType) : "entryentity_" + period.replaceAll("\\.", "_").toLowerCase() + "_" + colType.getNumber();
            if (!colSet.add(preColKey)) continue;
            colKeyList.add(preColKey);
            this.addToColMemberMap(analyseColTypeGroup, preColKey, colType.getNumber());
            if (colType.getControlRefCol().booleanValue()) {
                String balanceKey = this.getPreColKey(colMemberMap, preColKey, AnalysePreColType.BALANCE);
                analyseColTypeGroup.addControlCol(balanceKey, preColKey, colType);
                if (colSet.add(balanceKey)) {
                    colKeyList.add(balanceKey);
                    this.addToColMemberMap(analyseColTypeGroup, balanceKey, AnalysePreColType.BALANCE.getNumber());
                    toAddKeyMap.put(balanceKey, AnalysePreColType.BALANCE.getNumber());
                }
            } else {
                analyseColTypeGroup.addDataCol(preColKey);
            }
            toAddKeyMap.put(preColKey, colType.getNumber());
        }
    }

    private void addSpecialMembers(Map<String, Set<String>> queryInfo, AnalyseQueryParameter queryParameter) {
        Set<String> tmp = queryInfo.get(SysDimensionEnum.ChangeType.getNumber());
        HashSet<String> changeTypeMembers = new HashSet<String>(tmp);
        tmp = queryInfo.get(SysDimensionEnum.AuditTrail.getNumber());
        HashSet<String> auditTrails = new HashSet<String>(tmp);
        tmp = queryInfo.get(SysDimensionEnum.DataType.getNumber());
        HashSet<String> dataTypes = new HashSet<String>(tmp);
        tmp = queryInfo.get(SysDimensionEnum.Version.getNumber());
        HashSet<String> versions = new HashSet<String>(tmp);
        Map notHasPermColTypes = queryParameter.getNotHasPermColTypes();
        if (!queryParameter.isCheckDimPerm() || notHasPermColTypes == null) {
            String adjpstAuditTrail;
            changeTypeMembers.add("Occupation");
            changeTypeMembers.add("Execute");
            changeTypeMembers.add("ActualChanges");
            auditTrails.add("EntityInput");
            auditTrails.add("BudgetOccupation");
            String adjustAuditTrail = queryParameter.getAdjustAuditTrail();
            if (StringUtils.isNotEmpty((String)adjustAuditTrail)) {
                auditTrails.add(adjustAuditTrail);
            }
            if (StringUtils.isNotEmpty((String)(adjpstAuditTrail = queryParameter.getAdjpstAuditTrail()))) {
                auditTrails.add(adjpstAuditTrail);
            }
            dataTypes.add("Actual");
            versions.add("ACTUAL");
        } else {
            List analysePreColTypes = (List)notHasPermColTypes.get("#");
            if (analysePreColTypes.contains(AnalysePreColType.BUDGET)) {
                auditTrails.clear();
                if (analysePreColTypes.contains(AnalysePreColType.BUD_OCCUPY)) {
                    changeTypeMembers.clear();
                    dataTypes.clear();
                    versions.clear();
                }
            }
            if (!analysePreColTypes.contains(AnalysePreColType.OCCUPY)) {
                changeTypeMembers.add("Occupation");
                auditTrails.add("EntityInput");
                dataTypes.add("Actual");
                versions.add("ACTUAL");
            }
            if (!analysePreColTypes.contains(AnalysePreColType.EXECUTE)) {
                changeTypeMembers.add("ActualChanges");
                auditTrails.add("EntityInput");
                dataTypes.add("Actual");
                versions.add("ACTUAL");
            }
            if (!analysePreColTypes.contains(AnalysePreColType.INIT_ACTUAL)) {
                changeTypeMembers.add("ActualChanges");
                auditTrails.add("EntityInput");
                dataTypes.add("Actual");
                versions.add("ACTUAL");
            }
            if (!analysePreColTypes.contains(AnalysePreColType.BUD_OCCUPY)) {
                auditTrails.add("BudgetOccupation");
            }
        }
        queryInfo.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeMembers);
        queryInfo.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrails);
        queryInfo.put(SysDimensionEnum.DataType.getNumber(), dataTypes);
        queryInfo.put(SysDimensionEnum.Version.getNumber(), versions);
    }

    private void addAmountPeriodRange(Map<String, Set<String>> queryParam, AnalyseQueryParameter queryParameter) {
        Set amountPeriods = queryParameter.getAmountPeriods();
        Set<String> members = queryParam.get(SysDimensionEnum.BudgetPeriod.getNumber());
        HashSet<String> periods = new HashSet<String>(amountPeriods);
        periods.addAll(members);
        queryParam.put(SysDimensionEnum.BudgetPeriod.getNumber(), periods);
    }

    public void fillCustomMembers(Map<String, Set<String>> queryParam, AnalyseQueryParameter queryParameter) {
        List dimensionList = queryParameter.getModelCacheHelper().getDimensionList(queryParameter.getDatasetId());
        Map dimMembers = queryParameter.getDimMembers();
        dimensionList.forEach(e -> {
            String number = e.getNumber();
            if (!queryParam.containsKey(number)) {
                HashSet<String> customMembers = new HashSet<String>(16);
                String defaultMember = SysDimensionEnum.InternalCompany.getNumber().equals(number) ? e.getNoneNumber() : number;
                customMembers.add(defaultMember);
                queryParam.put(number, customMembers);
                dimMembers.put(number, defaultMember);
            }
        });
    }

    public void fillOtherData(AnalyseQueryParameter queryParameter, Object[] analyseData, Map<MembersKey, IKDCell> dataMap, Map<Long, SchemeColSetting> colSettingMap, List<IDataRow> dataRows, Boolean dealBalance) {
        HashMap<String, String> dimMembers_new = new HashMap<String, String>(queryParameter.getDimMembers());
        Map colKeys = queryParameter.getColKeys();
        queryParameter.getRowDimControlKeys().forEach(e -> dimMembers_new.put((String)colKeys.get(e), this.getDimMemberFromObjectArray(analyseData, (String)e, queryParameter.getColKeyList())));
        this.dealDataCols(queryParameter, analyseData, dataMap, dimMembers_new);
        this.dealPreFormulaCols(queryParameter, analyseData);
        this.dealFormulaCols(queryParameter, analyseData, colSettingMap, dataRows, dimMembers_new, dataMap);
        this.dealOtherCols(queryParameter, analyseData);
        Object[] tmp = new Object[analyseData.length];
        System.arraycopy(analyseData, 0, tmp, 0, analyseData.length);
        queryParameter.getTmpData().add(tmp);
        queryParameter.addBalanceMember(dimMembers_new);
        if (dealBalance.booleanValue() && queryParameter.getTmpData().size() >= 5000) {
            Map<String, IBudgetBalance> balanceMap = this.getAllBalances(queryParameter);
            CommonServiceHelper.handleLog((Log)log, (String)"AnalyseBudgetQueryService_queryBalance: ", (String)JSONUtils.toString(balanceMap));
            this.dealControlCols(queryParameter, balanceMap, null);
        }
    }

    public List<IDataRow> convertToDataRows(List<SchemeColSetting> schemeColSettings, AnalyseQueryParameter queryParameter) {
        ArrayList<IDataRow> dataRows = new ArrayList<IDataRow>(16);
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            if ((!schemeColSetting.getShow().booleanValue() || schemeColSetting.getColType() == SchemeColType.FORMULA) && !this.isRefCol(schemeColSetting.getNumber(), queryParameter)) continue;
            DataRow dataRow = new DataRow();
            dataRow.setIndex("A" + schemeColSetting.getId());
            dataRow.setDataRowType(DataRowEnum.DATA);
            dataRow.setLead("0");
            dataRows.add((IDataRow)dataRow);
        }
        return dataRows;
    }

    private boolean isRefCol(String number, AnalyseQueryParameter queryParameter) {
        Set refColTypes = queryParameter.getRefColTypes();
        if (refColTypes == null) {
            return false;
        }
        AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)number);
        return refColTypes.contains(preColType);
    }

    public boolean isAllColEmpty(Object[] analyseData, Map<String, String> colKeys, List<String> colKeyList, IModelCacheHelper modelCacheHelper) {
        if (analyseData == null) {
            return true;
        }
        for (int i = 0; i < analyseData.length; ++i) {
            Object value;
            String colKey = colKeyList.get(i);
            if (this.isDimensionCol(colKeys.get(colKey), modelCacheHelper) || (value = analyseData[i]) == null || ConvertUtils.toDecimal((Object)value) == null || BigDecimal.ZERO.doubleValue() == ConvertUtils.toDecimal((Object)value).doubleValue()) continue;
            return false;
        }
        return true;
    }

    private void dealDataCols(AnalyseQueryParameter queryParameter, Object[] analyseDataMap, Map<MembersKey, IKDCell> dataMap, Map<String, String> dimMembers) {
        List dataCols = queryParameter.getAnalyseColTypeGroup().getDataCols();
        if (dataCols == null) {
            return;
        }
        Map colKeys = queryParameter.getColKeys();
        String colDimKey = queryParameter.getColDimKey();
        String[] dimensionList = queryParameter.getDimensionList();
        Set amountPeriods = queryParameter.getAmountPeriods();
        DimMemberPermChecker checker = this.getDimPermChecker(queryParameter);
        Map metricDisplay = queryParameter.getMetricDisplay();
        for (String dataCol : dataCols) {
            String metricNumber;
            Object result;
            block12: {
                Map<String, String> memberMap;
                AnalysePreColType preColType;
                block11: {
                    preColType = AnalysePreColType.getColByNumber((String)((String)colKeys.get(dataCol)));
                    if (preColType == null || this.checkCurColTypeNotHasPerm(queryParameter, preColType, "#")) continue;
                    memberMap = this.addColDimMember(queryParameter, dataCol, dimMembers, colDimKey);
                    this.replaceDimRangeByPreColType(queryParameter, memberMap, preColType);
                    String colMember = memberMap.get(colDimKey);
                    result = null;
                    metricNumber = memberMap.get("Metric");
                    if (colMember == null) break block11;
                    if (this.checkCurColTypeNotHasPerm(queryParameter, preColType, colMember)) {
                        analyseDataMap[queryParameter.getColKeyList().indexOf((Object)dataCol)] = result = "notPermCell";
                        continue;
                    }
                    if (this.checkCellDimNotHasPerm(queryParameter, memberMap, checker)) {
                        analyseDataMap[queryParameter.getColKeyList().indexOf((Object)dataCol)] = result = "notPermCell";
                        continue;
                    }
                    MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(memberMap, dimensionList);
                    IKDCell cell = dataMap.get(membersKey);
                    if (cell == null) break block12;
                    result = cell.getValue().getValue();
                    if (AnalysePreColType.BUD_OCCUPY != preColType) break block12;
                    result = BigDecimal.valueOf(-ConvertUtils.toDecimal((Object)cell.getValue().getValue()).doubleValue());
                    break block12;
                }
                if (this.checkCurColTypeNotHasPerm(queryParameter, preColType, "amountRange")) {
                    result = "notPermCell";
                    this.setValue(analyseDataMap, result, queryParameter.getColKeyList().indexOf(dataCol));
                    continue;
                }
                for (String amountPeriod : amountPeriods) {
                    if (this.checkCurColTypeNotHasPerm(queryParameter, preColType, amountPeriod)) {
                        result = "notPermCell";
                        this.setValue(analyseDataMap, result, queryParameter.getColKeyList().indexOf(dataCol));
                        continue;
                    }
                    memberMap.put(colDimKey, amountPeriod);
                    if (this.checkCellDimNotHasPerm(queryParameter, memberMap, checker)) {
                        result = "notPermCell";
                        this.setValue(analyseDataMap, result, queryParameter.getColKeyList().indexOf(dataCol));
                        continue;
                    }
                    MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(memberMap, dimensionList);
                    IKDCell cell = dataMap.get(membersKey);
                    if (cell == null) continue;
                    if (result == null) {
                        result = BigDecimal.ZERO;
                    }
                    if (!(result instanceof BigDecimal)) continue;
                    if (AnalysePreColType.BUD_OCCUPY == preColType) {
                        result = ((BigDecimal)result).subtract(ConvertUtils.toDecimal((Object)cell.getValue().getValue()));
                        continue;
                    }
                    result = ((BigDecimal)result).add(ConvertUtils.toDecimal((Object)cell.getValue().getValue()));
                }
            }
            if (result instanceof BigDecimal && metricDisplay.get(metricNumber) != null) {
                result = ((BigDecimal)result).setScale((int)((Integer)metricDisplay.get(metricNumber)), 4);
            }
            this.setValue(analyseDataMap, result, queryParameter.getColKeyList().indexOf(dataCol));
        }
    }

    public DimMemberPermChecker getDimPermChecker(AnalyseQueryParameter queryParameter) {
        if (!queryParameter.isCheckDimPerm()) {
            return null;
        }
        List permDimGroups = queryParameter.getPermDimGroups();
        if (permDimGroups == null) {
            return null;
        }
        List<String> dimNums = Arrays.asList(queryParameter.getDimensionList());
        Set<String> matchedDims = this.matchNeedCheckPermDims(permDimGroups, dimNums);
        Set hasCheckedPermDims = queryParameter.getHasCheckedPermDims();
        if (matchedDims.size() == 0) {
            return null;
        }
        if (hasCheckedPermDims != null && matchedDims.containsAll(hasCheckedPermDims) && hasCheckedPermDims.containsAll(matchedDims)) {
            return null;
        }
        return DimMembPermHelper.getPermChecker((Long)queryParameter.getModelId(), (Long)queryParameter.getBizModelId(), dimNums, (Long)UserUtils.getUserId(), (DimMembPermType)DimMembPermType.READ);
    }

    private boolean checkCellDimNotHasPerm(AnalyseQueryParameter queryParameter, Map<String, String> memberMap, DimMemberPermChecker checker) {
        if (checker == null) {
            return false;
        }
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        HashMap<String, MemberItem> memberItemMap = new HashMap<String, MemberItem>(memberMap.size());
        for (Map.Entry<String, String> entry : memberMap.entrySet()) {
            String dimKey = entry.getKey();
            String member = entry.getValue();
            Member mem = modelCacheHelper.getMember(dimKey, (Long)viewMap.get(dimKey), member);
            if (mem == null) continue;
            memberItemMap.put(dimKey, new MemberItem(true, mem.getId()));
        }
        return !checker.check(memberItemMap);
    }

    private boolean checkCurColTypeNotHasPerm(AnalyseQueryParameter queryParameter, AnalysePreColType preColType, String permKey) {
        List analysePreColTypes;
        boolean hasPerm = false;
        if (queryParameter.isCheckDimPerm() && queryParameter.getNotHasPermColTypes() != null && (analysePreColTypes = (List)queryParameter.getNotHasPermColTypes().get(permKey)) != null && analysePreColTypes.contains(preColType)) {
            hasPerm = true;
        }
        return hasPerm;
    }

    private boolean checkCurColTypeNotHasPerm(AnalyseQueryParameter queryParameter, List<AnalysePreColType> preColTypes, List<String> permKeys, Map<String, String> dimMemberMap, Map<AnalysePreColType, Boolean> permMap, DimMemberPermChecker checker) {
        if (!queryParameter.isCheckDimPerm()) {
            return false;
        }
        for (AnalysePreColType preColType : preColTypes) {
            if (!this.checkSingleColTypeNotHasPerm(queryParameter, preColType, permKeys, dimMemberMap, permMap, checker)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSingleColTypeNotHasPerm(AnalyseQueryParameter queryParameter, AnalysePreColType preColType, List<String> permKeys, Map<String, String> dimMemberMap, Map<AnalysePreColType, Boolean> permMap, DimMemberPermChecker checker) {
        if (!queryParameter.isCheckDimPerm()) {
            return false;
        }
        Boolean notHasPerm = permMap.get(preColType);
        if (notHasPerm != null) {
            return notHasPerm;
        }
        Map notHasPermColTypes = queryParameter.getNotHasPermColTypes();
        if (notHasPermColTypes != null) {
            for (String permKey : permKeys) {
                List analysePreColTypes = (List)queryParameter.getNotHasPermColTypes().get(permKey);
                if (analysePreColTypes == null || !analysePreColTypes.contains(preColType)) continue;
                permMap.put(preColType, Boolean.TRUE);
                return true;
            }
        }
        HashMap<String, String> tmp = new HashMap<String, String>(dimMemberMap);
        this.replaceDimRangeByPreColType(queryParameter, tmp, preColType);
        notHasPerm = this.checkCellDimNotHasPerm(queryParameter, tmp, checker);
        permMap.put(preColType, notHasPerm);
        return notHasPerm;
    }

    private void setValue(Object[] analyseDataMap, Object result, int index) {
        BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)result);
        if (bigDecimal != null || result != null && result.toString().endsWith("%")) {
            analyseDataMap[index] = result;
        }
    }

    public void dealPreFormulaCols(AnalyseQueryParameter queryParameter, Object[] analyseDataMap) {
        AnalyseColTypeGroup analyseColTypeGroup = queryParameter.getAnalyseColTypeGroup();
        List preFormulaCols = analyseColTypeGroup.getPreFormulaCols();
        Map colKeys = queryParameter.getColKeys();
        Map colMemberMap = analyseColTypeGroup.getColMemberMap();
        block5: for (String preFormulaCol : preFormulaCols) {
            AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)((String)colKeys.get(preFormulaCol)));
            if (preColType == null) continue;
            List colKeyList = queryParameter.getColKeyList();
            int colIndex = colKeyList.indexOf(preFormulaCol);
            switch (preColType) {
                case BUD_ACT_RATE: {
                    Object actualDataObj = this.getActualData(colMemberMap, preFormulaCol, analyseDataMap, colKeyList);
                    Object budgetValueObj = this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.BUDGET), colKeyList);
                    if ("notPermCell".equals(actualDataObj) || "notPermCell".equals(budgetValueObj)) break;
                    BigDecimal actualData = ConvertUtils.toDecimal((Object)actualDataObj);
                    BigDecimal budgetValue = ConvertUtils.toDecimal((Object)budgetValueObj);
                    if (actualData == null || budgetValue == null) continue block5;
                    if (budgetValue.compareTo(BigDecimal.ZERO) == 0 || actualData.compareTo(BigDecimal.ZERO) == 0) {
                        analyseDataMap[colIndex] = BigDecimal.ZERO.setScale(2, 4) + "%";
                        break;
                    }
                    analyseDataMap[colIndex] = actualData.multiply(BigDecimal.TEN.pow(2)).divide(budgetValue, 2, 4) + "%";
                    break;
                }
                case ACTUAL: {
                    Object actualDataObj1 = this.getActualData(colMemberMap, preFormulaCol, analyseDataMap, colKeyList);
                    if ("notPermCell".equals(actualDataObj1)) break;
                    this.setValue(analyseDataMap, ConvertUtils.toDecimal((Object)actualDataObj1), colIndex);
                    break;
                }
                case BALANCE: {
                    Object balanceData = this.getBalanceData(colMemberMap, preFormulaCol, analyseDataMap, colKeyList);
                    if ("notPermCell".equals(balanceData)) break;
                    this.setValue(analyseDataMap, ConvertUtils.toDecimal((Object)balanceData), colIndex);
                }
            }
        }
    }

    private Object getBalanceData(Map<String, String> colMemberMap, String preFormulaCol, Object[] analyseDataMap, List<String> colKeyList) {
        return this.subtractValue(this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.BUDGET), colKeyList), this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.OCCUPY), colKeyList), this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.EXECUTE), colKeyList), this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.INIT_ACTUAL), colKeyList), this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.BUD_OCCUPY), colKeyList));
    }

    private Object subtractValue(Object ... values) {
        BigDecimal retValue = null;
        for (Object value : values) {
            if ("notPermCell".equals(value)) {
                return "notPermCell";
            }
            BigDecimal decimal = ConvertUtils.toDecimal((Object)value);
            if (decimal == null) {
                decimal = BigDecimal.ZERO;
            }
            retValue = retValue == null ? decimal : retValue.subtract(decimal);
        }
        return retValue;
    }

    private Object getActualData(Map<String, String> colMemberMap, String preFormulaCol, Object[] analyseDataMap, List<String> colKeyList) {
        return this.addAllValues(this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.OCCUPY), colKeyList), this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.EXECUTE), colKeyList), this.getAnalyseValue(analyseDataMap, this.getPreColKey(colMemberMap, preFormulaCol, AnalysePreColType.INIT_ACTUAL), colKeyList));
    }

    private Object addAllValues(Object ... values) {
        BigDecimal retValue = null;
        for (Object value : values) {
            if ("notPermCell".equals(value)) {
                return "notPermCell";
            }
            BigDecimal decimal = ConvertUtils.toDecimal((Object)value);
            if (decimal == null) continue;
            if (retValue == null) {
                retValue = BigDecimal.ZERO;
            }
            retValue = retValue.add(decimal);
        }
        return retValue;
    }

    private Object getAnalyseValue(Object[] analyseDataMap, String preColKey, List<String> colKeyList) {
        return analyseDataMap[colKeyList.indexOf(preColKey)];
    }

    private String getPreColKey(Map<String, String> colMemberMap, String key, AnalysePreColType preColType) {
        String colMember = colMemberMap.get(key);
        if (colMember == null) {
            colMember = "amountrange";
        }
        return "entryentity_" + colMember + "_" + preColType.getNumber();
    }

    public void dealFormulaCols(AnalyseQueryParameter queryParameter, Object[] analyseData, Map<Long, SchemeColSetting> colSettingMap, List<IDataRow> dataRows, Map<String, String> memberMap, Map<MembersKey, IKDCell> dataMap) {
        List formulaCols = queryParameter.getAnalyseColTypeGroup().getFormulaCols();
        if (formulaCols == null) {
            return;
        }
        HashMap<Long, Set> formulaMap = new HashMap<Long, Set>(16);
        for (String formulaCol : formulaCols) {
            Long colId = (Long)queryParameter.getAnalyseColTypeGroup().getFormulaMap().get(formulaCol);
            Set controlKeys = formulaMap.computeIfAbsent(colId, k -> new HashSet(16));
            controlKeys.add(formulaCol);
        }
        List colKeyList = queryParameter.getColKeyList();
        for (Map.Entry formulaEntry : formulaMap.entrySet()) {
            for (String controlKey : (Set)formulaEntry.getValue()) {
                Object formulaValue = this.getFormulaValue(queryParameter, analyseData, colSettingMap, (Long)formulaEntry.getKey(), controlKey, dataRows, memberMap, dataMap);
                this.setValue(analyseData, formulaValue, colKeyList.indexOf(controlKey));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object getFormulaValue(AnalyseQueryParameter queryParameter, Object[] analyseData, Map<Long, SchemeColSetting> colSettingMap, Long colId, String controlKey, List<IDataRow> dataRows, Map<String, String> memberMap, Map<MembersKey, IKDCell> dataMap) {
        dataRowMap = dataRows.stream().collect(Collectors.toMap((Function<IDataRow, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIndex(), (Lkd/epm/eb/olap/api/metadata/IDataRow;)Ljava/lang/String;)(), (Function<IDataRow, IDataRow>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFormulaValue$12(kd.epm.eb.olap.api.metadata.IDataRow ), (Lkd/epm/eb/olap/api/metadata/IDataRow;)Lkd/epm/eb/olap/api/metadata/IDataRow;)()));
        schemeColSetting = colSettingMap.get(colId);
        formula = schemeColSetting.getFormula();
        formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
        expr = (String)formulaMap.get("expr");
        dataRow = new DataRow();
        dataRow.setExpression(expr);
        dimMembers = this.addColDimMember(queryParameter, controlKey, memberMap, queryParameter.getColDimKey());
        analyseExpr = AnalyseExprParse.parse((DataRow)dataRow, (IModelCacheHelper)queryParameter.getModelCacheHelper(), dataRowMap, dimMembers);
        if (this.relDataColNotHasPerm(queryParameter, dimMembers, colSettingMap, colId)) {
            return null;
        }
        value = null;
        if (analyseExpr instanceof EmptyExpr) {
            expression = FormulaEngine.parseFormula((String)expr);
            variableMap = this.getAllVariables(analyseData, controlKey, queryParameter, colSettingMap);
            try {
                value = FormulaEngine.execExcelFormula((Expr)expression, variableMap);
            }
            catch (Throwable ex) {
                AnalyseBudgetQueryService.log.error("analyse-calc-error:", ex);
                AnalyseBudgetQueryService.log.error("analyse-calc-exp: " + expr);
                if (ex instanceof ArithmeticException || ex instanceof FormulaException) ** GOTO lbl63
                throw new KDBizException(ex.getMessage());
            }
        } else {
            dimensionList = queryParameter.getDimensionList();
            dimIndexMap = new HashMap<String, Integer>(16);
            for (i = 0; i < dimensionList.length; ++i) {
                dimIndexMap.put(dimensionList[i], i);
            }
            params = analyseExpr.getParams();
            if (params != null && params.size() != 0) {
                refColId = Long.parseLong(((String)params.get(0)).substring(1));
                colSetting = colSettingMap.get(refColId);
                if (colSetting == null) {
                    return null;
                }
                refPreColType = AnalysePreColType.getColByNumber((String)colSetting.getNumber());
                if (refPreColType != null) {
                    this.replaceDimRangeByPreColType(queryParameter, dimMembers, refPreColType);
                }
                if (controlKey.contains("amountrange")) {
                    sum = BigDecimal.ZERO;
                    divider = BigDecimal.ZERO;
                    dimMember_new = new HashMap<String, String>(dimMembers);
                    amountPeriods = queryParameter.getAmountPeriods();
                    for (String amountPeriod : amountPeriods) {
                        dimMember_new.put(SysDimensionEnum.BudgetPeriod.getNumber(), amountPeriod);
                        analyseExpr_new = AnalyseExprParse.parse((DataRow)dataRow, (IModelCacheHelper)queryParameter.getModelCacheHelper(), dataRowMap, dimMember_new);
                        analyseExpr_new.getMetas();
                        membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMember_new, dimensionList);
                        cell = dataMap.get(membersKey);
                        sum = sum.add(cell == null ? BigDecimal.ZERO : ConvertUtils.toDecimal((Object)cell.getValue().getValue()));
                        leadKey = this.leadPeriod(membersKey, dimIndexMap, this.getLeadByAnalyseExpr(analyseExpr_new));
                        cell = dataMap.get(leadKey);
                        divider = divider.add(cell == null ? BigDecimal.ZERO : ConvertUtils.toDecimal((Object)cell.getValue().getValue()));
                    }
                    if (sum != null && divider != null && divider.compareTo(BigDecimal.ZERO) != 0) {
                        value = sum.subtract(divider).divide(divider, 15, 4);
                    }
                } else {
                    analyseExpr.getMetas();
                    value = analyseExpr.calc(BgApplyBillUtils.getInstance().getMembersKey(dimMembers, dimensionList), dataMap, dimIndexMap);
                }
            }
        }
lbl63:
        // 6 sources

        fm = (String)formulaMap.get("fm");
        if (value instanceof BigDecimal) {
            isRate = false;
            if (fm.endsWith("%")) {
                value = ((BigDecimal)value).multiply(BigDecimal.TEN.pow(2));
                isRate = true;
            }
            scale = ExecuteAnalyseUtil.getInstance().getScaleByFm(fm);
            value = ((BigDecimal)value).setScale(scale, 4);
            if (isRate) {
                value = ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0 ? null : value + "%";
            }
        }
        return value;
    }

    private boolean relDataColNotHasPerm(AnalyseQueryParameter queryParameter, Map<String, String> dimMembers, Map<Long, SchemeColSetting> colSettingMap, Long colId) {
        if (!queryParameter.isCheckDimPerm()) {
            return false;
        }
        Map formulaRelDataMap = queryParameter.getFormulaRelDataMap();
        if (formulaRelDataMap == null || formulaRelDataMap.size() == 0) {
            return false;
        }
        List refDataColIds = (List)formulaRelDataMap.get(colId);
        if (refDataColIds == null || refDataColIds.size() == 0) {
            return false;
        }
        Map notHasPermColTypes = queryParameter.getNotHasPermColTypes();
        if (notHasPermColTypes == null) {
            return false;
        }
        String colMember = dimMembers.get(queryParameter.getColDimKey());
        for (Long refDataColId : refDataColIds) {
            AnalysePreColType preColType;
            SchemeColSetting schemeColSetting = colSettingMap.get(refDataColId);
            if (schemeColSetting == null || (preColType = AnalysePreColType.getColByNumber((String)schemeColSetting.getNumber())) == null) continue;
            List analysePreColTypes = (List)notHasPermColTypes.get("#");
            if (analysePreColTypes != null && analysePreColTypes.contains(preColType)) {
                return true;
            }
            if (colMember == null) {
                colMember = "amountRange";
            }
            if ((analysePreColTypes = (List)notHasPermColTypes.get(colMember)) == null || !analysePreColTypes.contains(preColType)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getLeadByAnalyseExpr(IAnalyseExpr analyseExpr) {
        Map leads = new HashMap(16);
        if (analyseExpr instanceof YearOnYear) {
            leads = ((YearOnYear)analyseExpr).getLeads();
        } else if (analyseExpr instanceof MonthOnMonth) {
            leads = ((MonthOnMonth)analyseExpr).getLeads();
        }
        return leads;
    }

    private MembersKey leadPeriod(MembersKey currKey, Map<String, Integer> dimIndexMap, Map<String, String> leads) {
        if (currKey == null || dimIndexMap == null) {
            return null;
        }
        Integer index = dimIndexMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (index == null) {
            log.warn("YearOnYear calc error. periodIndex is null.");
            return null;
        }
        int periodIndex = index + 1;
        Object[] metas = currKey.getKeys();
        if (metas != null && metas.length > periodIndex) {
            Object[] clone = new Object[metas.length];
            System.arraycopy(metas, 0, clone, 0, metas.length);
            String leadPeriod = leads.get(metas[periodIndex]);
            if (leadPeriod != null) {
                clone[periodIndex] = leadPeriod;
                return new MembersKey(clone);
            }
        }
        return null;
    }

    private Map<String, Object> getAllVariables(Object[] analyseData, String controlKey, AnalyseQueryParameter queryParameter, Map<Long, SchemeColSetting> colSettingMap) {
        HashMap<String, Object> variableMap = new HashMap<String, Object>(16);
        Map colKeys = queryParameter.getColKeys();
        List colKeyList = queryParameter.getColKeyList();
        for (Map.Entry<Long, SchemeColSetting> entry : colSettingMap.entrySet()) {
            Object value;
            Long pkId = entry.getKey();
            SchemeColSetting schemeColSetting = entry.getValue();
            String number = schemeColSetting.getNumber();
            String replaceKey = controlKey.replace((CharSequence)colKeys.get(controlKey), number);
            int index = colKeyList.indexOf(replaceKey);
            if (index == -1 || (value = analyseData[index]) == null || "notPermCell".equals(value.toString())) continue;
            variableMap.put("A" + pkId, value);
        }
        return variableMap;
    }

    public void dealOtherCols(AnalyseQueryParameter queryParameter, Object[] analyseData) {
    }

    private void replaceDimRangeByPreColType(AnalyseQueryParameter queryParameter, Map<String, String> memberMap, AnalysePreColType preColType) {
        switch (preColType) {
            case OCCUPY: {
                memberMap.put(SysDimensionEnum.ChangeType.getNumber(), "Occupation");
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                memberMap.put(SysDimensionEnum.DataType.getNumber(), "Actual");
                memberMap.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
                break;
            }
            case EXECUTE: {
                memberMap.put(SysDimensionEnum.ChangeType.getNumber(), "Execute");
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                memberMap.put(SysDimensionEnum.DataType.getNumber(), "Actual");
                memberMap.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
                break;
            }
            case INIT_ACTUAL: {
                memberMap.put(SysDimensionEnum.ChangeType.getNumber(), "ActualChanges");
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
                memberMap.put(SysDimensionEnum.DataType.getNumber(), "Actual");
                memberMap.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
                break;
            }
            case BUD_OCCUPY: {
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation");
                break;
            }
            case TOTAL_ADJUST: 
            case TOTAL_ADJUST_ADJUST: {
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), queryParameter.getAdjustAuditTrail());
                break;
            }
            case TOTAL_ADJUST_ADJPST: {
                memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), queryParameter.getAdjpstAuditTrail());
                break;
            }
        }
    }

    public void replaceDimRangeByPreColType(AnalyseQueryParameter queryParameter, Map<String, MemberItem> memberMap, AnalysePreColType preColType, IModelCacheHelper modelCacheHelper) {
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        switch (preColType) {
            case CONTROL_OCCUPY: 
            case OCCUPY: {
                this.addMember(SysDimensionEnum.ChangeType.getNumber(), "Occupation", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.DataType.getNumber(), "Actual", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.Version.getNumber(), "ACTUAL", memberMap, modelCacheHelper, viewMap);
                break;
            }
            case CONTROL_EXECUTE: 
            case EXECUTE: {
                this.addMember(SysDimensionEnum.ChangeType.getNumber(), "Execute", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.DataType.getNumber(), "Actual", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.Version.getNumber(), "ACTUAL", memberMap, modelCacheHelper, viewMap);
                break;
            }
            case INIT_ACTUAL: {
                this.addMember(SysDimensionEnum.ChangeType.getNumber(), "ActualChanges", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.DataType.getNumber(), "Actual", memberMap, modelCacheHelper, viewMap);
                this.addMember(SysDimensionEnum.Version.getNumber(), "ACTUAL", memberMap, modelCacheHelper, viewMap);
                break;
            }
            case BUD_OCCUPY: {
                this.addMember(SysDimensionEnum.AuditTrail.getNumber(), "BudgetOccupation", memberMap, modelCacheHelper, viewMap);
                break;
            }
            case TOTAL_ADJUST: 
            case TOTAL_ADJUST_ADJUST: {
                this.addMember(SysDimensionEnum.AuditTrail.getNumber(), queryParameter.getAdjustAuditTrail(), memberMap, modelCacheHelper, viewMap);
                break;
            }
            case TOTAL_ADJUST_ADJPST: {
                this.addMember(SysDimensionEnum.AuditTrail.getNumber(), queryParameter.getAdjpstAuditTrail(), memberMap, modelCacheHelper, viewMap);
                break;
            }
        }
    }

    private void addMember(String dimKey, String member, Map<String, MemberItem> memberMap, IModelCacheHelper modelCacheHelper, Map<String, Long> viewMap) {
        Member mem = modelCacheHelper.getMember(dimKey, viewMap.get(dimKey), member);
        if (mem != null) {
            memberMap.put(dimKey, new MemberItem(true, mem.getId()));
        }
    }

    private Map<String, String> addColDimMember(AnalyseQueryParameter queryParameter, String controlKey, Map<String, String> dimMembers, String colDimKey) {
        HashMap<String, String> memberMap = new HashMap<String, String>(dimMembers);
        AnalyseColTypeGroup analyseColTypeGroup = queryParameter.getAnalyseColTypeGroup();
        String colMember = (String)analyseColTypeGroup.getColMemberMap().get(controlKey);
        memberMap.put(colDimKey, (String)queryParameter.getColKeys().get(colMember));
        return memberMap;
    }

    public boolean isDimensionCol(String dimKey, IModelCacheHelper modelCacheHelper) {
        if (dimKey == null) {
            return false;
        }
        return modelCacheHelper.getDimension(dimKey) != null;
    }

    public void addPageDims(Map<String, Set<String>> queryInfo, AnalyseQueryParameter queryParameter) {
        List pageDimKeys = queryParameter.getPageDimKeys();
        Map dimMembers = queryParameter.getDimMembers();
        for (String pageDimKey : pageDimKeys) {
            Set<String> members = queryInfo.get(pageDimKey);
            if (members.size() == 0) continue;
            dimMembers.put(pageDimKey, members.iterator().next());
        }
    }

    private void addDimMember(AnalyseQueryParameter queryParameter, Object[] curData, Map<MembersKey, IKDCell> dataMap, List<Set<String>> dataKeyList, Map<Long, SchemeColSetting> colSettingMap, List<IDataRow> dataRows, int dimSize) {
        List rowDimKeys = queryParameter.getRowDimKeys();
        int size = rowDimKeys.size() - 1;
        String rowDimKey = (String)rowDimKeys.get(dimSize);
        List memberList = (List)queryParameter.getQueryParam().get(rowDimKey);
        List rowDimControlKeys = queryParameter.getRowDimControlKeys();
        List colKeyList = queryParameter.getColKeyList();
        String controlKey = (String)rowDimControlKeys.get(dimSize);
        int dimIndex = colKeyList.indexOf(controlKey);
        StringBuilder memberKey = new StringBuilder();
        String[] nextPageStartRowMembers = queryParameter.getNextPageStartRowMembers();
        boolean isMatch = false;
        Object[] tmp = new Object[colKeyList.size()];
        for (String memberNumber : memberList) {
            if (nextPageStartRowMembers != null && !isMatch && this.isPreMemberSame(curData, nextPageStartRowMembers, rowDimControlKeys, colKeyList, dimSize) && !nextPageStartRowMembers[dimSize].equals(memberNumber)) continue;
            isMatch = true;
            if (curData != null) {
                System.arraycopy(curData, 0, tmp, 0, curData.length);
            } else {
                Arrays.fill(tmp, null);
            }
            tmp[dimIndex] = memberNumber;
            if (!this.existOlapData(tmp, queryParameter, rowDimControlKeys, colKeyList, dataKeyList, memberKey, true, dimSize) && this.isNotNextSplitExistData(queryParameter, null, dataMap, dataKeyList, tmp, memberKey, dimSize)) continue;
            if (dimSize < size) {
                this.addDimMember(queryParameter, tmp, dataMap, dataKeyList, colSettingMap, dataRows, dimSize + 1);
                if (!this.isQueryFinish(queryParameter, queryParameter.getAnalyseData().size())) continue;
                return;
            }
            if (dimSize != size) continue;
            queryParameter.increaseRangeCount();
            this.fillOtherData(queryParameter, tmp, dataMap, colSettingMap, dataRows, true);
            if (!this.isQueryFinish(queryParameter, queryParameter.getAnalyseData().size())) continue;
            return;
        }
    }

    public boolean isNotNextSplitExistData(AnalyseQueryParameter queryParameter, AnalyseExportParameter exportParameter, Map<MembersKey, IKDCell> dataMap, List<Set<String>> dataKeyList, Object[] analyseData, StringBuilder memberKey, int dimSize) {
        if (queryParameter.getMaxQueryData() == 0 || !queryParameter.isNeedSplit()) {
            return true;
        }
        int curRangeCount = queryParameter.getCurRangeCount();
        this.updateRangeCount(1, queryParameter, dimSize);
        while (this.reQueryOlap(queryParameter, exportParameter, dataMap, dataKeyList)) {
            if (!this.existOlapData(analyseData, queryParameter, queryParameter.getRowDimControlKeys(), queryParameter.getColKeyList(), dataKeyList, memberKey, false, dimSize)) continue;
            queryParameter.setCurRangeCount(curRangeCount);
            return false;
        }
        return true;
    }

    private void updateRangeCount(int increaseSize, AnalyseQueryParameter queryParameter, int dimSize) {
        List rowDimKeys = queryParameter.getRowDimKeys();
        int size = rowDimKeys.size() - 1;
        if (dimSize != size) {
            Map queryParam = queryParameter.getQueryParam();
            for (int i = dimSize + 1; i <= size; ++i) {
                increaseSize *= ((List)queryParam.get(rowDimKeys.get(i))).size();
            }
        }
        queryParameter.setCurRangeCount(queryParameter.getCurRangeCount() + increaseSize);
    }

    public boolean existOlapData(Object[] analyseData, AnalyseQueryParameter queryParameter, List<String> rowDimControlKeys, List<String> colKeyList, List<Set<String>> dataKeyList, StringBuilder memberKey, boolean buildKey, int dimSize) {
        if (buildKey) {
            memberKey.setLength(0);
            for (int i = 0; i <= dimSize; ++i) {
                String rowDimControlKey = rowDimControlKeys.get(i);
                if (memberKey.length() != 0) {
                    memberKey.append("!");
                }
                memberKey.append(this.getDimMemberFromObjectArray(analyseData, rowDimControlKey, colKeyList));
            }
        }
        String memberKeyString = memberKey.toString();
        if (dataKeyList.size() <= dimSize) {
            return false;
        }
        Set<String> dataKeys = dataKeyList.get(dimSize);
        if (dataKeys.contains(memberKeyString)) {
            return true;
        }
        int index = queryParameter.getRowDimKeys().indexOf(SysDimensionEnum.Account.getNumber());
        if (index != -1 && dimSize >= index) {
            String account = this.getDimMemberFromObjectArray(analyseData, rowDimControlKeys.get(index), colKeyList);
            if (queryParameter.getExceptAccounts().contains(account)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPreMemberSame(String[] curRange, String[] nextPageStartRowMembers, int dimSize) {
        if (dimSize == 0) {
            return true;
        }
        for (int i = 0; i < dimSize; ++i) {
            if (curRange[i].equals(nextPageStartRowMembers[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isPreMemberSame(Object[] analyseMap, String[] nextPageStartRowMembers, List<String> controlKeys, List<String> colKeyList, int dimSize) {
        if (dimSize == 0) {
            return true;
        }
        for (int i = 0; i < dimSize; ++i) {
            if (nextPageStartRowMembers[i].equals(this.getDimMemberFromObjectArray(analyseMap, controlKeys.get(i), colKeyList))) continue;
            return false;
        }
        return true;
    }

    public List<String> getRowDimControlKeys(List<String> rowDimKeys, Map<String, String> colKeys) {
        ExecuteAnalyseUtil instance = ExecuteAnalyseUtil.getInstance();
        return rowDimKeys.stream().map(e -> instance.getControlKey((String)e, colKeys)).collect(Collectors.toList());
    }

    public Map<String, String> getRowDimControlKeyMap(List<String> rowDimKeys, Map<String, String> colKeys) {
        ExecuteAnalyseUtil instance = ExecuteAnalyseUtil.getInstance();
        return rowDimKeys.stream().collect(Collectors.toMap(e -> instance.getControlKey((String)e, colKeys), e -> e, (n1, n2) -> n1));
    }

    private boolean isQueryFinish(AnalyseQueryParameter queryParameter, int analyseDataSize) {
        int maxQueryData = queryParameter.getMaxQueryData();
        if (queryParameter.isShowEmpty() && queryParameter.getCurRangeCount() == maxQueryData * queryParameter.getPageIndex()) {
            return true;
        }
        return maxQueryData != 0 && analyseDataSize == maxQueryData;
    }

    public boolean reQueryOlap(AnalyseQueryParameter queryParameter, AnalyseExportParameter exportParameter, Map<MembersKey, IKDCell> dataMap, List<Set<String>> dataKeyList) {
        HashMap<String, Set<String>> queryParam = new HashMap<String, Set<String>>(16);
        int curQueryDataCount = queryParameter.getCurQueryDataCount();
        if (queryParameter.getMaxQueryData() != 0 && queryParameter.isNeedSplit()) {
            int curRangeCount = queryParameter.getCurRangeCount();
            List splitDimRanges = queryParameter.getSplitDimRanges();
            if (curQueryDataCount >= 0 && curRangeCount < this.getRangeSize(queryParameter, (SplitDimRange)splitDimRanges.get(curQueryDataCount), 0)) {
                return false;
            }
            dataMap.clear();
            dataKeyList.clear();
            if (++curQueryDataCount >= splitDimRanges.size()) {
                return false;
            }
            SplitDimRange splitDimRange = (SplitDimRange)splitDimRanges.get(curQueryDataCount);
            List rowDimKeys = queryParameter.getRowDimKeys();
            queryParameter.getQueryParam().forEach((key, value) -> {
                int index = rowDimKeys.indexOf(key);
                if (index == -1) {
                    queryParam.put((String)key, new HashSet(value));
                } else {
                    Set<String> rangeMembers = this.getSplitDimRange((List<String>)value, splitDimRange.getMemberRange(index));
                    if (exportParameter != null && key.equals(exportParameter.getMainDimKey())) {
                        Map firstRowMemberMap = exportParameter.getFirstRowMemberMap();
                        HashSet<String> tmp = new HashSet<String>(rangeMembers);
                        tmp.forEach(e -> rangeMembers.addAll((Collection)firstRowMemberMap.get(e)));
                    }
                    queryParam.put((String)key, rangeMembers);
                }
            });
            queryParameter.setCurQueryDataCount(curQueryDataCount);
        } else {
            if (curQueryDataCount != -1) {
                return false;
            }
            queryParameter.getQueryParam().forEach((key, value) -> {
                if (exportParameter != null && key.equals(exportParameter.getMainDimKey())) {
                    List toReplaceQueryMembers = exportParameter.getToReplaceQueryMembers();
                    queryParam.put((String)key, new HashSet(toReplaceQueryMembers));
                } else {
                    queryParam.put((String)key, new HashSet(value));
                }
            });
            queryParameter.setCurQueryDataCount(++curQueryDataCount);
        }
        this.dealQueryParam(queryParam, queryParameter);
        if (this.isAllDimExistMember(queryParam)) {
            dataMap.putAll(BgApplyBillUtils.getInstance().queryOlapData_new(queryParameter.getModelCacheHelper(), queryParameter.getModelId(), queryParameter.getDatasetId(), queryParam, dataKeyList, queryParameter.getRowDimKeys()));
        }
        log.info("AnalyseBudgetQueryService --- queryOlapData(" + curQueryDataCount + "): " + dataMap.size());
        return true;
    }

    private Set<String> getSplitDimRange(List<String> members, SplitMemberRange memberRange) {
        HashSet<String> members_new = new HashSet<String>(16);
        if (memberRange.isContainAll()) {
            members_new.addAll(members);
        } else {
            int end;
            int start = memberRange.getStart();
            if (start <= (end = memberRange.getEnd())) {
                if (start < 0) {
                    log.info("AnalyseBudgetQueryService_errorMemberRange: " + memberRange.getStart() + ";" + memberRange.getEnd() + ";" + memberRange.isContainAll());
                    start = 0;
                }
                for (int i = start; i <= end; ++i) {
                    members_new.add(members.get(i));
                }
            } else {
                for (int i = 0; i < members.size(); ++i) {
                    if (i > end && i < start) continue;
                    members_new.add(members.get(i));
                }
            }
        }
        return members_new;
    }

    private String getDimMemberFromObjectArray(Object[] array, String controlKey, List<String> colKeyList) {
        int index = colKeyList.indexOf(controlKey);
        if (index == -1 || index >= array.length) {
            return null;
        }
        return array[index].toString();
    }

    public Map<String, Object[]> convertMap(List<Object[]> analyseData, AnalyseQueryParameter queryParameter) {
        if (analyseData.size() == 0) {
            return new HashMap<String, Object[]>(16);
        }
        HashMap<String, Object[]> analyseDataMap = new HashMap<String, Object[]>(16);
        List rowDimControlKeys = queryParameter.getRowDimControlKeys();
        analyseData.forEach(e -> {
            List collect = rowDimControlKeys.stream().map(k -> this.getDimMemberFromObjectArray((Object[])e, (String)k, queryParameter.getColKeyList())).collect(Collectors.toList());
            analyseDataMap.put(String.join((CharSequence)"!", collect), (Object[])e);
        });
        return analyseDataMap;
    }

    public String getCtlKey(Map<String, String> memberMap, List<String> controlDimensions) {
        StringBuilder ctrlKey = new StringBuilder();
        for (String controlDimension : controlDimensions) {
            String member = memberMap.get(controlDimension);
            if (member == null) {
                member = controlDimension;
            }
            ctrlKey.append(controlDimension).append("_").append(member).append("!");
        }
        return ctrlKey.toString();
    }

    public String getCtlKey(IBudgetBalance balance, List<String> controlDimensions) {
        StringBuilder ctrlKey = new StringBuilder();
        for (String controlDimension : controlDimensions) {
            String member = balance.getMember(true, controlDimension).getNumber();
            ctrlKey.append(controlDimension).append("_").append(member).append("!");
        }
        return ctrlKey.toString();
    }

    public void getControlDimensions(AnalyseQueryParameter queryParameter) {
        queryParameter.setControlDimensions(this.getControlDimensions(queryParameter.getDimensionList(), queryParameter.getModelId(), queryParameter.getBizModelId()));
    }

    public List<String> getControlDimensions(String[] dimensionList, Long modelId, Long bizModelId) {
        List<String> controlDimensions = new ArrayList<String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("businessmodel", "=", (Object)bizModelId));
        DynamicObjectCollection ctrlDims = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)"entryentity.dimensionid as dimId", (QFilter[])builder.toArrays());
        Set ctrlDimensions = ctrlDims.stream().map(e -> e.getLong("dimId")).collect(Collectors.toSet());
        for (String dimensionNumber : dimensionList) {
            Dimension dimension = modelCacheHelper.getDimension(dimensionNumber);
            if (!ctrlDimensions.contains(dimension.getId())) continue;
            controlDimensions.add(dimension.getNumber());
        }
        if (controlDimensions.size() == 0) {
            controlDimensions = Arrays.asList(dimensionList);
        }
        return controlDimensions;
    }

    public List<String> getControlDimensions(Long modelId, Long bizModelId, Long datasetId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String[] dimensionNums = modelCacheHelper.getDimensionNums(datasetId);
        return this.getControlDimensions(dimensionNums, modelId, bizModelId);
    }

    public List<String> getControlDimensions(Long modelId, Long datasetId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        return this.getControlDimensions(modelId, modelCacheHelper.getBusModelByDataSet(datasetId), datasetId);
    }

    public int getRangeSize(AnalyseQueryParameter queryParameter, SplitDimRange range, int index) {
        return this.getRangeSize(queryParameter, range, index, null, null);
    }

    public int getRangeSize(AnalyseQueryParameter queryParameter, SplitDimRange range, int index, Map<String, Integer> memberSumMap, List<String> firstDimMemberList) {
        if (range == null) {
            return 0;
        }
        List memberRanges = range.getMemberRanges();
        if (index >= memberRanges.size()) {
            return 0;
        }
        SplitMemberRange splitMemberRange = (SplitMemberRange)memberRanges.get(index);
        int subtract = splitMemberRange.getEnd();
        if (index == 0) {
            if (splitMemberRange.isContainAll()) {
                subtract = ((List)queryParameter.getQueryParam().get(queryParameter.getRowDimKeys().get(0))).size();
            }
            if (memberSumMap != null && firstDimMemberList != null) {
                int sumCount = splitMemberRange.getEnd();
                if (splitMemberRange.isContainAll()) {
                    sumCount = firstDimMemberList.size();
                }
                subtract = 0;
                for (int i = 0; i < sumCount; ++i) {
                    subtract += memberSumMap.getOrDefault(firstDimMemberList.get(i), 0).intValue();
                }
            }
        }
        int loopSize = 0;
        if (subtract != 0) {
            loopSize = subtract * this.getNextAllDimMemberSize(queryParameter, index + 1);
        }
        return loopSize += this.getRangeSize(queryParameter, range, index + 1);
    }

    public int getNextAllDimMemberSize(AnalyseQueryParameter queryParameter, int index) {
        List rowDimKeys = queryParameter.getRowDimKeys();
        if (index >= rowDimKeys.size()) {
            return 1;
        }
        Map queryParam = queryParameter.getQueryParam();
        return ((List)queryParam.get(rowDimKeys.get(index))).size() * this.getNextAllDimMemberSize(queryParameter, index + 1);
    }

    public boolean isAllDimExistMember(Map<String, Set<String>> queryParam) {
        for (Map.Entry<String, Set<String>> entry : queryParam.entrySet()) {
            if (entry.getValue().size() != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isAllDimExistMember(AnalyseQueryParameter queryParameter) {
        String[] dimensionList;
        Map queryParam = queryParameter.getQueryParam();
        for (Map.Entry entry : queryParam.entrySet()) {
            String dimKey = (String)entry.getKey();
            if (ExecAnalyseConstant.NOT_REMOVE_PAGE_DIMS.contains(dimKey) || ((List)entry.getValue()).size() != 0) continue;
            return false;
        }
        DimMemberPermChecker checker = DimMembPermHelper.getReadPermChecker((Long)queryParameter.getModelId(), (Long)queryParameter.getDatasetId());
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        for (String dimension : dimensionList = queryParameter.getDimensionList()) {
            if (queryParam.containsKey(dimension)) continue;
            String member = dimension;
            Dimension dim = modelCacheHelper.getDimension(dimension);
            if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension)) {
                member = dim.getNoneNumber();
            }
            HashMap<String, MemberItem> memberMap = new HashMap<String, MemberItem>(16);
            Member mem = dim.getMember((Long)viewMap.get(dimension), member);
            if (mem == null) continue;
            memberMap.put(dimension, new MemberItem(true, mem.getId()));
            boolean hasPerm = checker.check(memberMap);
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    public Set<String> matchNeedCheckPermDims(List<PermDimGroup> permControlDimGroup, Collection<String> dimKeys) {
        HashSet<String> matchedDims = new HashSet<String>(16);
        for (PermDimGroup permDimGroup : permControlDimGroup) {
            List dimNums = permDimGroup.getDimNums();
            if (!CollectionUtils.containsAny((Collection)dimNums, dimKeys)) continue;
            matchedDims.addAll(dimNums);
        }
        HashSet tmp = new HashSet(matchedDims);
        tmp.removeAll(dimKeys);
        if (tmp.size() != 0) {
            matchedDims.clear();
        }
        return matchedDims;
    }

    public boolean isAllColNotHasPerm(String colMember, AnalyseQueryParameter queryParameter) {
        Map notHasPermColTypeMap = queryParameter.getNotHasPermColTypes();
        if (notHasPermColTypeMap == null || notHasPermColTypeMap.size() == 0) {
            return false;
        }
        List notHasPermColTypes = (List)notHasPermColTypeMap.get(colMember);
        if (notHasPermColTypes == null || notHasPermColTypes.size() == 0) {
            return false;
        }
        List colSettings = queryParameter.getColSettings();
        block4: for (SchemeColSetting colSetting : colSettings) {
            String settingNumber;
            AnalysePreColType colType;
            if (!colSetting.getShow().booleanValue() || SchemeColType.FORMULA == colSetting.getColType() || (colType = AnalysePreColType.getColByNumber((String)(settingNumber = colSetting.getNumber()))) == null) continue;
            switch (colType) {
                case ACTUAL: {
                    if (notHasPermColTypes.contains(AnalysePreColType.OCCUPY) || notHasPermColTypes.contains(AnalysePreColType.EXECUTE) || notHasPermColTypes.contains(AnalysePreColType.INIT_ACTUAL)) continue block4;
                    return false;
                }
                case BUD_ACT_RATE: 
                case BALANCE: {
                    if (notHasPermColTypes.contains(AnalysePreColType.BUDGET) || notHasPermColTypes.contains(AnalysePreColType.OCCUPY) || notHasPermColTypes.contains(AnalysePreColType.EXECUTE) || notHasPermColTypes.contains(AnalysePreColType.INIT_ACTUAL)) continue block4;
                    return false;
                }
            }
            if (notHasPermColTypes.contains(colType)) continue;
            return false;
        }
        Set refColTypes = queryParameter.getRefColTypes();
        return refColTypes == null || this.containsAllPreTypes(notHasPermColTypes, refColTypes);
    }

    private boolean containsAllPreTypes(List<AnalysePreColType> notHasPermColTypes, Set<AnalysePreColType> refColTypes) {
        for (AnalysePreColType refColType : refColTypes) {
            if (notHasPermColTypes.contains(refColType) || AnalysePreColType.ACTUAL == refColType && notHasPermColTypes.contains(AnalysePreColType.OCCUPY) && notHasPermColTypes.contains(AnalysePreColType.EXECUTE) && notHasPermColTypes.contains(AnalysePreColType.INIT_ACTUAL)) continue;
            return false;
        }
        return true;
    }

    public boolean filterPageDimPerm(AnalyseQueryParameter queryParameter) {
        if (!queryParameter.isCheckDimPerm()) {
            return false;
        }
        ArrayList<AnalysePreColType> notHasPermColTypes = new ArrayList<AnalysePreColType>(16);
        this.dealSingleMemberPerm(queryParameter, notHasPermColTypes);
        notHasPermColTypes.forEach(e -> queryParameter.addNotHasPermColType("#", e));
        List permControlDimGroup = DimMembPermUtil.getPermControlDimGroup((Long)queryParameter.getModelId(), (Long)queryParameter.getBizModelId());
        if (permControlDimGroup.size() == 0) {
            return true;
        }
        queryParameter.setPermDimGroups(permControlDimGroup);
        Map queryParam = queryParameter.getQueryParam();
        ArrayList<String> pageDimKeys = new ArrayList<String>(queryParameter.getPageDimKeys());
        this.addCustomDims(pageDimKeys, queryParameter, queryParam);
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        Set<String> matchedDims = instance.matchNeedCheckPermDims(permControlDimGroup, pageDimKeys);
        queryParameter.setHasCheckedPermDims(matchedDims);
        if (matchedDims.size() == 0) {
            return false;
        }
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        HashMap pageDimMembers = new HashMap(16);
        queryParameter.getPageDimKeys().forEach(e -> {
            Dimension dimension = modelCacheHelper.getDimension(e);
            Member member = dimension.getMember((Long)viewMap.get(e), (String)((List)queryParam.get(e)).get(0));
            if (member != null) {
                pageDimMembers.put(e, new MemberItem(true, member.getId()));
            }
        });
        pageDimKeys.forEach(e -> {
            if (!pageDimMembers.containsKey(e)) {
                Member member;
                Dimension dimension = modelCacheHelper.getDimension(e);
                String memberNumber = e;
                if (SysDimensionEnum.InternalCompany.getNumber().equals(e)) {
                    memberNumber = dimension.getNoneNumber();
                }
                if ((member = dimension.getMember((Long)viewMap.get(e), memberNumber)) != null) {
                    pageDimMembers.put(e, new MemberItem(true, member.getId()));
                }
            }
        });
        DimMemberPermChecker checker = DimMembPermHelper.getPermChecker((Long)queryParameter.getModelId(), (Long)queryParameter.getBizModelId(), new ArrayList<String>(matchedDims), (Long)UserUtils.getUserId(), (DimMembPermType)DimMembPermType.READ);
        for (AnalysePreColType preColType : AnalysePreColType.values()) {
            if (!preColType.getCheckPerm().booleanValue() || notHasPermColTypes.contains(preColType)) continue;
            HashMap<String, MemberItem> tmp = new HashMap<String, MemberItem>(pageDimMembers);
            instance.replaceDimRangeByPreColType(queryParameter, tmp, preColType, modelCacheHelper);
            boolean check = checker.check(tmp);
            if (check) continue;
            queryParameter.addNotHasPermColType("#", preColType);
        }
        return true;
    }

    private void dealSingleMemberPerm(AnalyseQueryParameter queryParameter, List<AnalysePreColType> notHasPermColTypes) {
        HashMap<String, Map<String, List<AnalysePreColType>>> checkMemberRefTypes = new HashMap<String, Map<String, List<AnalysePreColType>>>(16);
        HashMap<String, List<AnalysePreColType>> refTypes = new HashMap<String, List<AnalysePreColType>>(16);
        refTypes.put("Occupation", Arrays.asList(AnalysePreColType.OCCUPY, AnalysePreColType.CONTROL_OCCUPY));
        refTypes.put("Execute", Arrays.asList(AnalysePreColType.EXECUTE, AnalysePreColType.CONTROL_EXECUTE));
        refTypes.put("ActualChanges", Collections.singletonList(AnalysePreColType.INIT_ACTUAL));
        checkMemberRefTypes.put(SysDimensionEnum.ChangeType.getNumber(), refTypes);
        refTypes = new HashMap(16);
        String adjustAuditTrail = queryParameter.getAdjustAuditTrail();
        ArrayList types = Lists.newArrayList((Object[])new AnalysePreColType[]{AnalysePreColType.OCCUPY, AnalysePreColType.CONTROL_OCCUPY, AnalysePreColType.EXECUTE, AnalysePreColType.CONTROL_EXECUTE, AnalysePreColType.INIT_ACTUAL});
        if (adjustAuditTrail.equals("EntityInput")) {
            types.add(AnalysePreColType.TOTAL_ADJUST);
        }
        refTypes.put("EntityInput", types);
        types = Lists.newArrayList((Object[])new AnalysePreColType[]{AnalysePreColType.BUD_OCCUPY});
        if (adjustAuditTrail.equals("BudgetOccupation")) {
            types.add(AnalysePreColType.TOTAL_ADJUST);
        }
        refTypes.put("BudgetOccupation", types);
        checkMemberRefTypes.put(SysDimensionEnum.AuditTrail.getNumber(), refTypes);
        refTypes = new HashMap(16);
        refTypes.put("Actual", Arrays.asList(AnalysePreColType.OCCUPY, AnalysePreColType.CONTROL_OCCUPY, AnalysePreColType.EXECUTE, AnalysePreColType.CONTROL_EXECUTE, AnalysePreColType.INIT_ACTUAL));
        checkMemberRefTypes.put(SysDimensionEnum.DataType.getNumber(), refTypes);
        refTypes = new HashMap(16);
        refTypes.put("ACTUAL", Arrays.asList(AnalysePreColType.OCCUPY, AnalysePreColType.CONTROL_OCCUPY, AnalysePreColType.EXECUTE, AnalysePreColType.CONTROL_EXECUTE, AnalysePreColType.INIT_ACTUAL));
        checkMemberRefTypes.put(SysDimensionEnum.Version.getNumber(), refTypes);
        this.checkSingleMemberPerm(queryParameter, checkMemberRefTypes, notHasPermColTypes);
    }

    private void checkSingleMemberPerm(AnalyseQueryParameter queryParameter, Map<String, Map<String, List<AnalysePreColType>>> checkMemberRefTypes, List<AnalysePreColType> notHasPermColTypes) {
        if (checkMemberRefTypes == null || checkMemberRefTypes.size() == 0) {
            return;
        }
        Map dimPermMap = queryParameter.getDimPermMap();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        for (Map.Entry<String, Map<String, List<AnalysePreColType>>> checkMemberRefType : checkMemberRefTypes.entrySet()) {
            String dimKey = checkMemberRefType.getKey();
            Set memberIds = (Set)dimPermMap.get(dimKey);
            if (memberIds == null) continue;
            Map<String, List<AnalysePreColType>> refTypes = checkMemberRefType.getValue();
            for (Map.Entry<String, List<AnalysePreColType>> refType : refTypes.entrySet()) {
                Long id;
                Member member;
                String memberNum = refType.getKey();
                List<AnalysePreColType> types = refType.getValue();
                if (notHasPermColTypes.containsAll(types) || (member = modelCacheHelper.getMember(dimKey, (Long)viewMap.get(dimKey), memberNum)) == null || memberIds.contains(id = member.getId())) continue;
                for (AnalysePreColType type : types) {
                    if (notHasPermColTypes.contains(type)) continue;
                    notHasPermColTypes.add(type);
                }
            }
        }
    }

    public void filterColDimPerm(AnalyseQueryParameter queryParameter, boolean needShowTotal) {
        if (!queryParameter.isCheckDimPerm()) {
            return;
        }
        List permDimGroups = queryParameter.getPermDimGroups();
        if (permDimGroups == null || permDimGroups.size() == 0) {
            return;
        }
        List pageDimKeys = queryParameter.getPageDimKeys();
        ArrayList<String> toCheckDims = new ArrayList<String>(pageDimKeys);
        String colDimKey = queryParameter.getColDimKey();
        toCheckDims.add(colDimKey);
        this.addCustomDims(toCheckDims, queryParameter, queryParameter.getQueryParam());
        AnalyseBudgetQueryService instance = AnalyseBudgetQueryService.getInstance();
        Set<String> matchedDims = instance.matchNeedCheckPermDims(permDimGroups, toCheckDims);
        if (matchedDims.size() == 0) {
            return;
        }
        Set hasCheckedPermDims = queryParameter.getHasCheckedPermDims();
        if (hasCheckedPermDims != null && matchedDims.containsAll(hasCheckedPermDims) && hasCheckedPermDims.containsAll(matchedDims)) {
            return;
        }
        queryParameter.setHasCheckedPermDims(matchedDims);
        Map queryParam = queryParameter.getQueryParam();
        IModelCacheHelper modelCacheHelper = queryParameter.getModelCacheHelper();
        Map viewMap = modelCacheHelper.getViewsByDataSet(queryParameter.getDatasetId());
        HashMap pageDimMembers = new HashMap(16);
        pageDimKeys.forEach(e -> {
            Dimension dimension = modelCacheHelper.getDimension(e);
            Member member = dimension.getMember((Long)viewMap.get(e), (String)((List)queryParam.get(e)).get(0));
            if (member != null) {
                pageDimMembers.put(e, new MemberItem(true, member.getId()));
            }
        });
        toCheckDims.forEach(e -> {
            if (!pageDimMembers.containsKey(e)) {
                Member member;
                Dimension dimension = modelCacheHelper.getDimension(e);
                String memberNumber = e;
                if (SysDimensionEnum.InternalCompany.getNumber().equals(e)) {
                    memberNumber = dimension.getNoneNumber();
                }
                if ((member = dimension.getMember((Long)viewMap.get(e), memberNumber)) != null) {
                    pageDimMembers.put(e, new MemberItem(true, member.getId()));
                }
            }
        });
        DimMemberPermChecker checker = DimMembPermHelper.getPermChecker((Long)queryParameter.getModelId(), (Long)queryParameter.getBizModelId(), new ArrayList<String>(matchedDims), (Long)UserUtils.getUserId(), (DimMembPermType)DimMembPermType.READ);
        ArrayList<AnalysePreColType[]> toRemoveColMembers = new ArrayList<AnalysePreColType[]>(16);
        List colMembers = (List)queryParam.get(colDimKey);
        for (AnalysePreColType[] colMember : colMembers) {
            HashMap<String, MemberItem> colDimMembers = new HashMap<String, MemberItem>(pageDimMembers);
            Member cacheHelperMember = modelCacheHelper.getMember(colDimKey, (Long)viewMap.get(colDimKey), (String)colMember);
            if (cacheHelperMember == null) continue;
            colDimMembers.put(colDimKey, new MemberItem(true, cacheHelperMember.getId()));
            for (AnalysePreColType preColType : AnalysePreColType.values()) {
                if (!preColType.getCheckPerm().booleanValue()) continue;
                HashMap<String, MemberItem> tmp = new HashMap<String, MemberItem>(pageDimMembers);
                instance.replaceDimRangeByPreColType(queryParameter, tmp, preColType, modelCacheHelper);
                boolean check = checker.check(tmp);
                if (check) continue;
                queryParameter.addNotHasPermColType((String)colMember, preColType);
            }
            if (!instance.isAllColNotHasPerm((String)colMember, queryParameter)) continue;
            toRemoveColMembers.add(colMember);
        }
        colMembers.removeAll(toRemoveColMembers);
        if (!needShowTotal) {
            return;
        }
        Set amountPeriods = queryParameter.getAmountPeriods();
        for (AnalysePreColType preColType : AnalysePreColType.values()) {
            if (!preColType.getCheckPerm().booleanValue()) continue;
            HashSet<String> notHasPermPeriods = new HashSet<String>(16);
            HashMap<String, MemberItem> tmp = new HashMap<String, MemberItem>(pageDimMembers);
            instance.replaceDimRangeByPreColType(queryParameter, tmp, preColType, modelCacheHelper);
            for (String amountPeriod : amountPeriods) {
                tmp.put(colDimKey, new MemberItem(true, modelCacheHelper.getMember(colDimKey, (Long)viewMap.get(colDimKey), amountPeriod).getId()));
                boolean check = checker.check(tmp);
                if (check) continue;
                notHasPermPeriods.add(amountPeriod);
                queryParameter.addNotHasPermColType(amountPeriod, preColType);
            }
            if (!notHasPermPeriods.containsAll(amountPeriods)) continue;
            queryParameter.addNotHasPermColType("amountRange", preColType);
        }
        HashSet<String> toRemoveAmounts = new HashSet<String>(16);
        for (String amountPeriod : amountPeriods) {
            if (!instance.isAllColNotHasPerm(amountPeriod, queryParameter)) continue;
            toRemoveAmounts.add(amountPeriod);
        }
        amountPeriods.removeAll(toRemoveAmounts);
    }

    private void addCustomDims(List<String> pageDimKeys, AnalyseQueryParameter queryParameter, Map<String, List<String>> queryParam) {
        String[] dimensionList;
        for (String dimension : dimensionList = queryParameter.getDimensionList()) {
            if (queryParam.containsKey(dimension)) continue;
            pageDimKeys.add(dimension);
        }
    }

    public String getMinOrMaxPeriodNumber(Object period, IModelCacheHelper modelCacheHelper, boolean isMin) {
        Member member;
        String memberNumber;
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u7d2f\u8ba1\u6570\u8303\u56f4\u3002", (String)"ExecuteAnalyseReportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (period instanceof DynamicObject) {
            DynamicObject periodDynamic = (DynamicObject)period;
            boolean isLeaf = periodDynamic.getBoolean("isleaf");
            if (isLeaf) {
                return periodDynamic.getString("number");
            }
            memberNumber = periodDynamic.getString("number");
        } else if (period instanceof String) {
            member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, period.toString());
            if (member.isLeaf()) {
                return member.getNumber();
            }
            memberNumber = member.getNumber();
        } else if (period instanceof Member) {
            member = (Member)period;
            if (member.isLeaf()) {
                return member.getNumber();
            }
            memberNumber = member.getNumber();
        } else {
            return null;
        }
        List members = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), memberNumber, RangeEnum.ALL_DETAIL.getIndex());
        String periodNumber = null;
        for (Member member2 : members) {
            String number = member2.getNumber();
            if (periodNumber == null) {
                periodNumber = number;
                continue;
            }
            if (isMin && periodNumber.compareTo(number) > 0) {
                periodNumber = number;
                continue;
            }
            if (isMin || periodNumber.compareTo(number) >= 0) continue;
            periodNumber = number;
        }
        return periodNumber;
    }

    public void queryAuditTrail(AnalyseQueryParameter queryParameter) {
        Member member;
        Member member2;
        Long modelId = queryParameter.getModelId();
        queryParameter.setAdjustAuditTrail("EntityInput");
        Long adjustAuditId = ParamQueryServiceHelper.getChildLong((long)modelId, (ParamEnum)ParamEnum.BG001, (String)"adjust_small");
        if (adjustAuditId != null && (member2 = queryParameter.getModelCacheHelper().getMember("AuditTrail", Long.valueOf(0L), adjustAuditId)) != null) {
            queryParameter.setAdjustAuditTrail(member2.getNumber());
        }
        queryParameter.setAdjpstAuditTrail("EntityInput");
        Long adjpstAuditId = ParamQueryServiceHelper.getChildLong((long)modelId, (ParamEnum)ParamEnum.BG004, (String)"adjust_small");
        if (adjpstAuditId != null && (member = queryParameter.getModelCacheHelper().getMember("AuditTrail", Long.valueOf(0L), adjpstAuditId)) != null) {
            queryParameter.setAdjpstAuditTrail(member.getNumber());
        }
    }

    public void queryMemberPerms(AnalyseQueryParameter queryParameter) {
        Long modelId = queryParameter.getModelId();
        Map viewMap = queryParameter.getModelCacheHelper().getViewsByDataSet(queryParameter.getDatasetId());
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)modelId);
        List<String> pageDimKeys = Arrays.asList(SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Version.getNumber());
        for (Dimension permControlDim : permControlDims) {
            Set readPermMembIds;
            String dimNumber = permControlDim.getNumber();
            if (!pageDimKeys.contains(dimNumber) || (readPermMembIds = DimMembPermHelper.getReadPermMembIds((String)dimNumber, (Long)queryParameter.getModelId(), (Long)queryParameter.getBizModelId(), (Long)((Long)viewMap.get(dimNumber)), (boolean)true)) == null) continue;
            queryParameter.addDimPerms(dimNumber, readPermMembIds);
        }
    }

    public TreeNode getDimMemberTree(IModelCacheHelper modelCacheHelper, String dimNum, Long viewId, Collection<String> memNums) {
        TreeNode treeNode = new TreeNode("", "0", "root");
        List members = modelCacheHelper.getMembers(dimNum, viewId, memNums);
        if (members.isEmpty()) {
            return treeNode;
        }
        members = members.stream().sorted(Comparator.comparing(Member::getLongNumber)).collect(Collectors.toList());
        HashMap<String, TreeNode> longNumberMap = new HashMap<String, TreeNode>(16);
        for (Member member : members) {
            int i;
            TreeNode node = new TreeNode("0", member.getId().toString(), member.getNumber());
            String longNumber = member.getLongNumber();
            String parentLongNumber = "";
            if (longNumber.lastIndexOf("!") != -1) {
                parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            }
            while (!longNumberMap.containsKey(parentLongNumber) && (i = parentLongNumber.lastIndexOf("!")) != -1) {
                parentLongNumber = parentLongNumber.substring(0, i);
            }
            if (longNumberMap.containsKey(parentLongNumber)) {
                TreeNode parentNode = (TreeNode)longNumberMap.get(parentLongNumber);
                node.setParentid(parentNode.getId());
                parentNode.addChild(node);
            } else {
                treeNode.addChild(node);
            }
            longNumberMap.put(longNumber, node);
        }
        return treeNode;
    }

    private static /* synthetic */ IDataRow lambda$getFormulaValue$12(IDataRow v) {
        return v;
    }
}

