/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import kd.bos.form.IFormView;
import kd.bos.report.IReportView;
import kd.epm.eb.business.centralapproval.CentralAppThreadManager;
import kd.epm.eb.business.executeanalyse.runtask.FillRowValueTask;
import kd.epm.eb.business.executeanalyse.runtask.UpdateRowShowTypeTask;
import kd.epm.eb.business.executeanalyse.runtask.UpdateRowUnitTask;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.execanalyse.FillRowValueParameter;
import kd.epm.eb.common.execanalyse.UpdateRowUnitParameter;

public class ExecAnalyseThreadService {
    private static final ExecAnalyseThreadService instance = new ExecAnalyseThreadService();

    public static ExecAnalyseThreadService getInstance() {
        return instance;
    }

    public void createFillRowValueProcessThread(IReportView formView, FillRowValueParameter fillRowValueParameter, CountDownLatch countDownLatch, int groupSize, int baseLevel) {
        ExecutorService fillRowValueProPool = CentralAppThreadManager.getCentralAppProPool();
        for (int i = 0; i <= groupSize; ++i) {
            int startIndex = i * 5000;
            int endIndex = (i + 1) * 5000;
            int size = fillRowValueParameter.getInsertEntryKeys().size();
            if (startIndex >= size) {
                return;
            }
            if (endIndex >= size) {
                endIndex = size;
            }
            fillRowValueProPool.submit(new FillRowValueTask((IFormView)formView, fillRowValueParameter, countDownLatch, startIndex, endIndex, i, baseLevel));
        }
    }

    public void createUpdateRowShowTypeProcessThread(IReportView formView, IModelCacheHelper modelCacheHelper, CountDownLatch countDownLatch, Map<String, String> rowDimKeyMap, Map<String, List<PropertyObj>> dimProperties, MemberShowType curShowType, MemberShowType showType, int rowCount, int groupSize, int threadExecute, Long dataSetId) {
        ExecutorService updateRowShowTypeProPool = CentralAppThreadManager.getCentralAppProPool();
        for (int i = 0; i <= groupSize; ++i) {
            int startIndex = i * 5000;
            int endIndex = (i + 1) * 5000;
            if (startIndex >= rowCount) {
                return;
            }
            if (endIndex >= rowCount) {
                endIndex = rowCount;
            }
            updateRowShowTypeProPool.submit(new UpdateRowShowTypeTask((IFormView)formView, modelCacheHelper, countDownLatch, rowDimKeyMap, dimProperties, curShowType, showType, startIndex, endIndex, i, dataSetId));
        }
    }

    public void createUpdateRowUnitProcessThread(IFormView formView, CountDownLatch countDownLatch, UpdateRowUnitParameter updateRowUnitParameter, int rowCount, int groupSize) {
        ExecutorService updateRowUnitProPool = CentralAppThreadManager.getCentralAppProPool();
        for (int i = 0; i <= groupSize; ++i) {
            int startIndex = i * 5000;
            int endIndex = (i + 1) * 5000;
            if (startIndex >= rowCount) {
                return;
            }
            if (endIndex >= rowCount) {
                endIndex = rowCount;
            }
            updateRowUnitProPool.submit(new UpdateRowUnitTask(formView, countDownLatch, updateRowUnitParameter, startIndex, endIndex, i));
        }
    }
}

