/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.executeanalyse.ReportShareHelper;
import kd.epm.eb.common.analysereport.constants.UnitEnum;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnStyle;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.DynamicKeyMapping;
import kd.epm.eb.common.execanalyse.ExecuteAnalyseShowSetting;
import kd.epm.eb.common.execanalyse.FillRowValueParameter;
import kd.epm.eb.common.execanalyse.PathItem;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SchemeColType;
import kd.epm.eb.common.execanalyse.SchemeDimension;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.enums.DataRowEnum;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExecuteAnalyseUtil {
    private static final ExecuteAnalyseUtil instance = new ExecuteAnalyseUtil();
    private final List<String> queryDimOrder = Arrays.asList("Entity", "Account", "BudgetPeriod", "custom", "Version", "DataType", "Currency", "ChangeType", "AuditTrail", "Metric", "InternalCompany");
    private static final Log log = LogFactory.getLog(ExecuteAnalyseUtil.class);
    private final Map<AnalysePreColType, Tips> colTipMap = new HashMap<AnalysePreColType, Tips>(16);

    public static ExecuteAnalyseUtil getInstance() {
        return instance;
    }

    public FlexPanelAp getFlexPanelAp(DynamicKeyMapping dynamicKeyMapping, SchemeDimension schemeDimension) {
        return this.getFlexPanelAp(dynamicKeyMapping, schemeDimension, "querypanel", "eb_execanalysereport", true);
    }

    public FlexPanelAp getFlexPanelAp(DynamicKeyMapping dynamicKeyMapping, SchemeDimension schemeDimension, String panelKey, String pageKey, boolean isReport) {
        FlexPanelAp panelAp = new FlexPanelAp();
        panelAp.setKey(panelKey);
        HashMap queryParam = new HashMap(16);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)pageKey, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        this.queryDimOrder.forEach(e -> {
            boolean isAdded = this.addFieldAps(panelAp, entityMeta, schemeDimension.getRowDimensions(), queryParam, (String)e, true, false);
            boolean isAdded1 = this.addFieldAps(panelAp, entityMeta, schemeDimension.getColDimensions(), queryParam, (String)e, true, isAdded);
            this.addFieldAps(panelAp, entityMeta, schemeDimension.getPageDimensions(), queryParam, (String)e, !isReport, isAdded || isAdded1);
        });
        if (dynamicKeyMapping != null) {
            dynamicKeyMapping.setPanelKeyMapping(queryParam);
        }
        return panelAp;
    }

    public List<BaseColumn> convertSettingToCols(List<SchemeColSetting> schemeColSettings, kd.epm.eb.common.model.Dimension dimension, Map<String, String> colKeyMap, List<String> colKeyList, IFormView formView) {
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>(16);
        List<Object> colInfos = this.getColInfos(dimension, formView);
        HashSet<String> groupKeys = new HashSet<String>(16);
        MemberShowType showType = this.getShowType(formView);
        for (Object colInfo : colInfos) {
            String colRealKey = null;
            if (colInfo instanceof kd.epm.eb.common.model.Dimension) {
                kd.epm.eb.common.model.Dimension dimensionInfo = (kd.epm.eb.common.model.Dimension)colInfo;
                colRealKey = dimensionInfo.getNumber();
            } else {
                if (!(colInfo instanceof kd.epm.eb.common.model.Member)) continue;
                kd.epm.eb.common.model.Member member = (kd.epm.eb.common.model.Member)colInfo;
                colRealKey = member.getNumber();
            }
            String colName = this.getShowValue(colInfo, showType);
            this.addColumn(colKeyMap, colKeyList, schemeColSettings, columns, colRealKey, groupKeys, colName);
        }
        return columns;
    }

    private String getShowValue(Object object, MemberShowType showType) {
        String showValue = null;
        String number = null;
        String name = null;
        if (object instanceof kd.epm.eb.common.model.Dimension) {
            kd.epm.eb.common.model.Dimension dimension = (kd.epm.eb.common.model.Dimension)object;
            name = dimension.getName();
            number = dimension.getNumber();
        } else if (object instanceof kd.epm.eb.common.model.Member) {
            kd.epm.eb.common.model.Member member = (kd.epm.eb.common.model.Member)object;
            name = member.getName();
            number = member.getNumber();
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5217\u7c7b\u578b\u5931\u8d25", (String)"ExecuteAnalyseUtil_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        switch (showType) {
            case NAME: {
                showValue = name;
                break;
            }
            case NUMBER: {
                showValue = number;
                break;
            }
            case NAME_NUMBER: {
                showValue = number + "#" + name;
                break;
            }
        }
        return showValue;
    }

    public void addColumn(Map<String, String> colKeyMap, List<String> colKeyList, List<SchemeColSetting> schemeColSettings, List<BaseColumn> columns, String colRealKey, Set<String> groupKeys, String colName) {
        String colKey = colRealKey.toLowerCase();
        colKey = colKey.replaceAll("\\.", "_");
        if (colKeyMap != null) {
            colKeyMap.put(colKey, colRealKey);
        }
        String groupKey = "entryentity_" + colKey;
        if (groupKeys != null) {
            if (groupKeys.contains(groupKey)) {
                return;
            }
            groupKeys.add(groupKey);
        }
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            Boolean show = schemeColSetting.getShow();
            if (!show.booleanValue()) continue;
            String number = schemeColSetting.getNumber();
            String fieldKey = groupKey + "_" + number;
            if (colKeyMap != null) {
                colKeyMap.put(fieldKey, number);
                colKeyList.add(fieldKey);
            }
            if (AnalysePreColType.AMOUNT_TOTAL.getNumber().equals(schemeColSetting.getNumber())) continue;
            TextColumn column = new TextColumn();
            column.setFieldtype(FieldTypeEnum.TextField);
            column.setKey(fieldKey);
            column.setTitle(schemeColSetting.getShowName());
            column.setIsmustinput(false);
            column.setIgnoreDB(true);
            column.setGrouptitle(colName);
            AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)number);
            if (AnalysePreColType.CONTROL_BALANCE == preColType) {
                ColumnStyle style = new ColumnStyle();
                style.setHyperlink(true);
                column.setStyle(style);
            }
            columns.add((BaseColumn)column);
        }
    }

    public boolean isRateFormula(String fieldKey, Map<Long, SchemeColSetting> colSettingMap) {
        if (!fieldKey.startsWith("formula")) {
            return false;
        }
        String colId = fieldKey.replace("formula", "");
        SchemeColSetting schemeColSetting = colSettingMap.get(Long.parseLong(colId));
        if (schemeColSetting == null) {
            return false;
        }
        return this.isRateFormula(schemeColSetting);
    }

    public boolean isRateFormula(SchemeColSetting schemeColSetting) {
        String formula = schemeColSetting.getFormula();
        if (formula == null) {
            return false;
        }
        Map formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
        String fm = (String)formulaMap.get("fm");
        return fm != null && fm.endsWith("%");
    }

    public DecimalFormat getFormulaDecimalFormat(SchemeColSetting schemeColSetting, Map<String, DecimalFormat> bigDecimalFormatMap) {
        Map formulaMap;
        String fm;
        String formula = schemeColSetting.getFormula();
        if (bigDecimalFormatMap.containsKey(formula)) {
            return bigDecimalFormatMap.get(formula);
        }
        if (formula != null && (fm = (String)(formulaMap = (Map)SerializationUtils.fromJsonString((String)formula, Map.class)).get("fm")) != null) {
            DecimalFormat decimalFormat = new DecimalFormat(fm);
            bigDecimalFormatMap.put(formula, decimalFormat);
            return decimalFormat;
        }
        return new DecimalFormat(",###,##0.00");
    }

    public DecimalFormat getCurMetricBigDecimalFormat(int metricScale, boolean showSqe) {
        if (metricScale == 0) {
            return new DecimalFormat(showSqe ? ",###,##0" : "#0");
        }
        StringBuilder builder = showSqe ? new StringBuilder(",###,##0.") : new StringBuilder("#0.");
        for (int i = 0; i < metricScale; ++i) {
            builder.append("0");
        }
        return new DecimalFormat(builder.toString());
    }

    public int getScaleByFm(String fmKey) {
        String[] split = fmKey.split("\\.");
        if (split.length != 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u5217\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExecuteAnalyseUtil_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        char[] scaleChars = split[1].toCharArray();
        int scale = 0;
        for (char scaleChar : scaleChars) {
            if (scaleChar != '0') break;
            ++scale;
        }
        return scale;
    }

    public String getControlKey(String dimKey, Map<String, String> queryParamMap) {
        for (Map.Entry<String, String> entry : queryParamMap.entrySet()) {
            String value = entry.getValue();
            if (!dimKey.equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addThisViewToContainer(Container container, List<Control> fieldEdits, IFormView view) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems(), view);
                }
                fieldEdit.setView(view);
            } else if (fieldEdit != null) {
                fieldEdit.setView(view);
            }
            container.getItems().add(fieldEdit);
        }
    }

    public void addThisViewToEntryGrid(EntryGrid entryGrid, List<Control> fieldEdits, IFormView view) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems(), view);
                }
                fieldEdit.setView(view);
            } else if (fieldEdit != null) {
                fieldEdit.setView(view);
            }
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public List<SchemeColSetting> sortByOrder(List<SchemeColSetting> settings) {
        settings.sort((o1, o2) -> {
            int order2;
            int order1 = o1.getOrder();
            if (order1 != (order2 = o2.getOrder())) {
                return Integer.compare(order1, order2);
            }
            Date modifyTime = o1.getModifyTime();
            if (modifyTime == null) {
                return -1;
            }
            Date modifyTime1 = o2.getModifyTime();
            if (modifyTime1 == null) {
                return 1;
            }
            return modifyTime.compareTo(modifyTime1);
        });
        return settings;
    }

    public SchemeColSetting convertToSchemeSetting(DynamicObject colSetting) {
        SchemeColSetting schemeColSetting = new SchemeColSetting();
        schemeColSetting.setOrder(colSetting.getInt("order"));
        schemeColSetting.setId(Long.valueOf(colSetting.getLong("id")));
        String number = colSetting.getString("number");
        long schemeId = colSetting.getLong("exescheme.id");
        String name = colSetting.getString("name");
        String analyseInfo = colSetting.getString("analyseinfo");
        String desc = colSetting.getString("desc");
        if (schemeId == 0L) {
            String nameSourceKey = number + "_name";
            analyseInfo = name = ResManager.loadKDString((String)name, (String)nameSourceKey, (String)"epm-eb-business", (Object[])new Object[0]);
            String descSourceKey = number + "_desc";
            desc = ResManager.loadKDString((String)desc, (String)descSourceKey, (String)"epm-eb-business", (Object[])new Object[0]);
        } else if ("amount_total".equals(number)) {
            analyseInfo = ResManager.loadKDString((String)analyseInfo, (String)(number + "_name"), (String)"epm-eb-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)desc, (String)(number + "_desc"), (String)"epm-eb-business", (Object[])new Object[0]);
        }
        schemeColSetting.setShowName(name);
        schemeColSetting.setSchemeId(Long.valueOf(schemeId));
        schemeColSetting.setAnalyseInfo(analyseInfo);
        schemeColSetting.setNumber(number);
        schemeColSetting.setFormula(colSetting.getString("formula"));
        schemeColSetting.setShow(Boolean.valueOf(colSetting.getBoolean("isshow")));
        schemeColSetting.setColType(SchemeColType.getTypeByValue((String)colSetting.getString("coltype")));
        schemeColSetting.setDesc(desc);
        schemeColSetting.setModifyTime(colSetting.getDate("modifydate"));
        return schemeColSetting;
    }

    public List<SchemeColSetting> getSchemeColSettingsById(Long schemeId, boolean needBase) {
        ArrayList<SchemeColSetting> settings = new ArrayList<SchemeColSetting>(16);
        HashSet<Long> schemeIds = new HashSet<Long>(16);
        if (needBase) {
            schemeIds.add(0L);
        }
        schemeIds.add(schemeId);
        QFilter qFilter = new QFilter("exescheme", "in", schemeIds);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_execcolentity", null);
        if (idList.size() == 0) {
            return settings;
        }
        DynamicObject[] colEntities = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_execcolentity"));
        if (colEntities == null || colEntities.length == 0) {
            return settings;
        }
        for (DynamicObject colEntity : colEntities) {
            SchemeColSetting setting = this.convertToSchemeSetting(colEntity);
            SchemeColSetting sameSetting = this.getContainValue(settings, setting);
            if (sameSetting == null) {
                settings.add(setting);
                continue;
            }
            if (sameSetting.getSchemeId() != 0L) continue;
            settings.remove(sameSetting);
            settings.add(setting);
        }
        return needBase ? this.sortByOrder(settings) : settings;
    }

    public List<SchemeColSetting> getSchemeColSettingsById(Long schemeId) {
        return this.getSchemeColSettingsById(schemeId, true);
    }

    public void updateGridColumns(EntryAp entryAp, IFormView view, String entryKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Map control = entryAp.createControl();
        List columnInfos = (List)control.get("columns");
        List items = entryAp.getItems();
        ArrayList<String> freezeKeys = new ArrayList<String>(16);
        for (ControlAp item : items) {
            EntryFieldAp ap;
            if (item instanceof EntryFieldAp) {
                ap = (EntryFieldAp)item;
                if (!ap.isFreeze()) continue;
                freezeKeys.add(ap.getKey());
                continue;
            }
            if (!(item instanceof EntryFieldGroupAp) || !(ap = (EntryFieldGroupAp)item).isFreeze()) continue;
            freezeKeys.add(ap.getKey());
        }
        for (Map columnInfo : columnInfos) {
            if (freezeKeys.contains(columnInfo.get("dataIndex").toString())) {
                columnInfo.put("isFixed", true);
            }
            if (columnInfo.get("children") == null) continue;
            List children = (List)columnInfo.get("children");
            for (Map child : children) {
                if (!freezeKeys.contains(child.get("dataIndex").toString())) continue;
                columnInfo.put("isFixed", true);
            }
        }
        clientViewProxy.preInvokeControlMethod(entryKey, "createGridColumns", new Object[]{control});
    }

    public void cacheMemberInfo(IModelCacheHelper modelCacheHelper, Long viewId, IPageCache pageCache, String number, List<kd.epm.eb.common.model.Member> members) {
        ArrayList memberInfos = new ArrayList(16);
        for (kd.epm.eb.common.model.Member member : members) {
            Member cacheMember = modelCacheHelper.getMember(number, viewId, member.getNumber());
            if (cacheMember == null) continue;
            HashMap<String, String> memberInfo = new HashMap<String, String>(16);
            memberInfo.put("id", String.valueOf(cacheMember.getId()));
            memberInfo.put("name", cacheMember.getName());
            memberInfo.put("number", cacheMember.getNumber());
            memberInfo.put("longnumber", cacheMember.getLongNumber());
            memberInfo.put("scope", String.valueOf(member.getRange()));
            memberInfos.add(memberInfo);
        }
        pageCache.put(number, SerializationUtils.toJsonString(memberInfos));
    }

    public PathItem createDefaultPathItem() {
        PathItem pathItem = new PathItem();
        pathItem.setKey("all_0_path");
        pathItem.setName(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ExecuteAnalyseUtil_2", (String)"epm-eb-business", (Object[])new Object[0]));
        return pathItem;
    }

    public Boolean isDefaultPathItem(String pathKey) {
        return "all_0_path".equals(pathKey);
    }

    public boolean isPathItemEquals(PathItem pathItem, String number, int index) {
        String key = pathItem.getKey();
        String replace = key.replace("_" + index + "_path", "");
        return number.toLowerCase(Locale.ENGLISH).equals(replace);
    }

    public PathItem createPathItem(kd.epm.eb.common.model.Member member, String dimKey, List<String> memberList, String controlKey, int size, boolean isMainPath) {
        PathItem pathItem = new PathItem();
        if (member == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u4e3a\u7a7a", (String)"ExecuteAnalyseUtil_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        pathItem.setKey(member.getNumber().toLowerCase() + "_" + size + "_path");
        pathItem.setName(member.getName());
        pathItem.setControlKey(controlKey);
        pathItem.setDimKey(dimKey);
        pathItem.setMember(member.getNumber());
        pathItem.setMemberList(memberList);
        pathItem.setMainPath(isMainPath);
        return pathItem;
    }

    public int getPathItemIndex(String controlKey, List<PathItem> pathItems) {
        for (int i = 0; i < pathItems.size(); ++i) {
            PathItem pathItem = pathItems.get(i);
            if (!pathItem.getKey().equals(controlKey)) continue;
            return i;
        }
        return -1;
    }

    public SchemeColSetting getContainValue(List<SchemeColSetting> settings, SchemeColSetting setting) {
        for (SchemeColSetting schemeColSetting : settings) {
            if (!setting.equals((Object)schemeColSetting)) continue;
            return schemeColSetting;
        }
        return null;
    }

    private void addThisViewToEntryEditField(List<Control> items, IFormView view) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems(), view);
                }
                fieldEdit.setView(view);
                continue;
            }
            if (fieldEdit == null) continue;
            fieldEdit.setView(view);
        }
    }

    private List<Object> getColInfos(kd.epm.eb.common.model.Dimension dimension, IFormView formView) {
        ArrayList<Object> colInfos = new ArrayList<Object>(16);
        if (formView == null) {
            colInfos.add(dimension);
        } else {
            String colMembers = formView.getPageCache().get("colMembers");
            if (colMembers == null) {
                colInfos.add(dimension);
            } else {
                List members = (List)SerializationUtils.deSerializeFromBase64((String)colMembers);
                colInfos.addAll(members);
            }
        }
        return colInfos;
    }

    private Boolean addFieldAps(FlexPanelAp panelAp, EntityMetadata entityMeta, List<kd.epm.eb.common.model.Dimension> dimensions, Map<String, String> queryParam, String dimKey, boolean isMulti, boolean isAdded) {
        if (!"custom".equals(dimKey) && isAdded) {
            return true;
        }
        List<kd.epm.eb.common.model.Dimension> toAddDimensions = this.getDimensions(dimensions, dimKey);
        if (toAddDimensions.size() != 0) {
            this.addFieldAps(panelAp, entityMeta, toAddDimensions, queryParam, isMulti);
            return true;
        }
        return false;
    }

    public List<kd.epm.eb.common.model.Dimension> getDimensions(List<kd.epm.eb.common.model.Dimension> dimensions, String dimKey) {
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)dimKey);
        ArrayList<kd.epm.eb.common.model.Dimension> retDimensions = new ArrayList<kd.epm.eb.common.model.Dimension>(16);
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            String number = dimension.getNumber();
            if (dimensionEnum != null && dimensionEnum.getNumber().equals(number)) {
                retDimensions.add(dimension);
                break;
            }
            if (dimensionEnum != null || SysDimensionEnum.getEnumByNumber((String)number) != null) continue;
            retDimensions.add(dimension);
        }
        return retDimensions;
    }

    private void addFieldAps(FlexPanelAp panelAp, EntityMetadata entityMeta, List<kd.epm.eb.common.model.Dimension> dimensions, Map<String, String> queryParam, boolean isMulti) {
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            TextField field;
            String number = dimension.getNumber();
            String fieldKey = "panel_" + number.toLowerCase();
            queryParam.put(fieldKey, number);
            FieldAp fieldAp = this.createFieldAp(fieldKey, dimension.getName());
            fieldAp.setFieldBackColor("#f3f8ff");
            fieldAp.setQuickAddNew(false);
            if (isMulti) {
                field = new TextField();
                field.setMustInput(true);
                field.setKey(fieldKey);
                field.setId(fieldKey);
                field.setEditStyle(1);
                field.setEntityMetadata(entityMeta);
                fieldAp.setField((Field)field);
            } else {
                field = new BasedataField();
                field.setMustInput(true);
                field.setKey(fieldKey);
                field.setId(fieldKey);
                field.setViewDetail(false);
                fieldAp.setField((Field)field);
            }
            panelAp.getItems().add(fieldAp);
        }
    }

    private FieldAp createFieldAp(String key, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        return fieldAp;
    }

    public String getCopyIndex(String number, String entityKey, Long modelId) {
        return this.getCopyIndex(number, entityKey, modelId, null);
    }

    public String getCopyIndex(String number, String entityKey, Long modelId, QFilter qFilter_other) {
        DynamicObjectCollection query;
        String copyNumber = number + "copy";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("number", "like", (Object)(copyNumber + "%"));
        if (qFilter_other != null) {
            qFilter.and(qFilter_other);
        }
        if ((query = QueryServiceHelper.query((String)entityKey, (String)"number", (QFilter[])new QFilter[]{qFilter})).size() == 0) {
            return "copy";
        }
        long index = 0L;
        for (DynamicObject scheme : query) {
            String schemeNum = scheme.getString("number");
            String replace = schemeNum.replace(copyNumber, "");
            long indexKey = 0L;
            if (StringUtils.isNotEmpty((String)replace)) {
                if (this.isNotLong(replace)) continue;
                indexKey = ConvertUtils.toLong((Object)replace);
            }
            if (index > indexKey) continue;
            index = indexKey + 1L;
        }
        return "copy" + (index == 0L ? "" : Long.valueOf(index));
    }

    public boolean isNotLong(String str) {
        char[] chars;
        for (char aChar : chars = str.toCharArray()) {
            if (aChar >= '0' && aChar <= '9') continue;
            return true;
        }
        return false;
    }

    public void openTipPage(String tip, IFormView formView, CloseCallBack closeCallBack) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("eb_tipinfo");
        showParam.setCustomParam("tipInfo", (Object)tip);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCloseCallBack(closeCallBack);
        formView.showForm(showParam);
    }

    public List<DynamicObject> convertSchemeSettingToDyn(List<SchemeColSetting> schemeColSettings) {
        ArrayList<DynamicObject> schemeDynamics = new ArrayList<DynamicObject>(16);
        Object[] pkArray = schemeColSettings.stream().filter(e -> e.getNew() == false).map(SchemeColSetting::getId).toArray();
        DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_execcolentity").getDynamicObjectType());
        HashMap<Long, DynamicObject> schemeMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject scheme : schemes) {
            schemeMap.put(scheme.getLong("id"), scheme);
        }
        for (SchemeColSetting schemeColSetting : schemeColSettings) {
            Long schemeId = schemeColSetting.getSchemeId();
            if (schemeId == 0L) continue;
            Long id = schemeColSetting.getId();
            DynamicObject scheme = (DynamicObject)schemeMap.get(id);
            if (scheme == null) {
                scheme = BusinessDataServiceHelper.newDynamicObject((String)"eb_execcolentity");
                scheme.set("id", (Object)id);
                scheme.set("coltype", (Object)schemeColSetting.getColType().getValue());
                scheme.set("number", (Object)schemeColSetting.getNumber());
            }
            scheme.set("order", (Object)schemeColSetting.getOrder());
            scheme.set("exescheme", (Object)schemeColSetting.getSchemeId());
            scheme.set("analyseinfo", (Object)schemeColSetting.getAnalyseInfo());
            scheme.set("formula", (Object)schemeColSetting.getFormula());
            scheme.set("name", (Object)schemeColSetting.getShowName());
            scheme.set("isshow", (Object)schemeColSetting.getShow());
            scheme.set("desc", (Object)schemeColSetting.getDesc());
            schemeDynamics.add(scheme);
        }
        return schemeDynamics;
    }

    public List<FilterScheme> filterSchemeByPkId(List<FilterScheme> schemeList, Long pkId) {
        List<Long> pkIds = Collections.singletonList(pkId);
        return this.filterSchemeByPkIds(schemeList, pkIds);
    }

    public List<FilterScheme> filterSchemeByPkIds(List<FilterScheme> schemeList, Collection<Long> pkIds) {
        ArrayList<FilterScheme> afterFilterSchemes = new ArrayList<FilterScheme>(16);
        for (FilterScheme filterScheme : schemeList) {
            Map<String, List<MemberCondition>> queryRange = this.getQueryRangeFromFilterScheme(filterScheme);
            List<MemberCondition> ids = queryRange.get("pkId");
            if (ids == null || ids.size() == 0 || !pkIds.contains(IDUtils.toLong((Object)ids.get(0).getId()))) continue;
            afterFilterSchemes.add(filterScheme);
        }
        return afterFilterSchemes;
    }

    public Map<String, List<MemberCondition>> getQueryRangeFromFilterScheme(FilterScheme filterScheme) {
        String schemeJson = filterScheme.getScheme();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)schemeJson, HashMap.class);
        String cusFilters = (String)filterMap.get("custfilters");
        Map schemeInfos = (Map)SerializationUtils.fromJsonString((String)cusFilters, HashMap.class);
        Object schemeFilter = schemeInfos.get("schemefilter_tag");
        if (schemeFilter == null || StringUtils.isEmpty((String)schemeFilter.toString())) {
            return new HashMap<String, List<MemberCondition>>(16);
        }
        return this.upgradeCurScheme(schemeFilter.toString());
    }

    public MemberShowType getShowType(IFormView formView) {
        if (formView == null) {
            return MemberShowType.NAME;
        }
        String showType = formView.getPageCache().get("showType");
        MemberShowType enumByValue = MemberShowType.getEnumByValue((String)showType);
        return enumByValue == null ? MemberShowType.NAME : enumByValue;
    }

    public String getCurBizAppIndex(IFormView formView) {
        if (NewEbAppUtil.isNewEbApp((IFormView)formView)) {
            return ApplicationTypeEnum.BG.getIndex();
        }
        return ApplicationTypeEnum.BGMD.getIndex();
    }

    public boolean checkQuoteByExec(Long modelId, Long datasetId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("dataset", "=", (Object)datasetId);
        QFilter qFilter2 = new QFilter("bizmodel", "=", (Object)datasetId);
        boolean exists = QueryServiceHelper.exists((String)"eb_diffanalyzescheme", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (!exists) {
            return QueryServiceHelper.exists((String)"eb_execschemeentity", (QFilter[])new QFilter[]{qFilter, qFilter2});
        }
        return true;
    }

    public kd.epm.eb.common.model.Dimension getDimension(List<kd.epm.eb.common.model.Dimension> dimensions, String dimKey) {
        kd.epm.eb.common.model.Dimension retDimension = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            String number = dimension.getNumber();
            if (!number.equals(dimKey)) continue;
            retDimension = dimension;
            break;
        }
        return retDimension;
    }

    public kd.epm.eb.common.model.Dimension getDimension(List<kd.epm.eb.common.model.Dimension> dimensions, Long dimId) {
        kd.epm.eb.common.model.Dimension retDimension = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            Long dimensionId = dimension.getId();
            if (!dimensionId.equals(dimId)) continue;
            retDimension = dimension;
            break;
        }
        return retDimension;
    }

    public QFilter getQFilter(Collection<Long> busModelIds, String dataSetProName, String creatorProName, Long modelId, boolean isOnlyEnable, boolean needShare) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        if (busModelIds != null) {
            qFilter.and(dataSetProName, "in", busModelIds);
        }
        QFilter qFilter1 = new QFilter("type", "=", (Object)"1");
        Long userId = UserUtils.getUserId();
        qFilter1.and(creatorProName, "=", (Object)userId);
        QFilter qFilter2 = new QFilter("type", "=", (Object)"2");
        qFilter2.or(qFilter1);
        if (needShare) {
            List<Long> sharedReport = ReportShareHelper.getSharedReport();
            QFilter qFilter3 = new QFilter("id", "in", sharedReport);
            qFilter2.or(qFilter3);
        }
        qFilter.and(qFilter2);
        if (isOnlyEnable) {
            qFilter.and("status", "=", (Object)"1");
        }
        return qFilter;
    }

    public String getMemberShowValue(Object object, MemberShowType showType) {
        kd.epm.eb.common.model.Member member = this.convertToMember(object);
        String value = null;
        switch (showType) {
            case NAME: {
                value = member.getName();
                break;
            }
            case NUMBER: {
                value = member.getShowNumber();
                break;
            }
            case NAME_NUMBER: {
                value = member.getShowNumber() + "#" + member.getName();
                break;
            }
        }
        return value;
    }

    public kd.epm.eb.common.model.Member convertToMember(Object object) {
        kd.epm.eb.common.model.Member member = null;
        if (object instanceof DynamicObject) {
            member = kd.epm.eb.common.model.Member.loadFromDynamicObject((DynamicObject)((DynamicObject)object));
        } else if (object instanceof Member) {
            member = kd.epm.eb.common.model.Member.loadFormCache((Member)((Member)object));
        } else if (object instanceof kd.epm.eb.common.model.Member) {
            member = (kd.epm.eb.common.model.Member)object;
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u5458\u7c7b\u578b\u5931\u8d25", (String)"ExecuteAnalyseUtil_4", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return member;
    }

    public int getDimMemberShowValue(Object object, FillRowValueParameter fillRowValueParameter, String dimNumber, MemberShowType showType, StringBuilder showValue, int baseLevel) {
        showValue.append(this.getMemberShowValue(object, showType));
        int retLevel = 0;
        int level = 0;
        boolean needAddPreEmpty = false;
        kd.epm.eb.common.model.Member member = this.convertToMember(object);
        if (!member.isLeaf()) {
            String number = member.getNumber();
            if (dimNumber.equals(fillRowValueParameter.getMainDimKey())) {
                if (number.equals(fillRowValueParameter.getMainMember())) {
                    if (fillRowValueParameter.isExpand()) {
                        showValue.insert(0, "-");
                    } else {
                        showValue.insert(0, "+");
                    }
                } else {
                    showValue.insert(0, "  +");
                    ++level;
                }
                needAddPreEmpty = true;
            } else {
                showValue.insert(0, "+");
            }
        } else if (dimNumber.equals(fillRowValueParameter.getMainDimKey())) {
            showValue.insert(0, "  ");
            ++level;
            needAddPreEmpty = true;
        }
        if (needAddPreEmpty) {
            for (int i = 0; i < baseLevel; ++i) {
                showValue.insert(0, "  ");
            }
            retLevel = baseLevel + level;
        }
        return retLevel;
    }

    public String getDimPropShowValue(CustomPropertyValue propertyValue, MemberShowType showType) {
        if (MemberShowType.NAME == showType) {
            return propertyValue.getName();
        }
        if (MemberShowType.NUMBER == showType) {
            return propertyValue.getNumber();
        }
        if (MemberShowType.NAME_NUMBER == showType) {
            return propertyValue.getNumber() + "#" + propertyValue.getName();
        }
        return "";
    }

    public void deleteSXSSFTempFiles(SXSSFWorkbook workbook) {
        workbook.dispose();
    }

    public String getMemberShowTypeShow(String showTypeNumber) {
        MemberShowType showType = MemberShowType.getEnumByValue((String)showTypeNumber);
        if (showType == null) {
            return null;
        }
        return ResManager.loadResFormat((String)"\u663e\u793a%1", (String)"ExecuteAnalyseUtil_5", (String)"epm-eb-business", (Object[])new Object[]{showType.getDesc()});
    }

    public String getEmptyTypeShow(boolean showEmpty) {
        if (showEmpty) {
            return ResManager.loadKDString((String)"\u663e\u793a\u7a7a\u767d\u884c", (String)"ExecuteAnalyseUtil_6", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u9690\u85cf\u7a7a\u767d\u884c", (String)"ExecuteAnalyseUtil_7", (String)"epm-eb-business", (Object[])new Object[0]);
    }

    public String comparePeriod(String periodNumber, String compareNumber) {
        if (periodNumber == null) {
            return null;
        }
        String retStr = periodNumber.startsWith("HF") ? (compareNumber.startsWith("HF") ? (periodNumber.compareTo(compareNumber) > 0 ? periodNumber : compareNumber) : periodNumber) : (periodNumber.startsWith("Q") ? (compareNumber.startsWith("HF") ? compareNumber : (compareNumber.startsWith("Q") ? (periodNumber.compareTo(compareNumber) > 0 ? periodNumber : compareNumber) : periodNumber)) : (compareNumber.startsWith("HF") || compareNumber.startsWith("Q") ? compareNumber : (periodNumber.compareTo(compareNumber) > 0 ? periodNumber : compareNumber)));
        return retStr;
    }

    public void addCtrlTip(EntryAp entryAp, Map<String, String> colKeyMap) {
        if (entryAp == null) {
            return;
        }
        for (ControlAp item : entryAp.getItems()) {
            if (!(item instanceof EntryFieldGroupAp)) continue;
            EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)item;
            List items = entryFieldGroupAp.getItems();
            for (ControlAp controlAp : items) {
                Tips colTip;
                AnalysePreColType colByNumber;
                String controlKey = controlAp.getKey();
                String type = colKeyMap.get(controlKey);
                if (StringUtils.isEmpty((String)type) || (colByNumber = AnalysePreColType.getColByNumber((String)type)) == null || !colByNumber.getShowDesc().booleanValue() || (colTip = this.getColTip(colByNumber)) == null || !(controlAp instanceof FieldAp)) continue;
                ((FieldAp)controlAp).setCtlTips(colTip);
            }
        }
    }

    private Tips getColTip(AnalysePreColType colType) {
        if (colType == null) {
            return null;
        }
        Tips tips = this.colTipMap.get(colType);
        if (tips == null) {
            tips = new Tips();
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            tips.setContent(new LocaleString(colType.getDesc()));
            this.colTipMap.put(colType, tips);
        }
        return tips;
    }

    public int getMetricScale(Map<String, List<String>> queryParam, Map<String, Integer> metricDisplay) {
        List<String> metrics = queryParam.get(SysDimensionEnum.Metric.getNumber());
        if (metrics == null || metrics.size() == 0 || metricDisplay == null) {
            return 2;
        }
        String metric = metrics.get(0);
        Integer scale = metricDisplay.get(metric);
        if (scale == null) {
            scale = 2;
        }
        return scale;
    }

    public List<Long> getControlDimension(Long bizModelId) {
        QFilter qFilter = new QFilter("businessmodel", "=", (Object)bizModelId);
        DynamicObjectCollection dimensionIds = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)"entryentity.dimensionid", (QFilter[])new QFilter[]{qFilter});
        if (dimensionIds == null || dimensionIds.size() == 0) {
            return new ArrayList<Long>(16);
        }
        return dimensionIds.stream().map(e -> e.getLong("entryentity.dimensionid")).collect(Collectors.toList());
    }

    public Map<String, List<MemberCondition>> upgradeCurScheme(String schemeFilterJson) {
        if (StringUtils.isEmpty((String)schemeFilterJson)) {
            return new HashMap<String, List<MemberCondition>>(0);
        }
        if (schemeFilterJson.contains("\"prop\"")) {
            return (Map)ObjectSerialUtil.parseObject((String)schemeFilterJson, (TypeReference)new TypeReference<Map<String, List<MemberCondition>>>(){}, (Feature[])new Feature[0]);
        }
        Map queryRange = (Map)SerializationUtils.fromJsonString((String)schemeFilterJson, Map.class);
        HashMap<String, List<MemberCondition>> schemeFilterRange = new HashMap<String, List<MemberCondition>>(16);
        for (Map.Entry entry : queryRange.entrySet()) {
            String filterKey = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)values)) continue;
            List conditions = schemeFilterRange.computeIfAbsent(filterKey, e -> new ArrayList(values.size()));
            for (Object value : values) {
                conditions.add(new MemberCondition(IDUtils.toLong(value)));
            }
        }
        return schemeFilterRange;
    }

    public Map<String, String> getRowDimOrPropGroupTitle(List<kd.epm.eb.common.model.Dimension> rowDimensions, List<String> dimColOrder, MemberPropCache memberPropCache, IModelCacheHelper modelCacheHelper) {
        if (CollectionUtils.isEmpty(rowDimensions) || CollectionUtils.isEmpty(dimColOrder) || dimColOrder.size() < 2) {
            return new HashMap<String, String>(0);
        }
        if (dimColOrder.stream().noneMatch(e -> e.startsWith("rowdimprop_"))) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> rowDimColGroupTitle = new HashMap<String, String>(16);
        Long groupDimId = 0L;
        HashSet<String> groupColKeys = new HashSet<String>();
        for (int i = 0; i < dimColOrder.size(); ++i) {
            long curColKeyRelDimId;
            String dimOrder = dimColOrder.get(i);
            boolean isProp = dimOrder.startsWith("rowdimprop_");
            if (isProp) {
                Long propId = IDUtils.toLong((Object)dimOrder.split("_")[1]);
                CustomProperty property = memberPropCache.getProperty(propId);
                curColKeyRelDimId = property != null ? property.getDimId() : 0L;
            } else {
                kd.epm.eb.common.model.Dimension dimension = this.getDimension(rowDimensions, dimOrder);
                long l = curColKeyRelDimId = dimension != null ? dimension.getId() : 0L;
            }
            if (IDUtils.isNull((long)curColKeyRelDimId)) continue;
            if (!IDUtils.equals((Object)curColKeyRelDimId, (Object)groupDimId)) {
                this.setContinuousColKeyGroupTitle(rowDimensions, rowDimColGroupTitle, groupDimId, groupColKeys);
                groupColKeys.clear();
                groupDimId = curColKeyRelDimId;
            }
            groupColKeys.add(dimOrder);
            if (i != dimColOrder.size() - 1 || !IDUtils.equals((Object)curColKeyRelDimId, (Object)groupDimId)) continue;
            this.setContinuousColKeyGroupTitle(rowDimensions, rowDimColGroupTitle, groupDimId, groupColKeys);
        }
        return rowDimColGroupTitle;
    }

    private void setContinuousColKeyGroupTitle(List<kd.epm.eb.common.model.Dimension> rowDimensions, Map<String, String> rowDimColGroupTitle, Long groupDimId, Set<String> groupColKeys) {
        boolean isExistDimMemCol;
        if (groupColKeys.size() > 1 && (isExistDimMemCol = groupColKeys.stream().anyMatch(e -> this.getDimension(rowDimensions, (String)e) != null))) {
            String dimensionName = this.getDimension(rowDimensions, groupDimId).getName();
            groupColKeys.forEach(e -> rowDimColGroupTitle.put((String)e, dimensionName));
        }
    }

    public List<String> getSchemeDefaultDimColOrder(SchemeDimension schemeDimension) {
        ArrayList<String> dimColOrder = new ArrayList<String>(16);
        List rowDimensions = schemeDimension.getRowDimensions();
        Map dimProperties = schemeDimension.getDimProperties();
        for (kd.epm.eb.common.model.Dimension rowDimension : rowDimensions) {
            dimColOrder.add(rowDimension.getNumber());
            List propertyObjs = (List)dimProperties.get(rowDimension.getNumber());
            if (!CollectionUtils.isNotEmpty((Collection)propertyObjs)) continue;
            for (PropertyObj propertyObj : propertyObjs) {
                dimColOrder.add("rowdimprop_" + propertyObj.getId());
            }
        }
        return dimColOrder;
    }

    public List<BaseColumn> createRowDimRelCols(Long modelId, SchemeDimension schemeDimension) {
        return this.createRowDimRelCols(modelId, null, null, schemeDimension);
    }

    public List<BaseColumn> createRowDimRelCols(Long modelId, Map<String, String> colKeyMap, List<String> colKeyList, SchemeDimension schemeDimension) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || schemeDimension == null) {
            return new ArrayList<BaseColumn>(0);
        }
        List<String> dimColOrders = schemeDimension.getDimColOrder();
        List rowDimensions = schemeDimension.getRowDimensions();
        if (CollectionUtils.isEmpty((Collection)dimColOrders)) {
            dimColOrders = this.getSchemeDefaultDimColOrder(schemeDimension);
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        Map<String, String> rowDimOrPropGroupTitle = this.getRowDimOrPropGroupTitle(rowDimensions, dimColOrders, memberPropCache, modelCacheHelper);
        ArrayList<BaseColumn> rowDimCols = new ArrayList<BaseColumn>(10);
        for (String dimColOrder : dimColOrders) {
            String groupTitle = rowDimOrPropGroupTitle.get(dimColOrder);
            boolean isProp = dimColOrder.startsWith("rowdimprop_");
            if (isProp) {
                Dimension dimension;
                Long propId = IDUtils.toLong((Object)dimColOrder.split("_")[1]);
                CustomProperty property = memberPropCache.getProperty(propId);
                if (property == null || (dimension = modelCacheHelper.getDimension(property.getDimId())) == null) continue;
                String fieldKey = "rowdimprop_" + property.getId();
                String title = StringUtils.isNotEmpty((String)groupTitle) ? property.getName() : dimension.getName() + "_" + property.getName();
                rowDimCols.add((BaseColumn)this.createTextColumn(fieldKey, title, groupTitle, true));
                continue;
            }
            kd.epm.eb.common.model.Dimension dimension = this.getDimension((List<kd.epm.eb.common.model.Dimension>)rowDimensions, dimColOrder);
            if (dimension == null) continue;
            rowDimCols.addAll(this.createRowDimMemberCol(groupTitle, dimension, colKeyList, colKeyMap));
        }
        return rowDimCols;
    }

    private List<BaseColumn> createRowDimMemberCol(String groupTitle, kd.epm.eb.common.model.Dimension dimension, List<String> colKeyList, Map<String, String> colKeyMap) {
        ArrayList<BaseColumn> baseColumns = new ArrayList<BaseColumn>(2);
        String dimensionNumber = dimension.getNumber();
        TextColumn memberIdColumn = this.createTextColumn("entryentity_" + dimensionNumber.toLowerCase(), dimension.getName(), groupTitle, false);
        if (StringUtils.isNotEmpty((String)groupTitle)) {
            memberIdColumn.setTitle(ResManager.loadKDString((String)"\u6210\u5458", (String)"ExecuteAnalyseSchemeEditPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        baseColumns.add((BaseColumn)memberIdColumn);
        TextColumn memberShowColumn = this.createTextColumn(memberIdColumn.getKey() + "_text", memberIdColumn.getTitle(), groupTitle, true);
        baseColumns.add((BaseColumn)memberShowColumn);
        if (colKeyList != null && colKeyMap != null) {
            colKeyList.add(memberIdColumn.getKey());
            colKeyMap.put(memberIdColumn.getKey(), dimensionNumber);
        }
        return baseColumns;
    }

    public TextColumn createTextColumn(String fieldKey, String title, String groupTitle, boolean visible) {
        TextColumn textColumn = new TextColumn();
        textColumn.setKey(fieldKey);
        textColumn.setTitle(title);
        textColumn.setType(ColumnEnum.Text);
        textColumn.setFieldtype(FieldTypeEnum.TextField);
        textColumn.setEditStyle(1);
        textColumn.setIsmustinput(false);
        textColumn.setIgnoreDB(true);
        textColumn.setBaseVisible(visible);
        textColumn.setEnable(false);
        textColumn.setGrouptitle(groupTitle);
        textColumn.setFreeze(true);
        return textColumn;
    }

    public void dealNoExistPropertyObjs(SchemeDimension schemeDimension, Long modelId) {
        Map dimProperties = schemeDimension.getDimProperties();
        if (CollectionUtils.isEmpty((Map)dimProperties)) {
            return;
        }
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        for (Map.Entry entry : dimProperties.entrySet()) {
            List propertyObjs = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)propertyObjs)) continue;
            HashSet<PropertyObj> needRemove = new HashSet<PropertyObj>(propertyObjs.size());
            for (PropertyObj propertyObj : propertyObjs) {
                CustomProperty property = memberPropCache.getProperty(propertyObj.getId());
                if (property == null) {
                    needRemove.add(propertyObj);
                    continue;
                }
                propertyObj.setName(property.getName());
                propertyObj.setNumber(property.getNumber());
            }
            if (needRemove.size() <= 0) continue;
            propertyObjs.removeAll(needRemove);
        }
    }

    public List<DynamicObject> convertDiffToDyn(Map<Long, DynamicObject> copySchemes_diff) {
        Set<Long> preSchemes = copySchemes_diff.keySet();
        DynamicObject[] preSchemeDynamics = BusinessDataServiceHelper.load((Object[])preSchemes.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_diffanalyzescheme"));
        DynamicObject[] afterSchemeDynamics = BusinessDataServiceHelper.load((Object[])copySchemes_diff.values().stream().map(e -> e.getLong("id")).distinct().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_diffanalyzescheme"));
        for (int i = 0; i < copySchemes_diff.size(); ++i) {
            DynamicObject afterSchemeDynamic = afterSchemeDynamics[i];
            DynamicObject preSchemeDynamic = preSchemeDynamics[i];
            DynamicObjectCollection afterEntry = afterSchemeDynamic.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection preEntry = preSchemeDynamic.getDynamicObjectCollection("entryentity");
            HashMap<String, String> newIdMap = new HashMap<String, String>(16);
            for (int j = 0; j < preEntry.size(); ++j) {
                newIdMap.put(((DynamicObject)preEntry.get(j)).getString("id"), ((DynamicObject)afterEntry.get(j)).getString("id"));
            }
            for (DynamicObject col : afterEntry) {
                if (DataRowEnum.CUSTOM.getIndex() != col.getInt("coltype")) continue;
                String configJson = col.getString("colconfigjson");
                Map configMap = (Map)SerializationUtils.fromJsonString((String)configJson, HashMap.class);
                String expr = (String)configMap.get("_EXPRESSION");
                if (StringUtils.isNotEmpty((String)expr)) {
                    for (Map.Entry entry : newIdMap.entrySet()) {
                        expr = expr.replaceAll((String)entry.getKey(), (String)entry.getValue());
                    }
                    configMap.put("_EXPRESSION", expr);
                }
                col.set("colconfigjson", (Object)SerializationUtils.toJsonString((Object)configMap));
            }
        }
        return Arrays.asList(afterSchemeDynamics);
    }

    public boolean isAmountTotalColType(SchemeColSetting schemeColSetting) {
        return this.isAmountTotalColType(schemeColSetting.getNumber());
    }

    public boolean isAmountTotalColType(String number) {
        return AnalysePreColType.AMOUNT_TOTAL.getNumber().equals(number);
    }

    public int getCurUserDefaultUnit(Long reportId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_alyscheme_memory", (String)"dataunit", (QFilter[])new QFilter("alyscheme", "=", (Object)reportId).and("user", "=", (Object)UserUtils.getUserId()).toArray());
        if (object != null) {
            return object.getInt("dataunit");
        }
        return 0;
    }

    public void saveCurUserDefaultUnit(Long reportId, int dataUnit) {
        Long userId = UserUtils.getUserId();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"eb_alyscheme_memory", (String)"dataunit", (QFilter[])new QFilter("alyscheme", "=", (Object)reportId).and("user", "=", (Object)userId).toArray());
        if (object == null) {
            object = BusinessDataServiceHelper.newDynamicObject((String)"eb_alyscheme_memory");
            object.set("alyscheme", (Object)reportId);
            object.set("user", (Object)userId);
        }
        object.set("dataunit", (Object)dataUnit);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public ExecuteAnalyseShowSetting getExecuteAnalyseShowSetting(Long modelId, Long schemeId, String curQueryMetricMemNum) {
        DynamicObject dy;
        if (IDUtils.isEmptyLong((Long)schemeId).booleanValue() || curQueryMetricMemNum == null) {
            return null;
        }
        ExecuteAnalyseShowSetting showSetting = new ExecuteAnalyseShowSetting();
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_metricmembertree", (String)"decimalnum", (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)curQueryMetricMemNum).toArray());
        if (object != null) {
            showSetting.setMetricScale(object.getInt("decimalnum"));
        }
        if ((dy = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"eb_execschemeentity", (String)"configjson")) == null || StringUtils.isEmpty((String)dy.getString("configjson"))) {
            return showSetting;
        }
        Map params = (Map)SerializationUtils.fromJsonString((String)dy.getString("configjson"), HashMap.class);
        if (params.get("defmember") != null && !"".equals(params.get("defmember"))) {
            Map defMem = (Map)SerializationUtils.fromJsonString((String)((String)params.get("defmember")), HashMap.class);
            showSetting.setHideDimToMemNumMap(defMem);
        }
        if (params.get("metricdisplay") != null && !"".equals(params.get("metricdisplay"))) {
            Map metricdisplay = (Map)SerializationUtils.fromJsonString((String)((String)params.get("metricdisplay")), HashMap.class);
            showSetting.setMetricScale(((Integer)metricdisplay.get(curQueryMetricMemNum)).intValue());
        }
        if (params.get("defemptyrowdisplay") != null) {
            showSetting.setShowEmptyRow("1".equals(params.get("defemptyrowdisplay")));
        }
        if (params.get("defmemberdisplay") != null) {
            showSetting.setMemberShowType(MemberShowType.getEnumByValue((String)((String)params.get("defmemberdisplay"))));
        }
        if (params.get("defunitdisplay") != null) {
            showSetting.setUnit(UnitEnum.getUnitEnumByUnit((int)Integer.parseInt((String)params.get("defunitdisplay"))));
        }
        if (params.get("metricdisplay_no_sep") != null) {
            List noSepMetrics = (List)SerializationUtils.fromJsonString((String)((String)params.get("metricdisplay_no_sep")), List.class);
            showSetting.setShowSqe(!noSepMetrics.contains(curQueryMetricMemNum));
        }
        return showSetting;
    }
}

