/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.execanalyse.AnalyseType;
import kd.epm.eb.common.utils.UserUtils;

public class ReportShareHelper {
    public static Map<Long, Pair<Long, Long>> sendMessageToReceivers(List<Long> shareUserIds, Long reportId, String reportType, Long modelId, Long datasetId, boolean isNewEbForm) {
        HashMap<Long, Pair<Long, Long>> userIdToPairMsgIdShareId = new HashMap<Long, Pair<Long, Long>>(16);
        int i = 0;
        long[] shareIds = DB.genGlobalLongIds((int)shareUserIds.size());
        Long userId = UserUtils.getUserId();
        Date sendTime = new Date(System.currentTimeMillis());
        String currentUrl = UrlService.getDomainContextUrl();
        for (Long shareUserId : shareUserIds) {
            Long shareId = shareIds[i++];
            LocaleString title = new LocaleString();
            LocaleString tag = new LocaleString();
            StringBuilder params = new StringBuilder("/?formId=");
            String typeName = null;
            String formId = null;
            if (AnalyseType.MULTI_DIM.getValue().equals(reportType)) {
                typeName = AnalyseType.MULTI_DIM.getDesc();
                formId = "eb_diffanalysis";
                params.append(formId).append("&eb_diffanalyzescheme=").append(reportId).append("&KEY_MODEL_ID=").append(modelId).append("&eb_dataset=").append(datasetId);
            } else {
                typeName = AnalyseType.EXECUTE.getDesc();
                params.append("eb_execanalysereport").append("&schemeId=").append(reportId).append("&model=").append(modelId).append("&dataset=").append(datasetId).append("&shareId=").append(shareId).append("&type=report");
            }
            params.append("&isFormEnjoy=true");
            tag.setLocaleValue(typeName);
            title.setLocaleValue(ResManager.loadResFormat((String)"\u60a8\u597d\uff0c\u201c%1\u201d\u7ed9\u60a8\u5206\u4eab\u4e86\u201c%2\u201d\uff0c\u8bf7\u6253\u5f00\u94fe\u63a5\u67e5\u770b\u3002", (String)"ReportShareHelper_0", (String)"epm-eb-business", (Object[])new Object[]{RequestContext.get().getUserName(), typeName}));
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageTitle((ILocaleString)title);
            messageInfo.setMessageContent((ILocaleString)title);
            messageInfo.setUserIds(Collections.singletonList(shareUserId));
            messageInfo.setSenderId(userId);
            messageInfo.setSendTime(sendTime);
            messageInfo.setMessageTag((ILocaleString)tag);
            messageInfo.setContentUrl(currentUrl + params);
            userIdToPairMsgIdShareId.put(shareUserId, (Pair<Long, Long>)new Pair((Object)MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo), (Object)shareId));
        }
        return userIdToPairMsgIdShareId;
    }

    public static void saveReportShare(Map<Long, Pair<Long, Long>> userIdToPairMsgIdShareId, Long modelId, String shareCache, String dataJson, int unit) {
        Map shareMap = (Map)SerializationUtils.fromJsonString((String)shareCache, HashMap.class);
        String reportType = (String)shareMap.get("reportType");
        String reportName = (String)shareMap.get("reportName");
        String reportId = (String)shareMap.get("reportId");
        String datasetId = (String)shareMap.get("datasetId");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmssSSS");
        String flagId = sdf.format(new Date());
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(userIdToPairMsgIdShareId.size());
        ArrayList<DynamicObject> dataUnitMemoryList = new ArrayList<DynamicObject>(userIdToPairMsgIdShareId.size());
        for (Map.Entry<Long, Pair<Long, Long>> entry : userIdToPairMsgIdShareId.entrySet()) {
            DynamicObject shareObj;
            String number;
            Long receiverId = entry.getKey();
            Long msgId = (Long)entry.getValue().p1;
            Long shareId = (Long)entry.getValue().p2;
            Long seq = 0L;
            QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
            qFilter.and("receiver", "=", (Object)receiverId);
            qFilter.and("reportid", "=", (Object)reportId);
            DynamicObjectCollection shareList = QueryServiceHelper.query((String)"eb_reportshare", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"sharedate desc");
            if (shareList != null && shareList.size() > 0 && StringUtils.isNotEmpty((String)(number = (shareObj = (DynamicObject)shareList.get(0)).getString("number")))) {
                String[] numberArr = number.split("\\_");
                seq = numberArr.length > 1 ? Long.valueOf(new BigDecimal(numberArr[1]).add(new BigDecimal(1)).longValue()) : Long.valueOf(1L);
            }
            String reportNumber = reportType;
            if (seq != 0L) {
                reportNumber = reportType + "_" + seq;
                reportName = ResManager.loadResFormat((String)"%1-\u9ed8\u8ba4%2", (String)"ReportShareHelper_1", (String)"epm-eb-business", (Object[])new Object[]{reportName, seq});
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_reportshare");
            dynamicObject.set("id", (Object)shareId);
            dynamicObject.set("number", (Object)reportNumber);
            dynamicObject.set("name", (Object)reportName);
            dynamicObject.set("sharers", (Object)userId);
            dynamicObject.set("receiver", (Object)receiverId);
            dynamicObject.set("islook", (Object)"B");
            dynamicObject.set("messageid", (Object)msgId);
            dynamicObject.set("sharestatus", (Object)"A");
            dynamicObject.set("status", (Object)"A");
            dynamicObject.set("sharedate", (Object)now);
            dynamicObject.set("flagid", (Object)flagId);
            dynamicObject.set("modelid", (Object)modelId);
            if (AnalyseType.MULTI_DIM.getValue().equals(reportType)) {
                dynamicObject.set("templatetype", (Object)"M");
                dynamicObject.set("formid", (Object)"eb_diffanalysis_scheme");
            } else {
                dynamicObject.set("templatetype", (Object)"E");
                dynamicObject.set("formid", (Object)"eb_execanalysescheme");
            }
            dynamicObject.set("reportid", (Object)reportId);
            dynamicObject.set("reportcatalog", (Object)"0");
            dynamicObject.set("dataset", (Object)datasetId);
            dynamicObject.set("data", (Object)dataJson);
            saveList.add(dynamicObject);
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_alyscheme_memory");
            object.set("alyscheme", (Object)dynamicObject.getLong("id"));
            object.set("user", (Object)receiverId);
            object.set("dataunit", (Object)unit);
            dataUnitMemoryList.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dataUnitMemoryList.toArray(new DynamicObject[0]));
    }

    public static boolean checkSingleEnjoyed(Long reportId) {
        if (reportId == null || reportId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5206\u4eab\u7684reportId\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ReportShareHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("reportid", "=", (Object)String.valueOf(reportId));
        qFilter.and("sharestatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean checkSingleEnjoyed(String reportId) {
        if (StringUtils.isEmpty((String)reportId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5206\u4eab\u7684reportId\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ReportShareHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("reportid", "=", (Object)reportId);
        qFilter.and("sharestatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean checkEnjoyed(List<String> reportIds) {
        if (reportIds == null || reportIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5206\u4eab\u7684reportId\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ReportShareHelper_4", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("reportid", "in", reportIds);
        qFilter.and("sharestatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean checkIsReceiver(Long reportId) {
        if (reportId == null || reportId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u88ab\u5206\u4eab\u8005\u7684reportId\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ReportShareHelper_5", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Long userId = UserUtils.getUserId();
        QFilter qFilter = new QFilter("reportid", "=", (Object)String.valueOf(reportId));
        qFilter.and("sharers", "!=", (Object)userId);
        qFilter.and("receiver", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"eb_reportshare", (QFilter[])new QFilter[]{qFilter});
    }

    public static List<Long> getSharedReport() {
        Long userId = UserUtils.getUserId();
        QFilter qFilter = new QFilter("sharestatus", "=", (Object)"A");
        qFilter.and("sharers", "!=", (Object)userId);
        qFilter.and("receiver", "=", (Object)userId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_reportshare", (String)"reportid", (QFilter[])new QFilter[]{qFilter});
        return query.stream().map(e -> Long.parseLong(e.getString("reportid"))).collect(Collectors.toList());
    }
}

