/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse.runtask;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.executeanalyse.AnalyseBudgetQueryService;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.execanalyse.AnalyseColTypeGroup;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.FillRowValueParameter;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;

public class FillRowValueTask
implements Runnable {
    private IFormView formView = null;
    private FillRowValueParameter fillRowValueParameter = null;
    private int startIndex = 0;
    private int endIndex = 0;
    private CountDownLatch countDownLatch = null;
    private int curThreadIndex = 0;
    private int baseLevel = 0;
    private static final Log log = LogFactory.getLog(FillRowValueTask.class);

    public FillRowValueTask(IFormView formView, FillRowValueParameter fillRowValueParameter, CountDownLatch countDownLatch, int startIndex, int endIndex, int curThreadIndex, int baseLevel) {
        this.formView = formView;
        this.fillRowValueParameter = fillRowValueParameter;
        this.countDownLatch = countDownLatch;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.curThreadIndex = curThreadIndex;
        this.baseLevel = baseLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Map dimProperties = this.fillRowValueParameter.getDimProperties();
            IModelCacheHelper modelCacheHelper = this.fillRowValueParameter.getModelCacheHelper();
            List colKeyList = this.fillRowValueParameter.getColKeyList();
            List rowDimKeys = this.fillRowValueParameter.getRowDimKeys();
            Map hasAdjustMemberMap = this.fillRowValueParameter.getHasAdjustMemberMap();
            MemberShowType showType = this.fillRowValueParameter.getShowType();
            ExecuteAnalyseUtil instance = ExecuteAnalyseUtil.getInstance();
            Map viewMap = modelCacheHelper.getViewsByDataSet(this.fillRowValueParameter.getDatasetId());
            Long modelId = modelCacheHelper.getModelobj().getId();
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
            DecimalFormat bigDecimalFormat = instance.getCurMetricBigDecimalFormat(this.fillRowValueParameter.getMetricScale(), this.fillRowValueParameter.isShowSqe());
            DataEntityPropertyCollection properties = null;
            HashMap<String, DecimalFormat> formulaDfMap = new HashMap<String, DecimalFormat>(16);
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                String insertKey = (String)this.fillRowValueParameter.getInsertEntryKeys().get(i);
                int newEntryRow = this.fillRowValueParameter.getNewEntryRows()[i];
                DynamicObject rowEntity = this.formView.getModel().getEntryRowEntity("entryentity1", newEntryRow);
                if (properties == null) {
                    properties = rowEntity.getDataEntityType().getProperties();
                }
                Object[] insertValues = (Object[])this.fillRowValueParameter.getAnalyseDataMap().get(insertKey);
                ArrayList<String> budgetCols = new ArrayList<String>(16);
                HashMap<String, String> rowMemberMap = new HashMap<String, String>(16);
                AnalyseColTypeGroup analyseColTypeGroup = this.fillRowValueParameter.getAnalyseColTypeGroup();
                for (int j = 0; j < colKeyList.size(); ++j) {
                    BigDecimal bigDecimal;
                    String controlKey = (String)colKeyList.get(j);
                    Object insertValue = null;
                    if (insertValues != null) {
                        insertValue = insertValues[j];
                    }
                    if (properties == null) continue;
                    String realKey = (String)this.fillRowValueParameter.getColKeys().get(controlKey);
                    if (AnalyseBudgetQueryService.getInstance().isDimensionCol(realKey, modelCacheHelper)) {
                        List propertyObjs;
                        String memberNumber;
                        if (insertValue != null) {
                            memberNumber = insertValue.toString();
                        } else {
                            String[] split = insertKey.split("!");
                            memberNumber = split[j];
                        }
                        Member member = modelCacheHelper.getMember(realKey, (Long)viewMap.get(realKey), memberNumber);
                        if (member == null) continue;
                        rowEntity.set(controlKey, (Object)member.getId().toString());
                        StringBuilder showValue = new StringBuilder();
                        int level = instance.getDimMemberShowValue(member, this.fillRowValueParameter, realKey, showType, showValue, this.baseLevel);
                        rowEntity.set(controlKey + "_text", (Object)showValue.toString());
                        rowMemberMap.put(realKey, memberNumber);
                        if (level != 0) {
                            rowEntity.set("spec_level_count", (Object)String.valueOf(level));
                        }
                        if (dimProperties == null || CollectionUtils.isEmpty((Collection)(propertyObjs = (List)dimProperties.get(realKey)))) continue;
                        for (PropertyObj propertyObj : propertyObjs) {
                            CustomPropertyValue propertyValue;
                            String propertyControlKey = "rowdimprop_" + propertyObj.getId();
                            if (!properties.containsKey((Object)propertyControlKey) || (propertyValue = memberPropCache.getPropertyValueByMemNumber(realKey, propertyObj.getNumber(), memberNumber)) == null) continue;
                            String dimPropShowValue = instance.getDimPropShowValue(propertyValue, showType);
                            rowEntity.set(propertyControlKey, (Object)dimPropShowValue);
                        }
                        continue;
                    }
                    if (!controlKey.startsWith("entryentity") || properties.get((Object)controlKey) == null || insertValue == null) continue;
                    AnalysePreColType preColType = AnalysePreColType.getColByNumber((String)realKey);
                    Object toInsertValue = insertValue;
                    int unit = this.fillRowValueParameter.getUnit();
                    if (insertValue instanceof Integer) {
                        toInsertValue = ConvertUtils.toDecimal((Object)insertValue);
                    }
                    if (AnalysePreColType.BUD_ACT_RATE == preColType) {
                        rowEntity.set(controlKey, toInsertValue);
                        continue;
                    }
                    if (preColType == null) {
                        if (analyseColTypeGroup == null) {
                            rowEntity.set(controlKey, toInsertValue);
                            continue;
                        }
                        List formulaCols = analyseColTypeGroup.getFormulaCols();
                        if (formulaCols == null || !formulaCols.contains(controlKey)) {
                            rowEntity.set(controlKey, toInsertValue);
                            continue;
                        }
                        Long formulaId = (Long)analyseColTypeGroup.getFormulaMap().get(controlKey);
                        if (formulaId == null) {
                            rowEntity.set(controlKey, toInsertValue);
                            continue;
                        }
                        SchemeColSetting schemeColSetting = (SchemeColSetting)this.fillRowValueParameter.getColSettingMap().get(formulaId);
                        if (ExecuteAnalyseUtil.getInstance().isRateFormula(schemeColSetting)) {
                            rowEntity.set(controlKey, toInsertValue);
                            continue;
                        }
                        DecimalFormat formulaDecimalFormat = ExecuteAnalyseUtil.getInstance().getFormulaDecimalFormat(schemeColSetting, formulaDfMap);
                        BigDecimal bigDecimal2 = ConvertUtils.toDecimal((Object)toInsertValue);
                        rowEntity.set(controlKey, (Object)formulaDecimalFormat.format(bigDecimal2.divide(BigDecimal.TEN.pow(unit), 4)));
                        continue;
                    }
                    if (AnalysePreColType.BUDGET == preColType) {
                        budgetCols.add(controlKey);
                    }
                    if ((bigDecimal = ConvertUtils.toDecimal((Object)toInsertValue)) == null) {
                        if (toInsertValue == null || "notPermCell".equals(toInsertValue.toString())) continue;
                        rowEntity.set(controlKey, toInsertValue);
                        continue;
                    }
                    BigDecimal divide = bigDecimal.divide(BigDecimal.TEN.pow(unit), 4);
                    rowEntity.set(controlKey, (Object)bigDecimalFormat.format(divide));
                }
                try {
                    if (hasAdjustMemberMap.isEmpty()) continue;
                    for (String budgetCol : budgetCols) {
                        String colMember = (String)analyseColTypeGroup.getColMemberMap().get(budgetCol);
                        StringBuilder memKey = new StringBuilder((String)this.fillRowValueParameter.getColKeys().get(colMember));
                        memKey.append("!");
                        for (String rowDimKey : rowDimKeys) {
                            Member cacheHelperMember = modelCacheHelper.getMember(rowDimKey, (Long)viewMap.get(rowDimKey), (String)rowMemberMap.get(rowDimKey));
                            if (cacheHelperMember == null) continue;
                            memKey.append(cacheHelperMember.getNumber()).append("!");
                        }
                        if (!hasAdjustMemberMap.containsKey(memKey.toString())) continue;
                        List cols = this.fillRowValueParameter.getRedRolCols().computeIfAbsent(i, e -> new ArrayList());
                        cols.add(budgetCol);
                    }
                    continue;
                }
                catch (Exception e2) {
                    log.error(CommonServiceHelper.getStackTraceStr((Throwable)e2));
                }
            }
        }
        catch (Exception e3) {
            String errInfo = "fillRowValueProPool-%s: %s";
            log.error(String.format(errInfo, this.curThreadIndex, Arrays.toString(e3.getStackTrace())));
        }
        finally {
            this.countDownLatch.countDown();
        }
    }
}

