/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse.runtask;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;

public class UpdateRowShowTypeTask
implements Runnable {
    private IFormView formView = null;
    private IModelCacheHelper modelCacheHelper = null;
    private int startIndex = 0;
    private int endIndex = 0;
    private CountDownLatch countDownLatch = null;
    private int curThreadIndex = 0;
    private MemberShowType curShowType = null;
    private MemberShowType showType = null;
    private Map<String, String> rowDimKeyMap = null;
    private Map<String, List<PropertyObj>> dimProperties = null;
    private Long dataSetId = null;
    private static final Log log = LogFactory.getLog(UpdateRowShowTypeTask.class);

    public UpdateRowShowTypeTask(IFormView formView, IModelCacheHelper modelCacheHelper, CountDownLatch countDownLatch, Map<String, String> rowDimKeyMap, Map<String, List<PropertyObj>> dimProperties, MemberShowType curShowType, MemberShowType showType, int startIndex, int endIndex, int curThreadIndex, Long dataSetId) {
        this.formView = formView;
        this.modelCacheHelper = modelCacheHelper;
        this.countDownLatch = countDownLatch;
        this.rowDimKeyMap = rowDimKeyMap;
        this.curShowType = curShowType;
        this.showType = showType;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.curThreadIndex = curThreadIndex;
        this.dimProperties = dimProperties;
        this.dataSetId = dataSetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExecuteAnalyseUtil instance = ExecuteAnalyseUtil.getInstance();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.modelCacheHelper.getModelobj().getId());
        Map viewMap = this.modelCacheHelper.getViewsByDataSet(this.dataSetId);
        try {
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                for (Map.Entry<String, String> entry : this.rowDimKeyMap.entrySet()) {
                    List<PropertyObj> propertyObjs;
                    kd.epm.eb.common.cache.impl.Member member;
                    String controlKey = entry.getKey();
                    String dimNumber = entry.getValue();
                    DynamicObject rowEntity = this.formView.getModel().getEntryRowEntity("entryentity1", i);
                    DataEntityPropertyCollection properties = rowEntity.getDataEntityType().getProperties();
                    String memberObj = rowEntity.getString(controlKey);
                    if (StringUtils.isEmpty((String)memberObj) || (member = this.modelCacheHelper.getMember(dimNumber, (Long)viewMap.get(dimNumber), Long.valueOf(Long.parseLong(memberObj)))) == null) continue;
                    Member member1 = Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)member);
                    String showValue = rowEntity.getString(controlKey + "_text");
                    showValue = showValue.replace(instance.getMemberShowValue(member1, this.curShowType), instance.getMemberShowValue(member1, this.showType));
                    rowEntity.set(controlKey + "_text", (Object)showValue);
                    if (this.dimProperties == null || !CollectionUtils.isNotEmpty(propertyObjs = this.dimProperties.get(dimNumber))) continue;
                    for (PropertyObj propertyObj : propertyObjs) {
                        String propertyControlKey = "rowdimprop_" + propertyObj.getId();
                        CustomPropertyValue propertyValue = memberPropCache.getPropertyValueByMemNumber(dimNumber, propertyObj.getNumber(), member.getNumber());
                        if (propertyValue == null || !properties.containsKey((Object)propertyControlKey)) continue;
                        String dimPropShowValue = instance.getDimPropShowValue(propertyValue, this.showType);
                        rowEntity.set(propertyControlKey, (Object)dimPropShowValue);
                    }
                }
            }
        }
        catch (Exception e) {
            String errInfo = "updateRowShowTypeProPool-%s: %s";
            log.error(String.format(errInfo, this.curThreadIndex, Arrays.toString(e.getStackTrace())));
        }
        finally {
            this.countDownLatch.countDown();
        }
    }
}

