/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.executeanalyse.runtask;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.executeanalyse.AnalyseBudgetQueryService;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.executeanalyse.runtask.UpdateRowShowTypeTask;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.UpdateRowUnitParameter;
import kd.epm.eb.common.utils.ConvertUtils;

public class UpdateRowUnitTask
implements Runnable {
    private IFormView formView = null;
    private int startIndex = 0;
    private int endIndex = 0;
    private CountDownLatch countDownLatch = null;
    private final UpdateRowUnitParameter updateRowUnitParameter;
    private int curThreadIndex = 0;
    private static final Log log = LogFactory.getLog(UpdateRowShowTypeTask.class);

    public UpdateRowUnitTask(IFormView formView, CountDownLatch countDownLatch, UpdateRowUnitParameter updateRowUnitParameter, int startIndex, int endIndex, int curThreadIndex) {
        this.formView = formView;
        this.countDownLatch = countDownLatch;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.curThreadIndex = curThreadIndex;
        this.updateRowUnitParameter = updateRowUnitParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Map analyseDataMap = this.updateRowUnitParameter.getAnalyseDataMap();
            List colKeyList = this.updateRowUnitParameter.getColKeyList();
            IModelCacheHelper modelCacheHelper = this.updateRowUnitParameter.getModelCacheHelper();
            Map viewMap = modelCacheHelper.getViewsByDataSet(this.updateRowUnitParameter.getDataSetId());
            ExecuteAnalyseUtil instance = ExecuteAnalyseUtil.getInstance();
            DecimalFormat decimalFormat = instance.getCurMetricBigDecimalFormat(this.updateRowUnitParameter.getMetricScale(), this.updateRowUnitParameter.isShowSqe());
            HashMap<String, DecimalFormat> formulaDecimalFormatMap = new HashMap<String, DecimalFormat>(16);
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                DynamicObject rowEntity = this.formView.getModel().getEntryRowEntity("entryentity1", i);
                ArrayList<String> rowMembers = new ArrayList<String>(16);
                for (String rowControlKey : this.updateRowUnitParameter.getRowControlKeys()) {
                    Member member;
                    String memberIdStr = rowEntity.getString(rowControlKey);
                    Long memberId = ConvertUtils.toLong((Object)memberIdStr);
                    String dimKey = (String)this.updateRowUnitParameter.getColKeys().get(rowControlKey);
                    if (dimKey == null || (member = modelCacheHelper.getMember(dimKey, (Long)viewMap.get(dimKey), memberId)) == null) continue;
                    rowMembers.add(member.getNumber());
                }
                String insertEntryKey = String.join((CharSequence)"!", rowMembers);
                Object[] data = (Object[])analyseDataMap.get(insertEntryKey);
                if (data == null) continue;
                for (Map.Entry colKey : this.updateRowUnitParameter.getColKeys().entrySet()) {
                    Object fieldValue;
                    BigDecimal bigDecimal;
                    SchemeColSetting setting;
                    AnalysePreColType preColType;
                    String key = (String)colKey.getKey();
                    String value = (String)colKey.getValue();
                    if (!key.startsWith("entryentity_") || instance.isAmountTotalColType(value) || AnalyseBudgetQueryService.getInstance().isDimensionCol(value, modelCacheHelper) || AnalysePreColType.BUD_ACT_RATE == (preColType = AnalysePreColType.getColByNumber((String)value))) continue;
                    int index = colKeyList.indexOf(key);
                    if (index == -1) {
                        log.error("UpdateRowUnitTask -- error: " + key + " " + colKeyList.toString());
                        continue;
                    }
                    DecimalFormat formulaDecimalFormat = null;
                    if (preColType == null && (setting = this.getCurFormulaSetting(value)) != null) {
                        if (instance.isRateFormula(setting)) continue;
                        formulaDecimalFormat = instance.getFormulaDecimalFormat(setting, formulaDecimalFormatMap);
                    }
                    if ((bigDecimal = ConvertUtils.toDecimal((Object)(fieldValue = data[index]))) == null || BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    int unitAbs = this.updateRowUnitParameter.getUnit();
                    bigDecimal = bigDecimal.divide(BigDecimal.TEN.pow(unitAbs), 4);
                    if (preColType != null) {
                        rowEntity.set(key, (Object)decimalFormat.format(bigDecimal));
                        continue;
                    }
                    if (formulaDecimalFormat == null) continue;
                    rowEntity.set(key, (Object)formulaDecimalFormat.format(bigDecimal));
                }
            }
        }
        catch (Exception e) {
            String errInfo = "updateRowUnitProPool-%s: %s";
            log.error(String.format(errInfo, this.curThreadIndex, Arrays.toString(e.getStackTrace())));
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    private SchemeColSetting getCurFormulaSetting(String fieldKey) {
        if (!fieldKey.startsWith("formula")) {
            return null;
        }
        String colId = fieldKey.replace("formula", "");
        return (SchemeColSetting)this.updateRowUnitParameter.getColSettingMap().get(Long.parseLong(colId));
    }
}

