/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.epm.eb.business.expr.Member;

public class CubeIterator
implements Iterator<Member[]> {
    private List<String> dimNumbers = Lists.newArrayListWithExpectedSize((int)16);
    private List<List<Member>> memberLists = Lists.newArrayListWithExpectedSize((int)16);
    private Member[] currentMembers;
    private Member[] defaultMembers;
    private int[] indexs;

    public void addDimension(String dimNumber, List<Member> members) {
        this.dimNumbers.add(dimNumber);
        this.memberLists.add(members);
    }

    private void init() {
        this.defaultMembers = new Member[this.dimNumbers.size()];
        this.indexs = new int[this.dimNumbers.size()];
        Arrays.fill(this.indexs, 0);
        for (int i = 0; i < this.memberLists.size(); ++i) {
            this.defaultMembers[i] = this.memberLists.get(i).get(0);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.defaultMembers == null) {
            this.init();
        }
        if (this.currentMembers == null) {
            this.currentMembers = new Member[this.dimNumbers.size()];
            for (int i = 0; i < this.defaultMembers.length; ++i) {
                this.currentMembers[i] = this.defaultMembers[i];
            }
        } else {
            for (int i = 0; i < this.indexs.length; ++i) {
                this.indexs[i] = this.indexs[i] + 1;
                if (this.indexs[i] < this.memberLists.get(i).size()) {
                    this.currentMembers[i] = this.memberLists.get(i).get(this.indexs[i]);
                    break;
                }
                if (i == this.indexs.length - 1) {
                    return false;
                }
                this.indexs[i] = 0;
                this.currentMembers[i] = this.defaultMembers[i];
            }
        }
        return true;
    }

    @Override
    public Member[] next() {
        return this.currentMembers;
    }

    public List<String> getDimNumbers() {
        return this.dimNumbers;
    }

    public long size() {
        long size = 1L;
        for (List<Member> memberList : this.memberLists) {
            if ((size *= (long)memberList.size()) >= 0L) continue;
            return -1L;
        }
        return size;
    }
}

