/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr;

import kd.epm.eb.algo.olap.util.LongObjectHashMap;
import kd.epm.eb.business.expr.Coordy;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.IDataReader;
import kd.epm.eb.business.expr.Member;
import kd.epm.eb.common.utils.ConvertUtils;

public class DataReader
implements IDataReader {
    private LongObjectHashMap<Object> detailCubeData = new LongObjectHashMap();
    private Coordy coordy;

    public DataReader(Coordy coordy) {
        this.coordy = coordy;
    }

    @Override
    public Object getByEvaluator(Evaluator evaluator) {
        Member[] currentMembers = evaluator.getCurrentMembers();
        long point = this.calcPoint(currentMembers);
        if (point < 0L) {
            return null;
        }
        return this.detailCubeData.get(point);
    }

    public void addData(Member[] currentMembers, Object value) {
        long point = this.calcPoint(currentMembers);
        if (value instanceof Number) {
            this.detailCubeData.put(point, (Object)ConvertUtils.toDecimal((Object)value));
        } else {
            this.detailCubeData.put(point, (Object)value.toString());
        }
    }

    public boolean isEmpty() {
        return this.detailCubeData.isEmpty();
    }

    public int size() {
        return this.detailCubeData.size();
    }

    public long calcPoint(Member[] currentMembers) {
        return this.coordy.getCoord(currentMembers);
    }
}

