/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.business.expr.Cube;
import kd.epm.eb.business.expr.Dimension;
import kd.epm.eb.business.expr.IDataReader;
import kd.epm.eb.business.expr.Member;
import kd.epm.eb.business.expr.calc.FunCalc;
import kd.epm.eb.business.expr.calc.FunCalcFactory;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.common.cache.IModelCacheHelper;
import org.apache.commons.collections4.CollectionUtils;

public class Evaluator {
    private Evaluator parent;
    private FunCalcFactory funCalcFactory;
    private IDataReader dataReader;
    private Member[] currentMembers;
    private Cube cube;
    private boolean isRelate = false;
    private String version;
    private Map<String, Object> medianCache = new HashMap<String, Object>(16);
    private boolean allNull;
    private String mainDim;
    private Map<Long, String> templateIdToNumMap;
    private IModelCacheHelper modelCache;
    private String number;
    private Map<String, Integer> dimIndexMap;

    public Evaluator() {
        this.version = DBServiceHelper.genStringId();
    }

    public Evaluator(Evaluator parent, FunCalcFactory funCalcFactory, IDataReader dataReader, Cube cube, Map<String, Integer> dimIndexMap, Member[] currentMembers, Map<String, Object> medianCache) {
        this.parent = parent;
        this.version = parent.getVersion();
        this.funCalcFactory = funCalcFactory;
        this.dataReader = dataReader;
        this.cube = cube;
        this.currentMembers = currentMembers;
        this.medianCache = medianCache;
        this.dimIndexMap = dimIndexMap;
    }

    public boolean isRelate() {
        return this.isRelate;
    }

    public void setRelate(boolean relate) {
        this.isRelate = relate;
    }

    public String getVersion() {
        return this.version;
    }

    public Evaluator getParent() {
        return this.parent;
    }

    public void setParent(Evaluator parent) {
        this.parent = parent;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public void setFunCalcFactory(FunCalcFactory funCalcFactory) {
        this.funCalcFactory = funCalcFactory;
    }

    public void setDataReader(IDataReader dataReader) {
        this.dataReader = dataReader;
    }

    public Member[] getCurrentMembers() {
        return this.currentMembers;
    }

    public void setCurrentMembers(Member[] currentMembers) {
        this.currentMembers = currentMembers;
    }

    public Map<String, Object> getMedianCache() {
        return this.medianCache;
    }

    public Evaluator push() {
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        return new Evaluator(this, this.funCalcFactory, this.dataReader, this.cube, this.dimIndexMap, cloneCurrentMembers, this.medianCache);
    }

    public Evaluator push(List<Member> members) {
        if (CollectionUtils.isEmpty(members) || this.currentMembers == null) {
            return this;
        }
        Evaluator cloneEvaluator = this.push();
        Member[] currentMembers = cloneEvaluator.getCurrentMembers();
        for (Member member : members) {
            int seq = member.getDimension().getSeq();
            currentMembers[seq - 1] = member;
        }
        cloneEvaluator.setCurrentMembers(currentMembers);
        return cloneEvaluator;
    }

    public Evaluator push(Member member) {
        if (member == null || this.currentMembers == null) {
            return this;
        }
        Evaluator cloneEvaluator = this.push();
        Member[] currentMembers = cloneEvaluator.getCurrentMembers();
        int seq = member.getDimension().getSeq();
        currentMembers[seq] = member;
        cloneEvaluator.setCurrentMembers(currentMembers);
        return cloneEvaluator;
    }

    public Member getMember(MemberExpr memberExpr) {
        String dimNumber = memberExpr.getDimNumber();
        Dimension dimension = this.cube.getDimensionMap().get(dimNumber);
        if (dimension == null) {
            return null;
        }
        return dimension.getMember(memberExpr.getNumber());
    }

    public Member getMember(String dimNumber, String memNumber) {
        Dimension dimension = this.cube.getDimensionMap().get(dimNumber);
        return dimension.getMember(memNumber);
    }

    public Object evaluatorCurrent() {
        return this.dataReader.getByEvaluator(this);
    }

    public boolean isAllNull() {
        return this.allNull;
    }

    public void setAllNull(boolean allNull) {
        this.allNull = allNull;
    }

    public String getMainDim() {
        return this.mainDim;
    }

    public void setMainDim(String mainDim) {
        this.mainDim = mainDim;
    }

    public Map<Long, String> getTemplateIdToNumMap() {
        return this.templateIdToNumMap;
    }

    public void setTemplateIdToNumMap(Map<Long, String> templateIdToNumMap) {
        this.templateIdToNumMap = templateIdToNumMap;
    }

    public IModelCacheHelper getModelCache() {
        return this.modelCache;
    }

    public void setModelCache(IModelCacheHelper modelCache) {
        this.modelCache = modelCache;
    }

    public FunCalc getFunCalc(String funName, IExpress[] args) {
        return this.funCalcFactory.getFunCalc(funName, args);
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public void setDimIndexMap(Map<String, Integer> dimIndexMap) {
        this.dimIndexMap = dimIndexMap;
    }

    public Map<String, Integer> getDimIndexMap() {
        return this.dimIndexMap;
    }
}

