/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.calc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.FunCalc;
import kd.epm.eb.business.expr.expr.BinaryExpr;
import kd.epm.eb.business.expr.expr.MemberGroupExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.oper.NotEqualOper;
import org.apache.commons.lang3.StringUtils;

public class DefaultFunCalcFactory {
    private static Map<String, List<FunCalc>> defaultFunTable;
    public static final BigDecimal oneDecimal;
    public static final BigDecimal negOneDecimal;
    public static final BigDecimal zeroDecimal;

    public static Map<String, List<FunCalc>> getDefaultFunTable() {
        return defaultFunTable;
    }

    private static void definedDefault() {
        defaultFunTable = new HashMap<String, List<FunCalc>>(16);
        DefaultFunCalcFactory.define(new FunCalc("+", ResManager.loadKDString((String)"\u52a0", (String)"FunCalcFactory_01", (String)"epm-eb-business", (Object[])new Object[0]), Type.Number, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return null;
                }
                if (o0 == null) {
                    return o1;
                }
                if (o1 == null) {
                    return o0;
                }
                return o0.add(o1);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("+", ResManager.loadKDString((String)"\u52a0", (String)"FunCalcFactory_01", (String)"epm-eb-business", (Object[])new Object[0]), Type.String, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return null;
                }
                if (o0 == null) {
                    return o1;
                }
                if (o1 == null) {
                    return o0;
                }
                return o0 + o1;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("-", ResManager.loadKDString((String)"\u51cf", (String)"FunCalcFactory_02", (String)"epm-eb-business", (Object[])new Object[0]), Type.Number, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return null;
                }
                if (o0 == null) {
                    return o1.multiply(negOneDecimal);
                }
                if (o1 == null) {
                    return o0;
                }
                return o0.subtract(o1);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("*", ResManager.loadKDString((String)"\u4e58", (String)"FunCalcFactory_03", (String)"epm-eb-business", (Object[])new Object[0]), Type.Number, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null || o1 == null) {
                    return null;
                }
                return o0.multiply(o1);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("/", ResManager.loadKDString((String)"\u9664", (String)"FunCalcFactory_04", (String)"epm-eb-business", (Object[])new Object[0]), Type.Number, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null || o1 == null || zeroDecimal.compareTo(o1) == 0) {
                    return null;
                }
                return o0.divide(o1, 12, 4);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("AND", ResManager.loadKDString((String)"\u4e0e", (String)"FunCalcFactory_05", (String)"epm-eb-business", (Object[])new Object[0]), Type.Boolean, new Type[]{Type.Boolean, Type.Boolean}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator);
                boolean o1 = (Boolean)args[1].calc(evaluator);
                return o0 && o1;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("OR", ResManager.loadKDString((String)"\u6216", (String)"FunCalcFactory_06", (String)"epm-eb-business", (Object[])new Object[0]), Type.Boolean, new Type[]{Type.Boolean, Type.Boolean}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator);
                boolean o1 = (Boolean)args[1].calc(evaluator);
                return o0 || o1;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("NOTNULL", ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"FunCalcFactory_07", (String)"epm-eb-business", (Object[])new Object[0]), Type.Boolean, new Type[]{Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                evaluator.setAllNull(false);
                if (!(args[0] instanceof MemberGroupExpr)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"NOTNULL\u51fd\u6570\u53c2\u6570\u5fc5\u987b\u4e3a\u6210\u5458,\u5f53\u524d\u53c2\u6570[%1]", (String)"ExamineCheckServiceHelper_5", (String)"epm-eb-business", (Object[])new Object[]{args[0].toString()}));
                }
                BigDecimal o = (BigDecimal)args[0].calc(evaluator);
                return o != null;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("NOTNULL", ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"FunCalcFactory_07", (String)"epm-eb-business", (Object[])new Object[0]), Type.Boolean, new Type[]{Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                evaluator.setAllNull(false);
                if (!(args[0] instanceof MemberGroupExpr)) {
                    throw new KDBizException(ResManager.loadResFormat((String)"NOTNULL\u51fd\u6570\u53c2\u6570\u5fc5\u987b\u4e3a\u6210\u5458,\u5f53\u524d\u53c2\u6570[%1]", (String)"ExamineCheckServiceHelper_5", (String)"epm-eb-business", (Object[])new Object[]{args[0].toString()}));
                }
                String o = (String)args[0].calc(evaluator);
                return StringUtils.isNotEmpty((CharSequence)o);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("IF", "if", Type.Boolean, new Type[]{Type.Boolean, Type.Number, Type.Number}, new boolean[]{false, false, false}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator.push());
                IExpress arg = o0 ? args[1] : args[2];
                if (arg != null) {
                    return arg.calc(evaluator);
                }
                return null;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("IF", "if", Type.Boolean, new Type[]{Type.Boolean, Type.String, Type.String}, new boolean[]{false, false, false}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator);
                IExpress arg = o0 ? args[1] : args[2];
                if (arg != null) {
                    return arg.calc(evaluator);
                }
                return null;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("IF", "if", Type.Boolean, new Type[]{Type.Boolean, Type.Boolean, Type.Boolean}, new boolean[]{false, false, false}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator);
                IExpress arg = o0 ? args[1] : args[2];
                if (arg != null) {
                    return arg.calc(evaluator);
                }
                return null;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("absoluteCompare", "absoluteCompare", Type.Boolean, new Type[]{Type.Boolean, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator);
                boolean allNull = evaluator.isAllNull();
                if (args[0] instanceof BinaryExpr && ((BinaryExpr)args[0]).getOperType() instanceof NotEqualOper) {
                    if (o0) {
                        IExpress[] newArgs;
                        BigDecimal tolerance = (BigDecimal)args[1].calc(evaluator);
                        evaluator.setAllNull(allNull);
                        if (tolerance == null || BigDecimal.ZERO.compareTo(tolerance) == 0) {
                            return true;
                        }
                        BinaryExpr binaryExpr = (BinaryExpr)args[0];
                        for (IExpress newArg : newArgs = new IExpress[]{binaryExpr.getLeft(), binaryExpr.getRight()}) {
                            if (newArg.getReturnType() == Type.Number) continue;
                            return true;
                        }
                        BigDecimal bigDecimal = (BigDecimal)((FunCalc)((List)defaultFunTable.get("-")).get(0)).calc(evaluator, newArgs);
                        if (bigDecimal == null) {
                            return true;
                        }
                        return DefaultFunCalcFactory.compare(binaryExpr.getOperType().getOper(), tolerance, bigDecimal);
                    }
                    return false;
                }
                if (!o0) {
                    IExpress[] newArgs;
                    BigDecimal tolerance = (BigDecimal)args[1].calc(evaluator);
                    evaluator.setAllNull(allNull);
                    if (tolerance == null || BigDecimal.ZERO.compareTo(tolerance) == 0) {
                        return false;
                    }
                    BinaryExpr binaryExpr = (BinaryExpr)args[0];
                    for (IExpress newArg : newArgs = new IExpress[]{binaryExpr.getLeft(), binaryExpr.getRight()}) {
                        if (newArg.getReturnType() == Type.Number) continue;
                        return false;
                    }
                    BigDecimal bigDecimal = (BigDecimal)((FunCalc)((List)defaultFunTable.get("-")).get(0)).calc(evaluator, newArgs);
                    if (bigDecimal == null) {
                        return false;
                    }
                    return DefaultFunCalcFactory.compare(binaryExpr.getOperType().getOper(), tolerance, bigDecimal);
                }
                return true;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("relativeCompare", "relativeCompare", Type.Boolean, new Type[]{Type.Boolean, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                boolean o0 = (Boolean)args[0].calc(evaluator);
                boolean allNull = evaluator.isAllNull();
                if (args[0] instanceof BinaryExpr && ((BinaryExpr)args[0]).getOperType() instanceof NotEqualOper) {
                    if (o0) {
                        BigDecimal tolerance = (BigDecimal)args[1].calc(evaluator);
                        evaluator.setAllNull(allNull);
                        if (tolerance == null || BigDecimal.ZERO.compareTo(tolerance) == 0) {
                            return true;
                        }
                        BinaryExpr binaryExpr = (BinaryExpr)args[0];
                        if (binaryExpr.getLeft().getReturnType() != Type.Number || binaryExpr.getRight().getReturnType() != Type.Number) {
                            return true;
                        }
                        BigDecimal o1 = (BigDecimal)binaryExpr.getLeft().calc(evaluator);
                        BigDecimal o2 = (BigDecimal)binaryExpr.getRight().calc(evaluator);
                        BigDecimal calcResult = null;
                        if (o2 == null || BigDecimal.ZERO.compareTo(o2) == 0) {
                            calcResult = o1;
                        } else if (o1 != null) {
                            calcResult = o1.divide(o2, 8, 4).subtract(oneDecimal);
                        }
                        if (calcResult == null || !DefaultFunCalcFactory.isNumber(calcResult)) {
                            return true;
                        }
                        return DefaultFunCalcFactory.compare(binaryExpr.getOperType().getOper(), tolerance, calcResult);
                    }
                    return false;
                }
                if (!o0) {
                    BigDecimal tolerance = (BigDecimal)args[1].calc(evaluator);
                    evaluator.setAllNull(allNull);
                    if (tolerance == null || BigDecimal.ZERO.compareTo(tolerance) == 0) {
                        return false;
                    }
                    BinaryExpr binaryExpr = (BinaryExpr)args[0];
                    if (binaryExpr.getLeft().getReturnType() != Type.Number || binaryExpr.getRight().getReturnType() != Type.Number) {
                        return false;
                    }
                    BigDecimal o1 = (BigDecimal)binaryExpr.getLeft().calc(evaluator);
                    BigDecimal o2 = (BigDecimal)binaryExpr.getRight().calc(evaluator);
                    BigDecimal calcResult = null;
                    if (o2 == null || BigDecimal.ZERO.compareTo(o2) == 0) {
                        calcResult = o1;
                    } else if (o1 != null) {
                        calcResult = o1.divide(o2, 8, 4).subtract(oneDecimal);
                    }
                    if (calcResult == null || !DefaultFunCalcFactory.isNumber(calcResult)) {
                        return false;
                    }
                    return DefaultFunCalcFactory.compare(binaryExpr.getOperType().getOper(), tolerance, calcResult);
                }
                return true;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("<", "<", Type.Boolean, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    o0 = zeroDecimal;
                } else if (o1 == null) {
                    o1 = zeroDecimal;
                }
                return o0.compareTo(o1) < 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("<=", "<=", Type.Boolean, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    o0 = zeroDecimal;
                } else if (o1 == null) {
                    o1 = zeroDecimal;
                }
                return o0.compareTo(o1) <= 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("<>", "<>", Type.Boolean, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    o0 = zeroDecimal;
                } else if (o1 == null) {
                    o1 = zeroDecimal;
                }
                return o0.compareTo(o1) != 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("=", "=", Type.Boolean, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    o0 = zeroDecimal;
                } else if (o1 == null) {
                    o1 = zeroDecimal;
                }
                return o0.compareTo(o1) == 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc(">", ">", Type.Boolean, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    o0 = zeroDecimal;
                } else if (o1 == null) {
                    o1 = zeroDecimal;
                }
                return o0.compareTo(o1) > 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc(">=", ">=", Type.Boolean, new Type[]{Type.Number, Type.Number}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                BigDecimal o0 = (BigDecimal)args[0].calc(evaluator);
                BigDecimal o1 = (BigDecimal)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    o0 = zeroDecimal;
                } else if (o1 == null) {
                    o1 = zeroDecimal;
                }
                return o0.compareTo(o1) >= 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("<", "<", Type.Boolean, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    return true;
                }
                if (o1 == null) {
                    return false;
                }
                return o0.compareTo(o1) < 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("<=", "<=", Type.Boolean, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    return true;
                }
                if (o1 == null) {
                    return false;
                }
                return o0.compareTo(o1) <= 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("<>", "<>", Type.Boolean, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    return true;
                }
                if (o1 == null) {
                    return true;
                }
                return !o0.equals(o1);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc("=", "=", Type.Boolean, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    return false;
                }
                if (o1 == null) {
                    return false;
                }
                return o0.equals(o1);
            }
        });
        DefaultFunCalcFactory.define(new FunCalc(">", ">", Type.Boolean, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    return false;
                }
                if (o1 == null) {
                    return true;
                }
                return o0.compareTo(o1) > 0;
            }
        });
        DefaultFunCalcFactory.define(new FunCalc(">=", ">=", Type.Boolean, new Type[]{Type.String, Type.String}){

            @Override
            public Object calc(Evaluator evaluator, IExpress[] args) {
                String o0 = (String)args[0].calc(evaluator);
                String o1 = (String)args[1].calc(evaluator);
                if (o0 == null && o1 == null) {
                    return DefaultFunCalcFactory.handlerNullTuple(this, evaluator);
                }
                if (o0 == null) {
                    return false;
                }
                if (o1 == null) {
                    return true;
                }
                return o0.compareTo(o1) >= 0;
            }
        });
    }

    private static boolean handlerNullTuple(FunCalc funCalc, Evaluator evaluator) {
        switch (funCalc.getName()) {
            case "<": 
            case "<>": 
            case ">": {
                return false;
            }
            case "<=": 
            case "=": 
            case ">=": {
                return true;
            }
        }
        return false;
    }

    private static Boolean compare(String symbol, BigDecimal tolerance, BigDecimal calcResult) {
        switch (symbol) {
            case "=": 
            case "==": 
            case ">=": 
            case "<=": {
                return tolerance.compareTo(calcResult.abs()) >= 0;
            }
            case "!=": 
            case "<>": {
                return tolerance.compareTo(calcResult.abs()) < 0;
            }
            case ">": 
            case "<": {
                return tolerance.compareTo(calcResult.abs()) > 0;
            }
        }
        return false;
    }

    private static boolean isNumber(BigDecimal calc) {
        Double _double = calc.doubleValue();
        return !_double.isInfinite() && !_double.isNaN();
    }

    private static void define(FunCalc funCalc) {
        defaultFunTable.computeIfAbsent(funCalc.getName(), v -> Lists.newArrayListWithExpectedSize((int)2)).add(funCalc);
    }

    static {
        oneDecimal = BigDecimal.valueOf(1.0);
        negOneDecimal = BigDecimal.valueOf(-1.0);
        zeroDecimal = BigDecimal.valueOf(0.0);
        DefaultFunCalcFactory.definedDefault();
    }
}

