/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.calc;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.DefaultFunCalcFactory;
import kd.epm.eb.business.expr.calc.FunCalc;
import kd.epm.eb.business.expr.face.IExpress;
import org.apache.commons.collections4.CollectionUtils;

public class FunCalcFactory {
    private static Map<String, List<FunCalc>> funTable;
    public static final FunCalcFactory instance;

    public static FunCalcFactory getInstance() {
        return instance;
    }

    private static void defineOtherFun() {
    }

    public FunCalc getFunCalc(String funName, IExpress[] args) {
        List<FunCalc> funCalcList = funTable.get(funName);
        if (CollectionUtils.isEmpty(funCalcList)) {
            this.throwException(funName, args);
        }
        for (FunCalc funCalc : funCalcList) {
            Type[] argsType = funCalc.getArgsType();
            boolean[] argsCanNull = funCalc.getArgsCanNull();
            if (args == null) {
                if (argsType != null) continue;
                return funCalc;
            }
            if (args.length != argsType.length) continue;
            boolean isThisFun = true;
            for (int i = 0; i < args.length; ++i) {
                IExpress arg = args[i];
                if (arg == null) {
                    boolean canNull;
                    if (argsCanNull != null && (canNull = argsCanNull[i])) continue;
                    isThisFun = false;
                    break;
                }
                Type argReturnType = arg.getReturnType();
                if (argsType[i] == argReturnType) continue;
                isThisFun = false;
                break;
            }
            if (!isThisFun) continue;
            return funCalc;
        }
        this.throwException(funName, args);
        return null;
    }

    private void throwException(String funName, IExpress[] args) {
        StringBuilder argType = new StringBuilder();
        StringBuilder argString = new StringBuilder();
        if (args != null) {
            for (IExpress arg : args) {
                if (argType.length() > 0) {
                    argType.append(",");
                    argString.append(",");
                }
                if (arg == null) {
                    argType.append("null");
                    argString.append("null");
                    continue;
                }
                argType.append(arg.getReturnType().name());
                argString.append(arg.toString());
            }
        }
        String message = ResManager.loadResFormat((String)"\u65e0\u6cd5\u627e\u5230\u51fd\u6570:\u51fd\u6570\u540d[%1],\u53c2\u6570\u7c7b\u578b[%2],\u53c2\u6570\u503c[%3]", (String)"FunCalcFactory_1", (String)"epm-eb-business", (Object[])new Object[]{funName, argType.toString(), argString.toString()});
        throw new KDBizException(message);
    }

    static {
        instance = new FunCalcFactory();
        funTable = DefaultFunCalcFactory.getDefaultFunTable();
        FunCalcFactory.defineOtherFun();
    }
}

