/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.command.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.AggPair;
import kd.epm.eb.business.expr.command.face.ScriptParse;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AggOprtEnum;

public abstract class AbstractParse
implements ScriptParse {
    private IModelCacheHelper modelCacheHelper = null;
    private static final int INDEX_MEMBERNUM = 0;
    private static final int INDEX_AGGSIGN = 1;

    protected IModelCacheHelper getModel() {
        return this.modelCacheHelper;
    }

    protected void setModel(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    public String getMeasure() {
        return "FMONEY";
    }

    @Override
    public void parse() {
        this.verify();
    }

    protected void verify() {
        if (this.getModel() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u4e2d\u6240\u4f7f\u7528\u7684\u4f53\u7cfb\u6570\u636e\u4e3a\u7a7a", (String)"AbstractParse_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean hasExecute() {
        return false;
    }

    @Override
    public void execute() {
    }

    protected List<AggPair> parseExprMembers(Dimension dimension, Member member, List<Member> shareMembers, Map<Long, List<Member>> shareMemberMap) {
        LinkedList<AggPair> members = new LinkedList<AggPair>();
        LinkedList<String[]> leaf = new LinkedList<String[]>();
        if (member != null && member.getChildren() != null && !member.getChildren().isEmpty()) {
            this.parseMembers(dimension, member, member.getChildren(), null, leaf, shareMemberMap);
        }
        if (shareMembers != null) {
            Member tmpMember = null;
            for (Member share : shareMembers) {
                tmpMember = dimension.getMember(null, share.getNumber());
                if (tmpMember == null) continue;
                if (tmpMember.getChildren() != null && !tmpMember.getChildren().isEmpty()) {
                    this.parseMembers(dimension, tmpMember, tmpMember.getChildren(), null, leaf, shareMemberMap);
                    continue;
                }
                leaf.add(new String[]{tmpMember.getNumber(), AggOprtEnum.getAggOprtEnumBySign((String)tmpMember.getAggType()).getName()});
            }
        }
        for (String[] memberSign : leaf) {
            if (memberSign[0] == null || memberSign[1] == null) continue;
            members.add(new AggPair(memberSign[0], memberSign[1]));
        }
        return members;
    }

    private void parseMembers(Dimension dimension, Member member, List<Member> children, String[] memberSign, List<String[]> leaf, Map<Long, List<Member>> shareMemberMap) {
        if (dimension == null || member == null || children == null || children.isEmpty() || leaf == null) {
            return;
        }
        String[] _memberSign = null;
        if (memberSign == null) {
            memberSign = new String[]{member.getNumber(), AggOprtEnum.ADD.getName()};
        }
        Member tmpMember = null;
        List tmpChildren = null;
        for (Member _child : children) {
            List list = tmpChildren = shareMemberMap != null ? shareMemberMap.get(_child.getId()) : null;
            if (tmpChildren != null && !tmpChildren.isEmpty()) {
                _child = tmpMember = dimension.getMember(null, _child.getNumber());
            } else if (_child.getChildren() == null || _child.getChildren().isEmpty()) {
                tmpMember = dimension.getMember(null, _child.getNumber());
                if (tmpMember != null && !tmpMember.getChildren().isEmpty()) {
                    _child = tmpMember;
                    tmpChildren = _child.getChildren();
                }
            } else {
                tmpChildren = _child.getChildren();
            }
            if (!AggOprtEnum.ADD.getSign().equals(_child.getAggType()) && !AggOprtEnum.SUBSTRACT.getSign().equals(_child.getAggType())) continue;
            _memberSign = new String[]{_child.getNumber(), this.getOperSign(memberSign[1], AggOprtEnum.getAggOprtEnumBySign((String)_child.getAggType()).getName())};
            if (tmpChildren != null && !tmpChildren.isEmpty()) {
                this.parseMembers(dimension, _child, tmpChildren, _memberSign, leaf, shareMemberMap);
                continue;
            }
            leaf.add(_memberSign);
        }
    }

    private String getOperSign(String parentSign, String currSign) {
        String sign = AggOprtEnum.ADD.getName();
        if (parentSign == null || currSign == null) {
            return sign;
        }
        if (AggOprtEnum.ADD.getName().equals(parentSign)) {
            if (AggOprtEnum.ADD.getName().equals(currSign)) {
                sign = AggOprtEnum.ADD.getName();
            } else if (AggOprtEnum.SUBSTRACT.getName().equals(currSign)) {
                sign = AggOprtEnum.SUBSTRACT.getName();
            }
        } else if (AggOprtEnum.SUBSTRACT.getName().equals(parentSign)) {
            if (AggOprtEnum.ADD.getName().equals(currSign)) {
                sign = AggOprtEnum.SUBSTRACT.getName();
            } else if (AggOprtEnum.SUBSTRACT.getName().equals(currSign)) {
                sign = AggOprtEnum.ADD.getName();
            }
        } else if (AggOprtEnum.SKIP.getName().equals(parentSign)) {
            sign = currSign;
        }
        return sign;
    }
}

