/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.command.impl;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.IExpressionItem;
import kd.epm.eb.business.expr.business.AccountExpr;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.entity.FormulaMemberInfo;
import kd.epm.eb.business.expr.command.entity.FormulaRightInfo;
import kd.epm.eb.business.expr.command.impl.AbstractParse;
import kd.epm.eb.business.expr.command.impl.ScriptAggParse;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.dao.formula.service.FelExpress;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.LogUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ScriptAccParse
extends AbstractParse {
    private static final LogUtils log = LogUtils.getInstance(ScriptAccParse.class);
    private final AccountExpr expr;
    private LinkedList<CommandInfo> commands = new LinkedList();

    protected AccountExpr getExpr() {
        return this.expr;
    }

    public ScriptAccParse(AccountExpr express, IModelCacheHelper modelCacheHelper) {
        this.expr = express;
        this.setModel(modelCacheHelper);
    }

    @Override
    public void parse() {
        super.parse();
        this.getCommands().clear();
        LinkedList<FelExpress> formulas = this.getExpr().getFormulas();
        if (formulas == null || formulas.isEmpty()) {
            return;
        }
        log.begin("budget-script-log : ", "start deal account formula . size = " + formulas.size());
        Model model = this.getModel().getModelobj();
        StringBuilder sb = new StringBuilder();
        for (FelExpress express : formulas) {
            Map filters1 = express.getDimensionFilter(model, this.expr.getMembers());
            if (filters1 == null) {
                sb.append(express.getName()).append("  ");
                continue;
            }
            if (express.isTemplateExecute()) {
                this.getAggCommand(filters1, express);
            }
            this.addFelCommond(filters1, express.getExpression(), express.getExpressLeft());
        }
        if (sb.length() < 1) {
            log.end("end deal account formula.");
        } else {
            sb.append(ResManager.loadKDString((String)"\u8303\u56f4\u4e3a\u7a7a\uff0cend deal account formula.", (String)"ScriptAccParse_0", (String)"epm-eb-business", (Object[])new Object[0]));
            log.end(sb.toString());
        }
    }

    private void getAggCommand(Map<String, Set<String>> filters1, FelExpress express) {
        List<FormulaRightInfo> rightMemberList = this.getRightMemberInfo(express.getExpression());
        for (FormulaRightInfo formulaMemberInfo : rightMemberList) {
            List<FormulaMemberInfo> infos = formulaMemberInfo.getInfos();
            boolean isLeaf = true;
            for (FormulaMemberInfo info : infos) {
                IModelCacheHelper modelCache = this.getModel();
                Member member = modelCache.getMember(info.getDimNumber(), null, info.getMemberNumber());
                if (member == null || member.isLeaf()) continue;
                isLeaf = false;
                break;
            }
            if (isLeaf) continue;
            AggregateExpr aggregateExpr = new AggregateExpr();
            HashMap<String, Set<String>> members = new HashMap<String, Set<String>>(16);
            for (FormulaMemberInfo formulaMemberInfo2 : infos) {
                members.put(formulaMemberInfo2.getDimNumber(), Sets.newHashSet((Object[])new String[]{formulaMemberInfo2.getMemberNumber()}));
            }
            for (Map.Entry entry : filters1.entrySet()) {
                if (members.containsKey(entry.getKey())) continue;
                members.put((String)entry.getKey(), (Set<String>)entry.getValue());
            }
            aggregateExpr.addMembers(members);
            ScriptAggParse scriptAggParse = new ScriptAggParse(aggregateExpr, this.getModel());
            scriptAggParse.parse();
            List<CommandInfo> list = scriptAggParse.getCommands();
            this.commands.addAll(list);
        }
    }

    private List<FormulaRightInfo> getRightMemberInfo(String formulaStr) {
        formulaStr = StringUtils.replace((String)formulaStr, (String)"V('", (String)"v('");
        String[] arr = StringUtils.splitByWholeSeparator((String)formulaStr, (String)"v('");
        ArrayList<FormulaRightInfo> list = new ArrayList<FormulaRightInfo>(10);
        for (String s : arr) {
            int index = s.indexOf("')");
            if (index < 0) continue;
            String memberStr = StringUtils.substring((String)s, (int)0, (int)index);
            String[] dimArr = StringUtils.splitByWholeSeparator((String)memberStr, (String)",");
            ArrayList<FormulaMemberInfo> formulaMemberInfos = new ArrayList<FormulaMemberInfo>(10);
            for (String memStr : dimArr) {
                String[] memberArr = StringUtils.contains((CharSequence)memStr, (CharSequence)"@") ? StringUtils.splitByWholeSeparator((String)memStr, (String)"@") : StringUtils.splitByWholeSeparator((String)memStr, (String)".");
                FormulaMemberInfo formulaMemberInfo = new FormulaMemberInfo(memberArr[0], memberArr[1]);
                formulaMemberInfos.add(formulaMemberInfo);
            }
            list.add(new FormulaRightInfo(formulaMemberInfos));
        }
        return list;
    }

    private void addFelCommond(Map<String, Set<String>> filters1, String expression, String expressLeft) {
        ComputingCommandInfo command = new ComputingCommandInfo();
        FelLambdaExpressionItem item = new FelLambdaExpressionItem();
        item.setExpression(expression);
        item.setExpressLeft(expressLeft);
        ArrayList<DimensionFilterItem> filters = new ArrayList<DimensionFilterItem>(16);
        for (Map.Entry<String, Set<String>> entry : filters1.entrySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)entry.getValue())) continue;
            filters.add(new DimensionFilterItem(entry.getKey(), new ArrayList(entry.getValue())));
        }
        command.setFilter(filters);
        command.addExpression((IExpressionItem)item);
        command.setMainMeaName(this.getMeasure());
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, (Map)ShrekIdCodeUtils.getDefaultIdCodes(null));
        this.commands.add((CommandInfo)command);
    }

    @Override
    protected void verify() {
        super.verify();
    }

    @Override
    public List<CommandInfo> getCommands() {
        return this.commands;
    }
}

