/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.command.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.AggAxis;
import kd.bos.olap.dataSources.AggExpressionItem;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.IExpressionItem;
import kd.bos.olap.dataSources.MultiDimensionAggExpressionItem;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.impl.AbstractParse;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;

public class ScriptAggParse
extends AbstractParse {
    private final AggregateExpr expr;
    private List<AggregateExprObj> exprs = new ArrayList<AggregateExprObj>(16);
    private Map<String, DimensionFilterItem> filters = new HashMap<String, DimensionFilterItem>(16);

    protected AggregateExpr getExpr() {
        return this.expr;
    }

    public ScriptAggParse(AggregateExpr expr, IModelCacheHelper modelCacheHelper) {
        this.expr = expr;
        this.setModel(modelCacheHelper);
    }

    public List<AggregateExprObj> getExprs() {
        return this.exprs;
    }

    protected Map<String, DimensionFilterItem> getFilters() {
        return this.filters;
    }

    @Override
    public void parse() {
        super.parse();
        this.getExprs().clear();
        this.getFilters().clear();
        Member member = null;
        Dimension dimension = null;
        Map.Entry<String, Set<String>> entry2 = null;
        if (this.getModel().getDimensionList().size() != this.getExpr().getMembers().size()) {
            return;
        }
        if (this.getExpr().getMembers() == null || this.getExpr().getMembers().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u4e2d\u672a\u4f20\u5165\u7ef4\u5ea6\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScriptAggParse_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        AggregateExprObj _orgExprObj = this.getEntityExpr();
        if (_orgExprObj != null) {
            this.getExprs().add(_orgExprObj);
        }
        AggregateExprObj exprObj = new AggregateExprObj();
        MultiDimensionAggExpressionItem item = new MultiDimensionAggExpressionItem();
        AggAxis axis = null;
        DimensionFilterItem filter = null;
        List<AggPair> aggPairs = null;
        String dimNumber = null;
        Set<String> memberNums = null;
        HashSet<String> filterSet = null;
        boolean hasClear = false;
        for (Map.Entry<String, Set<String>> entry2 : this.getExpr().getMembers().entrySet()) {
            dimNumber = entry2.getKey();
            memberNums = entry2.getValue();
            dimension = this.getModel().getDimension(dimNumber);
            if (dimNumber == null || memberNums == null || memberNums.isEmpty()) continue;
            if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                axis = new AggAxis();
                axis.setMainDimensionName(dimNumber);
                Map shareMemberMap = (Map)this.getModel().getModelobj().getShareMembers().get(dimension.getId());
                for (String memberNum : memberNums) {
                    List shareMembers;
                    member = dimension.getMember(memberNum);
                    if (member == null) continue;
                    List list = shareMembers = shareMemberMap != null ? (List)shareMemberMap.get(member.getId()) : null;
                    if (member.getChildren() != null && !member.getChildren().isEmpty() || shareMembers != null && !shareMembers.isEmpty()) {
                        aggPairs = this.parseExprMembers(dimension, member, shareMembers, shareMemberMap);
                        if (aggPairs == null || aggPairs.isEmpty()) continue;
                        axis.addExpressionItem(new AggExpressionItem(member.getNumber(), aggPairs));
                        continue;
                    }
                    axis.addFixedMember(member.getNumber());
                }
                if (!axis.getExpressionItems().isEmpty()) {
                    item.getAxes().add(axis);
                }
                filterSet = new HashSet(16);
                filterSet.addAll(memberNums);
                for (String number : memberNums) {
                    filterSet.addAll(ModelCacheServiceHelper.getLeafOfNums((Member)dimension.getMember(number)));
                }
                if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                    filterSet.retainAll(MemberServiceHelper.getAggregateMember((Long)this.getModel().getModelobj().getId()));
                } else if (this.getModel().getModelobj().isModelByEB() && SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    filterSet.removeAll(MemberServiceHelper.getNotAggregateMemberByAccount((Long)this.getModel().getModelobj().getId()));
                }
                if (filterSet.isEmpty()) {
                    hasClear = true;
                }
                filter = new DimensionFilterItem(dimNumber, new ArrayList(filterSet));
                this.getFilters().put(dimNumber, filter);
                if (axis.getExpressionItems().isEmpty()) {
                    exprObj.getFilters().put(dimNumber, null);
                }
            } else {
                filterSet = new HashSet<String>(16);
                filterSet.addAll(memberNums);
                filter = new DimensionFilterItem(dimNumber, new ArrayList(filterSet));
                exprObj.getFilters().put(dimNumber, filter);
            }
            if (!hasClear) continue;
            item.getAxes().clear();
            this.getExprs().clear();
            this.getFilters().clear();
            break;
        }
        if (!item.getAxes().isEmpty()) {
            exprObj.getExpressItems().add((IExpressionItem)item);
            this.getExprs().add(exprObj);
        }
    }

    @Override
    protected void verify() {
        super.verify();
        if (this.getExpr() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u805a\u5408\u516c\u5f0f\u4e3a\u7a7a", (String)"ScriptAggParse_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        for (Map.Entry<String, Set<String>> entry : this.getExpr().getMembers().entrySet()) {
            if (this.getModel().getDimension(entry.getKey()) == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5f53\u524d\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u6307\u5b9a\u7684\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u7f16\u7801\u201c%1\u201d\u3002", (String)"ScriptAggParse_4", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey()}));
            }
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u6210\u5458\u4e3a\u7a7a\u3002", (String)"ScriptAggParse_6", (String)"epm-eb-business", (Object[])new Object[]{entry.getKey()}));
        }
    }

    @Override
    public List<CommandInfo> getCommands() {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>(16);
        if (this.getExprs().isEmpty()) {
            return commands;
        }
        ComputingCommandInfo command = null;
        String dimNumber = null;
        for (AggregateExprObj exprObj : this.getExprs()) {
            command = new ComputingCommandInfo();
            HashMap<String, DimensionFilterItem> filters = new HashMap<String, DimensionFilterItem>(16);
            for (Map.Entry<String, DimensionFilterItem> entry : exprObj.getFilters().entrySet()) {
                dimNumber = entry.getKey();
                if (entry.getValue() == null) {
                    filters.put(dimNumber, this.getFilters().get(dimNumber));
                    continue;
                }
                filters.put(dimNumber, entry.getValue());
            }
            if (filters == null || filters.isEmpty()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8bf7\u68c0\u67e5\u201c%1\u201d\uff0c\u805a\u5408\u516c\u5f0f\u7f3a\u5c11\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"ScriptAggParse_5", (String)"epm-eb-business", (Object[])new Object[]{JSON.toJSONString((Object)this.getExpr())}));
            }
            for (IExpressionItem expr : exprObj.getExpressItems()) {
                if (expr == null) continue;
                if (expr instanceof MultiDimensionAggExpressionItem) {
                    MultiDimensionAggExpressionItem exprItem = (MultiDimensionAggExpressionItem)expr;
                    for (AggAxis asix : exprItem.getAxes()) {
                        if (asix.getMainDimensionName() == null || asix.getExpressionItems().isEmpty()) continue;
                        filters.remove(asix.getMainDimensionName());
                    }
                }
                command.addExpression(expr);
            }
            command.setFilter(new ArrayList(filters.values()));
            command.setMainMeaName(this.getMeasure());
            commands.add((CommandInfo)command);
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, (Map)ShrekIdCodeUtils.getDefaultIdCodes(null));
        }
        return commands;
    }

    protected AggregateExprObj getEntityExpr() {
        AggregateExprObj exprObj = new AggregateExprObj();
        MultiDimensionAggExpressionItem expr = new MultiDimensionAggExpressionItem();
        exprObj.getExpressItems().add((IExpressionItem)expr);
        for (String dimNumber : this.getExpr().getMembers().keySet()) {
            exprObj.getFilters().put(dimNumber, null);
        }
        exprObj.getFilters().remove(SysDimensionEnum.Entity.getNumber());
        Set<String> memberNums = this.getExpr().getMembers().get(SysDimensionEnum.Entity.getNumber());
        if (memberNums == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u7ef4\u5ea6\u3002", (String)"ScriptAggParse_1", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.Entity.getNumber()}));
        }
        List<AggPair> aggPairs = null;
        AggAxis axis = new AggAxis();
        axis.setMainDimensionName(SysDimensionEnum.Entity.getNumber());
        expr.getAxes().add(axis);
        Member member = null;
        Dimension dimension = this.getModel().getDimension(SysDimensionEnum.Entity.getNumber());
        Map shareMemberMap = (Map)this.getModel().getModelobj().getShareMembers().get(dimension.getId());
        for (String memberNum : memberNums) {
            List shareMembers;
            member = dimension.getMember(memberNum);
            List list = shareMembers = shareMemberMap != null ? (List)shareMemberMap.get(member.getId()) : null;
            if ((member == null || member.getChildren() == null || member.getChildren().isEmpty()) && (shareMembers == null || shareMembers.isEmpty()) || (aggPairs = this.parseExprMembers(dimension, member, shareMembers, shareMemberMap)) == null || aggPairs.isEmpty()) continue;
            axis.addExpressionItem(new AggExpressionItem(member.getNumber(), aggPairs));
        }
        if (axis.getExpressionItems().isEmpty()) {
            exprObj = null;
        }
        return exprObj;
    }

    static class AggregateExprObj {
        private List<IExpressionItem> items = new ArrayList<IExpressionItem>(16);
        private Map<String, DimensionFilterItem> filters = new HashMap<String, DimensionFilterItem>(16);

        AggregateExprObj() {
        }

        public List<IExpressionItem> getExpressItems() {
            return this.items;
        }

        public Map<String, DimensionFilterItem> getFilters() {
            return this.filters;
        }
    }
}

