/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.FunCalc;
import kd.epm.eb.business.expr.expr.OperationExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.oper.AbstractOper;
import kd.epm.eb.business.expr.oper.AddOper;
import kd.epm.eb.business.expr.oper.AndOper;
import kd.epm.eb.business.expr.oper.OperationType;
import kd.epm.eb.business.expr.oper.OrOper;
import kd.epm.eb.business.expr.utils.ExprUtils;
import org.apache.commons.lang3.StringUtils;

public class BinaryExpr
extends OperationExpr {
    private IExpress left = null;
    private IExpress right = null;
    private FunCalc funCalc;
    IExpress[] args;
    private String cacheKey;
    private String showString;

    public IExpress getLeft() {
        return this.left;
    }

    public void setLeft(IExpress left) {
        this.left = left;
    }

    public IExpress getRight() {
        return this.right;
    }

    public void setRight(IExpress right) {
        this.right = right;
    }

    public BinaryExpr(AbstractOper operType) {
        super(operType);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.getOperType().getSID(), _left.getOperType().getSID()) > 0) {
                str.append("(" + this.left.toString() + ")");
            } else {
                str.append(this.left.toString());
            }
        } else {
            str.append(this.left.toString());
        }
        str.append(this.getOperType().getOper());
        if (this.getOperType().getSID() == 20) {
            str.append(this.right.toString());
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.getOperType().getSID(), _right.getOperType().getSID()) >= 0) {
                str.append("(" + this.right.toString() + ")");
            } else {
                str.append(this.right.toString());
            }
        } else {
            str.append(this.right.toString());
        }
        return str.toString();
    }

    @Override
    public String toOlap() {
        if (this.left == null || this.right == null) {
            throw new KDBizException("");
        }
        StringBuilder str = new StringBuilder();
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            if (OperationType.comparePRI(this.getOperType().getSID(), _left.getOperType().getSID()) > 0) {
                str.append("(").append(this.left.toOlap()).append(")");
            } else {
                str.append(this.left.toOlap());
            }
        } else {
            str.append(this.left.toOlap());
        }
        str.append(this.getOperType().getOper());
        if (this.getOperType().getSID() == 20) {
            str.append(this.right.toOlap());
        } else if (this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            if (OperationType.comparePRI(this.getOperType().getSID(), _right.getOperType().getSID()) >= 0) {
                str.append("(").append(this.right.toOlap()).append(")");
            } else {
                str.append(this.right.toOlap());
            }
        } else {
            str.append(this.right.toOlap());
        }
        return str.toString();
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        return this.funCalc.calc(evaluator, this.args);
    }

    @Override
    public Type getReturnType() {
        if (this.getOperType() instanceof AddOper) {
            return this.funCalc.getReturnType();
        }
        return super.getReturnType();
    }

    @Override
    public void init(Evaluator evaluator) {
        if (this.args == null) {
            this.args = new IExpress[]{this.left, this.right};
        }
        for (IExpress arg : this.args) {
            arg.init(evaluator);
        }
        this.cacheKey = this.left.getCacheKey() + this.getOperType().getOper() + this.right.getCacheKey();
        this.funCalc = evaluator.getFunCalc(this.getOperType().getOper(), this.args);
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        boolean leftAddParenthesis = false;
        boolean rightAddParenthesis = false;
        if (this.left instanceof BinaryExpr) {
            BinaryExpr _left = (BinaryExpr)this.left;
            boolean bl = leftAddParenthesis = OperationType.comparePRI(this.getOperType().getSID(), _left.getOperType().getSID()) > 0;
        }
        if (this.getOperType().getSID() != 20 && this.right instanceof BinaryExpr) {
            BinaryExpr _right = (BinaryExpr)this.right;
            boolean bl = rightAddParenthesis = OperationType.comparePRI(this.getOperType().getSID(), _right.getOperType().getSID()) >= 0;
        }
        if (this.getOperType() instanceof AndOper || this.getOperType() instanceof OrOper) {
            ExprUtils.appendStringPanel(env, panels, this.getOperType().getOper());
            ExprUtils.appendStringPanel(env, panels, "(");
            ExprUtils.appendPartPanel(env, panels, false, this.left);
            ExprUtils.appendStringPanel(env, panels, ",");
            ExprUtils.appendPartPanel(env, panels, false, this.right);
            ExprUtils.appendStringPanel(env, panels, ")");
        } else {
            ExprUtils.appendPartPanel(env, panels, leftAddParenthesis, this.left);
            ExprUtils.appendStringPanel(env, panels, this.getOperType().getOper());
            ExprUtils.appendPartPanel(env, panels, rightAddParenthesis, this.right);
        }
        return panels;
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public String getShowString(Evaluator evaluator) {
        if (StringUtils.isEmpty((CharSequence)this.showString)) {
            StringBuilder str = new StringBuilder();
            if (this.left instanceof BinaryExpr && OperationType.comparePRI(this.getOperType().getSID(), ((BinaryExpr)this.left).getOperType().getSID()) > 0) {
                str.append("(").append(this.left.getShowString(evaluator)).append(")");
            } else {
                str.append(this.left.getShowString(evaluator));
            }
            str.append(this.getOperType().getOper());
            if (this.getOperType().getSID() == 20) {
                str.append(this.right.getShowString(evaluator));
            } else if (this.right instanceof BinaryExpr && OperationType.comparePRI(this.getOperType().getSID(), ((BinaryExpr)this.right).getOperType().getSID()) >= 0) {
                str.append("(").append(this.right.getShowString(evaluator)).append(")");
            } else {
                str.append(this.right.getShowString(evaluator));
            }
            this.showString = str.toString();
        }
        return this.showString;
    }
}

