/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.utils.ExprUtils;

public class BooleanExpr
extends AbstractExpr {
    private boolean value = true;

    public BooleanExpr() {
    }

    public BooleanExpr(boolean value) {
        this.value = value;
    }

    public BooleanExpr(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    @Override
    public String toString() {
        return this.value ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    @Override
    public String toOlap() {
        return this.value ? "1" : "0";
    }

    @Override
    public Type getReturnType() {
        return Type.Boolean;
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        return this.value;
    }

    @Override
    public String getCacheKey() {
        return this.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprUtils.appendStringPanel(env, panels, this.toString());
        return panels;
    }
}

