/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.FunCalc;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.utils.ExprUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConditionExpr
extends AbstractExpr {
    private IExpress condition = null;
    private List<IExpress> lefts = null;
    private List<IExpress> rights = null;
    private FunCalc funCalc;
    private IExpress[] params;
    private String cacheKey;
    private String showString;

    public IExpress getCondition() {
        return this.condition;
    }

    public void setCondition(IExpress condition) {
        this.condition = condition;
    }

    public List<IExpress> getLefts() {
        return this.lefts;
    }

    public void setLefts(List<IExpress> lefts) {
        this.lefts = lefts;
    }

    public List<IExpress> getRights() {
        return this.rights;
    }

    public void setRights(List<IExpress> rights) {
        this.rights = rights;
    }

    @Override
    public String toString() {
        int i;
        int in;
        if (this.condition == null || this.lefts == null || this.lefts.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder("IF").append(' ');
        str.append("[");
        str.append(this.condition.toString());
        str.append("]").append(' ');
        str.append("{").append("\r\n");
        if (this.lefts != null) {
            in = this.lefts.size();
            for (i = 0; i < in; ++i) {
                str.append(this.lefts.get(i).toString()).append(";").append("\r\n");
            }
        }
        str.append("}");
        if (this.rights != null && !this.rights.isEmpty()) {
            str.append(' ');
            str.append("ELSE").append(' ').append("{").append("\r\n");
            in = this.rights.size();
            for (i = 0; i < in; ++i) {
                str.append(this.rights.get(i).toString()).append(";").append("\r\n");
            }
            str.append("}");
        }
        return str.toString();
    }

    @Override
    public String toOlap() {
        if (this.condition == null || this.lefts == null || this.lefts.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6cd5\u7684if\u8bed\u53e5\u3002", (String)"ConditionExpr_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        StringBuilder str = new StringBuilder("IF").append(' ');
        str.append('(');
        str.append(this.condition.toString());
        str.append(')').append(' ');
        str.append("{").append("\r\n");
        if (this.lefts != null && this.lefts.size() > 0) {
            this.lefts.forEach(left -> str.append(left.toOlap()).append(";").append("\r\n"));
        }
        str.append("}");
        if (this.rights != null && this.rights.size() > 0) {
            str.append(' ');
            str.append("ELSE").append(' ').append("{").append("\r\n");
            this.rights.forEach(right -> str.append(right.toString()).append(";").append("\r\n"));
            str.append("}");
        }
        return str.toString();
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        return this.funCalc.calc(evaluator, this.params);
    }

    @Override
    public Type getReturnType() {
        IExpress param1 = this.params[1];
        IExpress param2 = this.params[2];
        if (param1 != null) {
            return param1.getReturnType();
        }
        if (param2 != null) {
            return param2.getReturnType();
        }
        return null;
    }

    @Override
    public void init(Evaluator evaluator) {
        if (this.params == null) {
            this.params = new IExpress[3];
            this.params[0] = this.condition;
            if (CollectionUtils.isNotEmpty(this.lefts)) {
                this.params[1] = this.lefts.get(0);
            }
            if (CollectionUtils.isNotEmpty(this.rights)) {
                this.params[2] = this.rights.get(0);
            }
        } else {
            this.params[0] = this.condition;
            if (CollectionUtils.isNotEmpty(this.lefts)) {
                this.params[1] = this.lefts.get(0);
            }
            if (CollectionUtils.isNotEmpty(this.rights)) {
                this.params[2] = this.rights.get(0);
            }
        }
        for (IExpress param : this.params) {
            if (param == null) continue;
            param.init(evaluator);
        }
        this.funCalc = evaluator.getFunCalc("IF", this.params);
        this.getCacheKey();
    }

    @Override
    public String getCacheKey() {
        if (StringUtils.isEmpty((CharSequence)this.cacheKey)) {
            StringBuilder cacheKeySb = new StringBuilder();
            cacheKeySb.append("IF(").append(this.condition.getCacheKey()).append(",");
            if (this.params[1] != null) {
                cacheKeySb.append(this.params[1].getCacheKey());
            } else {
                cacheKeySb.append("NULL");
            }
            cacheKeySb.append(",");
            if (this.params[2] != null) {
                cacheKeySb.append(this.params[2].getCacheKey());
            } else {
                cacheKeySb.append("NULL");
            }
            cacheKeySb.append(")");
            this.cacheKey = cacheKeySb.toString();
        }
        return this.cacheKey;
    }

    @Override
    public String getShowString(Evaluator evaluator) {
        if (StringUtils.isEmpty((CharSequence)this.showString)) {
            StringBuilder showStringSb = new StringBuilder();
            showStringSb.append("IF(").append(this.condition.getShowString(evaluator)).append(",");
            if (this.params[1] != null) {
                showStringSb.append(this.params[1].getShowString(evaluator));
            } else {
                showStringSb.append("NULL");
            }
            showStringSb.append(",");
            if (this.params[2] != null) {
                showStringSb.append(this.params[2].getShowString(evaluator));
            } else {
                showStringSb.append("NULL");
            }
            showStringSb.append(")");
            this.showString = showStringSb.toString();
        }
        return this.showString;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprUtils.appendStringPanel(env, panels, "IF(");
        panels.addAll(this.condition.toPanel(env));
        ExprUtils.appendStringPanel(env, panels, ",");
        if (this.lefts == null || this.lefts.isEmpty()) {
            ExprUtils.appendStringPanel(env, panels, "NULL");
        } else {
            panels.addAll(this.lefts.get(0).toPanel(env));
        }
        ExprUtils.appendStringPanel(env, panels, ",");
        if (this.rights == null || this.rights.isEmpty()) {
            ExprUtils.appendStringPanel(env, panels, "NULL");
        } else {
            panels.addAll(this.rights.get(0).toPanel(env));
        }
        ExprUtils.appendStringPanel(env, panels, ")");
        return panels;
    }
}

