/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.calc.FunCalc;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.utils.ExprUtils;

public class FunctionExpr
extends AbstractExpr {
    private String functionName = null;
    private FunCalc funCalc;
    private List<IExpress> params = Lists.newLinkedList();
    private IExpress[] paramArray;
    private String cacheKey;
    private String showString;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public List<IExpress> getParams() {
        return this.params;
    }

    public void setParams(List<IExpress> params) {
        this.params = params;
    }

    @Override
    public String toString() {
        if (this.functionName == null || this.functionName.trim().length() == 0) {
            return "";
        }
        StringBuilder expr = new StringBuilder("@").append(Character.toUpperCase(this.functionName.charAt(0))).append(this.functionName.substring(1).toLowerCase());
        expr.append("(");
        if (!this.params.isEmpty()) {
            int in = this.params.size();
            for (int i = 0; i < in; ++i) {
                expr.append(this.params.get(i).toString() + ",");
            }
            if (expr.length() > 0) {
                expr.setLength(expr.length() - 1);
            }
        }
        expr.append(")");
        return expr.toString();
    }

    @Override
    public void init(Evaluator evaluator) {
        this.paramArray = this.params.toArray(new IExpress[0]);
        for (IExpress param : this.params) {
            param.init(evaluator);
        }
        StringBuilder cacheKeySb = new StringBuilder(this.functionName);
        cacheKeySb.append("(");
        if (!this.params.isEmpty()) {
            int in = this.params.size();
            for (int i = 0; i < in; ++i) {
                cacheKeySb.append(this.params.get(i).toString()).append(",");
            }
            if (cacheKeySb.length() > 0) {
                cacheKeySb.setLength(cacheKeySb.length() - 1);
            }
        }
        cacheKeySb.append(")");
        this.cacheKey = cacheKeySb.toString();
        this.funCalc = evaluator.getFunCalc(this.functionName, this.paramArray);
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        return this.funCalc.calc(evaluator, this.paramArray);
    }

    @Override
    public boolean needCache() {
        return false;
    }

    @Override
    public Type getReturnType() {
        return Type.Boolean;
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprUtils.appendStringPanel(env, panels, this.functionName + "(");
        for (IExpress param : this.params) {
            if (param != null) {
                panels.addAll(param.toPanel(env));
            } else {
                ExprUtils.appendStringPanel(env, panels, "NULL");
            }
            ExprUtils.appendStringPanel(env, panels, ",");
        }
        panels.remove(panels.size() - 1);
        ExprUtils.appendStringPanel(env, panels, ")");
        return panels;
    }

    @Override
    public String getShowString(Evaluator evaluator) {
        if (this.showString == null) {
            StringBuilder showStringSb = new StringBuilder(this.functionName);
            showStringSb.append("(");
            if (!this.params.isEmpty()) {
                int in = this.params.size();
                for (int i = 0; i < in; ++i) {
                    showStringSb.append(this.params.get(i).getShowString(evaluator)).append(",");
                }
                if (showStringSb.length() > 0) {
                    showStringSb.setLength(showStringSb.length() - 1);
                }
            }
            showStringSb.append(")");
            this.showString = showStringSb.toString();
        }
        return this.showString;
    }
}

