/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.examinev2.vo.ExprPanelTypeEnum;
import kd.epm.eb.business.examinev2.vo.ReportShowExamineMemberBo;
import kd.epm.eb.business.expr.Dimension;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Member;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.utils.ExprUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MemberGroupExpr
extends AbstractExpr {
    private String memberKey;
    private Long templateId;
    private List<MemberExpr> members = new ArrayList<MemberExpr>(16);
    private List<MemberExpr> realMembers;
    private Set<String> dims;
    private Type returnType;
    private List<Member> evalMembers;
    private String showString;

    public List<MemberExpr> getMembers() {
        return this.members;
    }

    public List<MemberExpr> getRealMembers() {
        if (this.realMembers == null) {
            return this.members;
        }
        return this.realMembers;
    }

    public void setRealMembers(List<MemberExpr> realMembers) {
        this.realMembers = realMembers;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public void addMember(MemberExpr member) {
        if (member == null) {
            return;
        }
        boolean hasAdd = true;
        MemberExpr _member = null;
        int in = this.members.size();
        for (int i = 0; i < in; ++i) {
            _member = this.members.get(i);
            if (!_member.getDimNumber().equals(member.getDimNumber())) continue;
            this.members.set(i, member);
            hasAdd = false;
        }
        if (hasAdd) {
            this.members.add(member);
        }
    }

    public boolean remove(MemberExpr member) {
        if (member == null || member.getDimNumber() == null || member.getNumber() == null) {
            return false;
        }
        return this.remove(member.getDimNumber(), member.getNumber());
    }

    public boolean remove(String dimNumber, String number) {
        boolean hasRemove = false;
        if (dimNumber == null || number == null) {
            return hasRemove;
        }
        MemberExpr _member = null;
        int in = this.members.size();
        for (int i = 0; i < in; ++i) {
            _member = this.members.get(i);
            if (!_member.getDimNumber().equals(dimNumber) || !_member.getNumber().equals(number)) continue;
            this.members.remove(i);
            hasRemove = true;
            break;
        }
        return hasRemove;
    }

    @Override
    public String toString() {
        return "Member";
    }

    @Override
    public String toOlap() {
        if (this.members.size() == 0) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        str.append("v('");
        for (int i = 0; i < this.members.size(); ++i) {
            MemberExpr memberExpr = this.members.get(i);
            str.append(memberExpr.toOlap());
            if (i == this.members.size() - 1) continue;
            str.append(",");
        }
        str.append("')");
        return str.toString();
    }

    @Override
    public void init(Evaluator evaluator) {
        Member member;
        List<Dimension> dimensionList = evaluator.getCube().getDimensionList();
        ArrayList evalMembersTem = Lists.newArrayListWithExpectedSize((int)dimensionList.size());
        List<MemberExpr> realMembers = this.getRealMembers();
        for (int i = 0; i < realMembers.size(); ++i) {
            MemberExpr memberExpr = realMembers.get(i);
            if (SysDimensionEnum.Metric.getNumber().equals(memberExpr.getDimNumber())) {
                this.putInReturnType(evaluator, evaluator.getModelCache(), memberExpr);
            }
            if ((member = evaluator.getMember(memberExpr)) == null) continue;
            evalMembersTem.add(member);
        }
        for (Dimension dimension : dimensionList) {
            if (this.dims.contains(dimension.getNumber())) continue;
            member = dimension.getMember(dimension.getNoneNumber());
            evalMembersTem.add(member);
        }
        this.evalMembers = evalMembersTem;
    }

    private void putInReturnType(Evaluator evaluator, IModelCacheHelper modelCache, MemberExpr memberExpr) {
        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(memberExpr.getDimNumber(), null, memberExpr.getNumber());
        if (member == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6210\u5458\u201c%1\u201d\u627e\u4e0d\u5230,\u8bf7\u68c0\u67e5\u52fe\u7a3d\u5173\u7cfb\u201d%2\u2018\u3002", (String)"RuleExecutionService_12", (String)"epm-eb-business", (Object[])new Object[]{memberExpr.toString(), evaluator.getNumber()}));
        }
        this.returnType = ExprUtils.analyzeReturnType(member);
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        Object value;
        Evaluator evaluator1 = evaluator.push(this.evalMembers);
        if (this.relate(evaluator1)) {
            evaluator.setRelate(true);
        }
        if ((value = evaluator1.evaluatorCurrent()) != null) {
            evaluator.setAllNull(false);
        }
        return value;
    }

    private boolean relate(Evaluator evaluator1) {
        if (!evaluator1.getCube().getCartesian().booleanValue()) {
            return true;
        }
        Map<Object, Set<String>> relationMap = evaluator1.getCube().getRelationMap();
        if (CollectionUtils.isEmpty(relationMap)) {
            return false;
        }
        Map<String, String> fixMemberMap = evaluator1.getCube().getFixMemberMap();
        Member[] currentMembers = evaluator1.getCurrentMembers();
        Map<String, Integer> dimIndexMap = evaluator1.getDimIndexMap();
        for (Map.Entry<Object, Set<String>> entry : relationMap.entrySet()) {
            String[] dimArr = (String[])entry.getKey();
            StringBuilder memNums = new StringBuilder();
            for (int i = 0; i < dimArr.length; ++i) {
                Integer index;
                if (fixMemberMap.containsKey(dimArr[i])) {
                    memNums.append(fixMemberMap.get(dimArr[i]));
                }
                if ((index = dimIndexMap.get(dimArr[i])) != null) {
                    memNums.append(currentMembers[index].getNumber());
                }
                memNums.append(":");
            }
            if (entry.getValue().contains(memNums.substring(0, memNums.length() - 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.Number;
        }
        return this.returnType;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        Map<String, ReportShowExamineMemberBo> examineMemberBoMap = env.getExamineMemberBoMap();
        ReportShowExamineMemberBo ruleMemberBo = examineMemberBoMap.get(this.getMemberKey());
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelTypeEnum.Member, true);
        panel.setMemberKey(this.getMemberKey());
        panel.setShowString(ruleMemberBo.getName());
        panel.setDimMemberInfo(ruleMemberBo.getDimToMemMap());
        panel.setValue(ruleMemberBo.getValue().toString());
        panels.add(panel);
        return panels;
    }

    @Override
    public String getCacheKey() {
        return this.memberKey;
    }

    public String getMemberKey() {
        return this.memberKey;
    }

    public void setMemberKey(String memberKey) {
        this.memberKey = memberKey;
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    @Override
    public String getShowString(Evaluator evaluator) {
        if (StringUtils.isEmpty((CharSequence)this.showString)) {
            Map<Long, String> templateIdToNumMap;
            String templateNumber;
            StringBuilder str = new StringBuilder();
            str.append('{');
            if (this.templateId != null && StringUtils.isNotEmpty((CharSequence)(templateNumber = (templateIdToNumMap = evaluator.getTemplateIdToNumMap()).get(this.templateId)))) {
                str.append(templateNumber).append('|');
            }
            for (MemberExpr member : this.members) {
                if (!evaluator.getMainDim().equals(member.getDimNumber())) continue;
                IModelCacheHelper modelCache = evaluator.getModelCache();
                kd.epm.eb.common.cache.impl.Member member1 = modelCache.getMember(member.getDimNumber(), null, member.getNumber());
                if (member1 != null) {
                    str.append(member1.getName());
                    continue;
                }
                str.append(member.getNumber());
            }
            str.append('}');
            this.showString = str.toString();
        }
        return this.showString;
    }

    public void setDims(Set<String> dims) {
        this.dims = dims;
    }

    public Set<String> getDims() {
        return this.dims;
    }
}

