/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.common.utils.StringUtils;

public class MemberSetExpr
extends AbstractExpr {
    private String dimNumber;
    private Set<String> members = new LinkedHashSet<String>();

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }

    public String getDimNumber() {
        return this.dimNumber;
    }

    public Set<String> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public MemberSetExpr() {
    }

    public MemberSetExpr(String dimNumber) {
        this();
        this.dimNumber = dimNumber;
    }

    public void addMember(MemberExpr member) {
        if (member == null || StringUtils.isEmpty((String)member.getNumber())) {
            return;
        }
        if (this.getDimNumber().equalsIgnoreCase(member.getDimNumber())) {
            this.members.add(member.getNumber());
        }
    }

    public boolean remove(String memberNumber) {
        return this.members.remove(memberNumber);
    }

    public void clear() {
        this.members.clear();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String toOlap() {
        if (this.members.size() == 0 || this.dimNumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MemberSetExpr_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Iterator<String> memberiterator = this.members.iterator();
        if (this.members.size() == 1) {
            MemberExpr memberExpr = new MemberExpr();
            memberExpr.setDimNumber(this.dimNumber);
            memberExpr.setNumber(memberiterator.next());
            return memberExpr.toOlap();
        }
        StringBuilder str = new StringBuilder();
        str.append(this.dimNumber).append(".In").append('(');
        while (memberiterator.hasNext()) {
            str.append(memberiterator.next());
            if (!memberiterator.hasNext()) continue;
            str.append(",");
        }
        str.append(')');
        return str.toString();
    }
}

