/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.utils.ExprUtils;

public class NumberExpr
extends AbstractExpr {
    private Number number = null;

    public Number getNumber() {
        return this.number;
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    public NumberExpr() {
    }

    public NumberExpr(String numeric) {
        this.number = new BigDecimal(numeric);
    }

    public NumberExpr(BigDecimal numeric) {
        this.number = numeric;
    }

    @Override
    public String toString() {
        if (this.number instanceof BigDecimal) {
            return ((BigDecimal)this.number).stripTrailingZeros().toPlainString();
        }
        return String.valueOf(this.number.toString());
    }

    public IExpress clone() {
        NumberExpr expr = new NumberExpr();
        if (this.number instanceof BigDecimal) {
            expr.number = new BigDecimal(((BigDecimal)this.number).stripTrailingZeros().toPlainString());
        }
        return expr;
    }

    @Override
    public String toOlap() {
        if (this.number instanceof BigDecimal) {
            return ((BigDecimal)this.number).stripTrailingZeros().toPlainString();
        }
        return String.valueOf(this.number.toString());
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        evaluator.setAllNull(false);
        if (this.number instanceof BigDecimal) {
            return this.number;
        }
        return new BigDecimal(this.number.toString());
    }

    @Override
    public Type getReturnType() {
        return Type.Number;
    }

    @Override
    public String getCacheKey() {
        return this.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprUtils.appendStringPanel(env, panels, this.toString());
        return panels;
    }
}

