/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.business.examinev2.PanelEnvironment;
import kd.epm.eb.business.examinev2.vo.ExprPanel;
import kd.epm.eb.business.expr.Evaluator;
import kd.epm.eb.business.expr.Type;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.utils.ExprUtils;

public class StringExpr
extends AbstractExpr {
    private String value = null;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public StringExpr(String value) {
        this.value = value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value;
    }

    @Override
    public String toString() {
        return "\"" + (this.value == null || this.value.trim().length() == 0 ? "" : this.value.trim()) + "\"";
    }

    public IExpress clone() {
        StringExpr expr = new StringExpr(this.value);
        return expr;
    }

    @Override
    public String toOlap() {
        return this.value;
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprUtils.appendStringPanel(env, panels, this.toString());
        return panels;
    }

    @Override
    public Object doCalc(Evaluator evaluator) {
        evaluator.setAllNull(false);
        return this.value;
    }

    @Override
    public String getCacheKey() {
        return "'" + this.value + "'";
    }

    @Override
    public Type getReturnType() {
        return Type.String;
    }
}

