/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.exprproxy;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.epm.eb.business.expr.ParseException;
import kd.epm.eb.business.expr.expr.AbstractProxy;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.parse.ScriptParseUtils;
import kd.epm.eb.common.utils.StringUtils;

public class FunctionExprProxy
extends AbstractProxy {
    private static final Set<String> functionName = new HashSet<String>(16);
    public static final String Self = "Self";
    public static final String Descendants = "Descendants";
    public static final String Idescendants = "Idescendants";
    public static final String Children = "Children";
    public static final String IChildrens = "IChildrens";
    public static final String Siblings = "Siblings";
    public static final String ISiblings = "ISiblings";
    public static final String Leafs = "Leafs";
    public static final String NotLeafs = "NotLeafs";
    public static final String Ancestors = "Ancestors";
    public static final String IAncestors = "IAncestors";
    public static final String Remove = "Remove";
    public static final String IF = "IF";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NOTNULL = "NOTNULL";

    public static boolean check(String functionStr) {
        FunctionExpr expr = FunctionExprProxy.parse(functionStr);
        return expr != null;
    }

    public static FunctionExpr get(String functionStr) {
        FunctionExpr expr = null;
        try {
            expr = FunctionExprProxy.parse(functionStr);
        }
        catch (Exception ex) {
            logger.error("parse function error:" + functionStr, (Throwable)ex);
        }
        return expr;
    }

    private static FunctionExpr parse(String functionStr) throws ParseException {
        if (StringUtils.isEmpty((String)functionStr)) {
            throw new ParseException("error function or function is null.");
        }
        String functionName = null;
        String function = null;
        String paramStr = null;
        int pSize = 0;
        int bkSize = 0;
        int brSize = 0;
        int index = 0;
        List<IExpress> params = null;
        FunctionExpr expr = null;
        functionStr = functionStr.trim();
        try {
            if (!functionStr.startsWith("@")) {
                return null;
            }
            int begin = functionStr.indexOf("(");
            if (begin == -1) {
                return null;
            }
            functionName = functionStr.substring(1, begin);
            if (StringUtils.isEmpty((String)functionName) || !FunctionExprProxy.getFunctionName().contains(functionName) || !functionStr.endsWith(")")) {
                throw new ParseException("Unsupported functions." + functionName);
            }
            expr = new FunctionExpr();
            expr.setFunctionName(functionName);
            ScriptParseUtils utils = new ScriptParseUtils();
            function = functionStr.substring(begin + 1, functionStr.length() - 1);
            int in = function.length();
            for (int i = 0; i < in; ++i) {
                char _char = function.charAt(i);
                if ('(' == _char) {
                    ++pSize;
                } else if ('[' == _char) {
                    ++bkSize;
                } else if ('{' == _char) {
                    ++brSize;
                } else if (')' == _char) {
                    --pSize;
                } else if (']' == _char) {
                    --bkSize;
                } else if ('}' == _char) {
                    --brSize;
                }
                if (pSize == 0 && bkSize == 0 && brSize == 0 && ',' == _char) {
                    paramStr = function.substring(index, i);
                    index = i + 1;
                    params = utils.prase(paramStr);
                    if (params != null) {
                        expr.getParams().addAll(params);
                    }
                }
                if (i != function.length() - 1 || (params = utils.prase(paramStr = function.substring(index, i + 1))) == null) continue;
                expr.getParams().addAll(params);
            }
        }
        catch (ParseException ex) {
            logger.error("function parse error:", (Throwable)((Object)ex));
            expr = null;
        }
        return expr;
    }

    public static Set<String> getFunctionName() {
        if (functionName.isEmpty()) {
            try {
                Field[] fields = FunctionExprProxy.class.getDeclaredFields();
                if (fields != null) {
                    for (Field field : fields) {
                        if (field.getType() != String.class) continue;
                        functionName.add(field.getName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return functionName;
    }
}

