/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.exprproxy;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.expr.ParseException;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.parse.ScriptParseUtils;

public class OrExprProxy {
    public static final String CONDITION_KEY = "^(?i)OR\\(.*?\\)$";

    public static boolean check(String formulaStr) throws ParseException {
        FunctionExpr expr = OrExprProxy.get(formulaStr);
        return expr != null;
    }

    public static FunctionExpr get(String formulaStr) throws ParseException {
        if (formulaStr == null || formulaStr.trim().length() == 0) {
            return null;
        }
        String _formulaStr = formulaStr.trim();
        if (!_formulaStr.matches(CONDITION_KEY)) {
            return null;
        }
        return OrExprProxy.parse(_formulaStr);
    }

    private static FunctionExpr parse(String formulaStr) throws ParseException {
        List<IExpress> exprs;
        if (formulaStr == null) {
            return null;
        }
        formulaStr = formulaStr.substring(3, formulaStr.length() - 1);
        FunctionExpr expr = new FunctionExpr();
        expr.setFunctionName("OR");
        expr.setParams(Lists.newArrayListWithExpectedSize((int)2));
        int count = formulaStr.length();
        int bracket = 0;
        boolean brace = false;
        StringBuilder paramStr = new StringBuilder();
        ScriptParseUtils utils = new ScriptParseUtils();
        int paramSize = 0;
        for (int index = 0; index < count; ++index) {
            char _char = formulaStr.charAt(index);
            if (_char == '(') {
                ++bracket;
            }
            if (_char == ')') {
                --bracket;
            }
            if (bracket < 0) {
                throw new kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConditionProxy_0", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            if (bracket == 0 && _char == ',') {
                if (paramStr.length() > 0) {
                    exprs = utils.prase(paramStr.toString().trim());
                    expr.getParams().add(exprs.get(0));
                }
                ++paramSize;
                paramStr.setLength(0);
                continue;
            }
            paramStr.append(_char);
        }
        if (paramSize != 1) {
            throw new kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u8868\u8fbe\u5f0f\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConditionProxy_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (paramStr.length() > 0) {
            exprs = utils.prase(paramStr.toString().trim());
            expr.getParams().add(exprs.get(0));
        }
        return expr;
    }
}

