/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.parse;

import java.util.List;
import java.util.Stack;
import kd.epm.eb.business.expr.ParseException;
import kd.epm.eb.business.expr.expr.AbstractExpr;
import kd.epm.eb.business.expr.expr.BinaryExpr;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.oper.AbstractOper;

public class ExprParse {
    private final List<?> tokens;

    public ExprParse(List<?> tokens) {
        this.tokens = tokens;
    }

    public IExpress parse() throws ParseException {
        if (this.tokens == null || this.tokens.isEmpty()) {
            return null;
        }
        Stack<IExpress> stack = new Stack<IExpress>();
        int in = this.tokens.size();
        for (int i = 0; i < in; ++i) {
            Object obj = this.tokens.get(i);
            if (obj instanceof AbstractOper) {
                this.buildBinaryOp(stack, (AbstractOper)obj);
                continue;
            }
            if (obj instanceof FunctionExpr) {
                FunctionExpr funExpr = (FunctionExpr)obj;
                stack.push(funExpr);
                continue;
            }
            if (obj instanceof MemberExpr) {
                MemberExpr memExpr = (MemberExpr)obj;
                stack.push(memExpr);
                continue;
            }
            if (!(obj instanceof AbstractExpr)) continue;
            AbstractExpr calcExpr = (AbstractExpr)obj;
            stack.push(calcExpr);
        }
        return (IExpress)stack.pop();
    }

    private void buildBinaryOp(Stack<IExpress> stack, AbstractOper operType) {
        BinaryExpr be = new BinaryExpr(operType);
        be.setRight(stack.pop());
        be.setLeft(stack.pop());
        stack.push(be);
    }
}

