/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.parse;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.business.expr.ParseException;

public final class Parse2Expr {
    private String script = null;
    private int point = 0;
    private int length = 0;
    private char look;
    private List<String> exprs = new ArrayList<String>();

    public List<String> getExprs() {
        return this.exprs;
    }

    public void parse(String script) throws ParseException {
        this.init(script);
        while (this.look != '\u0000') {
            this.readScript();
            this.getChar();
        }
    }

    private void init(String script) {
        this.exprs.clear();
        if (script != null && script.trim().length() > 0) {
            this.script = script.trim();
            this.point = 0;
            this.length = this.script.length();
        }
        this.getChar();
    }

    private void getChar() {
        if (this.point == this.length) {
            this.look = '\u0000';
            return;
        }
        this.look = this.script.charAt(this.point++);
    }

    private void readScript() {
        StringBuilder script = new StringBuilder();
        int count = 0;
        while (!(this.isSemicolon(this.look) && count == 0 || this.look == '\u0000')) {
            if (!this.isOther(this.look)) {
                if (this.look == '{') {
                    ++count;
                }
                if (this.look == '}') {
                    --count;
                }
                script.append(this.look);
            }
            this.getChar();
        }
        if (script.length() > 0) {
            this.exprs.add(script.toString().trim());
        }
    }

    private boolean isSemicolon(char c) {
        return ';' == c;
    }

    private boolean isOther(char c) {
        return '\t' == c || '\r' == c || '\n' == c;
    }
}

