/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.parse;

import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.expr.ParseException;
import kd.epm.eb.business.expr.expr.BooleanExpr;
import kd.epm.eb.business.expr.expr.ConditionExpr;
import kd.epm.eb.business.expr.expr.FormulaExpr;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.expr.MemberGroupExpr;
import kd.epm.eb.business.expr.expr.NameExpr;
import kd.epm.eb.business.expr.expr.NumberExpr;
import kd.epm.eb.business.expr.expr.StringExpr;
import kd.epm.eb.business.expr.expr.TernaryOperExpr;
import kd.epm.eb.business.expr.expr.VariateExpr;
import kd.epm.eb.business.expr.exprproxy.AndExprProxy;
import kd.epm.eb.business.expr.exprproxy.ConditionExpr2Proxy;
import kd.epm.eb.business.expr.exprproxy.ConditionExprProxy;
import kd.epm.eb.business.expr.exprproxy.FormulaExprProxy;
import kd.epm.eb.business.expr.exprproxy.FunctionExprProxy;
import kd.epm.eb.business.expr.exprproxy.MemberExprProxy;
import kd.epm.eb.business.expr.exprproxy.MemberGroupExprProxy;
import kd.epm.eb.business.expr.exprproxy.NumberExprProxy;
import kd.epm.eb.business.expr.exprproxy.OrExprProxy;
import kd.epm.eb.business.expr.exprproxy.TernaryOperProxy;
import kd.epm.eb.business.expr.exprproxy.VariateExprProxy;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.expr.oper.AddOper;
import kd.epm.eb.business.expr.oper.AssignmentOper;
import kd.epm.eb.business.expr.oper.DivOper;
import kd.epm.eb.business.expr.oper.EqualOper;
import kd.epm.eb.business.expr.oper.GreaterEqualOper;
import kd.epm.eb.business.expr.oper.GreaterThanOper;
import kd.epm.eb.business.expr.oper.LeftParentheses;
import kd.epm.eb.business.expr.oper.LessEqualOper;
import kd.epm.eb.business.expr.oper.LessthanOper;
import kd.epm.eb.business.expr.oper.LogicAndOper;
import kd.epm.eb.business.expr.oper.LogicOrOper;
import kd.epm.eb.business.expr.oper.ModOper;
import kd.epm.eb.business.expr.oper.MultiplyOper;
import kd.epm.eb.business.expr.oper.NotEqualOper;
import kd.epm.eb.business.expr.oper.SubOper;
import kd.epm.eb.business.expr.parse.ExprParse;
import kd.epm.eb.business.expr.parse.ParseBase2RPN;
import kd.epm.eb.business.expr.utils.ParseUtils;

public class Parse2RPN
extends ParseBase2RPN {
    private String formulaStr = null;
    private int length = 0;
    private int point = 0;
    private char look;
    private boolean isOperation = false;
    private ParseUtils utils = new ParseUtils();

    @Override
    public void parse(String formulaStr) throws ParseException {
        this.init(formulaStr);
        String s = this.utils.qj2bj(formulaStr);
        if (TernaryOperProxy.check(s)) {
            this.readTernary(s);
            this.point = this.length;
            this.getChar();
        }
        while (this.look != '\u0000') {
            this.readOperand();
            if (!this.utils.isOperation(this.look) && this.look != '(' && this.look != ')') continue;
            this.isOperation = this.utils.isOperation(this.look);
            this.readOperation(this.look);
        }
        this.push2S1();
    }

    public void Expected(String c) throws ParseException {
        throw new ParseException(" cannot Parse, sorry : " + c);
    }

    private void init(String formulaStr) throws ParseException {
        if (formulaStr == null || formulaStr.trim().length() == 0) {
            this.Expected(" formulaStr is null!");
        } else {
            this.formulaStr = formulaStr.trim();
            this.point = 0;
            this.length = this.formulaStr.length();
        }
        this.getOperator().clear();
        this.getOperand().clear();
        this.getChar();
    }

    protected void getChar() {
        if (this.point == this.length) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaStr.charAt(this.point++);
        this.look = this.utils.toDBC(this.look);
    }

    protected void SkipWhite() {
        while (this.utils.IsWhite(this.look)) {
            this.getChar();
        }
    }

    protected void match(char x) throws ParseException {
        if (this.look != x) {
            this.Expected("" + x + "");
        } else {
            this.getChar();
            this.SkipWhite();
        }
    }

    @Override
    public IExpress getExpr() throws ParseException {
        ExprParse exprParse = new ExprParse(this.getTokens());
        return exprParse.parse();
    }

    protected void readOperation(char c) throws ParseException {
        if ('+' == c) {
            this.add();
        } else if ('-' == c) {
            this.sub();
        } else if ('*' == c) {
            this.multiply();
        } else if ('/' == c) {
            this.div();
        } else if ('%' == c) {
            this.mod();
        } else if ('=' == c) {
            this.assignment();
        } else if ('>' == c) {
            this.greaterThan();
        } else if ('<' == c) {
            this.lessThan();
        } else if ('(' == c) {
            this.leftParentheses();
        } else if (')' == c) {
            this.rightParentheses();
        } else if ('&' == c) {
            this.and();
        } else if ('|' == c) {
            this.or();
        }
    }

    protected void add() throws ParseException {
        this.match('+');
        this.pushCheck2S2(new AddOper());
    }

    protected void sub() throws ParseException {
        this.match('-');
        this.pushCheck2S2(new SubOper());
    }

    protected void multiply() throws ParseException {
        this.match('*');
        this.pushCheck2S2(new MultiplyOper());
    }

    protected void div() throws ParseException {
        this.match('/');
        this.pushCheck2S2(new DivOper());
    }

    protected void mod() throws ParseException {
        this.match('%');
        this.pushCheck2S2(new ModOper());
    }

    protected void assignment() throws ParseException {
        this.match('=');
        if (this.look == '=') {
            this.equal();
        } else {
            this.pushCheck2S2(new AssignmentOper());
        }
    }

    protected void equal() throws ParseException {
        this.match('=');
        this.pushCheck2S2(new EqualOper());
    }

    protected void greaterThan() throws ParseException {
        this.match('>');
        if (this.look == '=') {
            this.greaterEqual();
        } else {
            this.pushCheck2S2(new GreaterThanOper());
        }
    }

    protected void greaterEqual() throws ParseException {
        this.match('=');
        this.pushCheck2S2(new GreaterEqualOper());
    }

    protected void lessThan() throws ParseException {
        this.match('<');
        if (this.look == '=') {
            this.lessEqual();
        } else if (this.look == '>') {
            this.notEqual();
        } else {
            this.pushCheck2S2(new LessthanOper());
        }
    }

    protected void lessEqual() throws ParseException {
        this.match('=');
        this.pushCheck2S2(new LessEqualOper());
    }

    protected void notEqual() throws ParseException {
        this.match('>');
        this.pushCheck2S2(new NotEqualOper());
    }

    protected void and() throws ParseException {
        this.match('&');
        if (this.look != '&') {
            throw new ParseException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301&\u64cd\u4f5c\u7b26\uff0c\u8bf7\u4f7f\u7528\u903b\u8f91\u4e0e&&", (String)"Parse2RPN_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.logicAnd();
    }

    protected void logicAnd() throws ParseException {
        this.match('&');
        this.pushCheck2S2(new LogicAndOper());
    }

    protected void or() throws ParseException {
        this.match('|');
        if (this.look != '|') {
            throw new ParseException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301|\u64cd\u4f5c\u7b26\uff0c\u8bf7\u4f7f\u7528\u903b\u8f91\u6216||", (String)"Parse2RPN_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        this.logicOr();
    }

    protected void logicOr() throws ParseException {
        this.match('|');
        this.pushCheck2S2(new LogicOrOper());
    }

    protected void leftParentheses() throws ParseException {
        this.match('(');
        this.push2S2(new LeftParentheses());
    }

    protected void rightParentheses() throws ParseException {
        this.match(')');
        this.pushS22S1ByRightP();
    }

    protected void readOperand() throws ParseException {
        this.SkipWhite();
        String _operand = this.getOperandStr();
        if (_operand == null || _operand.length() == 0) {
            return;
        }
        if (ConditionExprProxy.check(_operand)) {
            this.readCondition(_operand);
        } else if (ConditionExpr2Proxy.check(_operand)) {
            this.readCondition2(_operand);
        } else if (MemberExprProxy.check(_operand)) {
            this.readMember(_operand);
        } else if (MemberGroupExprProxy.check(_operand)) {
            this.readMemberGroup(_operand);
        } else if (AndExprProxy.check(_operand)) {
            this.readAnd(_operand);
        } else if (OrExprProxy.check(_operand)) {
            this.readOr(_operand);
        } else if (FunctionExprProxy.check(_operand)) {
            this.readFunction(_operand);
        } else if (VariateExprProxy.check(_operand)) {
            this.readVariate(_operand);
        } else if (FormulaExprProxy.check(_operand)) {
            this.readFormula(_operand);
        } else if (NumberExprProxy.check(_operand)) {
            this.readNumeric(_operand);
        } else if (Boolean.parseBoolean(_operand)) {
            this.readBoolean(_operand);
        } else if (_operand.length() > 1 && _operand.startsWith("'") && _operand.endsWith("'")) {
            this.readString(_operand);
        } else {
            this.readName(_operand);
        }
        this.isOperation = false;
    }

    protected String getOperandStr() throws ParseException {
        int brace = 0;
        int bracket = 0;
        int parenthes = 0;
        int strCount = 0;
        StringBuilder str = new StringBuilder();
        while (this.look == '(') {
            if (this.look != '(') continue;
            this.leftParentheses();
        }
        boolean check = brace > 0 || bracket > 0 || parenthes > 0 ? true : !this.utils.isOperation(this.look);
        boolean isSub = false;
        int backpoint = -1;
        if (this.look == '-' && this.isOperation) {
            check = true;
            backpoint = this.point;
            isSub = true;
        }
        while (check && this.look != '\u0000') {
            if (this.look == '(') {
                ++parenthes;
            }
            if (this.look == ')') {
                --parenthes;
            }
            if (this.look == '[') {
                ++bracket;
            }
            if (this.look == ']') {
                --bracket;
            }
            if (this.look == '{') {
                ++brace;
            }
            if (this.look == '}') {
                --brace;
            }
            if (this.look == '\"' || this.look == '\'') {
                ++strCount;
            }
            if (strCount >= 2) {
                strCount = 0;
            }
            if (brace < 0 || bracket < 0 || parenthes < 0) break;
            str.append(this.look);
            this.getChar();
            check = brace > 0 || bracket > 0 || parenthes > 0 || strCount > 0 ? true : !this.utils.isOperation(this.look);
        }
        this.SkipWhite();
        if (isSub) {
            if (NumberExprProxy.check(str.toString().trim())) {
                return str.toString().trim();
            }
            this.point = backpoint;
            return "";
        }
        return str.toString().trim();
    }

    protected void readTernary(String functionStr) throws ParseException {
        TernaryOperExpr expr = TernaryOperProxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readCondition(String functionStr) throws ParseException {
        ConditionExpr expr = ConditionExprProxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readCondition2(String functionStr) throws ParseException {
        ConditionExpr expr = ConditionExpr2Proxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readAnd(String functionStr) throws ParseException {
        FunctionExpr expr = AndExprProxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readOr(String functionStr) throws ParseException {
        FunctionExpr expr = OrExprProxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readFunction(String functionStr) throws ParseException {
        FunctionExpr funExpr = FunctionExprProxy.get(functionStr);
        if (funExpr != null) {
            this.getOperand().add(funExpr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readMember(String functionStr) throws ParseException {
        MemberExpr expr = MemberExprProxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readMemberGroup(String functionStr) throws ParseException {
        MemberGroupExpr expr = MemberGroupExprProxy.get(functionStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error function!" + functionStr);
        }
    }

    protected void readVariate(String variateStr) throws ParseException {
        VariateExpr expr = VariateExprProxy.get(variateStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error variate!" + variateStr);
        }
    }

    protected void readFormula(String formulaStr) throws ParseException {
        FormulaExpr expr = FormulaExprProxy.get(formulaStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error formula!" + formulaStr);
        }
    }

    protected void readNumeric(String numericStr) throws ParseException {
        NumberExpr expr = NumberExprProxy.get(numericStr);
        if (expr != null) {
            this.getOperand().add(expr);
        } else {
            this.Expected("error numeric!" + numericStr);
        }
    }

    protected void readBoolean(String booleanStr) throws ParseException {
        this.getOperand().add(new BooleanExpr(booleanStr));
    }

    protected void readString(String stringStr) throws ParseException {
        this.getOperand().add(new StringExpr(stringStr));
    }

    protected void readName(String nameStr) throws ParseException {
        this.getOperand().add(new NameExpr(nameStr));
    }
}

