/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.expr.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.ReflectionUtils;
import kd.epm.eb.business.expr.expr.FunctionExpr;
import kd.epm.eb.business.expr.expr.MemberExpr;
import kd.epm.eb.business.expr.expr.MemberSetExpr;
import kd.epm.eb.business.expr.exprproxy.FunctionExprProxy;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.utils.ReportVar.VarException;

public class FunctionExprServiceHelper {
    public static Object run(FunctionExpr expr, Model model) {
        if (expr == null || expr.getFunctionName() == null || model == null) {
            throw new KDBizException("error function.");
        }
        Object result = null;
        try {
            Field field = expr.getClass().getDeclaredField("functionName");
            if (field != null) {
                Class<?> _class = Class.forName(FunctionExprServiceHelper.class.getName());
                ReflectionUtils.makeAccessible((Field)field);
                Method _method = _class.getDeclaredMethod((String)field.get(expr), FunctionExpr.class, Model.class);
                if (_method != null) {
                    result = _method.invoke(null, expr, model);
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof VarException) {
                throw (VarException)targetException;
            }
            throw new KDBizException("function run error." + e);
        }
        catch (Exception ex) {
            throw new KDBizException("function run error." + ex);
        }
        return result;
    }

    public static boolean verify(FunctionExpr expr) {
        if (expr == null || StringUtils.isEmpty((String)expr.getFunctionName())) {
            return false;
        }
        return FunctionExprProxy.getFunctionName().contains(expr.getFunctionName());
    }

    public static boolean hasMemberExpr(FunctionExpr expr) {
        boolean verify = false;
        if (expr == null || StringUtils.isEmpty((String)expr.getFunctionName())) {
            return verify;
        }
        if ("Descendants".equals(expr.getFunctionName()) || "Idescendants".equals(expr.getFunctionName()) || "Children".equals(expr.getFunctionName()) || "IChildrens".equals(expr.getFunctionName()) || "Siblings".equals(expr.getFunctionName()) || "ISiblings".equals(expr.getFunctionName()) || "Ancestors".equals(expr.getFunctionName()) || "IAncestors".equals(expr.getFunctionName()) || "Remove".equals(expr.getFunctionName()) || "Self".equals(expr.getFunctionName()) || "Leafs".equals(expr.getFunctionName()) || "NotLeafs".equals(expr.getFunctionName())) {
            verify = true;
        }
        return verify;
    }

    public static Map<String, Member> Self(FunctionExpr expr, Model model) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getParams() == null || expr.getParams().isEmpty() || model == null) {
            return result;
        }
        Member member = null;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model.getId());
        for (IExpress param : expr.getParams()) {
            if (param instanceof MemberSetExpr) {
                MemberSetExpr memberSetExpr = (MemberSetExpr)param;
                Dimension dimension = model.getDimension(memberSetExpr.getDimNumber());
                if (dimension == null) continue;
                for (String memberNumber : memberSetExpr.getMembers()) {
                    member = modelCacheHelper.getMemberByAnyView(dimension.getNumber(), memberNumber);
                    if (member == null) continue;
                    result.put(member.getNumber(), member);
                }
                continue;
            }
            if (!(param instanceof MemberExpr)) continue;
            MemberExpr memberExpr = (MemberExpr)param;
            String memberNumber = "";
            memberNumber = memberExpr.getNumber();
            Dimension dimension = model.getDimension(memberExpr.getDimNumber());
            if (dimension == null || (member = modelCacheHelper.getMemberByAnyView(dimension.getNumber(), memberNumber)) == null) continue;
            result.put(member.getNumber(), member);
        }
        return result;
    }

    public static Map<String, Member> Descendants(FunctionExpr expr, Model model) {
        return FunctionExprServiceHelper.Descendants(expr, model, false);
    }

    public static Map<String, Member> Idescendants(FunctionExpr expr, Model model) {
        return FunctionExprServiceHelper.Descendants(expr, model, true);
    }

    private static Map<String, Member> Descendants(FunctionExpr expr, Model model, boolean hasSelf) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getParams() == null || expr.getParams().isEmpty() || model == null) {
            return result;
        }
        Map<String, Member> _result = null;
        for (IExpress param : expr.getParams()) {
            _result = param instanceof MemberExpr ? FunctionExprServiceHelper.Descendants((MemberExpr)param, model, hasSelf) : (param instanceof MemberSetExpr ? FunctionExprServiceHelper.Descendants((MemberSetExpr)param, model, hasSelf) : null);
            if (_result == null || _result.isEmpty()) continue;
            result.putAll(_result);
        }
        return result;
    }

    public static Map<String, Member> Children(FunctionExpr expr, Model model) {
        return FunctionExprServiceHelper.Children(expr, model, false);
    }

    public static Map<String, Member> IChildrens(FunctionExpr expr, Model model) {
        return FunctionExprServiceHelper.Children(expr, model, true);
    }

    private static Map<String, Member> Children(FunctionExpr expr, Model model, boolean hasSelf) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getParams() == null || expr.getParams().isEmpty() || model == null) {
            return result;
        }
        Map<String, Member> _result = null;
        for (IExpress param : expr.getParams()) {
            _result = param instanceof MemberExpr ? FunctionExprServiceHelper.Children((MemberExpr)param, model, hasSelf) : (param instanceof MemberSetExpr ? FunctionExprServiceHelper.Children((MemberSetExpr)param, model, hasSelf) : null);
            if (_result == null || _result.isEmpty()) continue;
            result.putAll(_result);
        }
        return result;
    }

    public Map<String, Member> Siblings(FunctionExpr expr, Model model) {
        return this.Siblings(expr, model, false);
    }

    public Map<String, Member> ISiblings(FunctionExpr expr, Model model) {
        return this.Siblings(expr, model, true);
    }

    private Map<String, Member> Siblings(FunctionExpr expr, Model model, boolean hasSelf) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getParams() == null || expr.getParams().isEmpty() || model == null) {
            return result;
        }
        Map<String, Member> _result = null;
        for (IExpress param : expr.getParams()) {
            _result = param instanceof MemberExpr ? FunctionExprServiceHelper.Siblings((MemberExpr)param, model, hasSelf) : (param instanceof MemberSetExpr ? FunctionExprServiceHelper.Siblings((MemberSetExpr)param, model, hasSelf) : null);
            if (_result == null || _result.isEmpty()) continue;
            result.putAll(_result);
        }
        return result;
    }

    public Map<String, Member> Ancestors(FunctionExpr expr, Model model) {
        return this.Ancestors(expr, model, false);
    }

    public Map<String, Member> IAncestors(FunctionExpr expr, Model model) {
        return this.Ancestors(expr, model, true);
    }

    private Map<String, Member> Ancestors(FunctionExpr expr, Model model, boolean hasSelf) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getParams() == null || expr.getParams().isEmpty() || model == null) {
            return result;
        }
        Map<String, Member> _result = null;
        for (IExpress param : expr.getParams()) {
            _result = param instanceof MemberExpr ? FunctionExprServiceHelper.Ancestors((MemberExpr)param, model, hasSelf) : (param instanceof MemberSetExpr ? FunctionExprServiceHelper.Ancestors((MemberSetExpr)param, model, hasSelf) : null);
            if (_result == null || _result.isEmpty()) continue;
            result.putAll(_result);
        }
        return result;
    }

    public static Map<String, Member> Leafs(FunctionExpr expr, Model model) {
        return FunctionExprServiceHelper.Leafs(expr, model, true);
    }

    public static Map<String, Member> NotLeafs(FunctionExpr expr, Model model) {
        return FunctionExprServiceHelper.Leafs(expr, model, false);
    }

    private static Map<String, Member> Descendants(MemberExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.ALL.getIndex() : RangeEnum.ALL_EXCLUDE.getIndex());
    }

    private static Map<String, Member> Descendants(MemberSetExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.ALL.getIndex() : RangeEnum.ALL_EXCLUDE.getIndex());
    }

    private static Map<String, Member> Children(MemberExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.DIRECTSUB.getIndex() : RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
    }

    private static Map<String, Member> Children(MemberSetExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.DIRECTSUB.getIndex() : RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
    }

    private static Map<String, Member> Siblings(MemberExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.PEERS_EXCLUDE.getIndex() : RangeEnum.PEERS.getIndex());
    }

    private static Map<String, Member> Siblings(MemberSetExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.PEERS_EXCLUDE.getIndex() : RangeEnum.PEERS.getIndex());
    }

    private static Map<String, Member> Ancestors(MemberExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.ANCESTOR_EXCLUDE.getIndex() : RangeEnum.ANCESTOR.getIndex());
    }

    private static Map<String, Member> Ancestors(MemberSetExpr expr, Model model, boolean hasSelf) {
        return FunctionExprServiceHelper.getMembers(expr, model, hasSelf ? RangeEnum.ANCESTOR_EXCLUDE.getIndex() : RangeEnum.ANCESTOR.getIndex());
    }

    private static Map<String, Member> getMembers(MemberExpr expr, Model model, int rangeValue) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getDimNumber() == null || expr.getNumber() == null) {
            return result;
        }
        List members = ModelCacheServiceHelper.getMember((Model)model, (String)expr.getDimNumber(), (String)expr.getNumber(), (int)rangeValue);
        if (members != null) {
            for (Member member : members) {
                result.put(member.getNumber(), member);
            }
        }
        return result;
    }

    private static Map<String, Member> getMembers(MemberSetExpr expr, Model model, int rangeValue) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>(16);
        if (expr == null || expr.getDimNumber() == null || expr.getMembers() == null || expr.getMembers().isEmpty()) {
            return result;
        }
        ArrayList<Member> members = new ArrayList<Member>(16);
        HashSet<String> numbers = new HashSet<String>();
        for (String memberNumber : expr.getMembers()) {
            List tmpLists = ModelCacheServiceHelper.getMember((Model)model, (String)expr.getDimNumber(), (String)memberNumber, (int)rangeValue);
            if (tmpLists == null) continue;
            for (Member _member : tmpLists) {
                if (numbers.contains(_member.getNumber())) continue;
                numbers.add(_member.getNumber());
                members.add(_member);
            }
        }
        for (Member member : members) {
            result.put(member.getNumber(), member);
        }
        return result;
    }

    private static Map<String, Member> Leafs(FunctionExpr expr, Model model, boolean hasLeaf) {
        LinkedHashMap<String, Member> result = new LinkedHashMap<String, Member>();
        if (expr == null || expr.getParams() == null || expr.getParams().isEmpty() || model == null) {
            return result;
        }
        Map<String, Member> _result = null;
        for (IExpress param : expr.getParams()) {
            if (param instanceof MemberExpr) {
                _result = FunctionExprServiceHelper.Descendants((MemberExpr)param, model, true);
                FunctionExprServiceHelper.getLeafs(result, _result, hasLeaf);
                continue;
            }
            if (!(param instanceof MemberSetExpr)) continue;
            _result = FunctionExprServiceHelper.Descendants((MemberSetExpr)param, model, true);
            FunctionExprServiceHelper.getLeafs(result, _result, hasLeaf);
        }
        return result;
    }

    private static void getLeafs(Map<String, Member> result, Map<String, Member> members, boolean hasLeaf) {
        if (result == null || members == null || members.isEmpty()) {
            return;
        }
        for (Member _member : members.values()) {
            if (hasLeaf != _member.isLeaf()) continue;
            result.put(_member.getNumber(), _member);
        }
    }
}

