/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;

public class PredictGuideService {
    private static final Log log = LogFactory.getLog(PredictGuideService.class);
    private static final String ENTITY_NAME = "eb_predict_guide";

    public static PredictGuideService getInstance() {
        return InnerClass.instance;
    }

    private PredictGuideService() {
    }

    public boolean isNeedGuide() {
        QFilter qFilter = new QFilter("creater", "=", (Object)UserUtils.getUserId());
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
    }

    public void save() {
        if (this.isNeedGuide()) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dynamicObject.set("creater", (Object)UserUtils.getUserId());
        dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static class InnerClass {
        private static final PredictGuideService instance = new PredictGuideService();

        private InnerClass() {
        }
    }
}

