/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class PredictMemoryService {
    private static final Log log = LogFactory.getLog(PredictMemoryService.class);
    private static final String ENTITY_NAME = "eb_predict_memory";

    public static PredictMemoryService getInstance() {
        return InnerClass.instance;
    }

    private PredictMemoryService() {
    }

    public List<PredFactor> queryMemory(Long targetDatasetId) {
        Long userId = UserUtils.getUserId();
        QFilter qFilter = new QFilter("targetdataset", "=", (Object)targetDatasetId);
        qFilter.and("creater", "=", (Object)userId);
        DynamicObjectCollection targets = QueryServiceHelper.query((String)ENTITY_NAME, (String)"name, dimhash, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray(), (String)"id");
        return targets.stream().map(this::transModel).collect(Collectors.toList());
    }

    public void save(Long targetDatasetId, List<PredFactor> factors) {
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        QFilter qFilter = new QFilter("targetdataset", "=", (Object)targetDatasetId);
        qFilter.and("creater", "=", (Object)userId);
        List<DynamicObject> saveFactors = factors.stream().map(e -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dynamicObject.set("dimhash", (Object)e.getHashId());
            dynamicObject.set("name", (Object)e.getName());
            dynamicObject.set("model", (Object)IDUtils.toLong((Object)e.getModel()));
            dynamicObject.set("targetdataset", (Object)targetDatasetId);
            dynamicObject.set("dataset", (Object)IDUtils.toLong((Object)e.getDataset()));
            dynamicObject.set("dimconf", (Object)e.getDimConf());
            dynamicObject.set("dimview", (Object)e.getDimView());
            dynamicObject.set("creater", (Object)userId);
            dynamicObject.set("createdate", (Object)now);
            return dynamicObject;
        }).collect(Collectors.toList());
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])qFilter.toArray());
                SaveServiceHelper.save((DynamicObject[])saveFactors.toArray(new DynamicObject[0]));
            }
            catch (Throwable e2) {
                tx.markRollback();
                log.error(e2.getMessage(), e2);
                throw new KDBizException(e2.getMessage());
            }
        }
    }

    private PredFactor transModel(DynamicObject factor) {
        PredFactor predFactor = new PredFactor();
        predFactor.setName(factor.getString("name"));
        predFactor.setModel(Long.toString(factor.getLong("model")));
        predFactor.setDataset(Long.toString(factor.getLong("dataset")));
        predFactor.setHashId(factor.getString("dimhash"));
        predFactor.setDimView(factor.getString("dimview"));
        predFactor.setDimConf(factor.getString("dimconf"));
        return predFactor;
    }

    private static class InnerClass {
        private static final PredictMemoryService instance = new PredictMemoryService();

        private InnerClass() {
        }
    }
}

