/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.forecast.model.MemberDto;
import kd.epm.eb.business.forecast.model.PredFactor;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PredictParamFactorService {
    private static final Log log = LogFactory.getLog(PredictParamFactorService.class);
    private static final String ENTITY_NAME = "eb_predict_param_factor";

    public static PredictParamFactorService getInstance() {
        return InnerClass.instance;
    }

    private PredictParamFactorService() {
    }

    public DynamicObject query(Long targetId) {
        QFilter qFilter = new QFilter("id", "=", (Object)targetId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id, name, target, dimhash, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"PredictParamFactorService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return dynamicObject;
    }

    public PredFactor queryFactor(Long targetId) {
        return this.transModel(this.query(targetId));
    }

    public DynamicObjectCollection queryByTarget(Long targetId) {
        QFilter qFilter = new QFilter("target", "=", (Object)targetId);
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, name, target, dimhash, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray());
    }

    public DynamicObject checkSameDimHashId(Long id, Long targetId, Long datasetId, Long dimHashId) {
        QFilter qFilter = new QFilter("target", "=", (Object)targetId);
        qFilter.and("dataset", "=", (Object)datasetId);
        qFilter.and("dimhash", "=", (Object)dimHashId);
        if (IDUtils.isNotEmptyLong((Long)id).booleanValue()) {
            qFilter.and("id", "!=", (Object)id);
        }
        return QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id, name", (QFilter[])qFilter.toArray());
    }

    public PredFactor queryMemory(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("modifier", "=", (Object)UserUtils.getUserId());
        DynamicObjectCollection targets = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, name, target, dimhash, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        return targets.size() == 0 ? null : this.transModel((DynamicObject)targets.get(0));
    }

    public PredFactor queryMemory(Long modelId, Long datasetId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("dataset", "=", (Object)datasetId));
        qFilter.and("modifier", "=", (Object)UserUtils.getUserId());
        DynamicObjectCollection targets = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, name, target, dimhash, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1);
        return targets.size() == 0 ? null : this.transModel((DynamicObject)targets.get(0));
    }

    public List<PredFactor> queryFactor(Set<Long> targetIds) {
        if (CollectionUtils.isEmpty(targetIds)) {
            return new ArrayList<PredFactor>();
        }
        QFilter qFilter = new QFilter("target", "in", targetIds);
        DynamicObjectCollection targets = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id, name, target, dimhash, model, dataset, dimconf, dimview", (QFilter[])qFilter.toArray(), (String)"id");
        return targets.stream().map(this::transModel).collect(Collectors.toList());
    }

    public Long save(Long id, Long targetId, String name, Long modelId, Long datasetId, String dimConf, String dimView) {
        DynamicObject dynamicObject;
        if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
            id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("id", (Object)id);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        }
        Long dimHashId = this.calcDimHashId(modelId, datasetId, dimConf);
        dynamicObject.set("target", (Object)targetId);
        dynamicObject.set("dimhash", (Object)dimHashId);
        dynamicObject.set("name", (Object)name);
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("dataset", (Object)datasetId);
        dynamicObject.set("dimconf", (Object)dimConf);
        dynamicObject.set("dimview", (Object)dimView);
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        return id;
    }

    public void deleteByTarget(Long targetId) {
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("target", "=", (Object)targetId)});
    }

    public void delete(List<Long> ids) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private PredFactor transModel(DynamicObject factor) {
        Long modelId = factor.getLong("model");
        Long datasetId = factor.getLong("dataset");
        String dimView = factor.getString("dimview");
        String dimConf = factor.getString("dimconf");
        PredFactor predFactor = new PredFactor();
        predFactor.setFactorId(factor.getString("id"));
        predFactor.setHashId(factor.getString("dimhash"));
        predFactor.setModel(modelId.toString());
        predFactor.setDataset(datasetId.toString());
        predFactor.setName(factor.getString("name"));
        predFactor.setDimView(dimView);
        predFactor.setDimConf(dimConf);
        return predFactor;
    }

    public Long calcDimHashId(Long modelId, Long datasetId, String dimConf) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCache.getDimensionList(datasetId);
        JSONObject dimMembers = JSON.parseObject((String)dimConf);
        String key = dimensionList.stream().filter(dim -> !SysDimensionEnum.BudgetPeriod.getNumber().equals(dim.getNumber())).map(dim -> ((MemberDto)JSONObject.parseArray((String)dimMembers.getString(dim.getNumber()), MemberDto.class).get(0)).getNumber()).filter(StringUtils::isNotEmpty).collect(Collectors.joining("!"));
        return Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).padToLong();
    }

    private static class InnerClass {
        private static final PredictParamFactorService instance = new PredictParamFactorService();

        private InnerClass() {
        }
    }
}

