/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.forecast;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class PredictParamService {
    private static final Log log = LogFactory.getLog(PredictParamService.class);
    private static final String ENTITY_NAME = "eb_predict_param";
    private final String selectFields = "model, datatype, version, samplelen, usemodel, reqtype, show";

    public static PredictParamService getInstance() {
        return InnerClass.instance;
    }

    private PredictParamService() {
    }

    public DynamicObject query(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"model, datatype, version, samplelen, usemodel, reqtype, show", (QFilter[])qFilter.toArray());
    }

    public DynamicObject loadSingle(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"model, datatype, version, samplelen, usemodel, reqtype, show", (QFilter[])qFilter.toArray());
    }

    public boolean isShow(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)"model, datatype, version, samplelen, usemodel, reqtype, show", (QFilter[])qFilter.toArray());
        if (dyObj == null) {
            return false;
        }
        return dyObj.getBoolean("show");
    }

    public Long save(Long modelId, Long dataTypeId, Long versionId, Integer sampleLen, String useModel, String reqType, Boolean showFlag) {
        DynamicObject dynamicObject;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject param = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)"id", (QFilter[])qFilter.toArray());
        if (param == null || IDUtils.isNull((long)param.getLong("id"))) {
            Long id = GlobalIdUtil.genGlobalLongId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            dynamicObject.set("id", (Object)id);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)param.getLong("id"), (String)ENTITY_NAME);
        }
        dynamicObject.set("model", (Object)modelId);
        dynamicObject.set("datatype", (Object)dataTypeId);
        dynamicObject.set("version", (Object)versionId);
        dynamicObject.set("samplelen", (Object)sampleLen);
        dynamicObject.set("usemodel", (Object)useModel);
        dynamicObject.set("reqtype", (Object)reqType);
        dynamicObject.set("show", (Object)showFlag);
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        return dynamicObject.getLong("id");
    }

    private static class InnerClass {
        private static final PredictParamService instance = new PredictParamService();

        private InnerClass() {
        }
    }
}

